/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.com.lowagie.text.rtf.document;

import com.fr.third.com.lowagie.text.DocWriter;
import com.fr.third.com.lowagie.text.rtf.RtfElement;
import com.fr.third.com.lowagie.text.rtf.document.RtfDocument;
import com.fr.third.com.lowagie.text.rtf.document.RtfInfoElement;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public class RtfInfoGroup
extends RtfElement {
    private static final byte[] INFO_GROUP = DocWriter.getISOBytes("\\info");
    private static final byte[] INFO_PASSWORD = DocWriter.getISOBytes("\\*\\password");
    ArrayList infoElements = new ArrayList();

    public RtfInfoGroup(RtfDocument doc) {
        super(doc);
    }

    public void add(RtfInfoElement infoElement) {
        this.infoElements.add(infoElement);
    }

    public void writeContent(OutputStream result) throws IOException {
        result.write(OPEN_GROUP);
        result.write(INFO_GROUP);
        int i = 0;
        while (i < this.infoElements.size()) {
            RtfInfoElement infoElement = (RtfInfoElement)this.infoElements.get(i);
            infoElement.writeContent(result);
            ++i;
        }
        if (this.document.getDocumentSettings().isDocumentProtected()) {
            result.write(OPEN_GROUP);
            result.write(INFO_PASSWORD);
            result.write(DELIMITER);
            result.write(this.document.getDocumentSettings().getProtectionHashBytes());
            result.write(CLOSE_GROUP);
        }
        result.write(CLOSE_GROUP);
        this.document.outputDebugLinebreak(result);
    }
}

