/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfmxSQLData;
import com.informix.jdbc.IfxBaseType;
import com.informix.jdbc.IfxUDTInput;
import com.informix.util.IfxErrMsg;
import java.sql.SQLException;

class IfxUDT
extends IfxBaseType {
    IfmxSQLData udtClass;

    IfxUDT() throws SQLException {
        this.setIfxType(44);
    }

    IfxUDT(byte[] byArray) throws SQLException {
        this.setIfxType(44);
        this.fromBytes(byArray);
    }

    public void fromObject(Object object) throws SQLException {
        String string;
        if (object == null) {
            this.nullify();
            this.udtClass = null;
            return;
        }
        if (!(object instanceof IfmxSQLData)) {
            throw IfxErrMsg.getSQLException(-79728, this.conn);
        }
        this.udtClass = (IfmxSQLData)object;
        if (!this.conn.isDirect()) {
            this.outputStream.reset();
            this.udtClass.writeSQL(this.outputStream);
        }
        if ((string = this.udtClass.getSQLTypeName()) != null) {
            this.setExtendedTypeName(string);
        }
        this.unnullify();
    }

    public Object toObject() throws SQLException {
        if (this.conn.isDirect()) {
            if (this.isNull()) {
                return null;
            }
            return this.udtClass;
        }
        if (this.typeMap == null && (this.typeMap = this.conn.getTypeMap()) == null) {
            throw IfxErrMsg.getSQLException(-79769, this.conn);
        }
        Class clazz = (Class)this.typeMap.get(this.extendedName);
        if (clazz == null) {
            throw IfxErrMsg.getSQLException(-79769, this.conn);
        }
        try {
            this.udtClass = (IfmxSQLData)clazz.newInstance();
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
        if (this.inputStream == null && this.outputStream != null && this.outputStream.length() > 0) {
            this.inputStream = new IfxUDTInput(this.conn, this.outputStream.toByteArray(), 0, this.outputStream.length());
        }
        this.udtClass.readSQL(this.inputStream, this.extendedName);
        if (this.isNull()) {
            return null;
        }
        return this.udtClass;
    }

    public void fromBytes(byte[] byArray) throws SQLException {
        this.outputStream.reset();
        this.outputStream.writeBytes(byArray, byArray.length);
        this.inputStream = new IfxUDTInput(this.conn, byArray, 0, byArray.length);
        this.unnullify();
    }

    public byte[] toBytes() throws SQLException {
        if (this.isNull() || this.inputStream == null) {
            return null;
        }
        return this.inputStream.toByteArray();
    }

    public void clear() {
        this.udtClass = null;
        this.nullify();
    }

    public String toString() {
        if (this.conn.isDirect()) {
            if (this.isNull()) {
                return null;
            }
            return this.udtClass.toString();
        }
        return super.toString();
    }
}

