/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfmxStatement;
import com.informix.jdbc.IfxCallableStatement;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxPreparedStatement;
import com.informix.jdbc.IfxProtocol;
import com.informix.jdbc.IfxResultSet;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.jdbc.IfxValue;
import com.informix.util.IfxErrMsg;
import com.informix.util.Trace;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Vector;

public class IfxStatement
implements IfmxStatement {
    private String cursorName;
    private int maxRows;
    private Trace trace;
    private boolean statementProcessed = false;
    private SQLWarning statementWarnings;
    private boolean calledgetResultSet = false;
    private boolean calledgetUpdateCount = false;
    private boolean autoFree = false;
    protected IfxConnection jconn;
    public String commandString;
    protected IfxResultSet savedResult;
    protected boolean escapeProcessing = true;
    protected int numqmarks;
    private int ResultSetType = 1003;
    private int ResultSetConcurrency;
    private int FetchSize;
    private int FetchDirection = 1000;
    protected Vector BatchVector = new Vector();
    protected int[] BatchRowCount = new int[1];
    protected IfxResultSetMetaData outputMetaData;
    protected int statementType;
    private IfxProtocol prot;

    IfxStatement(IfxConnection ifxConnection) {
        this.jconn = ifxConnection;
    }

    public ResultSet executeQuery(String string) throws SQLException {
        this.validate(string);
        return this.executeQueryImpl(false);
    }

    public ResultSet executeQuery(String string, boolean bl) throws SQLException {
        this.validate(string);
        return this.executeQueryImpl(bl);
    }

    void validate(String string) throws SQLException {
        if (string == null) {
            throw IfxErrMsg.getSQLException(-79726, this.jconn);
        }
        if (this instanceof IfxPreparedStatement || this instanceof IfxCallableStatement) {
            throw IfxErrMsg.getSQLException(-79729, this.jconn);
        }
        if (this.jconn == null) {
            throw IfxErrMsg.getSQLException(-79730, null);
        }
        String string2 = this.commandString = this.escapeProcessing ? this.jconn.nativeSQL(string) : string;
        if (this.savedResult != null) {
            this.savedResult.closePrev();
        }
    }

    public int executeUpdate(String string) throws SQLException {
        if (string == null) {
            throw IfxErrMsg.getSQLException(-79726, this.jconn);
        }
        if (this instanceof IfxPreparedStatement || this instanceof IfxCallableStatement) {
            throw IfxErrMsg.getSQLException(-79729, this.jconn);
        }
        if (this.jconn == null) {
            throw IfxErrMsg.getSQLException(-79730, null);
        }
        String string2 = this.commandString = this.escapeProcessing ? this.jconn.nativeSQL(string) : string;
        if (this.savedResult != null) {
            this.savedResult.closePrev();
        }
        return this.executeUpdateImpl();
    }

    public void close() throws SQLException {
        if (this.savedResult != null) {
            this.savedResult.closeNow();
            this.savedResult = null;
        }
        this.cursorName = null;
        this.statementWarnings = null;
        this.jconn = null;
        this.commandString = null;
    }

    public int getMaxFieldSize() throws SQLException {
        return 0;
    }

    public void setMaxFieldSize(int n) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": Statement.setMaxFieldSize(int).", this.jconn);
    }

    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    public void setMaxRows(int n) throws SQLException {
        if (n < 0) {
            throw IfxErrMsg.getSQLMinorException(-79731, -80007, this.jconn);
        }
        this.maxRows = n;
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        this.escapeProcessing = bl;
    }

    public int getQueryTimeout() throws SQLException {
        return 0;
    }

    public void setQueryTimeout(int n) throws SQLException {
        if (n != 0) {
            throw IfxErrMsg.getSQLException(-79700, ": Statement.setQueryTimeout(int).", this.jconn);
        }
    }

    public void cancel() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": Statement.cancel().", this.jconn);
    }

    void chainWarnings(SQLWarning sQLWarning) throws SQLException {
        if (sQLWarning != null) {
            if (this.statementWarnings != null) {
                this.statementWarnings.setNextWarning(sQLWarning);
                return;
            }
            this.statementWarnings = sQLWarning;
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        if (this.savedResult != null) {
            this.chainWarnings(this.savedResult.getWarnings());
        }
        return this.statementWarnings;
    }

    public void clearWarnings() throws SQLException {
        if (this.savedResult != null) {
            this.savedResult.clearWarnings();
        }
        this.statementWarnings = null;
    }

    public void setCursorName(String string) throws SQLException {
        if (string.length() > 0) {
            this.cursorName = string;
            return;
        }
        throw IfxErrMsg.getSQLException(-79732, this.jconn);
    }

    public boolean execute(String string) throws SQLException {
        if (string == null) {
            throw IfxErrMsg.getSQLException(-79726, this.jconn);
        }
        if (this instanceof IfxPreparedStatement || this instanceof IfxCallableStatement) {
            throw IfxErrMsg.getSQLException(-79729, this.jconn);
        }
        if (this.jconn == null) {
            throw IfxErrMsg.getSQLException(-79730, null);
        }
        String string2 = this.commandString = this.escapeProcessing ? this.jconn.nativeSQL(string) : string;
        if (this.savedResult != null) {
            this.savedResult.closePrev();
        }
        return this.executeImpl();
    }

    public ResultSet getResultSet() throws SQLException {
        if (this.calledgetResultSet) {
            throw IfxErrMsg.getSQLException(-79782, this.jconn);
        }
        this.calledgetResultSet = true;
        if (this.savedResult == null) {
            throw IfxErrMsg.getSQLException(-79733, this.jconn);
        }
        if (this.savedResult.getUpdateCount() != -1) {
            return null;
        }
        return this.savedResult;
    }

    public int getUpdateCount() throws SQLException {
        if (this.calledgetUpdateCount) {
            throw IfxErrMsg.getSQLException(-79782, this.jconn);
        }
        this.calledgetUpdateCount = true;
        if (this.savedResult == null) {
            throw IfxErrMsg.getSQLException(-79733, this.jconn);
        }
        return this.savedResult.getUpdateCount();
    }

    public boolean getMoreResults() throws SQLException {
        if (this.savedResult != null) {
            this.savedResult.clearWarnings();
            this.savedResult.closePrev();
        }
        return false;
    }

    public String getCursorName() throws SQLException {
        if (this.cursorName != null) {
            return this.cursorName;
        }
        return this.getGeneratedCursor();
    }

    private String getGeneratedCursor() throws SQLException {
        if (this.jconn == null) {
            throw IfxErrMsg.getSQLException(-79730, null);
        }
        this.cursorName = this.jconn.getGeneratedCursor();
        return this.cursorName;
    }

    int getqmarks() {
        return this.numqmarks;
    }

    void setqmarks(int n) {
        this.numqmarks = n;
    }

    public Connection getConnection() {
        return this.jconn;
    }

    protected ResultSet executeQueryImpl(boolean bl) throws SQLException {
        this.calledgetUpdateCount = false;
        this.calledgetResultSet = false;
        if (this.savedResult == null) {
            this.savedResult = new IfxResultSet(this);
        }
        this.clearWarnings();
        if (this.outputMetaData != null) {
            this.savedResult.executeQuery(this.outputMetaData, bl);
        } else {
            this.savedResult.executeQuery(bl);
        }
        return this.savedResult;
    }

    protected int executeUpdateImpl() throws SQLException {
        this.calledgetUpdateCount = false;
        this.calledgetResultSet = false;
        if (this.savedResult == null) {
            this.savedResult = new IfxResultSet(this);
        }
        this.clearWarnings();
        return this.savedResult.executeUpdate();
    }

    protected boolean executeImpl() throws SQLException {
        this.calledgetUpdateCount = false;
        this.calledgetResultSet = false;
        if (this.savedResult == null) {
            this.savedResult = new IfxResultSet(this);
        }
        this.clearWarnings();
        if (this.outputMetaData != null) {
            return this.savedResult.executeExecute(this.outputMetaData);
        }
        return this.savedResult.executeExecute();
    }

    public int getSerial() throws SQLException {
        if (this.savedResult == null) {
            return 0;
        }
        return this.savedResult.getSerial();
    }

    public long getSerial8() throws SQLException {
        if (this.savedResult == null) {
            return 0L;
        }
        return this.savedResult.getSerial8();
    }

    public void setFetchDirection(int n) throws SQLException {
        if (n != 1000 || n != 1001 || n != 1002) {
            throw IfxErrMsg.getSQLException(-79764, this.jconn);
        }
        if (this.getResultSetType() == 1003 && n != 1000) {
            throw IfxErrMsg.getSQLException(-79765, this.jconn);
        }
        this.FetchDirection = n;
    }

    public int getFetchDirection() throws SQLException {
        return this.FetchDirection;
    }

    public void setFetchSize(int n) throws SQLException {
        if (n < 0 || this.maxRows != 0 && n > this.maxRows) {
            throw IfxErrMsg.getSQLException(-79766, this.jconn);
        }
        this.FetchSize = n;
    }

    public int getFetchSize() throws SQLException {
        return this.FetchSize;
    }

    public int getResultSetConcurrency() throws SQLException {
        return this.ResultSetConcurrency;
    }

    public int getResultSetType() throws SQLException {
        return this.ResultSetType;
    }

    public void addBatch(String string) throws SQLException {
        if (string == null) {
            throw IfxErrMsg.getSQLException(-79726, this.jconn);
        }
        if (this.jconn == null) {
            throw IfxErrMsg.getSQLException(-79730, null);
        }
        this.commandString = this.escapeProcessing ? this.jconn.nativeSQL(string) : string;
        this.commandString = this.commandString.trim();
        if (!this.commandString.endsWith(";")) {
            this.commandString = String.valueOf(this.commandString) + ";";
        }
        this.BatchVector.addElement(this.commandString);
    }

    public void clearBatch() throws SQLException {
        this.BatchVector.removeAllElements();
    }

    public int[] executeBatch() throws SQLException {
        this.commandString = "";
        this.BatchRowCount[0] = 0;
        if (this.BatchVector.size() == 0) {
            throw IfxErrMsg.getSQLException(-79726, this.jconn);
        }
        int n = 0;
        while (n < this.BatchVector.size()) {
            this.commandString = String.valueOf(this.commandString) + this.BatchVector.elementAt(n);
            ++n;
        }
        this.BatchRowCount[0] = this.executeUpdateImpl();
        return this.BatchRowCount;
    }

    protected void setResultSetType(int n) throws SQLException {
        if (n != 1004 && n != 1003) {
            throw IfxErrMsg.getSQLException(-79775, this.jconn);
        }
        this.ResultSetType = n;
    }

    protected void setResultSetConcurrency(int n) throws SQLException {
        if (n != 1007) {
            throw IfxErrMsg.getSQLException(-79763, this.jconn);
        }
        this.ResultSetConcurrency = n;
    }

    public void registerOutputParameter(int n, int n2) throws SQLException {
        this.registerOutputParameter(n, n2, "");
    }

    public void registerOutputParameter(int n, int n2, String string) throws SQLException {
        if (this.outputMetaData == null) {
            this.outputMetaData = new IfxResultSetMetaData(0, this.jconn);
        }
        switch (n2) {
            case 101: {
                this.outputMetaData.setIfxColumnType(n, 44);
                this.outputMetaData.setExtendedName(n, "clob");
                this.outputMetaData.setColumnExtendedId(n, 11);
                this.outputMetaData.setEncodedLength(n, 72);
                return;
            }
            case 102: {
                this.outputMetaData.setIfxColumnType(n, 44);
                this.outputMetaData.setExtendedName(n, "blob");
                this.outputMetaData.setColumnExtendedId(n, 10);
                this.outputMetaData.setEncodedLength(n, 72);
                return;
            }
            case 45: {
                this.outputMetaData.setIfxColumnType(n, 45);
                this.outputMetaData.setExtendedName(n, "boolean");
                this.outputMetaData.setColumnExtendedId(n, 5);
                this.outputMetaData.setEncodedLength(n, 1);
                return;
            }
            case 43: {
                this.outputMetaData.setIfxColumnType(n, 43);
                this.outputMetaData.setExtendedName(n, "lvarchar");
                this.outputMetaData.setColumnExtendedId(n, 1);
                return;
            }
            case 40: 
            case 41: {
                this.outputMetaData.setIfxColumnType(n, 44);
                this.outputMetaData.setExtendedName(n, string);
                this.outputMetaData.setEncodedLength(n, 4);
                return;
            }
        }
        this.outputMetaData.setIfxColumnType(n, n2);
    }

    public void clearOutputParameter() {
        this.outputMetaData = null;
    }

    public void setAutoFree(boolean bl) {
        if (bl && this.jconn.isAutoFree()) {
            this.autoFree = bl;
            return;
        }
        this.autoFree = false;
    }

    public boolean getAutoFree() {
        return this.autoFree;
    }

    protected void setStatementType(int n) {
        this.statementType = n;
    }

    public int getStatementType() {
        return this.statementType;
    }

    public Vector executeFastPath(String string, Vector vector, boolean bl) throws SQLException {
        int n;
        Object[] objectArray;
        Object object;
        Object[] objectArray2;
        Object object2;
        Serializable serializable;
        if (string == null) {
            throw IfxErrMsg.getSQLException(-79726, this.jconn);
        }
        if (this.jconn == null) {
            throw IfxErrMsg.getSQLException(-79730, null);
        }
        if (this.prot == null) {
            try {
                serializable = Class.forName(this.jconn.getProtoClassName());
                object2 = Class.forName(this.jconn.getConnClassName());
                objectArray2 = new Class[]{object2};
                object = ((Class)serializable).getConstructor((Class<?>[])objectArray2);
                objectArray = new Object[]{this.jconn};
                this.prot = (IfxProtocol)((Constructor)object).newInstance(objectArray);
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.jconn);
            }
        }
        serializable = new Vector();
        object2 = null;
        objectArray2 = null;
        if (vector != null) {
            int n2 = 0;
            while (n2 < vector.size()) {
                objectArray2 = (Object[])vector.elementAt(n2);
                objectArray = this.jconn;
                n = (Integer)objectArray2[1];
                object2 = IfxValue.makeInstanceFromIfxType((IfxConnection)objectArray, n, null);
                ((IfxObject)object2).fromObject(objectArray2[0]);
                ((Vector)serializable).addElement(object2);
                ++n2;
            }
        }
        object = null;
        objectArray = null;
        object = this.prot.executeFastPath(string, (Vector)serializable, bl);
        if (object != null) {
            objectArray = new Vector();
            n = 0;
            while (n < ((Vector)object).size()) {
                objectArray2 = new Object[2];
                object2 = (IfxObject)((Vector)object).elementAt(n);
                objectArray2[0] = ((IfxObject)object2).toObject();
                objectArray2[1] = new Integer(((IfxObject)object2).getIfxType());
                ++n;
            }
        }
        return objectArray;
    }
}

