/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxBaseType;
import com.informix.jdbc.IfxBblob;
import com.informix.jdbc.IfxCblob;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxInt8;
import com.informix.jdbc.IfxInteger;
import com.informix.jdbc.IfxLoStat;
import com.informix.jdbc.IfxLobDescriptor;
import com.informix.jdbc.IfxLocator;
import com.informix.jdbc.IfxLvarchar;
import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxProtocol;
import com.informix.jdbc.IfxUDT;
import com.informix.util.IfxErrMsg;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;

public class IfxSmartBlob {
    public static final int LO_APPEND = 1;
    public static final int LO_WRONLY = 2;
    public static final int LO_RDONLY = 4;
    public static final int LO_RDWR = 8;
    public static final int LO_SEEK_SET = 0;
    public static final int LO_SEEK_CUR = 1;
    public static final int LO_SEEK_END = 2;
    private static final String IFX_LO_COL_INFO = "function informix.ifx_lo_col_s binfo(lvarchar,ifx_lo_spec)";
    private static final String IFX_LO_CREATE = "function informix.ifx_lo_create( ifx_lo_spec,integer,blob)";
    private static final String IFX_LO_RELEASE = "function informix.ifx_lo_release(blob)";
    private static final String IFX_LO_OPEN = "function informix.ifx_lo_open(blob ,integer)";
    private static final String IFX_LO_CLOSE = "function informix.ifx_lo_close(integer)";
    private static final String IFX_LO_SEEK = "function informix.ifx_lo_seek(integer,int8,integer,int8)";
    private static final String IFX_LO_LOCK = "function informix.ifx_lo_lock(integer,integer,int8,int8,integer)";
    private static final String IFX_LO_UNLOCK = "function informix.ifx_lo_unlock( integer,integer,int8,int8)";
    private static final String IFX_LO_TELL = "function informix.ifx_lo_tell(int, int8)";
    private static final String IFX_LO_TRUNCATE = "function informix.ifx_lo_truncate(integer,int8)";
    private static final String IFX_LO_COPY_TO_LO = "function informix.ifx_lo_from_file(int,lvarchar,int,int,int)";
    private static final String IFX_LO_COPY_TO_FILE = "function informix.ifx_lo_to_file(blob,lvarchar,int, int)";
    private static final String IFX_LO_FILENAME = "function informix.ifx_lo_filename(blob,lvarchar)";
    private static final String IFX_LO_ALTER = "function informix.ifx_lo_alter(blob,ifx_lo_spec)";
    private static final String IFX_LO_STAT = "function informix.ifx_lo_stat(int, ifx_lo_stat)";
    private static final String LO_CREATE_SPEC_NAME = "ifx_lo_spec";
    private static final String LO_COL_NAME = "lvarchar";
    private static final String LO_STAT_NAME = "ifx_lo_stat";
    private static final String LO_NAME = "blob";
    private static final int LO_STAT_SIZE = 644;
    private static final int PRE_LONG_ID_LO_STAT_SIZE = 212;
    IfxLocator lo_ptr;
    private IfxConnection conn;
    private IfxProtocol prot;

    public IfxSmartBlob(Connection connection) throws SQLException {
        this.conn = (IfxConnection)connection;
        try {
            Class<?> clazz = Class.forName(this.conn.getProtoClassName());
            Class<?> clazz2 = Class.forName(this.conn.getConnClassName());
            Class[] classArray = new Class[]{clazz2};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{this.conn};
            this.prot = (IfxProtocol)constructor.newInstance(objectArray);
            return;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79735, exception.toString(), this.conn);
        }
    }

    public IfxLobDescriptor IfxLoColInfo(String string) throws SQLException {
        if (string == null) {
            throw IfxErrMsg.getSQLException(-79708, this.conn);
        }
        Object object = this.conn;
        object = new byte[object.isLongID() ? 596 : 164];
        IfxLvarchar ifxLvarchar = new IfxLvarchar(string);
        ifxLvarchar.setExtendedTypeName(LO_COL_NAME);
        IfxUDT ifxUDT = new IfxUDT();
        ifxUDT.setConnection(this.conn);
        ifxUDT.setExtendedTypeName(LO_CREATE_SPEC_NAME);
        ifxUDT.fromBytes((byte[])object);
        Vector<IfxBaseType> vector = new Vector<IfxBaseType>();
        Vector vector2 = null;
        vector.addElement(ifxLvarchar);
        vector.addElement(ifxUDT);
        vector2 = this.prot.executeFastPath(IFX_LO_COL_INFO, vector, false);
        IfxUDT ifxUDT2 = (IfxUDT)vector2.elementAt(1);
        byte[] byArray = ifxUDT2.toBytes();
        IfxInteger ifxInteger = (IfxInteger)vector2.elementAt(2);
        ifxInteger.toInt();
        return new IfxLobDescriptor(this.conn, byArray);
    }

    public int IfxLoCreate(IfxLobDescriptor ifxLobDescriptor, int n, IfxLocator ifxLocator) throws SQLException {
        byte[] byArray = new byte[72];
        byte[] byArray2 = ifxLobDescriptor.getRawLobDescriptor();
        IfxUDT ifxUDT = new IfxUDT();
        ifxUDT.setConnection(this.conn);
        ifxUDT.setExtendedTypeName(LO_CREATE_SPEC_NAME);
        ifxUDT.fromBytes(byArray2);
        IfxInteger ifxInteger = new IfxInteger(n);
        IfxUDT ifxUDT2 = new IfxUDT();
        ifxUDT2.setConnection(this.conn);
        ifxUDT2.setExtendedTypeName(LO_NAME);
        ifxUDT2.fromBytes(byArray);
        Vector<IfxObject> vector = new Vector<IfxObject>();
        Vector vector2 = null;
        vector.addElement(ifxUDT);
        vector.addElement(ifxInteger);
        vector.addElement(ifxUDT2);
        vector2 = this.prot.executeFastPath(IFX_LO_CREATE, vector, false);
        IfxUDT ifxUDT3 = (IfxUDT)vector2.elementAt(0);
        byte[] byArray3 = ifxUDT3.toBytes();
        IfxInteger ifxInteger2 = (IfxInteger)vector2.elementAt(1);
        ifxLocator.setRawLocator(byArray3);
        return ifxInteger2.toInt();
    }

    public int IfxLoCreate(IfxLobDescriptor ifxLobDescriptor, int n, IfxBblob ifxBblob) throws SQLException {
        IfxLocator ifxLocator = new IfxLocator();
        ifxBblob.setLocator(ifxLocator);
        ifxBblob.setConnection(this.conn);
        return this.IfxLoCreate(ifxLobDescriptor, n, ifxLocator);
    }

    public int IfxLoCreate(IfxLobDescriptor ifxLobDescriptor, int n, IfxCblob ifxCblob) throws SQLException {
        IfxLocator ifxLocator = new IfxLocator();
        ifxCblob.setLocator(ifxLocator);
        ifxCblob.setConnection(this.conn);
        return this.IfxLoCreate(ifxLobDescriptor, n, ifxLocator);
    }

    public int IfxLoOpen(IfxLocator ifxLocator, int n) throws SQLException {
        byte[] byArray = ifxLocator.getRawLocator();
        IfxUDT ifxUDT = new IfxUDT();
        ifxUDT.setConnection(this.conn);
        ifxUDT.setExtendedTypeName(LO_NAME);
        ifxUDT.fromBytes(byArray);
        IfxInteger ifxInteger = new IfxInteger(n);
        Vector<IfxObject> vector = new Vector<IfxObject>();
        Vector vector2 = null;
        vector.addElement(ifxUDT);
        vector.addElement(ifxInteger);
        vector2 = this.prot.executeFastPath(IFX_LO_OPEN, vector, false);
        IfxInteger ifxInteger2 = (IfxInteger)vector2.elementAt(0);
        return ifxInteger2.toInt();
    }

    public int IfxLoOpen(IfxBblob ifxBblob, int n) throws SQLException {
        IfxLocator ifxLocator = ifxBblob.getLocator();
        return this.IfxLoOpen(ifxLocator, n);
    }

    public int IfxLoOpen(IfxCblob ifxCblob, int n) throws SQLException {
        IfxLocator ifxLocator = ifxCblob.getLocator();
        return this.IfxLoOpen(ifxLocator, n);
    }

    public void IfxLoRelease(IfxLocator ifxLocator) throws SQLException {
        byte[] byArray = ifxLocator.getRawLocator();
        int n = 0;
        IfxUDT ifxUDT = new IfxUDT();
        ifxUDT.setConnection(this.conn);
        ifxUDT.setExtendedTypeName(LO_NAME);
        ifxUDT.fromBytes(byArray);
        Vector<IfxUDT> vector = new Vector<IfxUDT>();
        Vector vector2 = null;
        vector.addElement(ifxUDT);
        vector2 = this.prot.executeFastPath(IFX_LO_RELEASE, vector, false);
        IfxInteger ifxInteger = (IfxInteger)vector2.elementAt(0);
        n = ifxInteger.toInt();
    }

    public void IfxLoRelease(IfxBblob ifxBblob) throws SQLException {
        IfxLocator ifxLocator = ifxBblob.getLocator();
        this.IfxLoRelease(ifxLocator);
    }

    public void IfxLoRelease(IfxCblob ifxCblob) throws SQLException {
        IfxLocator ifxLocator = ifxCblob.getLocator();
        this.IfxLoRelease(ifxLocator);
    }

    public void IfxLoClose(int n) throws SQLException {
        IfxInteger ifxInteger = new IfxInteger(n);
        Vector<IfxInteger> vector = new Vector<IfxInteger>();
        Vector vector2 = null;
        vector.addElement(ifxInteger);
        vector2 = this.prot.executeFastPath(IFX_LO_CLOSE, vector, false);
        IfxInteger ifxInteger2 = (IfxInteger)vector2.elementAt(0);
        ifxInteger2.toInt();
    }

    public long IfxLoSeek(int n, long l, int n2) throws SQLException {
        IfxInteger ifxInteger = new IfxInteger(n);
        IfxInt8 ifxInt8 = new IfxInt8(l);
        IfxInteger ifxInteger2 = new IfxInteger(n2);
        IfxInt8 ifxInt82 = new IfxInt8(0L);
        Vector<IfxObject> vector = new Vector<IfxObject>();
        Vector vector2 = null;
        vector.addElement(ifxInteger);
        vector.addElement(ifxInt8);
        vector.addElement(ifxInteger2);
        vector.addElement(ifxInt82);
        vector2 = this.prot.executeFastPath(IFX_LO_SEEK, vector, false);
        IfxInt8 ifxInt83 = (IfxInt8)vector2.elementAt(0);
        IfxInteger cfr_ignored_0 = (IfxInteger)vector2.elementAt(1);
        return ifxInt83.toLong();
    }

    public void IfxLoTruncate(int n, long l) throws SQLException {
        IfxInteger ifxInteger = new IfxInteger(n);
        IfxInt8 ifxInt8 = new IfxInt8(l);
        Vector<IfxObject> vector = new Vector<IfxObject>();
        Vector vector2 = null;
        vector.addElement(ifxInteger);
        vector.addElement(ifxInt8);
        vector2 = this.prot.executeFastPath(IFX_LO_TRUNCATE, vector, false);
        IfxInteger cfr_ignored_0 = (IfxInteger)vector2.elementAt(0);
    }

    public long IfxLoSize(int n) throws SQLException {
        IfxLoStat ifxLoStat = this.IfxLoGetStat(n);
        return ifxLoStat.getSize();
    }

    public IfxLoStat IfxLoGetStat(int n) throws SQLException {
        int n2 = this.conn.isLongID() ? 644 : 212;
        byte[] byArray = new byte[n2];
        IfxInteger ifxInteger = new IfxInteger(n);
        IfxUDT ifxUDT = new IfxUDT();
        ifxUDT.setConnection(this.conn);
        ifxUDT.setExtendedTypeName(LO_STAT_NAME);
        ifxUDT.fromBytes(byArray);
        Vector<IfxObject> vector = new Vector<IfxObject>();
        Vector vector2 = null;
        vector.addElement(ifxInteger);
        vector.addElement(ifxUDT);
        vector2 = this.prot.executeFastPath(IFX_LO_STAT, vector, false);
        IfxUDT ifxUDT2 = (IfxUDT)vector2.elementAt(0);
        byArray = ifxUDT2.toBytes();
        return new IfxLoStat(this.conn, byArray);
    }

    public long IfxLoTell(int n) throws SQLException {
        IfxInteger ifxInteger = new IfxInteger(n);
        IfxInt8 ifxInt8 = new IfxInt8(0L);
        Vector<IfxObject> vector = new Vector<IfxObject>();
        Vector vector2 = null;
        vector.addElement(ifxInteger);
        vector.addElement(ifxInt8);
        vector2 = this.prot.executeFastPath(IFX_LO_TELL, vector, false);
        IfxInt8 ifxInt82 = (IfxInt8)vector2.elementAt(0);
        return ifxInt82.toLong();
    }

    public byte[] IfxLoRead(int n, int n2) throws SQLException {
        if (n2 < 1 || n < -1) {
            throw IfxErrMsg.getSQLException(-79773, this.conn);
        }
        byte[] byArray = new byte[n2];
        this.prot.executeReadSmBlob(n, byArray, n2);
        return byArray;
    }

    public int IfxLoRead(int n, byte[] byArray, int n2) throws SQLException {
        if (byArray == null || byArray.length < n2 || n < -1) {
            throw IfxErrMsg.getSQLException(-79773, this.conn);
        }
        return this.prot.executeReadSmBlob(n, byArray, n2);
    }

    public int IfxLoRead(int n, FileOutputStream fileOutputStream, int n2) throws SQLException {
        if (n2 < 1 || n < -1) {
            throw IfxErrMsg.getSQLException(-79773, this.conn);
        }
        return this.prot.executeReadSmBlob(n, fileOutputStream, n2);
    }

    public int IfxLoWrite(int n, byte[] byArray) throws SQLException {
        int n2 = 0;
        if (byArray == null || n < -1) {
            throw IfxErrMsg.getSQLException(-79773, this.conn);
        }
        n2 = this.prot.executeWriteSmBlob(n, byArray);
        if (n2 < 0) {
            throw IfxErrMsg.getSQLException(-79754, this.conn);
        }
        return n2;
    }

    public int IfxLoWrite(int n, InputStream inputStream, int n2) throws SQLException {
        int n3 = 0;
        if (n2 < 1 || n < -1) {
            throw IfxErrMsg.getSQLException(-79773, this.conn);
        }
        n3 = this.prot.executeWriteSmBlob(n, inputStream, n2);
        if (n3 < 0) {
            throw IfxErrMsg.getSQLException(-79754, this.conn);
        }
        return n3;
    }
}

