/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxColumnInfo;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxDateTime;
import com.informix.lang.IfxTypes;
import com.informix.util.IfxErrMsg;
import com.informix.util.IfxMap;
import com.informix.util.Trace;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.StringTokenizer;
import java.util.Vector;

public class IfxResultSetMetaData
implements ResultSetMetaData {
    Vector cinfoVector = new Vector();
    boolean hasVariableLengthColumns;
    short textByteColumnCount;
    private int numberofcol;
    private boolean delimIdent = false;
    private IfxConnection conn;
    protected Trace trace;

    public IfxResultSetMetaData(int n, IfxConnection ifxConnection) {
        try {
            this.setColumnCount(n);
        }
        catch (SQLException sQLException) {}
        this.textByteColumnCount = 0;
        this.conn = ifxConnection;
        this.trace = this.conn.getTrace();
    }

    IfxResultSetMetaData(IfxResultSetMetaData ifxResultSetMetaData) throws SQLException {
        this.numberofcol = ifxResultSetMetaData.numberofcol;
        if (this.numberofcol > 0) {
            this.cinfoVector.setSize(this.numberofcol);
        } else {
            this.cinfoVector.setSize(20);
        }
        int n = 0;
        while (n < this.numberofcol) {
            this.cinfoVector.setElementAt(ifxResultSetMetaData.getColumnInfo(n + 1).clone(), n);
            ++n;
        }
        this.hasVariableLengthColumns = ifxResultSetMetaData.hasVariableLengthColumns;
        this.textByteColumnCount = ifxResultSetMetaData.textByteColumnCount;
        this.delimIdent = ifxResultSetMetaData.delimIdent;
        this.conn = ifxResultSetMetaData.conn;
        this.trace = ifxResultSetMetaData.trace;
    }

    public int getColumnCount() throws SQLException {
        return this.numberofcol;
    }

    IfxColumnInfo getColumnInfo(int n) throws SQLException {
        if (n < 1 || n > this.numberofcol) {
            throw IfxErrMsg.getSQLException(-79703, this.conn);
        }
        return (IfxColumnInfo)this.cinfoVector.elementAt(n - 1);
    }

    private IfxColumnInfo getColumnInfo(int n, boolean bl) throws SQLException {
        if (bl && n > this.numberofcol) {
            if (n > this.cinfoVector.size()) {
                this.cinfoVector.setSize(n + 20);
            }
            int n2 = 0;
            while (n2 < n - this.numberofcol) {
                this.cinfoVector.setElementAt(new IfxColumnInfo(), this.numberofcol + n2);
                ++n2;
            }
            this.numberofcol = n;
        }
        return this.getColumnInfo(n);
    }

    public int getColumnLength(int n) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n);
        int n2 = ifxColumnInfo.ColLength;
        int n3 = ifxColumnInfo.SQLtype;
        if (n2 != -1 && (n3 == 10 || n3 == 14 || n3 == 5 || n3 == 8)) {
            n2 = ((n2 >> 8 & 0xFF) + (n2 & 0xFF & 1) + 3) / 2;
        }
        return n2;
    }

    public int getColumnStartPosition(int n) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n);
        return ifxColumnInfo.ColStartPos;
    }

    public int getColumnExtendedId(int n) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n);
        return ifxColumnInfo.ExtendedId;
    }

    public String getExtendedName(int n) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n);
        return ifxColumnInfo.ExtendedName;
    }

    public String getExtendedOwnerName(int n) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n);
        return ifxColumnInfo.ExtendedOwner;
    }

    public short getReference(int n) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n);
        return ifxColumnInfo.Reference;
    }

    public int getAlignment(int n) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n);
        return ifxColumnInfo.Alignment;
    }

    public int getSourceType(int n) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n);
        return ifxColumnInfo.SourceType;
    }

    public boolean isAutoIncrement(int n) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n);
        return ifxColumnInfo.SQLtype == 6 || ifxColumnInfo.SQLtype == 18;
    }

    public boolean isCaseSensitive(int n) throws SQLException {
        this.getColumnInfo(n);
        return this.delimIdent;
    }

    public boolean isSearchable(int n) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n);
        switch (ifxColumnInfo.SQLtype) {
            case 11: 
            case 12: 
            case 40: 
            case 41: {
                return false;
            }
        }
        return true;
    }

    public boolean isCurrency(int n) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n);
        return ifxColumnInfo.SQLtype == 8;
    }

    public int isNullable(int n) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n);
        if (ifxColumnInfo.Nullable) {
            return 1;
        }
        return 0;
    }

    public boolean isSigned(int n) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n);
        switch (ifxColumnInfo.SQLtype) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 17: {
                return true;
            }
        }
        return false;
    }

    public int getColumnDisplaySize(int n) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n);
        switch (ifxColumnInfo.SQLtype) {
            case 13: {
                return ifxColumnInfo.ColLength & 0xFF;
            }
            case 45: {
                return 1;
            }
            case 1: {
                return 6;
            }
            case 10: 
            case 14: {
                int n2 = ifxColumnInfo.ColLength >> 8 & 0xFF;
                int n3 = ifxColumnInfo.ColLength >> 4 & 0xF;
                int n4 = ifxColumnInfo.ColLength & 0xF;
                int n5 = n2 + ((n4 > 10 ? 12 : n4) - n3) / 2 + (n3 == 12 ? 1 : 0);
                if (ifxColumnInfo.SQLtype == 10) {
                    return n5;
                }
                return n5 + 1;
            }
            case 7: {
                return 23;
            }
            case 2: 
            case 6: {
                return 11;
            }
            case 17: 
            case 18: {
                return 20;
            }
            case 3: 
            case 4: {
                return 14;
            }
            case 8: {
                int n6 = ifxColumnInfo.ColLength >> 8 & 0xFF;
                int n7 = ifxColumnInfo.ColLength & 0xFF;
                int n8 = n6 + 3;
                if (n6 == n7) {
                    ++n8;
                }
                return n8;
            }
            case 5: {
                int n9;
                int n10 = ifxColumnInfo.ColLength >> 8 & 0xFF;
                int n11 = ifxColumnInfo.ColLength & 0xFF;
                if (n11 == 255) {
                    n9 = 1 + n10 + 1 + 1 + 4;
                } else {
                    n9 = n10 + 1 + 1;
                    if (n10 == n11) {
                        ++n9;
                    }
                }
                return n9;
            }
        }
        return ifxColumnInfo.ColLength;
    }

    public String getColumnLabel(int n) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n);
        return ifxColumnInfo.ColName;
    }

    public String getColumnName(int n) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n);
        return ifxColumnInfo.ColName;
    }

    public String getSchemaName(int n) throws SQLException {
        this.getColumnInfo(n);
        return "";
    }

    public int getPrecision(int n) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n);
        if (ifxColumnInfo.SQLtype == 8 || ifxColumnInfo.SQLtype == 5) {
            return ifxColumnInfo.ColLength >> 8 & 0xFF;
        }
        return 0;
    }

    int getEncodedLength(int n) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n);
        return ifxColumnInfo.ColLength;
    }

    public int getScale(int n) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n);
        if (ifxColumnInfo.SQLtype == 8 || ifxColumnInfo.SQLtype == 5) {
            return ifxColumnInfo.ColLength & 0xFF;
        }
        return 0;
    }

    public String getTableName(int n) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n);
        return ifxColumnInfo.TableName;
    }

    public String getCatalogName(int n) throws SQLException {
        this.getColumnInfo(n);
        return "";
    }

    public int getColumnType(int n) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n);
        if (ifxColumnInfo.ExtendedName.equals("boolean")) {
            return 1111;
        }
        if (ifxColumnInfo.ExtendedName.equals("lvarchar")) {
            return -1;
        }
        if (ifxColumnInfo.IsDistinct) {
            return 2001;
        }
        return IfxTypes.FromIfxToJDBCType(ifxColumnInfo.SQLtype);
    }

    public int getIfxColumnType(int n) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n);
        return ifxColumnInfo.SQLtype;
    }

    public String getColumnTypeName(int n) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n);
        if (ifxColumnInfo.SQLtype > 18 || ifxColumnInfo.IsDistinct) {
            return ifxColumnInfo.ExtendedName;
        }
        return ifxColumnInfo.DataSourceName;
    }

    public boolean isReadOnly(int n) throws SQLException {
        this.getColumnInfo(n);
        return false;
    }

    public boolean isWritable(int n) throws SQLException {
        this.getColumnInfo(n);
        return true;
    }

    public boolean isDefinitelyWritable(int n) throws SQLException {
        this.getColumnInfo(n);
        return true;
    }

    void setEncodedLength(int n, int n2) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n, true);
        ifxColumnInfo.ColLength = n2;
        if (ifxColumnInfo.SQLtype == 10) {
            ifxColumnInfo.DataSourceName = String.valueOf(ifxColumnInfo.DataSourceName) + " " + IfxDateTime.getQualifierName((short)n2);
        }
    }

    public void setNullable(int n, boolean bl) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n, true);
        ifxColumnInfo.Nullable = bl;
    }

    void setMaxWidth(int n, int n2) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n, true);
        ifxColumnInfo.MaxWidth = n2;
    }

    void setColtitle(int n, String string) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n, true);
        if (string == null) {
            ifxColumnInfo.Coltitle = new String("");
            return;
        }
        ifxColumnInfo.Coltitle = new String(string);
    }

    public void setColumnName(int n, String string) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n, true);
        if (string == null) {
            ifxColumnInfo.ColName = new String("");
            return;
        }
        ifxColumnInfo.ColName = new String(string);
    }

    public void setDecimalDigits(int n, int n2) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n, true);
        ifxColumnInfo.DecimalDigits = n2;
    }

    public void setRightDecimal(int n, int n2) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n, true);
        ifxColumnInfo.RightDecimal = n2;
    }

    public void setTableName(int n, String string) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n, true);
        if (string == null) {
            ifxColumnInfo.TableName = new String("");
            return;
        }
        ifxColumnInfo.TableName = new String(string);
    }

    boolean isVariableLengthType(int n) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n, true);
        return ifxColumnInfo.SQLtype > 18;
    }

    public void setIfxColumnType(int n, int n2) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n, true);
        if (IfxResultSetMetaData.setTypeBooleanFields(ifxColumnInfo, n2)) {
            this.hasVariableLengthColumns = true;
        }
        if (!this.hasVariableLengthColumns && this.isVariableLengthType(n)) {
            this.hasVariableLengthColumns = true;
        }
        this.setDataSourceName(n, IfxTypes.IfxTypeToName(ifxColumnInfo.SQLtype));
    }

    public static boolean setTypeBooleanFields(IfxColumnInfo ifxColumnInfo, int n) {
        boolean bl = false;
        if ((n & 0x100) > 0) {
            ifxColumnInfo.Nullable = false;
        }
        if ((n & 0x800) > 0) {
            ifxColumnInfo.IsDistinct = true;
            bl = true;
        }
        if ((n & 0x1000) > 0) {
            ifxColumnInfo.IsNamedRow = true;
        }
        ifxColumnInfo.SQLtype = n & 0xFF;
        return bl;
    }

    public void setDataSourceName(int n, String string) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n, true);
        if (string == null) {
            ifxColumnInfo.DataSourceName = new String("");
            return;
        }
        ifxColumnInfo.DataSourceName = new String(string);
    }

    void setSourceType(int n, int n2) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n, true);
        ifxColumnInfo.SourceType = n2;
    }

    void setColumnStartPosition(int n, int n2) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n, true);
        ifxColumnInfo.ColStartPos = n2;
    }

    void setColumnExtendedId(int n, int n2) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n, true);
        ifxColumnInfo.ExtendedId = n2;
    }

    void setExtendedName(int n, String string) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n, true);
        if (string == null) {
            ifxColumnInfo.ExtendedName = new String("");
            return;
        }
        ifxColumnInfo.ExtendedName = new String(string);
    }

    void setExtendedOwnerName(int n, String string) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n, true);
        if (string == null) {
            ifxColumnInfo.ExtendedOwner = new String("");
            return;
        }
        ifxColumnInfo.ExtendedOwner = new String(string);
    }

    void setReference(int n, short s) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n, true);
        ifxColumnInfo.Reference = s;
    }

    void setAlignment(int n, short s) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n, true);
        ifxColumnInfo.Alignment = s;
    }

    public void setColumnCount(int n) throws SQLException {
        this.numberofcol = n;
        if (n > 0) {
            this.cinfoVector.setSize(n);
        } else {
            this.cinfoVector.setSize(20);
        }
        int n2 = 0;
        while (n2 < n) {
            this.cinfoVector.setElementAt(new IfxColumnInfo(), n2);
            ++n2;
        }
    }

    void setColInfo(int n, int n2, String string, String string2, int n3, String string3, int n4, int n5, int n6, String string4, String string5, int n7, int n8) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n, true);
        ifxColumnInfo.ColLength = n5;
        ifxColumnInfo.MaxWidth = n2;
        ifxColumnInfo.Coltitle = string == null ? new String("") : new String(string);
        ifxColumnInfo.ColName = ifxColumnInfo.Coltitle;
        ifxColumnInfo.TableName = string2 == null ? new String("") : new String(string2);
        if (n3 == 41 && n6 == 10) {
            this.setIfxColumnType(n, 102);
        } else if (n3 == 41 && n6 == 11) {
            this.setIfxColumnType(n, 101);
        } else {
            this.setIfxColumnType(n, n3);
        }
        ifxColumnInfo.DataSourceName = string3 == null ? new String("") : new String(string3);
        ifxColumnInfo.SourceType = n4;
        ifxColumnInfo.ExtendedId = n6;
        ifxColumnInfo.ExtendedName = string5 == null ? new String("") : new String(string5);
        ifxColumnInfo.ExtendedOwner = string4 == null ? new String("") : new String(string4);
        ifxColumnInfo.Nullable = n7 == 1;
        if (n8 == 1) {
            this.delimIdent = true;
            return;
        }
        this.delimIdent = false;
    }

    boolean isDistinct(int n) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n, true);
        return ifxColumnInfo.IsDistinct;
    }

    void setDistinct(int n, boolean bl) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n, true);
        ifxColumnInfo.IsDistinct = bl;
    }

    public void setDelimIdent(boolean bl) {
        this.delimIdent = bl;
    }

    void copyColumnInfo(int n, IfxColumnInfo ifxColumnInfo) throws SQLException {
        this.getColumnInfo(n, true);
        this.cinfoVector.setElementAt(ifxColumnInfo, n - 1);
    }

    public String getColumnClassName(int n) throws SQLException {
        Class clazz;
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n);
        IfxMap ifxMap = this.conn.getTypeMap();
        if (ifxColumnInfo.IsDistinct) {
            clazz = null;
            if (ifxMap != null && !ifxMap.isEmpty() && (clazz = (Class)ifxMap.get(ifxColumnInfo.ExtendedName)) != null) {
                return clazz.getName();
            }
        }
        if (ifxColumnInfo.SQLtype <= 18) {
            return IfxTypes.FromIfxTypeToJava(ifxColumnInfo.SQLtype);
        }
        if (ifxColumnInfo.ExtendedName.equals("boolean")) {
            return "java.lang.Boolean";
        }
        if (ifxColumnInfo.ExtendedName.equals("lvarchar")) {
            return "java.lang.String";
        }
        if (ifxColumnInfo.ExtendedName.equals("clob")) {
            return "com.informix.jdbc.IfxCblob";
        }
        if (ifxColumnInfo.ExtendedName.equals("blob")) {
            return "com.informix.jdbc.IfxBblob";
        }
        if (ifxColumnInfo.SQLtype == 41 || ifxColumnInfo.SQLtype == 40) {
            if (ifxColumnInfo.SourceType == 5) {
                return "java.lang.Boolean";
            }
            if (ifxColumnInfo.SourceType == 1) {
                return "java.lang.String";
            }
            if (ifxColumnInfo.SourceType == 11) {
                return "com.informix.jdbc.IfxCblob";
            }
            if (ifxColumnInfo.SourceType == 10) {
                return "com.informix.jdbc.IfxBblob";
            }
            clazz = null;
            if (ifxMap != null && !ifxMap.isEmpty() && (clazz = (Class)ifxMap.get(ifxColumnInfo.ExtendedName)) != null) {
                return clazz.getName();
            }
            return "java.sql.SQLData";
        }
        return "unknown classname";
    }

    void setTextByteColumnCount() throws SQLException {
        this.textByteColumnCount = 0;
        int n = 1;
        while (n <= this.getColumnCount()) {
            IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n, true);
            if (ifxColumnInfo.SQLtype == 11 || ifxColumnInfo.SQLtype == 12 || ifxColumnInfo.SQLtype == 41 && (ifxColumnInfo.ExtendedId == 10 || ifxColumnInfo.ExtendedId == 11)) {
                this.textByteColumnCount = (short)(this.textByteColumnCount + 1);
            }
            ++n;
        }
    }

    boolean needSvrConv() throws SQLException {
        int n = 1;
        while (n <= this.numberofcol) {
            int n2 = this.getIfxColumnType(n);
            if (n2 == 41 || n2 == 40 && this.getColumnExtendedId(n) != 1 || n2 == 19 || n2 == 21 || n2 == 20 || n2 == 22) {
                return true;
            }
            ++n;
        }
        return false;
    }

    boolean needSvrConv(int n) throws SQLException {
        int n2 = this.getIfxColumnType(n);
        return n2 == 41 || n2 == 40 && this.getColumnExtendedId(n) != 1 || n2 == 19 || n2 == 21 || n2 == 20 || n2 == 22;
    }

    public static String parseTableName(String string) {
        String string2 = null;
        if (string == null) {
            return null;
        }
        try {
            String string3 = string.toUpperCase().trim();
            int n = -1;
            boolean bl = true;
            if (string3.startsWith("SELECT")) {
                n = string3.indexOf("FROM");
                bl = true;
            } else if (string3.startsWith("UPDATE")) {
                n = 0;
            } else if (string3.startsWith("INSERT")) {
                n = string3.indexOf("INTO");
            }
            if (n > -1) {
                String string4 = string.substring(n);
                StringTokenizer stringTokenizer = new StringTokenizer(string4);
                String string5 = stringTokenizer.nextToken();
                string5 = stringTokenizer.nextToken();
                string2 = bl && (string5.equals(",") || string5.endsWith(",")) ? null : string5;
            }
        }
        catch (Exception exception) {}
        return string2;
    }

    public void parseSetTableName(String string) throws SQLException {
        String string2 = IfxResultSetMetaData.parseTableName(string);
        if (string2 != null) {
            int n = 1;
            while (n <= this.numberofcol) {
                this.setTableName(n, string2);
                ++n;
            }
        }
    }
}

