/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfmxResultSet;
import com.informix.jdbc.IfxBlob;
import com.informix.jdbc.IfxCallableStatement;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxPreparedStatement;
import com.informix.jdbc.IfxProtocol;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.jdbc.IfxSqli;
import com.informix.jdbc.IfxStatement;
import com.informix.jdbc.ResultSet2;
import com.informix.lang.Interval;
import com.informix.lang.IntervalDF;
import com.informix.lang.IntervalYM;
import com.informix.util.IfxErrMsg;
import com.informix.util.IfxMap;
import com.informix.util.Trace;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.sql.DataTruncation;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Vector;

public class IfxResultSet
implements IfmxResultSet,
ResultSet2 {
    static final int DIR_FIRST = 3;
    static final int DIR_LAST = 4;
    static final int DIR_ABSL = 6;
    static final int DIR_NEXT = 1;
    static final int DIR_PREV = 2;
    static final int DIR_RELT = 7;
    static final int DIR_CURR = 5;
    private IfxProtocol prot;
    protected Hashtable nameToIdxTable;
    protected IfxConnection conn;
    protected IfxStatement stmt;
    protected int curRowID;
    protected int LastRowID;
    protected IfxResultSetMetaData rsmd;
    protected Vector colVector;
    protected Trace trace;
    protected boolean lastColWasNull = false;

    IfxResultSet(IfxStatement ifxStatement) throws SQLException {
        this.conn = (IfxConnection)ifxStatement.getConnection();
        try {
            Class<?> clazz = Class.forName(this.conn.getProtoClassName());
            Class<?> clazz2 = Class.forName(this.conn.getConnClassName());
            Class[] classArray = new Class[]{clazz2};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{this.conn};
            this.prot = (IfxProtocol)constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79735, exception.toString(), this.conn);
        }
        this.stmt = ifxStatement;
    }

    public IfxResultSet() throws SQLException {
    }

    void setTrace(Trace trace) {
    }

    void executePrepare() throws SQLException {
        if (this.prot == null) {
            throw IfxErrMsg.getSQLException(-79736, this.conn);
        }
        this.clearWarnings();
        this.prot.executePrepare(this.stmt);
    }

    public void executeQuery() throws SQLException {
        this.executeQuery(false);
    }

    void executeQuery(boolean bl) throws SQLException {
        if (this.prot == null) {
            throw IfxErrMsg.getSQLException(-79736, this.conn);
        }
        this.clearWarnings();
        this.prot.executeStatementQuery(this.stmt, bl);
        this.curRowID = 0;
        this.LastRowID = 0;
    }

    void executeQuery(IfxResultSetMetaData ifxResultSetMetaData) throws SQLException {
        this.executeQuery(ifxResultSetMetaData, false);
    }

    void executeQuery(IfxResultSetMetaData ifxResultSetMetaData, boolean bl) throws SQLException {
        if (this.prot == null) {
            throw IfxErrMsg.getSQLException(-79736, this.conn);
        }
        this.clearWarnings();
        this.prot.executeStatementQuery(this.stmt, bl, ifxResultSetMetaData);
        this.curRowID = 0;
        this.LastRowID = 0;
    }

    int executeUpdate() throws SQLException {
        if (this.prot == null) {
            throw IfxErrMsg.getSQLException(-79736, this.conn);
        }
        this.clearWarnings();
        this.prot.executeCommand(this.stmt);
        this.curRowID = 0;
        this.LastRowID = 0;
        return this.prot.getNumberOfRowsProcessed();
    }

    boolean executeExecute() throws SQLException {
        boolean bl = false;
        if (this.prot == null) {
            throw IfxErrMsg.getSQLException(-79736, this.conn);
        }
        this.clearWarnings();
        this.prot.executeExecute(this.stmt);
        if (!this.isEmptyResultSet()) {
            bl = true;
        }
        this.curRowID = 0;
        this.LastRowID = 0;
        return bl;
    }

    boolean executeExecute(IfxResultSetMetaData ifxResultSetMetaData) throws SQLException {
        boolean bl = false;
        if (this.prot == null) {
            throw IfxErrMsg.getSQLException(-79736, this.conn);
        }
        this.clearWarnings();
        this.prot.executeExecute(this.stmt, ifxResultSetMetaData);
        if (!this.isEmptyResultSet()) {
            bl = true;
        }
        this.curRowID = 0;
        this.LastRowID = 0;
        return bl;
    }

    public boolean next() throws SQLException {
        int n;
        int n2 = this.stmt.getMaxRows();
        boolean bl = false;
        if (this.prot == null) {
            return false;
        }
        this.clearWarnings();
        if (n2 != 0 && this.curRowID >= n2) {
            return false;
        }
        int n3 = n = this.stmt.getResultSetType() == 1004 ? 1 : 0;
        if (n == 1) {
            bl = this.prot.getaRow(this.stmt.getFetchDirection(), ++this.curRowID, 6, n);
            this.curRowID = this.prot.getTupid();
        } else {
            bl = this.prot.getaRow(this.stmt.getFetchDirection(), 1, 1, n);
        }
        if (!bl) {
            return false;
        }
        if (this.colVector == null) {
            try {
                this.colVector = new Vector();
                this.colVector.setSize(this.getMetaData().getColumnCount());
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
            }
        } else {
            this.clearColumnVector();
        }
        if (n != 1) {
            ++this.curRowID;
        }
        return true;
    }

    public int findColumn(String string) throws SQLException {
        Integer n;
        if (this.nameToIdxTable == null) {
            if (this.rsmd == null) {
                this.getMetaData();
            }
            if (this.rsmd == null) {
                throw IfxErrMsg.getSQLException(-79737, this.conn);
            }
            int n2 = this.rsmd.getColumnCount();
            this.nameToIdxTable = new Hashtable(n2);
            int n3 = 1;
            while (n3 <= n2) {
                this.nameToIdxTable.put(this.rsmd.getColumnName(n3), new Integer(n3));
                ++n3;
            }
        }
        if ((n = !this.conn.isDelimIdentSet() ? (Integer)this.nameToIdxTable.get(string.toLowerCase()) : (Integer)this.nameToIdxTable.get(string)) == null) {
            throw IfxErrMsg.getSQLException(-79738, this.conn);
        }
        return n;
    }

    IfxObject getValue(int n) throws SQLException {
        if (this.colVector == null) {
            throw IfxErrMsg.getSQLException(-79739, this.conn);
        }
        if (n < 1 || n > this.colVector.size()) {
            throw IfxErrMsg.getSQLException(-79703, this.conn);
        }
        IfxObject ifxObject = (IfxObject)this.colVector.elementAt(n - 1);
        if (ifxObject == null) {
            ifxObject = this.prot.getColumnInRow(n);
            this.colVector.setElementAt(ifxObject, n - 1);
        } else {
            this.prot.loadColumnData(n, ifxObject);
        }
        if (ifxObject.isNull()) {
            this.lastColWasNull = true;
            return null;
        }
        this.lastColWasNull = false;
        return ifxObject;
    }

    public String getString(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        String string = null;
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        this.blobCheck(ifxObject);
        string = ifxObject.toString();
        DataTruncation dataTruncation = ifxObject.getWarning();
        if (dataTruncation != null) {
            this.prot.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return string;
    }

    public String getString(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getString(n);
    }

    public Object getObject(int n) throws SQLException {
        Object object = null;
        object = this.conn != null ? this.getObject(n, this.conn.getTypeMap()) : this.getObject(n, (IfxMap)null);
        return object;
    }

    public Object getObject(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getObject(n);
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        this.blobCheck(ifxObject);
        InputStream inputStream = ifxObject.toAsciiStream();
        DataTruncation dataTruncation = ifxObject.getWarning();
        if (dataTruncation != null) {
            this.prot.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return inputStream;
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getAsciiStream(n);
    }

    public Reader getCharacterStream(int n) throws SQLException {
        String string = this.getString(n);
        if (string != null) {
            return new StringReader(string);
        }
        return null;
    }

    public Reader getCharacterStream(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getCharacterStream(n);
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        BigDecimal bigDecimal = ifxObject.toDecimal().setScale(n2, 4);
        DataTruncation dataTruncation = ifxObject.getWarning();
        if (dataTruncation != null) {
            this.prot.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return bigDecimal;
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        int n2 = this.findColumn(string);
        return this.getBigDecimal(n2, n);
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        return ifxObject.toDecimal();
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getBigDecimal(n);
    }

    public boolean getBoolean(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return false;
        }
        boolean bl = ifxObject.toBoolean();
        DataTruncation dataTruncation = ifxObject.getWarning();
        if (dataTruncation != null) {
            this.prot.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return bl;
    }

    public boolean getBoolean(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getBoolean(n);
    }

    public short getShort(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return 0;
        }
        short s = ifxObject.toShort();
        DataTruncation dataTruncation = ifxObject.getWarning();
        if (dataTruncation != null) {
            this.prot.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return s;
    }

    public short getShort(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getShort(n);
    }

    public int getInt(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return 0;
        }
        int n2 = ifxObject.toInt();
        DataTruncation dataTruncation = ifxObject.getWarning();
        if (dataTruncation != null) {
            this.prot.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return n2;
    }

    public int getInt(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getInt(n);
    }

    public long getLong(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return 0L;
        }
        long l = ifxObject.toLong();
        DataTruncation dataTruncation = ifxObject.getWarning();
        if (dataTruncation != null) {
            this.prot.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return l;
    }

    public long getLong(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getLong(n);
    }

    public float getFloat(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return 0.0f;
        }
        float f = ifxObject.toFloat();
        DataTruncation dataTruncation = ifxObject.getWarning();
        if (dataTruncation != null) {
            this.prot.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return f;
    }

    public float getFloat(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getFloat(n);
    }

    public byte getByte(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return 0;
        }
        byte by = ifxObject.toByte();
        DataTruncation dataTruncation = ifxObject.getWarning();
        if (dataTruncation != null) {
            this.prot.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return by;
    }

    public byte getByte(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getByte(n);
    }

    public byte[] getBytes(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        this.blobCheck(ifxObject);
        byte[] byArray = ifxObject.toBytes();
        DataTruncation dataTruncation = ifxObject.getWarning();
        if (dataTruncation != null) {
            this.prot.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return byArray;
    }

    public byte[] getBytes(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getBytes(n);
    }

    public Date getDate(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        Date date = ifxObject.toDate();
        DataTruncation dataTruncation = ifxObject.getWarning();
        if (dataTruncation != null) {
            this.prot.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return date;
    }

    public Date getDate(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getDate(n);
    }

    public double getDouble(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return 0.0;
        }
        double d = ifxObject.toDouble();
        DataTruncation dataTruncation = ifxObject.getWarning();
        if (dataTruncation != null) {
            this.prot.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return d;
    }

    public double getDouble(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getDouble(n);
    }

    public Time getTime(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        Time time = ifxObject.toTime();
        DataTruncation dataTruncation = ifxObject.getWarning();
        if (dataTruncation != null) {
            this.prot.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return time;
    }

    public Time getTime(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getTime(n);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        Timestamp timestamp = ifxObject.toTimestamp();
        DataTruncation dataTruncation = ifxObject.getWarning();
        if (dataTruncation != null) {
            this.prot.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return timestamp;
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getTimestamp(n);
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.getUnicodeStream(int).", this.conn);
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.getUnicodeStream(String).", this.conn);
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        this.blobCheck(ifxObject);
        InputStream inputStream = ifxObject.toBinaryStream();
        DataTruncation dataTruncation = ifxObject.getWarning();
        if (dataTruncation != null) {
            this.prot.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return inputStream;
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getBinaryStream(n);
    }

    public SQLWarning getWarnings() throws SQLException {
        if (this.prot != null) {
            return this.prot.getWarnings();
        }
        return null;
    }

    public void clearWarnings() throws SQLException {
        if (this.prot != null) {
            this.prot.clearWarnings();
        }
    }

    public String getCursorName() throws SQLException {
        if (this.stmt == null) {
            throw IfxErrMsg.getSQLException(-79740, this.conn);
        }
        return this.stmt.getCursorName();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.prot == null) {
            throw IfxErrMsg.getSQLException(-79736, this.conn);
        }
        this.rsmd = (IfxResultSetMetaData)this.prot.getMetaData();
        return this.rsmd;
    }

    public Object getObject(int n, IfxMap ifxMap) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        Object object = null;
        if (ifxObject != null && !ifxObject.isNull()) {
            this.blobCheck(ifxObject);
            ifxObject.setTypeMap(ifxMap);
            object = ifxObject.toObject();
            DataTruncation dataTruncation = ifxObject.getWarning();
            if (dataTruncation != null) {
                this.prot.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
            }
        }
        return object;
    }

    public Object getObject(String string, IfxMap ifxMap) throws SQLException {
        int n = this.findColumn(string);
        return this.getObject(n, ifxMap);
    }

    public boolean wasNull() throws SQLException {
        return this.lastColWasNull;
    }

    int getUpdateCount() throws SQLException {
        if (this.prot == null) {
            throw IfxErrMsg.getSQLException(-79736, this.conn);
        }
        if (this.prot.isResultSet()) {
            return -1;
        }
        return this.prot.getNumberOfRowsProcessed();
    }

    boolean isEmptyResultSet() throws SQLException {
        if (this.prot == null) {
            throw IfxErrMsg.getSQLException(-79736, this.conn);
        }
        return !this.prot.isResultSet() || this.prot.getTupleCount() <= 0;
    }

    public void close() throws SQLException {
        if (this.prot != null && this.prot.isCursorOpen()) {
            this.prot.executeClose(this.stmt);
        }
        if (!(this.stmt instanceof IfxPreparedStatement) && !(this.stmt instanceof IfxCallableStatement)) {
            this.closePrev();
            return;
        }
        this.clear();
    }

    void clear() {
        if (this.nameToIdxTable != null) {
            this.nameToIdxTable.clear();
            this.nameToIdxTable = null;
        }
        this.lastColWasNull = false;
        this.curRowID = 0;
        this.LastRowID = 0;
        this.clearColumnVector();
    }

    void closePrev() throws SQLException {
        if (this.prot != null) {
            this.prot.executeRelease(this.stmt);
        }
        this.clear();
        if (this.colVector != null) {
            this.colVector.removeAllElements();
            this.colVector = null;
        }
    }

    private void clearColumnVector() {
        if (this.colVector != null) {
            int n = 0;
            while (n < this.colVector.size()) {
                IfxObject ifxObject = (IfxObject)this.colVector.elementAt(n);
                if (ifxObject != null) {
                    ifxObject.clear();
                }
                ++n;
            }
        }
    }

    void closeNow() throws SQLException {
        if (this.prot != null) {
            this.prot.executeRelease(this.stmt);
        }
        this.clear();
        this.prot = null;
        this.stmt = null;
        if (this.colVector != null) {
            this.colVector.removeAllElements();
            this.colVector = null;
        }
    }

    private void blobCheck(IfxObject ifxObject) throws SQLException {
        IfxBlob ifxBlob;
        if (ifxObject instanceof IfxBlob && !(ifxBlob = (IfxBlob)ifxObject).isBlobLoaded()) {
            try {
                this.prot.executeFetchBlob(ifxBlob);
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79701, this.conn);
            }
            ifxBlob.setLoaded();
        }
    }

    int getSerial() throws SQLException {
        if (this.prot == null) {
            throw IfxErrMsg.getSQLException(-79736, this.conn);
        }
        return this.prot.getSerialInsert();
    }

    long getSerial8() throws SQLException {
        if (this.prot == null) {
            throw IfxErrMsg.getSQLException(-79736, this.conn);
        }
        return this.prot.getSerial8Inserted();
    }

    public Interval getInterval(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        Interval interval = ifxObject.toInterval();
        DataTruncation dataTruncation = ifxObject.getWarning();
        if (dataTruncation != null) {
            this.prot.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return interval;
    }

    public Interval getInterval(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getInterval(n);
    }

    public IntervalYM getIntervalYM(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        IntervalYM intervalYM = ifxObject.toIntervalYM();
        DataTruncation dataTruncation = ifxObject.getWarning();
        if (dataTruncation != null) {
            this.prot.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return intervalYM;
    }

    public IntervalYM getIntervalYM(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getIntervalYM(n);
    }

    public IntervalDF getIntervalDF(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        IntervalDF intervalDF = ifxObject.toIntervalDF();
        DataTruncation dataTruncation = ifxObject.getWarning();
        if (dataTruncation != null) {
            this.prot.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return intervalDF;
    }

    public IntervalDF getIntervalDF(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getIntervalDF(n);
    }

    public boolean isBeforeFirst() throws SQLException {
        this.clearWarnings();
        return this.curRowID == 0;
    }

    public boolean isAfterLast() throws SQLException {
        this.clearWarnings();
        if (this.LastRowID == 0) {
            int n = this.curRowID;
            boolean bl = this.last();
            this.LastRowID = this.curRowID;
            if (n == 0) {
                this.curRowID = 0;
            } else {
                bl = this.absolute(n);
            }
        } else if (this.curRowID == this.LastRowID + 1) {
            return true;
        }
        return false;
    }

    public boolean isFirst() throws SQLException {
        this.clearWarnings();
        return this.curRowID == 1;
    }

    public boolean isLast() throws SQLException {
        this.clearWarnings();
        return this.curRowID > 0 && this.curRowID == this.LastRowID;
    }

    public void beforeFirst() throws SQLException {
        this.clearWarnings();
        if (this.stmt.getResultSetType() == 1003) {
            throw IfxErrMsg.getSQLException(-79767, this.conn);
        }
        this.curRowID = 0;
    }

    public void afterLast() throws SQLException {
        this.clearWarnings();
        if (this.stmt.getResultSetType() == 1003) {
            throw IfxErrMsg.getSQLException(-79767, this.conn);
        }
        if (this.LastRowID != 0) {
            this.curRowID = this.LastRowID + 1;
            return;
        }
        boolean bl = this.last();
        if (bl) {
            this.curRowID = this.LastRowID + 1;
        }
    }

    public boolean first() throws SQLException {
        this.clearWarnings();
        if (this.stmt.getResultSetType() == 1003) {
            throw IfxErrMsg.getSQLException(-79767, this.conn);
        }
        boolean bl = this.prot.getaRow(this.stmt.getFetchDirection(), 1, 6, 1);
        this.curRowID = this.prot.getTupid();
        if (!bl) {
            return false;
        }
        if (this.colVector == null) {
            try {
                this.colVector = new Vector();
                this.colVector.setSize(this.getMetaData().getColumnCount());
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
            }
        } else {
            this.clearColumnVector();
        }
        return true;
    }

    public boolean last() throws SQLException {
        this.clearWarnings();
        if (this.stmt.getResultSetType() == 1003) {
            throw IfxErrMsg.getSQLException(-79767, this.conn);
        }
        boolean bl = this.prot.getaRow(this.stmt.getFetchDirection(), 0, 4, 1);
        this.LastRowID = this.curRowID = this.prot.getTupid();
        if (!bl) {
            return false;
        }
        if (this.colVector == null) {
            try {
                this.colVector = new Vector();
                this.colVector.setSize(this.getMetaData().getColumnCount());
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
            }
        } else {
            this.clearColumnVector();
        }
        return true;
    }

    public int getRow() throws SQLException {
        return this.curRowID;
    }

    public boolean absolute(int n) throws SQLException {
        boolean bl = false;
        this.clearWarnings();
        if (this.stmt.getResultSetType() == 1003) {
            throw IfxErrMsg.getSQLException(-79767, this.conn);
        }
        if (n == 0) {
            throw IfxErrMsg.getSQLException(-79768, this.conn);
        }
        if (n > 0) {
            bl = this.prot.getaRow(this.stmt.getFetchDirection(), n, 6, 1);
        } else if (n < 0) {
            bl = this.prot.getaRow(this.stmt.getFetchDirection(), 0, 4, 1);
            this.curRowID = this.prot.getTupid();
            if (n != -1) {
                bl = this.prot.getaRow(this.stmt.getFetchDirection(), this.curRowID + n + 1, 6, 1);
            }
        }
        this.curRowID = this.prot.getTupid();
        if (!bl) {
            return false;
        }
        if (this.colVector == null) {
            try {
                this.colVector = new Vector();
                this.colVector.setSize(this.getMetaData().getColumnCount());
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
            }
        } else {
            this.clearColumnVector();
        }
        return true;
    }

    public boolean relative(int n) throws SQLException {
        this.clearWarnings();
        if (this.stmt.getResultSetType() == 1003) {
            throw IfxErrMsg.getSQLException(-79767, this.conn);
        }
        if (this.curRowID == 0) {
            throw IfxErrMsg.getSQLException(-79739, this.conn);
        }
        if (n == 0) {
            return true;
        }
        boolean bl = this.prot.getaRow(this.stmt.getFetchDirection(), this.curRowID + n, 6, 1);
        this.curRowID = this.prot.getTupid();
        if (!bl) {
            return false;
        }
        if (this.colVector == null) {
            try {
                this.colVector = new Vector();
                this.colVector.setSize(this.getMetaData().getColumnCount());
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
            }
        } else {
            this.clearColumnVector();
        }
        return true;
    }

    public boolean current() throws SQLException {
        this.clearWarnings();
        if (this.stmt.getResultSetType() == 1003) {
            throw IfxErrMsg.getSQLException(-79767, this.conn);
        }
        return this.curRowID != 0;
    }

    public boolean previous() throws SQLException {
        this.clearWarnings();
        if (this.stmt.getResultSetType() == 1003) {
            throw IfxErrMsg.getSQLException(-79767, this.conn);
        }
        if (this.LastRowID > 0 && this.curRowID > this.LastRowID) {
            return this.last();
        }
        boolean bl = this.prot.getaRow(this.stmt.getFetchDirection(), 1, 2, 1);
        this.curRowID = this.prot.getTupid();
        if (!bl) {
            return false;
        }
        if (this.colVector == null) {
            try {
                this.colVector = new Vector();
                this.colVector.setSize(this.getMetaData().getColumnCount());
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
            }
        } else {
            this.clearColumnVector();
        }
        return true;
    }

    public void setFetchDirection(int n) throws SQLException {
        this.stmt.setFetchDirection(n);
    }

    public int getFetchDirection() throws SQLException {
        return this.stmt.getFetchDirection();
    }

    public void setFetchSize(int n) throws SQLException {
    }

    public int getFetchSize() throws SQLException {
        return 0;
    }

    public int getType() throws SQLException {
        return this.stmt.getResultSetType();
    }

    public int getConcurrency() throws SQLException {
        return this.stmt.getResultSetConcurrency();
    }

    public boolean rowUpdated() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.rowUpdated().", this.conn);
    }

    public boolean rowInserted() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.rowInserted().", this.conn);
    }

    public boolean rowDeleted() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.rowDeleted().", this.conn);
    }

    public void updateNull(int n) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateNull(int).", this.conn);
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateBoolean(int,boolean).", this.conn);
    }

    public void updateByte(int n, byte by) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateByte(int,byte).", this.conn);
    }

    public void updateShort(int n, short s) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateShort(int,short).", this.conn);
    }

    public void updateInt(int n, int n2) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateInt(int,int).", this.conn);
    }

    public void updateLong(int n, long l) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateLong(int,long).", this.conn);
    }

    public void updateFloat(int n, float f) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateFloat(int,float).", this.conn);
    }

    public void updateDouble(int n, double d) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateDouble(int,double).", this.conn);
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateBigDecimal(int,BigDecimal).", this.conn);
    }

    public void updateString(int n, String string) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateString(int,String).", this.conn);
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateBytes(int,byte[]).", this.conn);
    }

    public void updateDate(int n, Date date) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateDate(int,Date).", this.conn);
    }

    public void updateTime(int n, Time time) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateTime(int,Time).", this.conn);
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateTimestamp(int,Timestamp).", this.conn);
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateAsciiStream(int,InputStream,int).", this.conn);
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateBinaryStream(int,InputStream,int).", this.conn);
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateCharacterStream(int,Reader,int).", this.conn);
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateObject(int,Object,int).", this.conn);
    }

    public void updateObject(int n, Object object) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateObject(int,Object).", this.conn);
    }

    public void updateNull(String string) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateNull(String).", this.conn);
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateBoolean(String,boolean).", this.conn);
    }

    public void updateByte(String string, byte by) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateByte(String,byte).", this.conn);
    }

    public void updateShort(String string, short s) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateShort(String,short).", this.conn);
    }

    public void updateInt(String string, int n) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateInt(String,int).", this.conn);
    }

    public void updateLong(String string, long l) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateLong(String,long).", this.conn);
    }

    public void updateFloat(String string, float f) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateFloat(String,float).", this.conn);
    }

    public void updateDouble(String string, double d) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateDouble(String,double).", this.conn);
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateBigDecimal(String,BigDecimal).", this.conn);
    }

    public void updateString(String string, String string2) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateString(String,String).", this.conn);
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateBytes(String,byte[]).", this.conn);
    }

    public void updateDate(String string, Date date) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateDate(String,java.sql.Date).", this.conn);
    }

    public void updateTime(String string, Time time) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateTime(String,Time).", this.conn);
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateTimestamp(String,Timestamp).", this.conn);
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateAsciiStream(String,InputStream,int).", this.conn);
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateBinaryStream(String,InputStream,int).", this.conn);
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateCharacterStream(String,Reader,int).", this.conn);
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateObject(String,Object,int).", this.conn);
    }

    public void updateObject(String string, Object object) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateObject(String,Object).", this.conn);
    }

    public void insertRow() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.insertRow().", this.conn);
    }

    public void updateRow() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateRow().", this.conn);
    }

    public void deleteRow() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.deleteRow().", this.conn);
    }

    public void refreshRow() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.refreshRow().", this.conn);
    }

    public void cancelRowUpdates() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.cancelRowUpdates().", this.conn);
    }

    public void moveToInsertRow() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.moveToInsertRow().", this.conn);
    }

    public void moveToCurrentRow() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.moveToCurrentRow().", this.conn);
    }

    public Statement getStatement() throws SQLException {
        return this.stmt;
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        Date date = this.getDate(n);
        if (date == null) {
            return null;
        }
        long l = date.getTime() + (long)calendar.get(15) + (long)calendar.get(16);
        return new Date(l);
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        int n = this.findColumn(string);
        return this.getDate(n, calendar);
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        Time time = this.getTime(n);
        if (time == null) {
            return null;
        }
        long l = time.getTime() + (long)calendar.get(15) + (long)calendar.get(16);
        return new Time(l);
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        int n = this.findColumn(string);
        return this.getTime(n, calendar);
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        Timestamp timestamp = this.getTimestamp(n);
        if (timestamp == null) {
            return null;
        }
        long l = ((java.util.Date)timestamp).getTime() + (long)calendar.get(15) + (long)calendar.get(16);
        Timestamp timestamp2 = new Timestamp(l);
        timestamp2.setNanos(timestamp.getNanos());
        return timestamp2;
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        int n = this.findColumn(string);
        return this.getTimestamp(n, calendar);
    }

    int getTupleBufferSize() {
        return ((IfxSqli)this.prot).getTupleBufferSize();
    }

    int getTupleSize() throws SQLException {
        return ((IfxSqli)this.prot).getTupleSize();
    }
}

