/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxUDTInput;
import com.informix.jdbc.IfxUDTOutput;
import com.informix.util.IfxErrMsg;
import java.sql.Connection;
import java.sql.SQLException;

public class IfxLobDescriptor {
    static final short LO_DESCRIPTOR_SIZE = 596;
    static final short PRE_LONG_ID_LO_DESCRIPTOR_SIZE = 164;
    static final short DISK_DESCRIPTOR_SIZE = 168;
    static final short PRE_LONG_ID_DISK_DESCRIPTOR_SIZE = 58;
    public static final short LO_LOG = 1;
    public static final short LO_NOLOG = 2;
    public static final short LO_DELAY_LOG = 4;
    public static final short LO_KEEP_LASTACCESS_TIME = 8;
    public static final short LO_NOKEEP_LASTACCESS_TIME = 16;
    public static final short LO_HIGH_INTEG = 32;
    public static final short LO_MODERATE_INTEG = 64;
    private int idSize = 18;
    private int MagicNumber;
    private int CreateTimeFlags;
    private int CreateTimeFlags1;
    private long estimatedNoBytes;
    private long sizeLimit;
    private int extentSize;
    private String spaceName;
    byte[] rawColDescriptor;
    private IfxConnection conn;

    public IfxLobDescriptor(Connection connection) throws SQLException {
        byte[] byArray = null;
        this.conn = (IfxConnection)connection;
        IfxUDTOutput ifxUDTOutput = new IfxUDTOutput(this.conn);
        if (this.conn.isLongID()) {
            this.idSize = 128;
        }
        byArray = new byte[this.idSize];
        this.MagicNumber = -623182099;
        this.CreateTimeFlags = 0;
        this.CreateTimeFlags1 = 0;
        this.estimatedNoBytes = -1L;
        this.sizeLimit = -1L;
        this.extentSize = -1;
        this.spaceName = "";
        try {
            ifxUDTOutput.writeInt(0);
            ifxUDTOutput.writeBytes(byArray, byArray.length);
            ifxUDTOutput.writeInt(0);
            ifxUDTOutput.writeBytes(byArray, byArray.length);
            ifxUDTOutput.writeInt(0);
            ifxUDTOutput.writeBytes(byArray, byArray.length);
            ifxUDTOutput.writeShort((short)0);
            ifxUDTOutput.writeShort((short)0);
            ifxUDTOutput.writeInt(0);
            ifxUDTOutput.writeInt(-1);
            ifxUDTOutput.writeInt(-1);
            ifxUDTOutput.writeInt(0);
            ifxUDTOutput.writeInt(0);
            ifxUDTOutput.writeInt(0);
            ifxUDTOutput.writeInt(0);
            this.rawColDescriptor = ifxUDTOutput.toByteArray();
            return;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            this.rawColDescriptor = null;
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    IfxLobDescriptor(IfxConnection ifxConnection, byte[] byArray) throws SQLException {
        int n;
        this.conn = ifxConnection;
        if (ifxConnection.isLongID()) {
            n = 428;
            this.idSize = 128;
        } else {
            n = 106;
        }
        try {
            IfxUDTInput ifxUDTInput = new IfxUDTInput(this.conn, byArray, 0, byArray.length);
            this.MagicNumber = ifxUDTInput.readInt();
            this.CreateTimeFlags = ifxUDTInput.readInt();
            this.CreateTimeFlags1 = ifxUDTInput.readInt();
            this.estimatedNoBytes = ifxUDTInput.readLong();
            this.sizeLimit = ifxUDTInput.readLong();
            this.extentSize = ifxUDTInput.readInt();
            this.spaceName = ifxUDTInput.readString(this.idSize);
            int n2 = this.spaceName.indexOf(0);
            if (n2 != -1) {
                this.spaceName = this.spaceName.substring(0, n2);
            }
            this.rawColDescriptor = ifxUDTInput.readBytes(n);
            return;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), ifxConnection);
        }
    }

    public void setCreateFlags(int n) {
        this.CreateTimeFlags = n;
    }

    public void setEstBytes(long l) {
        this.estimatedNoBytes = l;
    }

    public void setMaxBytes(long l) {
        this.sizeLimit = l;
    }

    public void setExtSize(int n) {
        this.extentSize = n;
    }

    public void setSbspace(String string) {
        this.spaceName = string;
    }

    public int getCreateFlags() {
        return this.CreateTimeFlags;
    }

    public long getEstSize() {
        return this.estimatedNoBytes;
    }

    public long getMaxBytes() {
        return this.sizeLimit;
    }

    public int getExtSize() {
        return this.extentSize;
    }

    public String getSbspace() {
        return this.spaceName;
    }

    int length() {
        IfxConnection ifxConnection = this.conn;
        if (ifxConnection.isLongID()) {
            return 596;
        }
        return 164;
    }

    static int size(IfxConnection ifxConnection) {
        if (ifxConnection.isLongID()) {
            return 596;
        }
        return 164;
    }

    byte[] getRawLobDescriptor() throws SQLException {
        IfxUDTOutput ifxUDTOutput = new IfxUDTOutput(this.conn);
        ifxUDTOutput.writeInt(this.MagicNumber);
        ifxUDTOutput.writeInt(this.CreateTimeFlags);
        ifxUDTOutput.writeInt(this.CreateTimeFlags1);
        ifxUDTOutput.writeLong(this.estimatedNoBytes);
        ifxUDTOutput.writeShort((short)0);
        ifxUDTOutput.writeLong(this.sizeLimit);
        ifxUDTOutput.writeShort((short)0);
        ifxUDTOutput.writeInt(this.extentSize);
        ifxUDTOutput.writeString(this.spaceName, this.idSize);
        ifxUDTOutput.writeBytes(this.rawColDescriptor);
        return ifxUDTOutput.toByteArray();
    }
}

