/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxObject;
import com.informix.lang.Decimal;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.JavaToIfxType;
import com.informix.util.IfxErrMsg;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;

public class IfxDateTime
extends IfxObject {
    private long value;
    private int nanos;
    private boolean isTime = false;
    private short qualifier;
    public static final byte TU_YEAR = 0;
    public static final byte TU_MONTH = 2;
    public static final byte TU_DAY = 4;
    public static final byte TU_HOUR = 6;
    public static final byte TU_MINUTE = 8;
    public static final byte TU_SECOND = 10;
    public static final byte TU_FRAC = 12;
    public static final byte TU_F1 = 11;
    public static final byte TU_F2 = 12;
    public static final byte TU_F3 = 13;
    public static final byte TU_F4 = 14;
    public static final byte TU_F5 = 15;

    IfxDateTime() throws SQLException {
        this.setIfxType(10);
    }

    IfxDateTime(Time time) throws SQLException {
        this.setIfxType(10);
        this.qualifier = IfxDateTime.getQualifier((byte)6, (byte)10);
        if (time != null) {
            this.value = time.getTime();
            this.isTime = true;
            this.unnullify();
        }
    }

    IfxDateTime(Timestamp timestamp) throws SQLException {
        this.setIfxType(10);
        this.qualifier = IfxDateTime.getQualifier((byte)0, (byte)15);
        if (timestamp != null) {
            this.value = ((Date)timestamp).getTime();
            this.nanos = timestamp.getNanos();
            this.isTime = false;
            this.unnullify();
        }
    }

    public byte[] toIfx() {
        if (this.isTime) {
            return JavaToIfxType.JavaToIfxDateTime(new Time(this.value));
        }
        Timestamp timestamp = new Timestamp(this.value);
        timestamp.setNanos(this.nanos);
        return JavaToIfxType.JavaToIfxDateTime(timestamp);
    }

    public byte[] toIfxTuple() {
        if (this.isNull()) {
            return JavaToIfxType.JavaToIfxDecimalNull((short)this.encodedLength);
        }
        byte[] byArray = this.toIfx();
        return Decimal.fromBindToTuple(byArray, (short)this.encodedLength);
    }

    public void fromIfx(byte[] byArray, short s) {
        if (byArray[0] == 0 && byArray[1] == 0) {
            this.nullify();
            return;
        }
        this.qualifier = s;
        Timestamp timestamp = IfxToJavaType.IfxToJavaDateTime(byArray, s);
        this.value = ((Date)timestamp).getTime();
        if (IfxDateTime.getStartCode(this.qualifier) >= 6) {
            this.qualifier = IfxDateTime.getQualifier((byte)6, (byte)10);
            this.nanos = 0;
            this.isTime = true;
        } else {
            this.qualifier = IfxDateTime.getQualifier((byte)0, (byte)15);
            this.nanos = timestamp.getNanos();
            this.isTime = false;
        }
        this.unnullify();
    }

    public Object toObject() {
        if (this.isNull()) {
            return null;
        }
        if (this.isTime) {
            return new Time(this.value);
        }
        Timestamp timestamp = new Timestamp(this.value);
        timestamp.setNanos(this.nanos);
        return timestamp;
    }

    public java.sql.Date toDate() {
        if (this.isNull()) {
            return null;
        }
        return new java.sql.Date(this.value);
    }

    public void fromDate(java.sql.Date date) throws SQLException {
        if (date == null) {
            this.nullify();
            return;
        }
        this.value = date.getTime();
        this.nanos = 0;
        this.isTime = false;
        this.unnullify();
    }

    public Timestamp toTimestamp() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        Timestamp timestamp = new Timestamp(this.value);
        timestamp.setNanos(this.nanos);
        return timestamp;
    }

    public void fromTimestamp(Timestamp timestamp) throws SQLException {
        if (timestamp == null) {
            this.nullify();
            return;
        }
        this.value = ((Date)timestamp).getTime();
        this.nanos = timestamp.getNanos();
        this.isTime = false;
        this.qualifier = IfxDateTime.getQualifier((byte)0, (byte)15);
        this.unnullify();
    }

    public void fromTimestamp(Timestamp timestamp, short s) throws SQLException {
        if (timestamp == null) {
            this.nullify();
            return;
        }
        this.value = ((Date)timestamp).getTime();
        this.nanos = timestamp.getNanos();
        this.isTime = false;
        this.qualifier = s;
        this.unnullify();
    }

    public Time toTime() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return new Time(this.value);
    }

    public void fromTime(Time time) throws SQLException {
        if (time == null) {
            this.nullify();
            return;
        }
        this.value = time.getTime();
        this.isTime = true;
        this.qualifier = IfxDateTime.getQualifier((byte)6, (byte)10);
        this.unnullify();
    }

    public String toString() {
        String string = null;
        if (this.isNull()) {
            return null;
        }
        if (this.isTime) {
            Time time = new Time(this.value);
            string = time.toString();
        } else {
            try {
                Timestamp timestamp = this.toTimestamp();
                string = timestamp.toString();
            }
            catch (Exception exception) {
                string = null;
            }
        }
        return string;
    }

    public void fromString(String string) throws SQLException {
        if (string == null) {
            this.nullify();
            return;
        }
        String string2 = string.trim();
        try {
            Timestamp timestamp = Timestamp.valueOf(string2);
            this.value = ((Date)timestamp).getTime();
            this.nanos = timestamp.getNanos();
            this.isTime = false;
            this.unnullify();
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                Time time = Time.valueOf(string2);
                this.value = time.getTime();
                this.nanos = 0;
                this.isTime = true;
                this.unnullify();
                return;
            }
            catch (Exception exception) {
                this.nullify();
                this.value = 0L;
                this.nanos = 0;
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
            }
        }
        catch (Exception exception) {
            this.nullify();
            this.value = 0L;
            this.nanos = 0;
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    public boolean equals(Object object) {
        if (this.isNull() || object == null) {
            return false;
        }
        if (object instanceof IfxDateTime) {
            IfxDateTime ifxDateTime = (IfxDateTime)object;
            if (ifxDateTime.isNull()) {
                return false;
            }
            if (ifxDateTime.value == this.value && ifxDateTime.nanos == this.nanos) {
                return true;
            }
        }
        return false;
    }

    static short getQualifier(byte by, byte by2) {
        short s = (short)(by2 - by + (by == 0 ? 4 : 2));
        short s2 = (short)((byte)s << 8 | by << 4 | by2);
        return s2;
    }

    static byte getStartCode(short s) {
        byte by = (byte)(s >> 4 & 0xF);
        return by;
    }

    static byte getEndCode(short s) {
        byte by = (byte)(s & 0xF);
        return by;
    }

    public short getEncodedLength() {
        if (this.qualifier == 0) {
            this.qualifier = IfxDateTime.getQualifier((byte)0, (byte)15);
        }
        return this.qualifier;
    }

    static String getQualifierName(short s) {
        if (s == 0) {
            return null;
        }
        byte by = IfxDateTime.getStartCode(s);
        byte by2 = IfxDateTime.getEndCode(s);
        String string = IfxDateTime.getFieldName(by);
        string = String.valueOf(string) + " to ";
        string = String.valueOf(string) + IfxDateTime.getFieldName(by2);
        return string;
    }

    static String getFieldName(byte by) {
        switch (by) {
            case 0: {
                return "year";
            }
            case 2: {
                return "month";
            }
            case 4: {
                return "day";
            }
            case 6: {
                return "hour";
            }
            case 8: {
                return "minute";
            }
            case 10: {
                return "second";
            }
            case 11: {
                return "fraction(1)";
            }
            case 12: {
                return "fraction(2)";
            }
            case 13: {
                return "fraction(3)";
            }
            case 14: {
                return "fraction(4)";
            }
            case 15: {
                return "fraction(5)";
            }
        }
        return "";
    }

    public boolean isTimeValue() {
        return this.isTime;
    }
}

