/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxInputStream;
import com.informix.jdbc.IfxLobInputStream;
import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxTmpFile;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.JavaToIfxType;
import com.informix.util.IfxErrMsg;
import com.informix.util.memoryUtil;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.SQLException;
import netscape.security.PrivilegeManager;

public class IfxBlob
extends IfxObject {
    private static final short TYPE_IS_BYTE = 0;
    private static final short TYPE_IS_TEXT = 1;
    private static final short TYPE_IS_BLOB = 2;
    private static final short TYPE_IS_CLOB = 3;
    protected static final short BLOBISNULL = 1;
    protected static final short BLOB_TYPE_BYTES = 0;
    protected static final short BLOB_TYPE_STREAM = 1;
    protected byte[] blobDesc;
    protected int tb_start;
    protected int tb_end;
    protected int tb_size;
    protected short tb_flags;
    protected InputStream BlobInputStream;
    protected IfxTmpFile tempBlobFile;
    protected byte[] blobBuffer;
    protected short blobType;
    protected boolean isBlob_loaded = false;
    protected short ifxType = 0;

    IfxBlob() throws SQLException {
        this.blobDesc = new byte[56];
        this.nullify();
    }

    public IfxBlob(InputStream inputStream, int n) throws SQLException {
        this.fromInputStream(inputStream, n);
    }

    public IfxBlob(byte[] byArray) throws SQLException {
        this.fromBytes(byArray);
    }

    protected short getBlobType() {
        return this.blobType;
    }

    protected boolean isBlobByteType() {
        return this.blobType == 0;
    }

    protected boolean isIfxTextType() {
        return this.ifxType == 1;
    }

    protected byte[] getBlobBuffer() {
        return this.blobBuffer;
    }

    protected void setBlobBuffer(byte[] byArray) {
        this.blobBuffer = byArray;
    }

    protected int getBlobLength() {
        return this.tb_size;
    }

    protected InputStream getBlobInputStream() {
        return this.BlobInputStream;
    }

    protected String getBlobFileName() {
        return this.tempBlobFile.getFileName();
    }

    protected void setBlobFileName() {
        this.tempBlobFile.close();
        this.tempBlobFile = null;
    }

    protected boolean isBlobLoaded() {
        return this.isBlob_loaded;
    }

    protected void setLoaded() {
        this.isBlob_loaded = true;
    }

    public void fromIfx(byte[] byArray) throws SQLException {
        if (this.blobDesc == null) {
            this.blobDesc = new byte[56];
        }
        System.arraycopy(byArray, 0, this.blobDesc, 0, 56);
        byte[] byArray2 = new byte[2];
        byte[] byArray3 = new byte[4];
        System.arraycopy(byArray, 8, byArray3, 0, 4);
        this.tb_start = IfxToJavaType.IfxToJavaInt(byArray3, (short)0);
        System.arraycopy(byArray, 12, byArray3, 0, 4);
        this.tb_end = IfxToJavaType.IfxToJavaInt(byArray3, (short)0);
        this.tb_size = this.tb_end - this.tb_start + 1;
        System.arraycopy(byArray, 38, byArray2, 0, 2);
        this.tb_flags = IfxToJavaType.IfxToJavaSmallInt(byArray2, (short)0);
        if (this.tb_flags != 1) {
            this.isBlob_loaded = false;
            this.blobType = 0;
            this.createTempFile();
            this.unnullify();
        }
    }

    public byte[] toIfx() {
        byte[] byArray = new byte[4];
        byArray = JavaToIfxType.JavaToIfxInt(this.tb_size);
        if (this.blobDesc == null) {
            this.blobDesc = new byte[56];
        }
        System.arraycopy(byArray, 0, this.blobDesc, 16, 4);
        return this.blobDesc;
    }

    public byte[] toIfxTuple() {
        if (this.isNull()) {
            if (this.blobDesc == null) {
                this.blobDesc = new byte[56];
            }
            memoryUtil.byfill(this.blobDesc, (byte)0);
            this.blobDesc[39] = 1;
            return this.blobDesc;
        }
        return this.toIfx();
    }

    public InputStream toAsciiStream() throws SQLException {
        if (this.tempBlobFile != null) {
            if (System.getProperty("java.vendor").startsWith("Netscape")) {
                try {
                    PrivilegeManager.enablePrivilege((String)"UniversalFileAccess");
                }
                catch (Exception exception) {}
            }
            try {
                IfxInputStream ifxInputStream = new IfxInputStream(this.tempBlobFile);
                return ifxInputStream;
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79701, this.conn);
            }
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.blobBuffer);
        return byteArrayInputStream;
    }

    public void fromInputStream(InputStream inputStream, int n) throws SQLException {
        this.tb_size = n;
        this.BlobInputStream = inputStream instanceof IfxLobInputStream ? ((IfxLobInputStream)inputStream).getStream() : inputStream;
        this.isBlob_loaded = false;
        this.blobType = 1;
        this.blobBuffer = null;
        this.unnullify();
    }

    public void fromAsciiStream(InputStream inputStream, int n) throws SQLException {
        this.fromInputStream(inputStream, n);
        this.ifxType = 1;
    }

    public InputStream toBinaryStream() throws SQLException {
        return this.toAsciiStream();
    }

    public void fromBinaryStream(InputStream inputStream, int n) throws SQLException {
        this.fromInputStream(inputStream, n);
        this.ifxType = 0;
    }

    public String toString() {
        int n;
        FileInputStream fileInputStream;
        if (this.tempBlobFile == null) {
            return new String(this.blobBuffer);
        }
        if (System.getProperty("java.vendor").startsWith("Netscape")) {
            try {
                PrivilegeManager.enablePrivilege((String)"UniversalFileAccess");
            }
            catch (Exception exception) {}
        }
        try {
            fileInputStream = new FileInputStream(this.tempBlobFile.getFileName());
            n = fileInputStream.available();
        }
        catch (Exception exception) {
            return null;
        }
        FileInputStream fileInputStream2 = fileInputStream;
        byte[] byArray = new byte[n];
        int n2 = 0;
        try {
            byte by = (byte)((InputStream)fileInputStream2).read();
            while (by != -1) {
                byArray[n2] = by;
                ++n2;
                by = (byte)((InputStream)fileInputStream2).read();
            }
            fileInputStream.close();
        }
        catch (Exception exception) {
            return null;
        }
        return new String(byArray);
    }

    public void fromString(String string) throws SQLException {
        if (string == null) {
            this.tb_size = 0;
            this.blobBuffer = null;
        } else {
            this.tb_size = string.length();
            this.blobBuffer = string.getBytes();
        }
        this.BlobInputStream = null;
        this.isBlob_loaded = false;
        this.blobType = 0;
        this.unnullify();
    }

    public Object toObject() throws SQLException {
        return this.toBytes();
    }

    public byte[] toBytes() throws SQLException {
        int n;
        FileInputStream fileInputStream;
        if (this.tempBlobFile == null) {
            return (byte[])this.blobBuffer.clone();
        }
        if (System.getProperty("java.vendor").startsWith("Netscape")) {
            try {
                PrivilegeManager.enablePrivilege((String)"UniversalFileAccess");
            }
            catch (Exception exception) {}
        }
        try {
            fileInputStream = new FileInputStream(this.tempBlobFile.getFileName());
            n = fileInputStream.available();
        }
        catch (Exception exception) {
            return null;
        }
        byte[] byArray = new byte[n];
        try {
            fileInputStream.read(byArray, 0, n);
            fileInputStream.close();
        }
        catch (Exception exception) {
            return null;
        }
        return byArray;
    }

    public void fromBytes(byte[] byArray) {
        if (byArray == null) {
            this.tb_size = 0;
            this.blobBuffer = null;
        } else {
            this.tb_size = byArray.length;
            this.blobBuffer = byArray;
            this.unnullify();
        }
        this.BlobInputStream = null;
        this.isBlob_loaded = false;
        this.blobType = 0;
    }

    public void clear() {
        this.isBlob_loaded = false;
        this.ifxType = 0;
        if (this.tempBlobFile != null) {
            if (System.getProperty("java.vendor").startsWith("Netscape")) {
                try {
                    PrivilegeManager.enablePrivilege((String)"UniversalFileAccess");
                }
                catch (Exception exception) {}
            }
            try {
                this.tempBlobFile.close();
            }
            catch (Exception exception) {}
        }
        this.blobBuffer = null;
        this.tempBlobFile = null;
        super.clear();
    }

    void dumpTblob() {
    }

    private void createTempFile() throws SQLException {
        String string = String.valueOf(System.currentTimeMillis());
        string = String.valueOf(this.conn.getJDBCTempDir()) + "ifxb_" + string.substring(4);
        this.tempBlobFile = new IfxTmpFile(string);
    }

    protected void finalize() {
        try {
            this.clear();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }
}

