/*
 * Decompiled with CFR 0.152.
 */
package com.informix.asf;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.StringTokenizer;

public class HttpBufferedOutputStream
extends BufferedOutputStream {
    private ByteArrayOutputStream os;
    private URLConnection conn;
    private URL url;
    private String id;
    private StringBuffer sendStr;
    private boolean debug = false;

    public HttpBufferedOutputStream(ByteArrayOutputStream byteArrayOutputStream, URL uRL, String string) {
        super(byteArrayOutputStream);
        this.os = byteArrayOutputStream;
        this.url = uRL;
        this.id = string;
        this.sendStr = new StringBuffer();
        this.sendStr.append("JDBC_SESSION=" + string + "&" + "JDBC_REQUEST" + "=SEND&");
    }

    public final void write(int n) throws IOException {
        this.os.write(n);
        if (this.debug) {
            this.traceOut("write(" + n + ")");
        }
    }

    public final void write(byte[] byArray, int n, int n2) throws IOException {
        this.os.write(byArray, n, n2);
        if (this.debug) {
            this.traceOut("write(byte b," + n + "," + n2 + ")");
        }
    }

    public final void flush() throws IOException {
        Closeable closeable;
        String string = null;
        if (this.debug) {
            this.traceOut("flush(): sending servlet= " + this.sendStr.toString());
        }
        if (this.debug) {
            this.traceOut("flush(): os.size= " + this.os.size());
        }
        this.openConnection(false, true, true);
        try {
            closeable = new DataOutputStream(new BufferedOutputStream(this.conn.getOutputStream()));
            ((DataOutputStream)closeable).writeShort(this.sendStr.toString().length());
            ((DataOutputStream)closeable).writeBytes(this.sendStr.toString());
            if (this.os.size() > 0) {
                this.os.writeTo((OutputStream)closeable);
            }
            ((FilterOutputStream)closeable).close();
        }
        catch (IOException iOException) {
            throw new IOException();
        }
        try {
            closeable = new DataInputStream(new BufferedInputStream(this.conn.getInputStream()));
            short s = ((DataInputStream)closeable).readShort();
            if (s == -1) {
                throw new IOException("Unexpected EOF error reading from proxy server.");
            }
            byte[] byArray = new byte[s];
            ((DataInputStream)closeable).readFully(byArray, 0, s);
            ((FilterInputStream)closeable).close();
            string = new String(byArray, 0, (int)s);
            StringTokenizer stringTokenizer = new StringTokenizer(string, "=");
            stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), ";");
            String string2 = stringTokenizer2.nextToken();
            String string3 = stringTokenizer.nextToken();
            if (this.debug) {
                this.traceOut("flush(): servlet response= " + string);
            }
            if (!string2.equals("SEND_OK") || !string3.equals(this.id)) {
                throw new IOException(string3);
            }
        }
        catch (IOException iOException) {
            throw new IOException(iOException.toString());
        }
        if (this.debug) {
            this.traceOut("flush(): end ");
        }
        this.os = new ByteArrayOutputStream();
    }

    private final void openConnection(boolean bl, boolean bl2, boolean bl3) throws IOException {
        try {
            this.conn = this.url.openConnection();
            this.conn.setUseCaches(bl);
            this.conn.setRequestProperty("Content-Type", "application/binary");
            this.conn.setDoOutput(bl2);
            this.conn.setDoInput(bl3);
            return;
        }
        catch (IOException iOException) {
            throw new IOException(iOException.toString());
        }
    }

    public final void close() throws IOException {
        if (this.debug) {
            this.traceOut("close() start ");
        }
        String string = null;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("JDBC_SESSION=" + this.id + "&" + "JDBC_REQUEST" + "=CLOSE&");
        this.openConnection(false, true, true);
        if (this.debug) {
            this.traceOut("close() sending proxy: " + stringBuffer);
        }
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(this.conn.getOutputStream()));
            dataOutputStream.writeShort(stringBuffer.toString().length());
            dataOutputStream.writeBytes(stringBuffer.toString());
            dataOutputStream.flush();
            dataOutputStream.close();
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(this.conn.getInputStream()));
            short s = dataInputStream.readShort();
            byte[] byArray = new byte[s];
            dataInputStream.readFully(byArray, 0, s);
            dataInputStream.close();
            string = new String(byArray, 0, (int)s);
            if (this.debug) {
                this.traceOut("close() received from proxy: " + string);
                return;
            }
        }
        catch (IOException iOException) {}
    }

    private void traceOut(String string) {
        System.out.println("HttpBufferedOutputStream: " + string + " - data bytes= " + this.os.size());
    }
}

