/*
 * Decompiled with CFR 0.152.
 */
package com.informix.asf;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.StringTokenizer;

public class HttpBufferedInputStream
extends BufferedInputStream {
    private BufferedInputStream is;
    private URLConnection conn;
    private URL url;
    private String id;
    private StringBuffer recvStr;
    private boolean debug = false;

    public HttpBufferedInputStream(InputStream inputStream, URL uRL, String string) {
        super(inputStream);
        this.url = uRL;
        this.id = string;
        this.recvStr = new StringBuffer();
        this.recvStr.append("JDBC_SESSION=" + string + "&" + "JDBC_REQUEST" + "=RECV&");
        this.is = new BufferedInputStream(new ByteArrayInputStream(new byte[0]));
    }

    public final int read() throws IOException {
        if (this.debug) {
            this.traceOut("read()");
        }
        int n = 0;
        if (this.is.available() <= 0) {
            this.getMoreData(false, true, true);
        }
        n = this.is.read();
        return n;
    }

    public final int read(byte[] byArray) throws IOException {
        if (this.debug) {
            this.traceOut("read(byte b[])");
        }
        int n = 0;
        if (this.is.available() <= 0) {
            this.getMoreData(false, true, true);
        }
        n = this.is.read(byArray);
        return n;
    }

    public final int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.debug) {
            this.traceOut("read(byte b[], " + n + "," + n2 + ")");
        }
        int n3 = 0;
        if (this.is.available() <= 0) {
            this.getMoreData(false, true, true);
        }
        n3 = this.is.read(byArray, n, n2);
        return n3;
    }

    public final int skip(int n) throws IOException {
        if (this.debug) {
            this.traceOut("skip(" + n + ")");
        }
        if (this.is.available() <= 0) {
            this.getMoreData(false, true, true);
        }
        int n2 = 0;
        while ((n2 += (int)this.is.skip(n - n2)) < n) {
        }
        return n;
    }

    private final void getMoreData(boolean bl, boolean bl2, boolean bl3) throws IOException {
        Closeable closeable;
        if (this.debug) {
            this.traceOut("getMoreData(" + bl + "," + bl2 + "," + bl3 + ")");
        }
        short s = 0;
        String string = null;
        byte[] byArray = null;
        short s2 = 0;
        try {
            this.conn = this.url.openConnection();
            this.conn.setUseCaches(bl);
            this.conn.setRequestProperty("Content-Type", "application/binary");
            this.conn.setDoOutput(bl2);
            this.conn.setDoInput(bl3);
        }
        catch (IOException iOException) {
            throw new IOException(iOException.toString());
        }
        if (this.debug) {
            this.traceOut("getMoreData(): sending proxy " + this.recvStr.toString());
        }
        try {
            closeable = new DataOutputStream(new BufferedOutputStream(this.conn.getOutputStream()));
            ((DataOutputStream)closeable).writeShort(this.recvStr.toString().length());
            ((DataOutputStream)closeable).writeBytes(this.recvStr.toString());
            ((FilterOutputStream)closeable).close();
        }
        catch (IOException iOException) {
            throw new IOException(iOException.toString());
        }
        if (this.debug) {
            this.traceOut("getMoreData(): opening inputstream from proxy ");
        }
        try {
            closeable = new DataInputStream(new BufferedInputStream(this.conn.getInputStream()));
            s = ((DataInputStream)closeable).readShort();
            if (s == -1) {
                throw new IOException("Unexpected EOF error reading from proxy server.");
            }
            byte[] byArray2 = new byte[s];
            ((DataInputStream)closeable).readFully(byArray2, 0, s);
            string = new String(byArray2, 0, (int)s);
            StringTokenizer stringTokenizer = new StringTokenizer(string, "=");
            stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), ";");
            String string2 = stringTokenizer2.nextToken();
            String string3 = stringTokenizer.nextToken();
            if (this.debug) {
                this.traceOut("getMoreData(): proxy response= " + string);
            }
            if (!string2.equals("RECV_OK")) {
                if (this.debug) {
                    this.traceOut("getMoreData(): NOT RECV_OK");
                }
                throw new IOException("Error from proxy: " + string3);
            }
            s2 = ((DataInputStream)closeable).readShort();
            byArray = new byte[s2];
            ((DataInputStream)closeable).readFully(byArray);
            if (this.debug) {
                this.traceOut("getMoreData(): received " + s2 + " data bytes from proxy.");
            }
            ((FilterInputStream)closeable).close();
        }
        catch (IOException iOException) {
            if (this.debug) {
                this.traceOut("getMoreData(): throwing EXCEPTION " + iOException.toString());
            }
            throw new IOException(iOException.toString());
        }
        this.is = new BufferedInputStream(new ByteArrayInputStream(byArray));
    }

    private void traceOut(String string) {
        try {
            System.out.println("HttpBufferedInputStream." + string + ": Data length= " + this.is.available());
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }
}

