package com.jshx.zzhxm.service.impl;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.zzhxm.dao.ZzhxmfshxxDao;
import com.jshx.zzhxm.dao.ZzhxmqfhtkDao;
import com.jshx.zzhxm.entity.Zzhxmfshxx;
import com.jshx.zzhxm.entity.Zzhxmqfhtk;
import com.jshx.zzhxm.service.ZzhxmfshxxService;
import com.jshx.zzhxm.service.ZzhxmqfhtkService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service("zzhxmqfhtkService")
public class ZzhxmqfhtkServiceImpl extends BaseServiceImpl implements ZzhxmqfhtkService
{
	/**
	 * Dao类
	 */
	@Autowired() 
	@Qualifier("zzhxmqfhtkDao")
	private ZzhxmqfhtkDao zzhxmqfhtkDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return zzhxmqfhtkDao.findByPage(page, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Zzhxmqfhtk getById(String id)
	{
		return zzhxmqfhtkDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param zzhxmqfhtk 信息
	 */
	@Transactional
	public void save(Zzhxmqfhtk zzhxmqfhtk)
	{
		zzhxmqfhtkDao.save(zzhxmqfhtk);
	}

	/**
	 * 修改信息
	 * @param zzhxmqfhtk 信息
	 */
	@Transactional
	public void update(Zzhxmqfhtk zzhxmqfhtk)
	{
		zzhxmqfhtkDao.update(zzhxmqfhtk);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects=zzhxmqfhtkDao.findZzhxmqfhtk(paraMap);

		zzhxmqfhtkDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
					zzhxmqfhtkDao.deleteWithFlag(id);
			}
		}
	}

	@Override
	public List<Zzhxmqfhtk> findZzhxmqfhtk(Map<String, Object> paraMap) {

		return zzhxmqfhtkDao.findZzhxmqfhtk(paraMap);

	}

	@Override
	public Zzhxmqfhtk getByYbjksbh(String ybjksbh){
		Map<String,Object> paramMap =  new HashMap<>();
		paramMap.put("ybjksbh",ybjksbh);
		Zzhxmqfhtk zzhxmqfhtk = (Zzhxmqfhtk)zzhxmqfhtkDao.findObjectByFieldsMap(Zzhxmqfhtk.class,paramMap);
		return zzhxmqfhtk;
	}

	@Override
	public Zzhxmqfhtk getByJfdmwybh(String jfdmwybh){
		Map<String,Object> paramMap =  new HashMap<>();
		paramMap.put("jfdmwybh",jfdmwybh);
		Zzhxmqfhtk zzhxmqfhtk = (Zzhxmqfhtk)zzhxmqfhtkDao.findObjectByFieldsMap(Zzhxmqfhtk.class,paramMap);
		return zzhxmqfhtk;
	}
}
