package com.jshx.zzhqfdz.dao.impl;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.zzhqfdz.dao.ZzhqfdzDao;
import com.jshx.zzhqfdz.entity.Zzhqfdz;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

@Component("zzhqfdzDao")
public class ZzhqfdzDaoImpl extends BaseDaoImpl implements ZzhqfdzDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findZzhqfdzByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findZzhqfdz(Map<String, Object> paraMap){
		return this.findListByHqlId("findZzhqfdzByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Zzhqfdz getById(String id)
	{
		return (Zzhqfdz)this.getObjectById(Zzhqfdz.class, id);
	}

	/**
	 * 保存信息
	 * @param zzhqfdz 信息
	 */
	public void save(Zzhqfdz zzhqfdz)
	{
		zzhqfdz.setId(null);
		this.saveOrUpdateObject(zzhqfdz);
	}

	/**
	 * 修改信息
	 * @param yzsdic 信息
	 */
	public void update(Zzhqfdz zzhqfdz)
	{
		this.saveOrUpdateObject(zzhqfdz);
	}

	/**
	 * 物理删除信息
	 * @param id 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Zzhqfdz.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param id 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Zzhqfdz zzhqfdz = (Zzhqfdz)this.getObjectById(Zzhqfdz.class, id);
		zzhqfdz.setDelFlag(1);
		this.saveObject(zzhqfdz);
	}
}
