package com.jshx.zzhkppj.service.impl;

import com.jshx.billManager.dao.BillManagerDao;
import com.jshx.billManager.entity.BillManager;
import com.jshx.billManager.entity.Indeticur;
import com.jshx.billlq.dao.BilllqDao;
import com.jshx.billlq.entity.Billlq;
import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.module.admin.entity.User;
import com.jshx.zzhkppj.dao.ZzhkppjDao;
import com.jshx.zzhkppj.entity.Zzhkppj;
import com.jshx.zzhkppj.service.ZzhkppjService;
import com.jshx.zzhxm.dao.ZzhxmJktzsDao;
import com.neusoft.egov.utils.billendnumber;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.io.FileInputStream;
import java.text.SimpleDateFormat;
import java.util.*;

@Service("zzhkppjService")
public class ZzhkppjServiceImpl extends BaseServiceImpl implements ZzhkppjService
{
	/**
	 * Dao类
	 */
	@Autowired() 
	@Qualifier("zzhkppjDao")
	private ZzhkppjDao zzhkppjDao;
	@Autowired()
	@Qualifier("zzhxmjktzsDao")
	private ZzhxmJktzsDao zzhxmJktzsDao;
	@Autowired()
	@Qualifier("billManagerDao")
	private BillManagerDao billManagerDao;
	@Autowired()
	@Qualifier("billlqDao")
	private BilllqDao billlqDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return zzhkppjDao.findByPage(page, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Zzhkppj getById(String id)
	{
		return zzhkppjDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param zzhkppj 信息
	 */
	@Transactional
	public void save(Zzhkppj zzhkppj)
	{
		zzhkppjDao.save(zzhkppj);
	}

	/**
	 * 修改信息
	 * @param zzhkppj 信息
	 */
	@Transactional
	public void update(Zzhkppj zzhkppj)
	{
		zzhkppjDao.update(zzhkppj);
	}

	@Override
	@Transactional
	public void updateMsg(Zzhkppj zzhkppj, User loginUser) {

	}

	public void analogInsertion(Zzhkppj zzhkppj, User loginUser) {

	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects=zzhkppjDao.findZzhkppj(paraMap);
		zzhkppjDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
					zzhkppjDao.deleteWithFlag(id);
			}
		}
	}

	@Override
	public List<Zzhkppj> findZzhkppj(Map<String, Object> paraMap) {

		return zzhkppjDao.findZzhkppj(paraMap);

	}

	@Override
	public List<Zzhkppj> findZzhkppjToZzhkp(Map<String, Object> paraMap) {

		return zzhkppjDao.findZzhkppjToZzhkp(paraMap);

	}
}
