package com.jshx.yzssfgl.service.impl;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.yzssfgl.dao.YzssfglDao;
import com.jshx.yzssfgl.entity.Yzssfgl;
import com.jshx.yzssfgl.service.YzssfglService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service("yzssfglService")
public class YzssfglServiceImpl extends BaseServiceImpl implements YzssfglService
{
	/**
	 * Dao类
	 */
	@Autowired() 
	@Qualifier("yzssfglDao")
	private YzssfglDao yzssfglDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return yzssfglDao.findByPage(page, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Yzssfgl getById(String id)
	{
		return yzssfglDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param yzssfgl 信息
	 */
	@Transactional
	public void save(Yzssfgl yzssfgl)
	{
		yzssfglDao.save(yzssfgl);
	}

	/**
	 * 修改信息
	 * @param yzssfgl 信息
	 */
	@Transactional
	public void update(Yzssfgl yzssfgl)
	{
		yzssfglDao.update(yzssfgl);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects= yzssfglDao.findYzssfgl(paraMap);
		yzssfglDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
					yzssfglDao.deleteWithFlag(id);
			}
		}
	}

	@Override
	public List<Yzssfgl> findYzssfgl(Map<String, Object> paraMap) {

		return yzssfglDao.findYzssfgl(paraMap);

	}

	/**
	 * 获取一站式收费区域
	 */
	@Override
	public List<String> getYzssfqy(Map<String,Object> paramMap){
		return yzssfglDao.getYzssfqy(paramMap);
	}

	/**
	 * 获取一站式代收单位
	 */
	@Override
	public List<String> getYzsdsdw(Map<String,Object> paramMap){
		return yzssfglDao.getYzsdsdw(paramMap);
	}

	/**
	 * 获取一站式收费项目名称
	 */
	@Override
	public List<String> getYzssfxmmc(Map<String,Object> paramMap){
		return yzssfglDao.getYzssfxmmc(paramMap);
	}

	/**
	 * 获取一站式审核部门
	 */
	@Override
	public List<String> getYzsshbm(Map<String,Object> paramMap){
		return yzssfglDao.getYzsshbm(paramMap);
	}

	@Override
	public List<String> getJktzsRemarks(Map<String, Object> paramMap) {
		return yzssfglDao.getJktzsRemarks(paramMap);
	}
}
