package com.jshx.yzsjfhc.service.impl;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.yzsjfhc.dao.PaymentVerificationDao;
import com.jshx.yzsjfhc.entity.PaymentVerification;
import com.jshx.yzsjfhc.service.PaymentVerificationService;
import com.jshx.zzhgl.dao.ZzhglDao;
import com.jshx.zzhgl.entity.Zzh;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.*;

@Service("paymentVerificationService")
public class PaymentVerificationServiceImpl extends BaseServiceImpl implements PaymentVerificationService
{
	/**
	 * Dao类
	 */
	@Autowired() 
	@Qualifier("paymentVerificationDao")
	private PaymentVerificationDao paymentVerificationDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return paymentVerificationDao.findByPage(page, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public PaymentVerification getById(String id)
	{
		return paymentVerificationDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	@Transactional
	public void save(PaymentVerification model)
	{
		paymentVerificationDao.save(model);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	@Transactional
	public void update(PaymentVerification model)
	{
		paymentVerificationDao.update(model);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects=paymentVerificationDao.findPaymentVerification(paraMap);

		paymentVerificationDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
					paymentVerificationDao.deleteWithFlag(id);
			}
		}
	}

	@Override
	public List<PaymentVerification> findPaymentVerification(Map<String, Object> paraMap) {

		return paymentVerificationDao.findPaymentVerification(paraMap);

	}
}
