package com.jshx.yzscw.yzscwfzhskm.web;

import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.json.CodeJsonValueProcessor;
import com.jshx.core.json.DateJsonValueProcessor;
import com.jshx.module.admin.entity.User;
import com.jshx.yzscw.yzscwfzhskm.entity.Yzscwfzhskm;
import com.jshx.yzscw.yzscwfzhskm.entity.YzscwkjkmYzscwfzhskm;
import com.jshx.yzscw.yzscwfzhskm.service.YzscwfzhskmService;
import com.jshx.yzscw.yzscwfzhskm.service.YzscwkjkmYzscwfzhskmService;
import com.jshx.yzscw.yzscwkmgl.entity.Yzscwkmgl;
import com.jshx.yzscw.yzscwkmgl.service.YzscwkmglService;
import net.sf.json.JSONArray;
import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.*;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.*;
import org.apache.struts2.ServletActionContext;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.util.*;

public class YzscwfzhskmAction extends BaseAction
{

	/**
	 * 主键ID列表，用于接收页面提交的多条主键ID信息
	 */
	private String ids;

	private String selKmgl;

	private InputStream excelFile;

	private String fileName;

	/**
	 * 实体类
	 */
	private Yzscwfzhskm yzscwfzhskm = new Yzscwfzhskm();

	private Yzscwkmgl yzscwkjkm = new Yzscwkmgl();

	private YzscwkjkmYzscwfzhskm kjkm2fzhskm = new YzscwkjkmYzscwfzhskm();

	private List<Yzscwkmgl> yzscwkjkmList = new ArrayList<>();
	/**
	 * 业务类
	 */
	@Autowired
	private YzscwfzhskmService yzscwfzhskmService;

	@Autowired
	private YzscwkmglService yzscwkjkmService;

	@Autowired
	private YzscwkjkmYzscwfzhskmService yzscwkjkmYzscwfzhskmService;

	/**
	 * 修改新增标记，add为新增、mod为修改
	 */
	private String flag;

	/**
	 * 分页信息
	 */
	private Pagination pagination;



	@Autowired()
	@Qualifier("sessionFactory")
	private SessionFactory sessionFactory;

	/**
	 * 跳转到会计科目页面
	 */
	public String fzhskmInit() {
		return SUCCESS;
	}
	/**
	 * 跳转到关联会计科目页面
	 */
	public String toLinkedKjkm() {
//		Yzscwfzhskm byId = yzscwfzhskmService.getById(yzscwfzhskm.getId());
		Map<String, Object> paraMap = new HashMap<>();
		paraMap.put("fzhskmId", yzscwfzhskm.getId());
		List<YzscwkjkmYzscwfzhskm> kjkmFzhskmList = yzscwkjkmYzscwfzhskmService.findYzscwkjkmYzscwfzhskm(paraMap);
		for (YzscwkjkmYzscwfzhskm yzscwkjkmYzscwfzhskm : kjkmFzhskmList) {
//			Yzscwkmgl yzscwkmgl = new Yzscwkmgl();
			Yzscwkmgl kjkmTemp = yzscwkjkmService.getById(yzscwkjkmYzscwfzhskm.getKjkmId());
			yzscwkjkmList.add(kjkmTemp);
		}

		return SUCCESS;
	}

	/**
	 * 执行查询的方法，返回json数据
	 */
	public void list() throws Exception{
		Map<String, Object> paraMap = new HashMap<String, Object>();

		if(StringUtils.isNotBlank(yzscwfzhskm.getKmmc())){
			paraMap.put("kmmc", "%" + yzscwfzhskm.getKmmc() + "%");
		}
		if(StringUtils.isNotBlank(yzscwfzhskm.getKmdm())){
			//x科目代码前缀都一样且冗长,可以通过只输入后面唯一码来查询
			paraMap.put("kmdm", "%" + yzscwfzhskm.getKmdm());
		}

		if(pagination==null)
		    pagination = new Pagination(this.getRequest());

		if(true){

		    //设置查询条件，开发人员可以在此增加过滤条件

		}
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(Date.class,new DateJsonValueProcessor());
		Map<String, String> codeMap = new HashMap<String, String>();
		//此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId
		
		config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap)); 
		final String filter = "id|showName|kmdm|kmmc|kmlx|parentKm|parentKmdm|parentKmmc|hasChild|";
		if (filter != null && filter.length() > 1) {
			config.setJsonPropertyFilter(new PropertyFilter() {
				public boolean apply(Object source, String name, Object value) {
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}

		paraMap.put("parentId", yzscwfzhskm.getId());
		if (StringUtils.isBlank(yzscwfzhskm.getId())) {
			paraMap.put("root", 1);
		} else {
		}
		pagination = yzscwfzhskmService.findByPage(pagination, paraMap);

		convObjectToJson(pagination, config);
	}

	/**
	 * 辅助核算科目的节点查询，封装成树的节点信息返回：<br>
	 * 初始化时：[{"id":"","text":"","state":"","children":[{"id":"","text":"","state":""}]}]<br>
	 * 非初始化时：[{"id":"","text":"","state":""}]
	 *
	 * @throws Exception
	 */
	public void findFzhskmTreeByCurrUser() throws Exception{
		User user = this.getLoginUser();
		Map<String, Object> paraMap = new HashMap<>();
		List<Map<String, Object>> items = new ArrayList<Map<String, Object>>();
		Map<String, Object> root = new HashMap<String, Object>();

		root.put("id", "");
		root.put("text", "辅助核算科目管理");
		root.put("state", "opened");
		paraMap.put("kmdm", "");
		paraMap.put("root", 1);
		List<Yzscwfzhskm> kmglList = yzscwfzhskmService.findKmListByParentKmdm(paraMap);
		kmglList.sort((o1, o2) -> o1.getKmdm().compareToIgnoreCase(o2.getKmdm()));
//		kmglList.sort((o1, o2) -> (o1.getSortBy() - o2.getSortBy()));
		List<Map<String, Object>> elements = new ArrayList<Map<String, Object>>();
		elements = toTreeData(kmglList, elements);
		root.put("children", elements);
		items.add(root);

		JSONArray json = JSONArray.fromObject(items);
		HttpServletResponse response = ServletActionContext
				.getResponse();
		response.setContentType("application/json;charset=UTF-8");
		response.setCharacterEncoding("utf-8");
		response.setHeader("Charset", "utf-8");
		response.setHeader("Cache-Control", "no-cache");
		response.getWriter().print(json.toString());

	}

	/**
	 * 关联会计科目树
	 */
	public void findKjkmTreeForFzhskm() throws Exception {
		// 获取当前辅助核算科目的关联会计科目数据集合
		Map<String, String> checkMap = new HashMap<>();
		if (null != yzscwfzhskm && StringUtils.isNotBlank(yzscwfzhskm.getId())) {
			checkMap = yzscwkjkmYzscwfzhskmService.findYzscwkjkmByFzhskmId(yzscwfzhskm.getId());
		}

		Map<String, Object> paraMap = new HashMap<>();
		/*List<Map<String, Object>> items = new ArrayList<Map<String, Object>>();
		Map<String, Object> root = new HashMap<String, Object>();

		root.put("id", "");
		root.put("text", "会计科目");
		root.put("state", "opened");
		paraMap.put("kmdm", "");
		paraMap.put("root", 1);*/
        List<Map<String, Object>> items = new ArrayList<Map<String, Object>>();
		List<Yzscwkmgl> kmglList = yzscwkjkmService.findYzscwkmgl(paraMap);
        for (Yzscwkmgl yzscwkmgl : kmglList) {
            Map<String, Object> element = new HashMap<>();
            element.put("id", yzscwkmgl.getId());
            element.put("parentId", yzscwkmgl.getParentId());
            element.put("name", yzscwkmgl.getKmmc());
            element.put("state", "open");
            if(checkMap.containsKey(yzscwkmgl.getId())){
                element.put("checked", true);
            }
            items.add(element);
        }
		/*List<Map<String, Object>> elements = new ArrayList<Map<String, Object>>();
		elements = toKjkmTreeData(kmglList, elements, checkMap);
		root.put("children", elements);
		items.add(root);*/

		JSONArray json = JSONArray.fromObject(items);
		HttpServletResponse response = ServletActionContext
				.getResponse();
		response.setContentType("application/json;charset=UTF-8");
		response.setCharacterEncoding("utf-8");
		response.setHeader("Charset", "utf-8");
		response.setHeader("Cache-Control", "no-cache");
		response.getWriter().print(json.toString());
	}


	/**
	 * 查看详细信息
	 */
	public String view() throws Exception{
		if (null != yzscwfzhskm && StringUtils.isNotBlank(yzscwfzhskm.getId())) {
			yzscwfzhskm = yzscwfzhskmService.getById(yzscwfzhskm.getId());
		}
		return VIEW;
	}

	/**
	 * 	初始化修改信息
	 */
	public String initEdit() throws Exception{
		Map<String, Object> paraMap = new HashMap<>();
		if (null != yzscwfzhskm && null != yzscwfzhskm.getId()) {
			paraMap.put("id", yzscwfzhskm.getId());
			yzscwfzhskm = yzscwfzhskmService.getById(yzscwfzhskm.getId());
			if (StringUtils.isNotBlank(yzscwfzhskm.getParentId())) {
				Yzscwfzhskm parent = yzscwfzhskmService.getById(yzscwfzhskm.getParentId());
				yzscwfzhskm.setParentYzscwkm(parent);
			}
		}
	    return EDIT;
	}
	/**
	 * 	初始化添加信息
	 */
	public String initAdd() throws Exception{
		Map<String, Object> paraMap = new HashMap<>();
		if (null != yzscwfzhskm && null != yzscwfzhskm.getId()) {
			Yzscwfzhskm kmglById = new Yzscwfzhskm();
			if ("undefind".equals(yzscwfzhskm.getKmdm()) || "".equals(yzscwfzhskm.getKmdm())) {
				//说明未选择或者为顶级
			}else {
//				paraMap.put("id", yzscwkmgl.getId());
//				kmglById = yzscwkmglService.findKmglByKmdm(yzscwkmgl.getKmdm());
				kmglById = yzscwfzhskmService.getById(yzscwfzhskm.getId());
			}
			yzscwfzhskm.setParentYzscwkm(kmglById);
		}
	    return EDIT;
	}

	/**
	 * 	保存信息（包括新增和修改）
	 */
	public String save() throws Exception{
		FileInputStream in = null;
		try
		{
			//设置Blob字段
			setBlobField(in);
		}
		finally
		{
			if (null != in)
			{
				try
				{
					in.close();
				}
				catch (Exception ex)
				{
				}
			}
		}

		if ("add".equalsIgnoreCase(this.flag)){
			if (null != yzscwfzhskm) {
				yzscwfzhskm.setDelFlag(0);
				yzscwfzhskm.setHasChild(0);
				//如果存在相同的科目代码则不允许添加	2019-8-16 start
//				Yzscwfzhskm fzhskm = yzscwfzhskmService.findKmglByKmdm(yzscwfzhskm.getKmdm());

				Map<String, Object> paraMap = new HashMap<>();
				paraMap.put("kmdm", yzscwfzhskm.getKmdm());
				paraMap.put("delFlag", 0);
				List<Yzscwfzhskm> exist = yzscwfzhskmService.findYzscwfzhskm(paraMap);

				if (CollectionUtils.isNotEmpty(exist)) {
					this.getResponse().getWriter().println("{\"result\":" + false + ",\"message\":\"" + "已存在相同的科目代码!" + "\"}");
					return null;
				}
				// 2019-8-16 end
				
				if (StringUtils.isNotBlank(yzscwfzhskm.getKmdm())){
					yzscwfzhskm.setShowName("("+yzscwfzhskm.getKmdm()+")"+yzscwfzhskm.getKmmc());
				}else {
					yzscwfzhskm.setShowName(yzscwfzhskm.getKmmc());
				}
				//有,代表不是顶级;
				//没有,代表是顶级科目;
				if (StringUtils.isNotBlank(yzscwfzhskm.getParentId())) {
					Yzscwfzhskm parentById = yzscwfzhskmService.getById(yzscwfzhskm.getParentId());
					yzscwfzhskm.setParentKmmc(parentById.getKmmc());
				}
				yzscwfzhskmService.save(yzscwfzhskm);
				this.getResponse().getWriter().println("{\"result\":" + true + ",\"message\":\"" + "新增成功!" + "\"}");
				return null;
			}

		}else{
			if (null != yzscwfzhskm) {
				Yzscwfzhskm byId = yzscwfzhskmService.getById(yzscwfzhskm.getId());
				// 如果修改的科目代码重复则不允许修改,并给出提示
				if (StringUtils.isNotBlank(yzscwfzhskm.getKmdm()) && StringUtils.isNotBlank(byId.getKmdm()) && !byId.getKmdm().equalsIgnoreCase(yzscwfzhskm.getKmdm())) {
					Yzscwfzhskm fzhskm = yzscwfzhskmService.findKmglByKmdm(yzscwfzhskm.getKmdm());
					if (null != fzhskm) {
						this.getResponse().getWriter().println("{\"result\":" + false + ",\"message\":\"" + "已存在相同的科目代码!" + "\"}");
						return null;
					}
				}
				byId.setKmdm(yzscwfzhskm.getKmdm());
				byId.setKmmc(yzscwfzhskm.getKmmc());

				//修改了科目代码和科目名称
				byId.setShowName("(" + yzscwfzhskm.getKmdm() + ")" + yzscwfzhskm.getKmmc());
				/*}else {
					byId.setShowName("(" +byId.getKmdm()+ ")" + yzscwfzhskm.getKmmc());
				}*/
				yzscwfzhskmService.updateAndChildren(byId);
				this.getResponse().getWriter().println("{\"result\":" + true + ",\"message\":\"" + "修改成功!" + "\"}");
				return null;
			}
		}
		return RELOAD;
	}

	/**
	 * 将File对象转换为Blob对象，并设置到实体类中
	 * 如果没有File对象，可删除此方法，并一并删除save方法中调用此方法的代码
	*/
	private void setBlobField(FileInputStream in)
	{
		if (true)
		{
			try
			{
				//此处将File对象转换成blob对象，并设置到zsdw中去
				
            }
            catch (Exception ex)
            {
                ex.printStackTrace();
            }
        }
    }

	/**
	 * 保存关联信息
	 * @return
	 * @throws IOException
	 */
	public void saveLinkedKjkm() throws IOException {
		try {
			if (StringUtils.isNotBlank(ids)) {
				// 关联的会计科目id数组
				String[] idArray = ids.split(",");
				// 被关联的辅助核算科目id
				String id = yzscwfzhskm.getId();
				//保存关联的会计科目
				List<YzscwkjkmYzscwfzhskm> linkedList = new ArrayList<>();
				//保存当前辅助核算科目的子科目
				List<String> fzhsList = new ArrayList<>();
				List<String> childrenIds = findChildrenIds(id, fzhsList);
				//将父级id加入
				childrenIds.add(id);
				//保存
				for (String s : idArray) {
					for (String childrenId : childrenIds) {
						YzscwkjkmYzscwfzhskm linkedModel = new YzscwkjkmYzscwfzhskm();
						linkedModel.setKjkmId(s);
						linkedModel.setFzhskmId(id);
						linkedModel.setDelFlag(0);
						linkedList.add(linkedModel);
					}
				}
				yzscwkjkmYzscwfzhskmService.saveNewAndDeleteOld(linkedList, childrenIds);
			}
			this.getResponse().getWriter().println("{\"result\":" + true + ",\"message\":\"" + "关联会计科目成功!" + "\"}");
		} catch (Exception e) {
			e.printStackTrace();
			this.getResponse().getWriter().println("{\"result\":" + false + ",\"message\":\"" + "关联会计科目失败!" + "\"}");
		}
	}

	/**
	 * 删除信息
	*/
	public String delete() throws Exception{
		List<String> list = new ArrayList<>();
	    try{
//			yzscwkmglService.deleteWithFlag(ids);
			String[] idArray = ids.split(",");
			if(null != idArray) {
				for (String id : idArray) {
					List<String> childrenIds = findChildrenIds(id.trim(), list);
					list.add(id.trim());
				}
			}
			yzscwfzhskmService.deleteWithFlag(list);
			this.getResponse().getWriter().println("{\"result\":\"true\"}");
		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":\"false\"}");
		}
		return null;
	}

	/**
	 * 获取传入科目列表id下的所有子科目的id
	 */
	public List<String> findChildrenIds(String id, List<String> list) {
		Map<String, Object> paraMap = new HashMap<>();
		List<Yzscwfzhskm> kmgls = yzscwfzhskmService.findYzscwfzhskmListByParentId(id);
		paraMap.put("parentId", id);
		List<Yzscwfzhskm> kmgles = yzscwfzhskmService.findYzscwfzhskm(paraMap);
		for (Yzscwfzhskm kmgl : kmgles) {
			if(kmgl.getHasChild()>0 && yzscwfzhskmService.findYzscwfzhskmListByParentId(id).size()>0){
				List<String> childrenIds = findChildrenIds(kmgl.getId(), new ArrayList<>());
				list.addAll(childrenIds);
			}
			list.add(kmgl.getId());
		}
//		list.add(id);
		return list;
	}

	/**
	 * 遍历目录树
	 * @return
	 */
	private List<Map<String, Object>> toTreeData(List<Yzscwfzhskm> list, List<Map<String, Object>> elements) {
		for (Yzscwfzhskm kmgl : list) {
			Map<String, Object> item = new HashMap<String, Object>();
			item.put("id", kmgl.getId());
			item.put("text", kmgl.getShowName());
			List<Yzscwfzhskm> childList = new ArrayList<>();
//					if (StringUtils.isNotBlank(kmgl.getParentId())) {
			Map<String, Object> paraMap1 = new HashMap<>();
			paraMap1.put("parentId",kmgl.getId());
			childList = yzscwfzhskmService.findKmListByParentKmdm(paraMap1);
			childList.sort((o1, o2) -> o1.getKmdm().compareToIgnoreCase(o2.getKmdm()));
//					}
			if (childList.size() > 0) {
				item.put("state", "opened");
				List<Map<String, Object>> element = new ArrayList<>();
				List<Map<String, Object>> mapList = toTreeData(childList, element);
				item.put("children", mapList);
			}
			elements.add(item);
		}
		return elements;
	}
	private List<Map<String, Object>> toKjkmTreeData(List<Yzscwkmgl> list, List<Map<String, Object>> elements, Map<String, String> checkMap) {

		for (Yzscwkmgl kmgl : list) {
			Map<String, Object> item = new HashMap<String, Object>();
			item.put("id", kmgl.getId());
			item.put("text", kmgl.getShowName());
			item.put("pId", kmgl.getParentId());
			if (checkMap.containsKey(kmgl.getId())) {
				item.put("checked", "checked");
			}
			List<Yzscwkmgl> childList = new ArrayList<>();
//					if (StringUtils.isNotBlank(kmgl.getParentId())) {
			Map<String, Object> paraMap1 = new HashMap<>();
			paraMap1.put("parentId",kmgl.getId());
			childList = yzscwkjkmService.findKmListByParentKmdm(paraMap1);
//					}
			if (childList.size() > 0) {
				item.put("state", "opened");
				List<Map<String, Object>> element = new ArrayList<>();
				List<Map<String, Object>> mapList = toKjkmTreeData(childList, element, checkMap);
				item.put("children", mapList);
			}
			elements.add(item);
		}
		return elements;
	}

	/**
	 * 导出Excel
	 * @return
	 */
	public String exportExcel() {
		try {
            List<Yzscwfzhskm> list = yzscwfzhskmService.findYzscwfzhskm(new HashMap<>());
            list.sort((o1, o2) -> o1.getKmdm().compareToIgnoreCase(o2.getKmdm()));
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            // 声明一个工作薄
            HSSFWorkbook workbook = new HSSFWorkbook();
            // 生成一个表格
            HSSFSheet sheet = workbook.createSheet();

			// 设置Excel样式 start-------------------------------
			HSSFCellStyle cellStyle = workbook.createCellStyle(); // 单元格样式
			Font fontStyle = workbook.createFont(); // 字体样式
//			fontStyle.setBold(true); // 加粗
			fontStyle.setFontName("黑体"); // 字体
			fontStyle.setFontHeightInPoints((short) 11); // 大小
			// 将字体样式添加到单元格样式中
			cellStyle.setFont(fontStyle);
			// 边框，居中
			cellStyle.setBorderBottom(BorderStyle.THIN);
			cellStyle.setBorderLeft(BorderStyle.THIN);
			cellStyle.setBorderRight(BorderStyle.THIN);
			cellStyle.setBorderTop(BorderStyle.THIN);
			HSSFCellStyle cellStyleNotCenter = cellStyle;

			cellStyle.setAlignment(HorizontalAlignment.CENTER);
//			cellB2.setCellStyle(cellStyle); // 为B2单元格添加样式
			// 设置Excel样式 end---------------------------------

            // 产生表格标题行
            HSSFRow row = sheet.createRow(0);

			HSSFCell title0 = row.createCell(0);
			title0.setCellValue("序号");
			HSSFCell title1 = row.createCell(1);
			title1.setCellValue("科目代码");
			HSSFCell title2 = row.createCell(2);
			title2.setCellValue("科目名称");
			HSSFCell title3 = row.createCell(3);
			title3.setCellValue("备注");

			// 设置样式
			title0.setCellStyle(cellStyle);
			title1.setCellStyle(cellStyle);
			title2.setCellStyle(cellStyle);
			title3.setCellStyle(cellStyle);


            Iterator<Yzscwfzhskm> iterator = list.iterator();

            int index = 0;
            while (iterator.hasNext()) {
                index ++;
                Yzscwfzhskm fzhs = iterator.next();
                /*if (StringUtils.isNotBlank(fzhs.getParentId())) {*/
                    row = sheet.createRow(index);
                    HSSFCell cell0 = row.createCell(0);
                    cell0.setCellValue(index);
                    HSSFCell cell = row.createCell(1);
                    cell.setCellValue(fzhs.getKmdm());
                    HSSFCell cell2 = row.createCell(2);
                    cell2.setCellValue(fzhs.getKmmc());
                    HSSFCell cell3 = row.createCell(3);
                    cell3.setCellValue(fzhs.getDescription());

					//样式
					cell0.setCellStyle(cellStyle);
					cell.setCellStyle(cellStyleNotCenter);
					cell2.setCellStyle(cellStyle);
					cell3.setCellStyle(cellStyle);
                /*}*/
            }

			// 设置列自适应宽度
			for (int i = 0; i < 4; i++) {
				sheet.autoSizeColumn(i);
				sheet.setColumnWidth(i,sheet.getColumnWidth(i)*17/10);
			}
            workbook.write(out);
            out.close();

            fileName = new String("辅助核算科目".getBytes(), "iso-8859-1") + ".xls";

            excelFile = new ByteArrayInputStream(out.toByteArray());

			logger.debug("导出辅助核算科目Excel成功!");
			return "exportExcel";
		} catch (Exception e) {
			e.printStackTrace();
			logger.error(e.getMessage(), e);
			return null;
		}
	}

	
	public String getIds(){
		return ids;
	}

	public void setIds(String ids){
		this.ids = ids;
	}

	public Pagination getPagination(){
		return pagination;
	}

	public void setPagination(Pagination pagination){
		this.pagination = pagination;
	}

	public Yzscwfzhskm getYzscwfzhskm() {
		return yzscwfzhskm;
	}

	public void setYzscwfzhskm(Yzscwfzhskm yzscwfzhskm) {
		this.yzscwfzhskm = yzscwfzhskm;
	}

	public YzscwfzhskmService getyzscwfzhskmService() {
		return yzscwfzhskmService;
	}

	public void setYzscwfzhskmService(YzscwfzhskmService yzscwfzhskmService) {
		this.yzscwfzhskmService = yzscwfzhskmService;
	}

	public String getFlag() {
		return flag;
	}

	public void setFlag(String flag) {
		this.flag = flag;
	}

	public String getSelKmgl() {
		return selKmgl;
	}

	public void setSelKmgl(String selKmgl) {
		this.selKmgl = selKmgl;
	}

    public InputStream getExcelFile() {
        return excelFile;
    }

    public void setExcelFile(InputStream excelFile) {
        this.excelFile = excelFile;
    }

    public Yzscwkmgl getYzscwkjkm() {
        return yzscwkjkm;
    }

    public void setYzscwkjkm(Yzscwkmgl yzscwkjkm) {
        this.yzscwkjkm = yzscwkjkm;
    }

    public YzscwkjkmYzscwfzhskm getKjkm2fzhskm() {
        return kjkm2fzhskm;
    }

    public void setKjkm2fzhskm(YzscwkjkmYzscwfzhskm kjkm2fzhskm) {
        this.kjkm2fzhskm = kjkm2fzhskm;
    }

    public List<Yzscwkmgl> getYzscwkjkmList() {
        return yzscwkjkmList;
    }

    public void setYzscwkjkmList(List<Yzscwkmgl> yzscwkjkmList) {
        this.yzscwkjkmList = yzscwkjkmList;
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }
}
