package com.jshx.yzscw.yzscwfzhskm.service.impl;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.yzscw.yzscwfzhskm.dao.YzscwfzhskmDao;
import com.jshx.yzscw.yzscwfzhskm.entity.Yzscwfzhskm;
import com.jshx.yzscw.yzscwfzhskm.service.YzscwfzhskmService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service("yzscwfzhskmService")
public class YzscwfzhskmServiceImpl extends BaseServiceImpl implements YzscwfzhskmService
{
	/**
	 * Dao类
	 */
	@Autowired() 
	@Qualifier("yzscwfzhskmDao")
	private YzscwfzhskmDao yzscwfzhskmDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return yzscwfzhskmDao.findByPage(page, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Yzscwfzhskm getById(String id)
	{
		return yzscwfzhskmDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param yzscwfzhskm 信息
	 */
	@Transactional
	public void save(Yzscwfzhskm yzscwfzhskm)
	{
		yzscwfzhskmDao.save(yzscwfzhskm);
		//如果父节点部位空则更新父节点hasChild字段
		if (StringUtils.isNotBlank(yzscwfzhskm.getParentId())) {
			Yzscwfzhskm parentKmgl = yzscwfzhskmDao.getById(yzscwfzhskm.getParentId());

			parentKmgl.setHasChild(parentKmgl.getHasChild()+1);

			yzscwfzhskmDao.update(parentKmgl);
		}
	}

	/**
	 * 修改信息
	 * @param yzscwfzhskm 信息
	 */
	@Transactional
	public void update(Yzscwfzhskm yzscwfzhskm)
	{
		yzscwfzhskmDao.update(yzscwfzhskm);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects= yzscwfzhskmDao.findYzscwfzhskm(paraMap);
		yzscwfzhskmDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(List<String> ids) {
		for (String id : ids) {
			yzscwfzhskmDao.deleteWithFlag(id);
		}

	}

	@Override
	public List<Yzscwfzhskm> findYzscwfzhskm(Map<String, Object> paraMap) {

		return yzscwfzhskmDao.findYzscwfzhskm(paraMap);

	}

	@Override
	public List<Yzscwfzhskm> findKmListByParentKmdm(Map<String, Object> paraMap) {
		return yzscwfzhskmDao.findKmListByParentKmdm(paraMap);
	}

	@Override
	public Yzscwfzhskm findKmglByKmdm(String s) {
		return yzscwfzhskmDao.findKmglByKmdm(s);
	}

	@Transactional
	@Override
	public void updateAndChildren(Yzscwfzhskm yzscwfzhskm) {
		Map<String, Object> paraMap = new HashMap<>();
		paraMap.put("parentId", yzscwfzhskm.getId());
		List<Yzscwfzhskm> children = yzscwfzhskmDao.findYzscwfzhskm(paraMap);
		//修改同时修改对应的children的parentId
		if (CollectionUtils.isNotEmpty(children)) {
			for (Yzscwfzhskm child : children) {
				child.setParentKmmc(yzscwfzhskm.getKmmc());
				child.setParentKmdm(yzscwfzhskm.getParentKmdm());
				yzscwfzhskmDao.update(child);
			}
		}
		yzscwfzhskmDao.update(yzscwfzhskm);
	}

	@Override
	public List<Yzscwfzhskm> findYzscwfzhskmListByParentId(String parentId) {
		return yzscwfzhskmDao.findListBy(Yzscwfzhskm.class, "parentId", parentId);
	}
}
