package com.jshx.tjfx.web;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletResponse;

import org.apache.struts2.ServletActionContext;
import org.hibernate.LobHelper;
import org.hibernate.SessionFactory;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import net.sf.json.JSONArray;
import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;


import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.utils.BaseExcel;
import com.jshx.core.utils.Struts2Util;

import com.jshx.module.admin.entity.Department;
import com.jshx.module.admin.entity.User;
import com.jshx.module.form.service.AttachfileService;
import com.jshx.core.json.CodeJsonValueProcessor;
import com.jshx.core.json.DateJsonValueProcessor;

import com.jshx.tjfx.entity.Tjfx;
import com.jshx.tjfx.service.TjfxService;
import com.jshx.zsdw.service.ZsdwService;


public class TjfxAction extends BaseAction
{

	/**
	 * 主键ID列表，用于接收页面提交的多条主键ID信息
	 */
	private String ids;

	/**
	 * 实体类
	 */
	private Tjfx tjfx = new Tjfx();

	/**
	 * 业务类
	 */
	@Autowired
	private TjfxService tjfxService;

	/**
	 * 修改新增标记，add为新增、mod为修改
	 */
	private String flag;

	/**
	 * 分页信息
	 */
	private Pagination pagination;
	
	@Autowired
	private ZsdwService zsdwService;
	
	@Autowired()
	@Qualifier("sessionFactory")
	private SessionFactory sessionFactory;
	
	
	private String shStartDate;
	
	private String shEndDate;
	
	private String slStartDate;
	
	private String slEndDate;
	
	
	
	
	/**
	 * 执行查询的方法，返回json数据
	 */
	public void list() throws Exception{
		Map<String, Object> paraMap = new HashMap<String, Object>();

		if(pagination==null)
		    pagination = new Pagination(this.getRequest());
		    


		if(null != tjfx){
		    //设置查询条件，开发人员可以在此增加过滤条件
			if ((null != tjfx.getJsdwmc()) && (0 < tjfx.getJsdwmc().trim().length())){
				paraMap.put("jsdwmc", "%" + tjfx.getJsdwmc().trim() + "%");
			}
			
			if ((null != tjfx.getGcxmmc()) && (0 < tjfx.getGcxmmc().trim().length())){
				paraMap.put("gcxmmc", "%" + tjfx.getGcxmmc().trim() + "%");
			}
			
			if ((null != tjfx.getGcxmdz()) && (0 < tjfx.getGcxmdz().trim().length())){
				paraMap.put("gcxmdz", "%" + tjfx.getGcxmdz().trim() + "%");
			}
			
			if ((null != tjfx.getBllb()) && (0 < tjfx.getBllb().trim().length())){
				paraMap.put("bllb", tjfx.getBllb().trim());
			}
			
			if ((null != tjfx.getZclb()) && (0 < tjfx.getZclb().trim().length())){
				paraMap.put("zclb", tjfx.getZclb().trim());
			}
			
			
			if ((null != tjfx.getJmtk()) && (0 <  tjfx.getJmtk().trim().length())){
				paraMap.put("jmtk", tjfx.getJmtk().trim());
			}
			
			if ((null != shStartDate) && (0 < shStartDate.trim().length())){
				paraMap.put("shStartDate",  shStartDate.trim());
			}
			
			if ((null != shEndDate) && (0 < shEndDate.trim().length())){
				paraMap.put("shEndDate",    shEndDate.trim());
			}
			
			if ((null != slStartDate) && (0 < slStartDate.trim().length())){
				paraMap.put("slStartDate",  slStartDate.trim());
			}
			
			if ((null != slEndDate) && (0 < slEndDate.trim().length())){
				paraMap.put("slEndDate",    slEndDate.trim());
			}
			
			
			if ((null != tjfx.getXmly()) && (0 < tjfx.getXmly().trim().length())){
				paraMap.put("xmly", tjfx.getXmly().trim());
			}


		}
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(java.util.Date.class,new DateJsonValueProcessor());  
		Map<String, String> codeMap = new HashMap<String, String>();
		//此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId
		
		config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap)); 
//		final String filter = "id|xmmc|xmdd|dwmc|dwdd|zclb|jzmj|";
//		if (filter != null && filter.length() > 1) {
//			config.setJsonPropertyFilter(new PropertyFilter() {
//				public boolean apply(Object source, String name, Object value) {
//					if (filter.indexOf(name + "|") != -1)
//						return false;
//					else
//						return true;
//				}
//			});
//		}
		pagination = tjfxService.findByPage(pagination, paraMap);
		
		
		pagination.setListOfObject(pagination.getList());
		convObjectToJson(pagination, config);
	}

	/**
	 * 查看详细信息
	 */
	public String view() throws Exception{
		if((null != tjfx)&&(null != tjfx.getId()))
			tjfx = tjfxService.getById(tjfx.getId());
		
		return VIEW;
	}

	/**
	 * 初始化修改信息
	 */
	public String initEdit() throws Exception{
		view();
	    return EDIT;
	}

	/**
	 * 保存信息（包括新增和修改）
	 */
	public String save() throws Exception{
		FileInputStream in = null;
		try
		{
			//设置Blob字段
			setBlobField(in);
		}
		finally
		{
			if (null != in)
			{
				try
				{
					in.close();
				}
				catch (Exception ex)
				{
				}
			}
		}		
	
		if ("add".equalsIgnoreCase(this.flag)){
			tjfx.setDeptId(this.getLoginUserDepartmentId());
			tjfx.setDelFlag(0);
			tjfxService.save(tjfx);
		}else{
			tjfxService.update(tjfx);
		}
		
		return RELOAD;
	}

	/**
	 * 将File对象转换为Blob对象，并设置到实体类中
	 * 如果没有File对象，可删除此方法，并一并删除save方法中调用此方法的代码
	 */
	private void setBlobField(FileInputStream in)
	{
		if (null != tjfx)
		{
			try
			{
				//此处将File对象转换成blob对象，并设置到tjfx中去
				
            }
            catch (Exception ex)
            {
                ex.printStackTrace();
            }
        }
    }

	/**
	 * 删除信息
	 */
	public String delete() throws Exception{
	    try{
			tjfxService.deleteWithFlag(ids);
			this.getResponse().getWriter().println("{\"result\":true}");
		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}
//	
//	
	public String exportData() throws Exception
	{
		Map<String, Object> paraMap = new HashMap<String, Object>();
		
		String dwdm = "";
		if (!this.getLoginUser().getIsSuperAdmin())
		{
			dwdm = zsdwService.getDwdm(this.getLoginUserDepartmentId());
		}
		if (!"".equals(dwdm))
		{
			paraMap.put("dwdm", dwdm);
		}
		
		if(null != tjfx){
			//设置查询条件，开发人员可以在此增加过滤条件

			if ((null != tjfx.getXmmc()) && (0 < tjfx.getXmmc().trim().length())){
				paraMap.put("xmmc", "%" + tjfx.getXmmc().trim() + "%");
			}

			if ((null != tjfx.getXmdd()) && (0 < tjfx.getXmdd().trim().length())){
				paraMap.put("xmdd", "%" + tjfx.getXmdd().trim() + "%");
			}

			if ((null != tjfx.getDwmc()) && (0 < tjfx.getDwmc().trim().length())){
				paraMap.put("dwmc", "%" + tjfx.getDwmc().trim() + "%");
			}

			if ((null != tjfx.getDwdd()) && (0 < tjfx.getDwdd().trim().length())){
				paraMap.put("dwdd", "%" + tjfx.getDwdd().trim() + "%");
			}

			
		}
		
		List<Map<String, String>> datas = tjfxService.exportData(paraMap); 
		
//		List<Tjfx> list=new ArrayList<>();
//		for(Map<String, String> map:datas){
//			Tjfx tjfx=new Tjfx();
//			tjfx.setXmmc(map.get("XMMC"));
//			tjfx.setXmdd(map.get("XMDD"));
//			tjfx.setDwmc(map.get("DWMC"));
//			tjfx.setDwdd(map.get("DWDD"));
//			tjfx.setJzmj(map.get("JZMJ"));
//			tjfx.setYjje(map.get("YJJE"));
//			tjfx.setYmje(map.get("YMJE"));
//			list.add(tjfx);
//		}
		
		Map dataMap = new HashMap();
		dataMap.put("exportList", datas);
		BaseExcel baseExcel=new BaseExcel();
		return baseExcel.exportExcel("tjfx", dataMap, "tjfx.xls");
		
	}

	public String getIds(){
		return ids;
	}

	public void setIds(String ids){
		this.ids = ids;
	}

	public Pagination getPagination(){
		return pagination;
	}

	public void setPagination(Pagination pagination){
		this.pagination = pagination;
	}

	public Tjfx getTjfx(){
		return this.tjfx;
	}

	public void setTjfx(Tjfx tjfx){
		this.tjfx = tjfx;
	}

	public String getFlag(){
		return flag;
	}

    public void setFlag(String flag){
        this.flag = flag;
    }

	public String getShStartDate() {
		return shStartDate;
	}

	public void setShStartDate(String shStartDate) {
		this.shStartDate = shStartDate;
	}

	public String getShEndDate() {
		return shEndDate;
	}

	public void setShEndDate(String shEndDate) {
		this.shEndDate = shEndDate;
	}

	public String getSlStartDate() {
		return slStartDate;
	}

	public void setSlStartDate(String slStartDate) {
		this.slStartDate = slStartDate;
	}

	public String getSlEndDate() {
		return slEndDate;
	}

	public void setSlEndDate(String slEndDate) {
		this.slEndDate = slEndDate;
	}
       
    
    
}
