package com.jshx.rfxm.web;

import com.jshx.common.utils.Constant;
import com.jshx.common.utils.FileUtils;
import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.json.CodeJsonValueProcessor;
import com.jshx.core.json.DateJsonValueProcessor;

import com.jshx.core.utils.*;
import com.jshx.dxpz.service.DxpzService;
import com.jshx.module.admin.entity.User;
import com.jshx.paymentItemHis.entity.PaymentItemHis;
import com.jshx.paymentItemHis.service.PaymentItemHisService;
import com.jshx.sdjd.entity.Sdjd;
import com.jshx.sdjd.service.SdjdService;
import com.jshx.xmhf.entity.Xmhf;
import com.jshx.xmhf.service.XmhfService;
import com.jshx.xmxxb.entity.Xmxxb;
import com.jshx.xmxxb.service.XmxxbService;
import com.jshx.yzssfgl.entity.Yzssfgl;
import com.jshx.yzssfgl.service.YzssfglService;
import com.jshx.zzhkppj.service.ZzhkppjService;
import com.jshx.zzhgl.service.ZzhglService;
import com.jshx.zzhqfdz.entity.Zzhqfdz;
import com.jshx.zzhqfdz.service.ZzhqfdzService;
import com.jshx.rfxm.entity.Rfxm;
import com.jshx.rfxm.entity.RfxmSfxx;
import com.jshx.rfxm.service.*;
import com.jshx.zzhxm.entity.Zzhxm;
import com.jshx.zzhxm.entity.ZzhxmJktzs;
import com.jshx.zzhxm.service.ZzhxmJktzsService;
import com.jshx.zzhxm.service.ZzhxmService;
import com.neusoft.egov.utils.TextUtils;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import org.activiti.editor.language.json.converter.util.CollectionUtils;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.converters.DateConverter;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.SessionFactory;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import javax.servlet.http.HttpServletRequest;
import java.io.*;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;

public class RfxmAction extends BaseAction
{

/*	private static final Map<String, String> paymentNames;
	static {
		paymentNames = new HashMap();
		paymentNames.put("", "one");
		paymentNames.put("", "two");
	}*/

	/**
	 * 主键ID列表，用于接收页面提交的多条主键ID信息
	 */
	private String ids;
	private int downloadIndex;
	private String attachId;
	private String gdh;


	/**
	 * 收费信息相关数据
	 */
	List<String> yzssxqyList = new ArrayList<>();
	List<String> yzssxdsdwList = new ArrayList<>();
	List<String> yzssxsfxmmcList = new ArrayList<>();
	List<String> yzssxshbmList = new ArrayList<>();

	/**
	 * 文件下载
	 */
	private String downFileName;// 文件下载下载文件文件名
	private InputStream downFileStream;// 文件下载，被下载文件的输入流

	/**
	 * 缴费代码唯一编号
	 */
	private String jfdmwybh;

	/**
	 * 子账户项目id
	 */
	private String rfxmid;

	/**
	 * 标记复核
	 * 1.通过,status改为1;
	 * 2.打回,status改为2;
	 *
	 */
	private String reviewTag;

	/**
	 * 记录当前打印者名称
	 */
	private String printerName;

	/**
	 * 实体类
	 */
	private Rfxm rfxm = new Rfxm();

	private PaymentItemHis paymentItemHis = new PaymentItemHis();

	private Sdjd sdjd = new Sdjd();

	private List<RfxmSfxx> rfxmSfxx = new ArrayList<>();

	//2019-6-26 用于显示打印用 start
	private List<RfxmSfxx> rfxmSfxx4Print = new ArrayList<>();
	//2019-6-26 end

	//--------验证需要 2019-6-5---------
	/**
	 * 代收单位
	 */
	private String dsdw;
	/**
	 * 区域
	 */
	private String yzsqy;
	/**
	 * 实体类
	 */
	private RfxmSfxx rfxmsfxx = new RfxmSfxx();


	/**
	 * 实体类
	 */
	private Zzhqfdz zzhqfdz = new Zzhqfdz();

	/**
	 * 实体类
	 */
	private Yzssfgl yzssfgl = new Yzssfgl();
	/**
	 * 实体类
	 */
	private Xmhf xmhf = new Xmhf();
	private Xmxxb xmxxb =new Xmxxb();

	/**
	 * 业务类
	 */
	@Autowired
	private XmhfService xmhfService;
	@Autowired
	private XmxxbService xmxxbService;


	/**
	 * 业务类
	 */
	@Autowired
	private RfxmService rfxmService;
	@Autowired
	private ZzhqfdzService zzhqfdzService;
	@Autowired
	private RfxmSfxxService rfxmSfxxService;
	@Autowired
	private ZzhkppjService zzhkppjService;
	@Autowired
	private DxpzService dxpzService;
	@Autowired
	private SdjdService sdjdService;

	/**
	 * 业务类
	 */
	@Autowired
	private ZzhglService zzhglService;

	/**
	 * 业务类
	 */
//	@Autowired
//	private RfxmHistoryService rfxmHistoryService;

	@Autowired
	private YzssfglService yzssfglService;
	@Autowired
	private PaymentItemHisService paymentItemHisService;

	@Autowired
	ZzhxmService zzhxmService;

	@Autowired
	ZzhxmJktzsService zzhxmJktzsService;

	/**
	 * 修改新增标记，add为新增、mod为修改
	 */
	private String flag;
	/**
	 * 区域
	 */
	private String yzssfqy;

	/**
	 * 分页信息
	 */
	private Pagination pagination;

	private String urldz;
	private List<File> file1 ;
	private List<File> file2 ;
	private List<File> file3 ;
	private List<File> file4 ;
	private List<String> file1FileName ;
	private List<String> file2FileName ;
	private List<String> file3FileName ;
	private List<String> file4FileName ;
	private String allFileName;
	private String originFileName;

	@Autowired
	@Qualifier("sessionFactory")
	private SessionFactory sessionFactory;




	/**
	 *	获取状态为未激活状态的子账号
	 * @return
	 */
	public String getZzh(String dsdw){
		String sjzzh="";
		Map<String,Object> map = new HashMap<>();
		map.put("dsdw",dsdw);
		//获取子账户
		sjzzh = zzhglService.findZzh(map);
		if(StringUtil.isNotEmpty(sjzzh)){
			System.out.println(sjzzh);
		}
		return sjzzh;
	}


	public static void main(String[] args) {
		/*Map<String,Object>  messageMap = new HashMap<String, Object>();
		messageMap.put("ybjksbh","0380424016");
		messageMap.put("pjjxrq","2020-04-10 00:00:00");
		messageMap.put("pjqfrq","2020-04-10 00:00:00");
		String message = JSON.toJSONString(messageMap);
		Map<String,String> messageResult = new HashMap<String,String>();
		messageResult.put("message",message);
		String api = "http://localhost:8080/jsp/rfxm/recPjqfjx.action";//86为测试 89生产*/
		System.out.println(new BigDecimal("123.00").stripTrailingZeros().toPlainString());
		try {
//			String s = "01234567890123456789";
//			System.out.println(s.substring(0,10));
//			String result2 = HttpclientUtil.post(api, messageResult, "UTF-8");
			Date date = DateTime.parse("2020-04-10 00:00:00".substring(0, 10)).toDate();
			System.out.println(date);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * 项目
	 * 执行查询的方法，返回json数据
	 */
	public void list() throws Exception{
		Map<String, Object> paraMap = new HashMap<String, Object>();
		//查询不需要复核的数据
//		paraMap.put("status", "1");
		if(pagination==null)
			pagination = new Pagination(this.getRequest());

		if(null != rfxm){

			//设置查询条件，开发人员可以在此增加过滤条件
			/**
			 *	    			"rfxm.xkzh": $("#xkzh").val(),
			 * 					"rfxm.zslxdbh": $("#zslxdbh").val(),
			 * 					"rfxm.xxylbbh": $("#xxylbbh").val(),
			 * 					"rfxm.xmbh": $("#xmbh").val(),
			 * 					"rfxm.jsdwmc": $("#jsdwmc").val(),
			 * 					"rfxm.gcxmmc": $("#gcxmmc").val(),
			 * 					"rfxm.paymentLink": $("#paymentLink").val(),
			 * 					"rfxm.isRfyz": $("#isRfyz").val(),
			 * 					"rfxm.mjyj": $("#mjyj").val()
			 */
			if (!TextUtils.isEmpty(rfxm.getXkzh())){
				paraMap.put("xkzh", "%" + rfxm.getXkzh().trim() + "%");
			}
			if (!TextUtils.isEmpty(rfxm.getZslxdbh())){
				paraMap.put("zslxdbh", "%" + rfxm.getZslxdbh().trim() + "%");
			}
			if (!TextUtils.isEmpty(rfxm.getXxylbbh())){
				paraMap.put("xxylbbh", "%" + rfxm.getXxylbbh().trim() + "%");
			}
			if (!TextUtils.isEmpty(rfxm.getXmbh())){
				paraMap.put("xmbh", "%" + rfxm.getXmbh().trim() + "%");
			}
			if (!TextUtils.isEmpty(rfxm.getJsdwmc())){
				paraMap.put("jsdwmc", "%" + rfxm.getJsdwmc().trim() + "%");
			}
			if (!TextUtils.isEmpty(rfxm.getGcxmmc())){
				paraMap.put("gcxmmc", "%" + rfxm.getGcxmmc().trim() + "%");
			}

			if (rfxm.getPaymentLink() != null && rfxm.getPaymentLink() > 0){
				paraMap.put("paymentLink", rfxm.getPaymentLink());
			}
			if (rfxm.getIsRfyz() != null){
				paraMap.put("isRfyz", rfxm.getIsRfyz());
			}
			if (!TextUtils.isEmpty(rfxm.getMjyj())){
				paraMap.put("mjyj", rfxm.getMjyj().trim());
			}

		}
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(Date.class,new DateJsonValueProcessor());
		Map<String, String> codeMap = new HashMap<String, String>();
		//此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId

		config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap));

		pagination = rfxmService.findByPage(pagination, paraMap);

		convObjectToJson(pagination, config);
	}
	/**
	 * 收费信息
	 * 执行查询的方法，返回json数据
	 */
	public void listSfxx() throws Exception{
		Map<String, Object> paraMap = new HashMap<String, Object>();

		if(pagination==null) {
			pagination = new Pagination(this.getRequest());
		}

		if(null != ids){
			paraMap.put("rfxmid", ids);
		}else if(null != jfdmwybh){
			paraMap.put("jfdmwybh", ids);
		}
		paraMap.put("sortCnjfhj", 1);
		/*pagination.setSortCriterion("cnjfhj");
		pagination.setSortType(Pagination.SORT_ASC);*/
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(Date.class,new DateJsonValueProcessor());
		Map<String, String> codeMap = new HashMap<String, String>();
		//此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId

		config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap));

		/*Map<String, Object> tempMap = new HashMap<>();
		tempMap.put("jfdmwybh", "111SF001南京市城市建设费用征收服务中心第1轮");
		List sfxxs = rfxmSfxxService.findRfxmSfxx(tempMap);*/
		pagination = rfxmSfxxService.findByPage(pagination, paraMap);

		rfxm = rfxmService.getById(ids);
		if(pagination.totalCount > 0) {
			//如果缴费金额为0（或0.0、0.00），则反馈单编号应为空缺。如果缴费金额不为0，则反馈单编号与联系单编号相同。
			RfxmSfxx s = (RfxmSfxx) pagination.list.get(0);
			s.setUpdateTime(rfxm.getYzTime());
			try {
				double b = Double.parseDouble(s.getYjjemx());
				if(b != 0 && s.getStatus() != null && s.getStatus() > 1 && s.getStatus() != 3) {
					s.setZslxdbh(s.getSfxmlxdbh());
				} else {
					s.setZslxdbh("");
				}
			} catch (Exception e) {
				s.setZslxdbh("");
			}
		}
		if(!TextUtils.isEmpty(rfxm.getPaymentHisId())) {
			PaymentItemHis paymentItemHis = paymentItemHisService.getById(rfxm.getPaymentHisId());
			RfxmSfxx sfxx = new RfxmSfxx();
			sfxx.setSfxmmc("城市基础设施配套费");
			sfxx.setSfxmlxdbh(rfxm.getJktzsbh());
			sfxx.setYjjemx(paymentItemHis.getZyjje());
			sfxx.setShbm(paymentItemHis.getZsdw());
			sfxx.setZslxdbh(paymentItemHis.getZslxdbh());
			sfxx.setUpdateTime(paymentItemHis.getYzTime());
			sfxx.setCnjfhj(rfxm.getPaymentLink() != null && rfxm.getPaymentLink() == 3 ? "30日内" : "施工许可前");
			sfxx.setStatus(10);//审核通过
			sfxx.setSfxxjbr(paymentItemHis.getJbr());
			sfxx.setPaymentHisId(paymentItemHis.getId());
			pagination.list.add(0,sfxx);
			pagination.totalCount ++;
		}


		convObjectToJson(pagination, config);
	}


	/**
	 * 下载收费信息附件
	 * @return
	 */
	public String downloadFile() throws IOException{
		if (StringUtil.isNotEmpty(ids))
		{
			try
			{
				RfxmSfxx sfxx = rfxmSfxxService.getById(ids);
				if (null != sfxx)
				{
					// 服务器路径,创建文件夹
					// 得到当前路径
					String filename = sfxx.getUrldz();
					String showName = sfxx.getShowName();
					if(downloadIndex == 1) {
						filename = sfxx.getUrldzFk();
						showName = sfxx.getShowNameFk();
					} else if(downloadIndex == 2) {
						filename = sfxx.getUrldzSq();
						showName = sfxx.getShowNameSq();
					} else if(downloadIndex == 3) {
						filename = sfxx.getUrldzZm();
						showName = sfxx.getShowNameZm();
					}
					String cc = this.getRequest().getSession().getServletContext()
							.getRealPath(File.separator);
					File ff = new File(cc);
					String ab=ff.getParent();
					String path=new File(ab).getParent()+File.separator+ "uploads" + File.separator + Constant.ZSLC_SFXX + File.separator+ filename;
					String url = path.replaceAll("\\\\", "/").trim();
					File file = new File(url);
					System.out.println(url);
					System.out.println(file.exists());
					downFileName = java.net.URLEncoder.encode(showName, "UTF-8");
					InputStream inputStream = null;
					byte[] contents = null;
					try {
						inputStream = new FileInputStream(file);
						contents = new byte[inputStream.available()];
						inputStream.read(contents);
                    } catch (FileNotFoundException e) {
                        this.getResponse().getWriter().println("{\"result\":false,\"message\":\""+"系统异常,请联系管理员!"+"\"}");
                        e.printStackTrace();
                    } catch (IOException e) {
                        e.printStackTrace();
                    }
                    downFileStream = getDownLoadFileStream(contents);
                }
            } catch (Exception ex){
                logger.error(ex.toString());
                this.getResponse().getWriter().println("{\"result\":false,\"message\":\""+"系统异常,请联系管理员!"+"\"}");
			}
		}
		return SUCCESS;
	}

	/**
	 * 将文件转换成输入流，提供struts下载参数
	 * @param bytes 需要下载的文件路径
	 * @return
	 */
	public InputStream getDownLoadFileStream(byte[] bytes)
	{
		try
		{
			// 将得到的字节输出流转换成字节数组——>字节输入流
			downFileStream = new ByteArrayInputStream(bytes);
		} catch (Exception e)
		{
			return null;
		}
		return downFileStream;
	}


	/**
	 * 查看详细信息
	 */
	public String view() throws Exception{
		if((null != rfxm)&&(null != rfxm.getId())) {
			Map<String, Object> paraMap = new HashMap<>();
			//按照 施工 竣工 x日内 顺序排序;
			paraMap.put("sortCnjfhj", 1);
			String id = "";
			if (ids!=null) {
				id = ids;
			}else if (rfxm.getId()!=null) {
				id = rfxm.getId();
			}
			rfxm = rfxmService.getById(id);
			Map<String, Object> paraMap2 = new HashMap<>();
			paraMap2.put("rfxmid", rfxm.getId());
			rfxmSfxx =  rfxmSfxxService.findRfxmSfxx(paraMap2);
			if(rfxm.getIsRfyz() == 1) {
				rfxm.setEnableRfyz(0);
			} else if("004".equals(rfxm.getMjyj())) {//非市本级的房改办项目
				rfxm.setEnableRfyz(0);
			} else if(rfxm.getIsSbj() == 0) {
				rfxm.setEnableRfyz(1);
			} else if((rfxmSfxx == null || rfxmSfxx.size() == 0)) {
				rfxm.setEnableRfyz(0);
			} else if(rfxmSfxx.get(0).getStatus() != 10) {
				rfxm.setEnableRfyz(0);
			} else if(!this.getLoginUser().getLoginId().equals("102023") && !this.getLoginUser().getLoginId().equals("102018")) {
				rfxm.setEnableRfyz(0);
			} else {
				rfxm.setEnableRfyz(1);
			}


			paraMap.put("rfxmid", id);
			rfxmSfxx =  rfxmSfxxService.findRfxmSfxx(paraMap);
			paymentItemHis = paymentItemHisService.getById(rfxm.getPaymentHisId());
			paymentItemHis.setSlbh(rfxm.getJktzsbh());

			Map<String, Object> paramMap = new HashMap<>();
			List<String> remarks = yzssfglService.getJktzsRemarks(paramMap);
			String remark = StringUtils.isBlank(remarks.get(0))?"此轮不涉及":remarks.get(0);


			//将已存在的复制到打印用的list中
			rfxmSfxx4Print.addAll(rfxmSfxx);


			//end 2019-6-25
			if (this.getLoginUser() == null) {
				this.getResponse().getWriter().println("{\"result\":false,\"message\":\""+"当前登录信息失效,请重新登录!"+"\"}");
				return null;
			}
			Map<String, List<String>> permissions = this.getLoginUser().getPermissions();
			printerName = this.getLoginUser().getDisplayName();

		}
		return VIEW;
	}

	public String sfxxView() throws IOException {
		if (null != ids) {
			Map<String, Object> paraMap =new HashMap<>();
			/*paraMap.put("jfdmwybh", jfdmwybh);
			rfxmSfxx = rfxmSfxxService.findRfxmSfxx(paraMap);*/
			rfxmsfxx = rfxmSfxxService.getById(ids);
			rfxm = rfxmService.getById(rfxmsfxx.getRfxmid());
			return VIEW;
		}else {
			this.getResponse().getWriter().println("{\"result\":false,\"message\":\""+"获取当前收费信息失败,请稍后再试."+"\"}");
			return null;
		}
	}

	public String sfxxView2() throws IOException {
		if (null != ids) {
			PaymentItemHis paymentItemHis = paymentItemHisService.getById(ids);
			Map<String, Object> paraMap =new HashMap<>();
			paraMap.put("paymentHisId", ids);
			List<Rfxm> rfxmList = rfxmService.findRfxm(paraMap);
			if(rfxmList != null && rfxmList.size() > 0) {
				rfxm = rfxmList.get(0);
			}
			rfxmsfxx = new RfxmSfxx();
			rfxmsfxx.setSfxmmc("城市基础设施配套费");
			rfxmsfxx.setYjjemx(paymentItemHis.getZyjje());
			rfxmsfxx.setShbm(paymentItemHis.getZsdw());
			rfxmsfxx.setZslxdbh(paymentItemHis.getZslxdbh());
			rfxmsfxx.setSfxmlxdbh(rfxm.getJktzsbh());
			rfxmsfxx.setCnjfhj(rfxm.getPaymentLink() ==1 ? "施工许可前" : "30日内");
			return VIEW;
		}else {
			this.getResponse().getWriter().println("{\"result\":false,\"message\":\""+"获取当前收费信息失败,请稍后再试."+"\"}");
			return null;
		}
	}


	public void rfxmSfxxReviewCheck() throws IOException {
		RfxmSfxx sfxx = rfxmSfxxService.getById(rfxmsfxx.getId());
		boolean result = false;
		String message;
		if(sfxx.getSfxxjbr().equals(this.getLoginUser().getDisplayName())) {
			message = "不允许复核自己添加的费用";
		} else {
			result = true;
			message = "OK";
		}
		this.getResponse().getWriter().println("{\"result\":"+result+",\"message\":\"" + message + "!"+"\"}");
	}
	/**
	 * 复核收费信息
	 */
	public String rfxmSfxxReview() throws IOException {
		if (StringUtils.isNotBlank(flag) && null != rfxmsfxx) {
			//退回时，清空收费项目的联系单编号
			RfxmSfxx sfxx = rfxmSfxxService.getById(rfxmsfxx.getId());
			Rfxm rfxm = rfxmService.getById(sfxx.getRfxmid());

			if ("2".equalsIgnoreCase(flag)) {
				if(rfxm.getPaymentLink() != 3) {//提前缴纳选未选是
					sfxx.setStatus(10);
				} else if(sfxx.getTqjn() != 1) {
					sfxx.setStatus(10);
				} else if(sfxx.getStatus() == 2) {//提前选是，并且复核过1次，不路过了
					sfxx.setStatus(10);
				} else {//提前选是，1次未复核
					sfxx.setStatus(1);
				}
				rfxm.setTqjn(sfxx.getTqjn());
				rfxm.setSfxxStatus(sfxx.getStatus());
				if(sfxx.getStatus() == 1 || sfxx.getStatus() == 10) {
					rfxm.setIsTb(0);
				}
				sfxx.setFhTime(new Date());
				sfxx.setSfxxfhr(this.getLoginUser().getDisplayName());
				if (StringUtils.isNotBlank(rfxmsfxx.getSfxxfhyj())){
					sfxx.setSfxxfhyj(rfxmsfxx.getSfxxfhyj());
				}
				rfxmService.update(rfxm);
				rfxmSfxxService.update(sfxx);
			} else {
				if(sfxx.getStatus() == 2) {//补录未复核
					sfxx.setStatus(3);//补录拒绝
					rfxm.setSfxxStatus(sfxx.getStatus());
					rfxmSfxxService.update(sfxx);
				} else {
					//退回
					rfxmSfxxService.deleteWithFlag(sfxx.getId());
					rfxm.setTqjn(null);
					rfxm.setSfxxStatus(null);
					rfxm.setSfxmlxdbh(null);
				}

				rfxmService.update(rfxm);
			}
		}
		return RELOAD;
	}

	//start 2019-6-5 --------------------------------------------
	/**
	 * 获取收费信息相关
	 */
	public String viewYzssfgl(){
		if((null != yzssfgl)&&(null != yzssfgl.getId()))
			yzssfgl = yzssfglService.getById(yzssfgl.getId());
		return VIEW;
	}
	/**
	 * 获取收费区域信息
	 */
	public void getQyxxYzssfgl(){
		Map<String,Object> paramMap =  new HashMap<>();
		yzssxqyList =yzssfglService.getYzssfqy(paramMap);
	}
	/**
	 * 获取一站式代收单位
	 */
	public void getDsdwYzssfgl(){
		Map<String,Object> paramMap =  new HashMap<>();
		yzssxdsdwList =yzssfglService.getYzsdsdw(paramMap);
	}
	/**
	 * 获取一站式收费项目名称
	 */
	public void getSfxmmcYzssfgl(){
		Map<String,Object> paramMap =  new HashMap<>();
//		yzssxsfxmmcList =yzssfglService.getYzssfxmmc(paramMap);
		yzssxsfxmmcList = new ArrayList<>();
		yzssxsfxmmcList.add("防空地下室易地建设费");
	}
	/**
	 * 获取一站式审核部门
	 */
	public void getShbmYzssfgl(){
		Map<String,Object> paramMap =  new HashMap<>();
//		yzssxshbmList =yzssfglService.getYzsshbm(paramMap);
		yzssxshbmList = new ArrayList<>();
		yzssxshbmList.add("南京市人民防空办公室");
		yzssxshbmList.add("南京市建邺区人防办");
	}

	// end 2019-6-5 ---------------------------------------------

	/**
	 * 	初始化修改信息
	 */
	public String initEdit() throws Exception{
		if (null != rfxm && StringUtils.isNotBlank(rfxm.getId())) {
			rfxm = rfxmService.getById(rfxm.getId());
		}

		return EDIT;
	}

	/**
	 * 	打开rfxm下的sdjd列表页面
	 * 	2019-5-21 15:39:43
	 * 	author: jinx@caoz
	 */
	public String condition(){
		return EDIT;
	}

	/**
	 * 跳转到添加
	 * @return
	 * @throws Exception
	 */
	public String add() throws Exception{
		Map<String, Object> paraMap = new HashMap<>();
		view();
		dsdw = "收费处".equals(this.getLoginUserDepartment().getDeptName())?"南京市城市建设费用征收服务中心":this.getLoginUserDepartment().getDeptName();
		paraMap.put("xkzh", "%" + rfxm.getGhxkzbh() + "%");
		paraMap.put("xmbh", rfxm.getGhxmbh()+"%");
//		paraMap.put("dwbh", this.getLoginUser().getDeptCode());
		List xmxxbs = xmxxbService.findXmxxb(paraMap);
		//通过以上条件可以确定唯一
		if (null !=xmxxbs && xmxxbs.size()>0) {
			//有
			xmxxb = (Xmxxb)xmxxbs.get(0);
			Map<String, Object> xmhfParaMap = new HashMap<>();
			xmhfParaMap.put("xxbbh", xmxxb.getId());
			List<Xmhf> xmhfs = xmhfService.findXmhf(xmhfParaMap);
			if (null !=xmhfs && xmhfs.size() > 0) {
				//唯一
				xmhf = xmhfs.get(0);
			}
		}
		return EDIT;
	}

	/**
	 * 跳转到项目添加验证
	 * @return
	 * @throws Exception
	 */
	public String projectCheck() throws Exception{
		Map<String, Object> paraMap = new HashMap<>();
		//todo 测试使用,正式修改为获取当前登录账号的单位
		dsdw = "收费处".equals(this.getLoginUserDepartment().getDeptName())?"南京市城市建设费用征收服务中心":this.getLoginUserDepartment().getDeptName();

//		dsdw = "南京市城市建设费用征收服务中心";
		paraMap.put("dsdw", dsdw);
//		List<Yzsdicgl> list = yzsdicglService.findYzsdicgl(paraMap);
		List<Yzssfgl> list = yzssfglService.findYzssfgl(paraMap);
		if (null != list && list.size()>0) {
			for (Yzssfgl yzssfgl1 : list) {
				if (StringUtils.isNotBlank(yzssfgl1.getYzsqy())) {
					yzsqy = yzssfgl1.getYzsqy();
					break;
				}
			}
		}
		return EDIT;
	}

	/**
	 * 跳转收费信息添加页面
	 * @return
	 * @throws Exception
	 */
	public String sfxxAdd() throws Exception{
		Map<String, Object> paraMap = new HashMap<>();
		//todo 测试使用,正式修改为获取当前登录账号的单位
		dsdw = "收费处".equals(this.getLoginUserDepartment().getDeptName())?"南京市城市建设费用征收服务中心":this.getLoginUserDepartment().getDeptName();

//		dsdw = "南京市城市建设费用征收服务中心";
		paraMap.put("dsdw", dsdw);
//		List<Yzsdicgl> list = yzsdicglService.findYzsdicgl(paraMap);
		List<Yzssfgl> list = yzssfglService.findYzssfgl(paraMap);
		for (Yzssfgl yzssfgl1 : list) {
			if (StringUtils.isNotBlank(yzssfgl1.getYzsqy())) {
				yzsqy = yzssfgl1.getYzsqy();
				break;
			}
		}
		view();
		viewYzssfgl();
		getQyxxYzssfgl();
		getDsdwYzssfgl();
		getSfxmmcYzssfgl();
		getShbmYzssfgl();
		return EDIT;
	}

	/**
	 * 初始化关联添加页面
	 * @return
	 * @throws Exception
	 */
	public String initAdd() throws Exception{
		if((null != ids)) {
			sdjd = sdjdService.getById(ids);
		}
		return EDIT;
	}

	/**
	 * 	保存信息（包括新增和修改）
	 */
	public String save() throws Exception{
		FileInputStream in = null;
		try
		{
			//设置Blob字段
			setBlobField(in);
		}
		finally
		{
			if (null != in)
			{
				try
				{
					in.close();
				}
				catch (Exception ex)
				{
				}
			}
		}

		if ("add".equalsIgnoreCase(this.flag)){
			rfxm.setDeptId(this.getLoginUserDepartmentId());
			rfxm.setDelFlag(0);
			//新建项目标记为0待复核
			rfxm.setStatus("0");
			rfxm.setStatus("0");
			//设置三种缴费环节状态为0,在生成缴费通知单时再修改为1;
			rfxm.setStatusConstract(0);
			rfxm.setStatusComplete(0);
			rfxm.setStatusWithinTheDay(0);


			/**
			 * TODO
			 * 代收单位及代收单位层级
			 */
			User loginUser = getLoginUser();
			//经办人姓名
			rfxm.setDsdwjbr(loginUser.getDisplayName());
			rfxm.setJbTime(new Date());
			//0 待复核
			rfxm.setStatusJBFH(0);
			// 手动录入
			rfxm.setInsertType(1);
			// 防止重复输入"建字第"及"号";
			String xkzh = rfxm.getGhxkzbh();
			// 转换成字符数组
			char[] chars = xkzh.toCharArray();
			StringBuilder sb = new StringBuilder();
			for (int i = 0; i < chars.length; i++) {
				char aChar = chars[i];
				if (aChar>= 48 && aChar <= 57) {
					sb.append(aChar);
				}
			}
			sb.append("号");
			String s = sb.toString();
			s = "建字第" + s;
			rfxm.setGhxkzbh(s);
			rfxmService.save(this.rfxm);
			/*
			 * 添加之前的验证操作,此步骤已经单独提出在projectVerify方法内;
			 * Rfxm exist =  rfxmService.getByXmdm(rfxm.getXmdm());
			 * if (exist != null) {
			 *     getResponse().getWriter().println("{\"result\":\"false\",\"info\":\"已存在相同的项目！\"}");
			 * }else {
			 *     rfxmService.save(rfxm);
			 * }
			 *
			 * */
		}else{

		}

		return RELOAD;
	}

	/**
	 * 保存收费信息
	 */
	public String sfxxSave() {
		rfxm = rfxmService.getById(rfxm.getId());
		Map<String, String> paraMapfj = new HashMap<String, String>();
		try {
			//再上一级目录+新建文件夹名
			String path= SysPropertiesUtil.jdlj(this.getRequest())+File.separator+ "uploads" + File.separator + Constant.ZSLC_SFXX + File.separator;
			// 写到指定的路径中
			JSONObject jsonObject = JSONObject.fromObject(allFileName);
			JSONObject jsonObject1= JSONObject.fromObject(originFileName);
			String fileName = "";
			if(file1 != null && file1.size() > 0) {
				fileName = FileUtils.uploadFile(file1.get(0),file1FileName.get(0), path,UUID.randomUUID().toString());
				String attachType = fileName.substring(fileName.lastIndexOf(".")+1);
				rfxmsfxx.setAttachname(file1FileName.get(0));
				rfxmsfxx.setUrldz(fileName);
				rfxmsfxx.setFilePath(path);
				rfxmsfxx.setAttachType(attachType);
				rfxmsfxx.setXmType("征收联系单");
				//前台显示名称,目前方案为 缴费项目名称.扩展名 eg:配套费.xlsx
				if (StringUtils.isNotBlank(rfxmsfxx.getAttachType())) {
					rfxmsfxx.setShowName(rfxmsfxx.getXmType()+"."+rfxmsfxx.getAttachType());
				} else {
					rfxmsfxx.setShowName("");
				}
			}

			if(file2 != null && file2.size() > 0) {
				fileName = FileUtils.uploadFile(file2.get(0),file2FileName.get(0), path,UUID.randomUUID().toString());
				String attachType = fileName.substring(fileName.lastIndexOf(".")+1);
				rfxmsfxx.setAttachnameFk(file2FileName.get(0));
				rfxmsfxx.setUrldzFk(fileName);
				rfxmsfxx.setFilePathFk(path);
				rfxmsfxx.setAttachTypeFk(attachType);
				rfxmsfxx.setXmTypeFk("税务反馈单");
				//前台显示名称,目前方案为 缴费项目名称.扩展名 eg:配套费.xlsx
				if (StringUtils.isNotBlank(rfxmsfxx.getAttachTypeFk())) {
					rfxmsfxx.setShowNameFk(rfxmsfxx.getXmTypeFk()+"."+rfxmsfxx.getAttachTypeFk());
				} else {
					rfxmsfxx.setShowNameFk("");
				}
			}

			if(file3 != null && file3.size() > 0) {
				fileName = FileUtils.uploadFile(file3.get(0),file3FileName.get(0), path,UUID.randomUUID().toString());
				String attachType = fileName.substring(fileName.lastIndexOf(".")+1);
				rfxmsfxx.setAttachnameSq(file3FileName.get(0));
				rfxmsfxx.setUrldzSq(fileName);
				rfxmsfxx.setFilePathSq(path);
				rfxmsfxx.setAttachTypeSq(attachType);
				rfxmsfxx.setXmTypeSq("先行缴纳配套费申请");
				//前台显示名称,目前方案为 缴费项目名称.扩展名 eg:配套费.xlsx
				if (StringUtils.isNotBlank(rfxmsfxx.getAttachTypeSq())) {
					rfxmsfxx.setShowNameSq(rfxmsfxx.getXmTypeSq()+"."+rfxmsfxx.getAttachTypeSq());
				} else {
					rfxmsfxx.setShowNameSq("");
				}
			}

			if(file4 != null && file4.size() > 0) {
				fileName = FileUtils.uploadFile(file4.get(0),file4FileName.get(0), path,UUID.randomUUID().toString());
				String attachType = fileName.substring(fileName.lastIndexOf(".")+1);
				rfxmsfxx.setAttachnameZm(file4FileName.get(0));
				rfxmsfxx.setUrldzZm(fileName);
				rfxmsfxx.setFilePathZm(path);
				rfxmsfxx.setAttachTypeZm(attachType);
				rfxmsfxx.setXmTypeZm("完税证明");
				//前台显示名称,目前方案为 缴费项目名称.扩展名 eg:配套费.xlsx
				if (StringUtils.isNotBlank(rfxmsfxx.getAttachTypeZm())) {
					rfxmsfxx.setShowNameZm(rfxmsfxx.getXmTypeZm()+"."+rfxmsfxx.getAttachTypeZm());
				} else {
					rfxmsfxx.setShowNameZm("");
				}
			}
		}catch (Exception e) {
			logger.error("保存附件失败", e);
		}



		//收费信息名称

		//缴费代码唯一编号
//		rfxmsfxx.setJfdmwybh(jfdmwybh);
		//承诺缴费环节
		if(rfxm.getPaymentLink() != null) {
			rfxmsfxx.setCnjfhj(rfxm.getPaymentLink() == 3 ? "30日内" : "施工许可前");
		}

		// 是否生成缴款通知书 0 未生成(初始化) 1 已生成
		rfxmsfxx.setStatusCnjfhj(0);
		//记录项目id
		rfxmsfxx.setRfxmid(rfxm.getId());
		//设置部门id
		rfxmsfxx.setDeptId(this.getLoginUserDepartmentId());
		//逻辑删除标记符
		rfxmsfxx.setDelFlag(0);
		Map<String, Object> paraMap = new HashMap<>();
		paraMap.put("yzsqy", rfxmsfxx.getYzsqy());
		paraMap.put("dsdw", rfxmsfxx.getDsdw());
		paraMap.put("sfxmmc", rfxmsfxx.getSfxmmc());
		paraMap.put("shbm", rfxmsfxx.getShbm());
		List<Yzssfgl> list = yzssfglService.findYzssfgl(paraMap);
        if (rfxmsfxx.getYjjemx().contains(",")/* || rfxmsfxx.getYjjemx().contains("，")*/) {
			String replaceAll = rfxmsfxx.getYjjemx().replaceAll(",", "");
			rfxmsfxx.setYjjemx(replaceAll);
//        	rfxmsfxx.getYjjemx().replaceAll("，", "");
		}
		rfxmsfxx.setSfxxjbr(this.getLoginUser().getDisplayName());
        rfxmsfxx.setJbTime(new Date());
        rfxmsfxx.setStatus(0);

		if(rfxm.getPaymentLink() == null && rfxmsfxx.getCnjfhj() != null) {//如果项目没有缴费环节，则收费处可以补充
			rfxm.setPaymentLink(rfxmsfxx.getCnjfhj().contains("30") ? 3 : 1);
			rfxmService.update(rfxm);
		}
		if(!TextUtils.isEmpty(rfxmsfxx.getSfxmlxdbh())) {
			rfxm.setSfxmlxdbh(rfxmsfxx.getSfxmlxdbh());
			rfxmService.update(rfxm);
		}
		rfxmsfxx.setZslxdbh(rfxm.getZslxdbh());
		rfxmsfxx.setUpdateTime(new Date());
		rfxmSfxxService.save(rfxmsfxx);
//		}
		return RELOAD;
	}

	/**
	 * 跳转修改收费信息页面
	 */
	public String initEditSfxx() throws IOException {
		String message = "";
		try {
			if (StringUtils.isNotBlank(ids)) {
				if ("edit".equalsIgnoreCase(flag)){
					rfxmsfxx = rfxmSfxxService.getById(ids);
					rfxm = rfxmService.getById(rfxmsfxx.getRfxmid());
					getQyxxYzssfgl();
					getDsdwYzssfgl();
					getSfxmmcYzssfgl();
					getShbmYzssfgl();
				}
			}else {
				//id为空
				message = "未查询x到相关收费信息记录";
				getResponse().getWriter().println("{\"result\":false,\"message\":"+message+"\"}");
			}
		}catch (Exception e) {
			logger.error(e.getMessage());
			e.printStackTrace();
			message = "发生错误!";
			getResponse().getWriter().println("{\"result\":false,\"message\":"+message+"\"}");
//			getResponse().getWriter().println("{\"result\":true}");
		}

		return EDIT;
	}



	/**
	 * 验证收费信息添加
	 * 1. 当前缴费状态(status_constract,status_complete,status_within_the_day)是否已生成缴费通知单
	 * 2. 当前状态下是否<=8 条缴费信息
	 *
	 * todo 添加项目时,记得给status_xxx三个置为0,在点击生成缴款通知书时候,将对应的缴费环节状态改为1;
	 */
	public void chargeVerification() throws IOException {
		boolean status = true;
		//TODO 这里可以校验选择的对不对
		String message = "OK";
		if(!"edit".equals(flag)) {
			Map<String, Object> query = new HashMap<>();
			query.put("rfxmid",rfxmid);
			if(pagination==null) {
				pagination = new Pagination(this.getRequest());
			}
			Pagination byPage = rfxmSfxxService.findByPage(pagination, query);
			if(byPage.totalCount > 0) {
				status = false;
				message = "只允许添加一条记录";
				this.getResponse().getWriter().println("{\"result\":"+status+",\"message\":\""+message+"\"}");
				return;
			}
		}

		if(rfxmsfxx == null) {
			status = false;
			message = "请添加信息";
		} else {
			if(!TextUtils.isEmpty(rfxmsfxx.getYjjemx())) {
				try {
					Double.parseDouble(rfxmsfxx.getYjjemx());
				} catch (Exception e) {
					status = false;
					message = "请输入正确的金额";
				}
			}
			if(!TextUtils.isEmpty(rfxmsfxx.getSfxmlxdbh())) {
				Map<String, Object> paraMap = new HashMap<>();
				paraMap.put("sfxmlxdbh", rfxmsfxx.getSfxmlxdbh());
				rfxmSfxx =  rfxmSfxxService.findRfxmSfxx(paraMap);
				if(rfxmSfxx != null && rfxmSfxx.size() > 0) {
					if(rfxmSfxx.get(0).getPaymentHisId() != rfxm.getPaymentHisId()) {
						status = false;
						message = "收费项目联系单编号重复";
					}

				}
			}
		}

		this.getResponse().getWriter().println("{\"result\":"+status+",\"message\":\""+message+"\"}");
	}


	/**
	 * 将File对象转换为Blob对象，并设置到实体类中
	 * 如果没有File对象，可删除此方法，并一并删除save方法中调用此方法的代码
	 */
	private void setBlobField(FileInputStream in)
	{
		if (null != rfxm)
		{
			try
			{
				//此处将File对象转换成blob对象，并设置到zsdw中去

			}
			catch (Exception ex)
			{
				ex.printStackTrace();
			}
		}
	}

	/**
	 * 删除信息
	 */
	public String delete() throws Exception{
		try{
			rfxmService.deleteWithFlag(ids);
			this.getResponse().getWriter().println("{\"result\":true}");
		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}
	/**
	 * 获取需要生成缴款通知书的数据
	 */
	public void getNoticeData() {
		Map<String, Object> paraMap = new HashMap<>();
		paraMap.put("rfxmid", rfxmid);
		//通过前台传递过来的cnjfhj状态码来获取对应的数据集合
		paraMap.put("typeCnjfhj", rfxmsfxx.getTypeCnjfhj());
		//获取到当前需要生成的缴费环节的集合
		rfxmSfxx = rfxmSfxxService.findRfxmSfxx(paraMap);
	}

	/**
	 *	资料归集
	 * @return
	 */
	public String materialCollect(){
		return EDIT;
	}


	/**
	 * 保存信息（包括新增和修改）
	 */
	public String materialCollectSave() throws Exception
	{
		return RELOAD;
	}


	/**
	 *	查看资料归集信息
	 * @return
	 */
	public String materialView(){
		return VIEW;
	}

	private static final String host = SysPropertiesUtil.getProperty("gd.host");
	private static final String port = SysPropertiesUtil.getProperty("gd.port");
	private static final String username = SysPropertiesUtil.getProperty("gd.username");
	private static final String password = SysPropertiesUtil.getProperty("gd.password");
	private static final String ftpPath = SysPropertiesUtil.getProperty("gd.ftpPath");

//	2020-1-3 start ------------------------------------------
	/**
	 * 跳转账表
	 * @return
	 * @Date 2020-1-3
	 */
	public String toProjectReport() {
		System.out.println("----------method in-------------");
		if (null != this.getLoginUser()) {
			deptCode = "/ReportServer?reportlet=" + cpt + ".cpt&loginUser="+this.getLoginUser().getDisplayName();
			return SUCCESS;
		} else {
			return "fail";
		}

	}

	/**
	 * 判断是否可以人防用章
	 * @throws Exception
	 */
	public void rfyzCheck() throws Exception {
		if(TextUtils.isEmpty(rfxm.getId())) {
			rfxm.setId(ids);
		}
		view();
		boolean result = true;
		String message = "";
		result = rfxm.getEnableRfyz() == 1;

		this.getResponse().getWriter().println("{\"result\":" + result + ",\"message\":\""+message+"\"}");
	}

	public void rfyz() throws Exception {
		Rfxm rfxm = rfxmService.getById(ids);
		rfxm.setIsRfyz(1);
		rfxm.setYzTime(new Date());
		rfxm.setJbr(this.getLoginUser().getDisplayName());//盖章的经办人
		rfxmService.update(rfxm);
	}

	/**
	 * 收费信息修改页面
	 */
	public String sfxxEdit() throws IOException {

		User loginUser = this.getLoginUser();
		Map<String, List<String>> permissions = loginUser.getPermissions();
		String message = "";
		// 先判断是否已经生成缴款通知书
		RfxmSfxx sfxx = rfxmSfxxService.getById(rfxmsfxx.getId());
		//clone原收费信息
		//为空 一般情况下不存在此种情况
		if (sfxx == null) {
			message = "该收费信息不存在,请核实或者重新登录后再试!";
			this.getResponse().getWriter().println("{\"result\":false,\"message\":\""+message+"\"}");
			return null;
			// 已生成缴款通知书的情况下不允许修改
		}else{
			if (sfxx.getStatusCnjfhj() > 0) {
				// 已生成缴款通知书
				message = "该收费信息已生成缴款通知书,不可再进行修改!";
				this.getResponse().getWriter().println("{\"result\":false,\"message\":\""+message+"\"}");
				return null;
			}else {
				Map<String, String> paraMapfj = new HashMap<String, String>();
				try {
					//再上一级目录+新建文件夹名
					String path= SysPropertiesUtil.jdlj(this.getRequest())+File.separator+ "uploads" + File.separator + Constant.ZSLC_SFXX + File.separator;
					String fileName = "";
					if(file1 != null && file1.size() > 0) {
						fileName = FileUtils.uploadFile(file1.get(0),file1FileName.get(0), path,UUID.randomUUID().toString());
						String attachType = fileName.substring(fileName.lastIndexOf(".")+1);
						sfxx.setAttachname(file1FileName.get(0));
						sfxx.setUrldz(fileName);
						sfxx.setFilePath(path);
						sfxx.setAttachType(attachType);
						sfxx.setXmType("征收联系单");
						//前台显示名称,目前方案为 缴费项目名称.扩展名 eg:配套费.xlsx
						if (StringUtils.isNotBlank(sfxx.getAttachType())) {
							sfxx.setShowName(sfxx.getXmType()+"."+sfxx.getAttachType());
						} else {
							sfxx.setShowName("");
						}
					}

					if(file2 != null && file2.size() > 0) {
						fileName = FileUtils.uploadFile(file2.get(0),file2FileName.get(0), path,UUID.randomUUID().toString());
						String attachType = fileName.substring(fileName.lastIndexOf(".")+1);
						sfxx.setAttachnameFk(file2FileName.get(0));
						sfxx.setUrldzFk(fileName);
						sfxx.setFilePathFk(path);
						sfxx.setAttachTypeFk(attachType);
						sfxx.setXmTypeFk("税务反馈单");
						//前台显示名称,目前方案为 缴费项目名称.扩展名 eg:配套费.xlsx
						if (StringUtils.isNotBlank(sfxx.getAttachTypeFk())) {
							sfxx.setShowNameFk(sfxx.getXmTypeFk()+"."+sfxx.getAttachTypeFk());
						} else {
							sfxx.setShowNameFk("");
						}
					}

					if(file3 != null && file3.size() > 0) {
						fileName = FileUtils.uploadFile(file3.get(0),file3FileName.get(0), path,UUID.randomUUID().toString());
						String attachType = fileName.substring(fileName.lastIndexOf(".")+1);
						sfxx.setAttachnameSq(file3FileName.get(0));
						sfxx.setUrldzSq(fileName);
						sfxx.setFilePathSq(path);
						sfxx.setAttachTypeSq(attachType);
						sfxx.setXmTypeSq("先行缴纳配套费申请");
						//前台显示名称,目前方案为 缴费项目名称.扩展名 eg:配套费.xlsx
						if (StringUtils.isNotBlank(sfxx.getAttachTypeSq())) {
							sfxx.setShowNameSq(sfxx.getXmTypeSq()+"."+sfxx.getAttachTypeSq());
						} else {
							sfxx.setShowNameSq("");
						}
					}

					if(file4 != null && file4.size() > 0) {
						fileName = FileUtils.uploadFile(file4.get(0),file4FileName.get(0), path,UUID.randomUUID().toString());
						String attachType = fileName.substring(fileName.lastIndexOf(".")+1);
						sfxx.setAttachnameZm(file4FileName.get(0));
						sfxx.setUrldzZm(fileName);
						sfxx.setFilePathZm(path);
						sfxx.setAttachTypeZm(attachType);
						sfxx.setXmTypeZm("完税证明");
						//前台显示名称,目前方案为 缴费项目名称.扩展名 eg:配套费.xlsx
						if (StringUtils.isNotBlank(sfxx.getAttachTypeZm())) {
							sfxx.setShowNameZm(sfxx.getXmTypeZm()+"."+sfxx.getAttachTypeZm());
						} else {
							sfxx.setShowNameZm("");
						}
					}
				}catch (Exception e) {
					logger.error("保存附件失败", e);
				}

				if (null != rfxmsfxx.getSfxmmc() && !(rfxmsfxx.getSfxmmc()).equalsIgnoreCase(sfxx.getSfxmmc())) {
					sfxx.setSfxmmc(rfxmsfxx.getSfxmmc());
				}
				if (null != rfxmsfxx.getShbm() && !(rfxmsfxx.getShbm()).equalsIgnoreCase(sfxx.getShbm())) {
					sfxx.setShbm(rfxmsfxx.getShbm());
				}
				if (null != rfxmsfxx.getSfxmlxdbh() && !(rfxmsfxx.getSfxmlxdbh()).equalsIgnoreCase(sfxx.getSfxmlxdbh())) {
					sfxx.setSfxmlxdbh(rfxmsfxx.getSfxmlxdbh());
				}
				if (null != rfxmsfxx.getYjjemx() && !(rfxmsfxx.getYjjemx()).equalsIgnoreCase(sfxx.getYjjemx())) {
					sfxx.setYjjemx(rfxmsfxx.getYjjemx());
				}
				sfxx.setFkTime(rfxmsfxx.getFkTime());


				if (null != rfxmsfxx.getBeizhu() && !(rfxmsfxx.getBeizhu()).equalsIgnoreCase(sfxx.getBeizhu())) {
					sfxx.setBeizhu(rfxmsfxx.getBeizhu());
				}
				rfxm = rfxmService.getById(sfxx.getRfxmid());
				rfxm.setSfxmlxdbh(rfxmsfxx.getSfxmlxdbh());
				rfxmService.update(rfxm);

				sfxx.setStatus(2);//2补录之后，不可以补录了
				sfxx.setJbTime(new Date());
				rfxmSfxxService.update(sfxx);
			}
		}

		return RELOAD;
	}


	private String deptCode;
	private String cpt;

	public String getDeptCode() {
		return deptCode;
	}

	public void setDeptCode(String deptCode) {
		this.deptCode = deptCode;
	}

	public String getCpt() {
		return cpt;
	}

	public void setCpt(String cpt) {
		this.cpt = cpt;
	}
//	2020-1-3 end ---------------------------------------

	public String getIds(){
		return ids;
	}

	public void setIds(String ids){
		this.ids = ids;
	}

	public Pagination getPagination(){
		return pagination;
	}

	public void setPagination(Pagination pagination){
		this.pagination = pagination;
	}

	public Rfxm getRfxm(){
		return this.rfxm;
	}

	public void setRfxm(Rfxm rfxm){
		this.rfxm = rfxm;
	}

	public String getFlag(){
		return flag;
	}

	public void setFlag(String flag){
		this.flag = flag;
	}

	public Sdjd getSdjd() {
		return sdjd;
	}

	public void setSdjd(Sdjd sdjd) {
		this.sdjd = sdjd;
	}

	public List<RfxmSfxx> getRfxmSfxx() {
		return rfxmSfxx;
	}

	public void setRfxmSfxx(List<RfxmSfxx> rfxmSfxx) {
		this.rfxmSfxx = rfxmSfxx;
	}

	public RfxmSfxx getRfxmsfxx() {
		return rfxmsfxx;
	}

	public void setRfxmsfxx(RfxmSfxx rfxmsfxx) {
		this.rfxmsfxx = rfxmsfxx;
	}

	public Zzhqfdz getZzhqfdz() {
		return zzhqfdz;
	}

	public void setZzhqfdz(Zzhqfdz zzhqfdz) {
		this.zzhqfdz = zzhqfdz;
	}

	public String getDsdw() {
		return dsdw;
	}

	public void setDsdw(String dsdw) {
		this.dsdw = dsdw;
	}

	public String getUrldz() {
		return urldz;
	}

	public void setUrldz(String urldz) {
		this.urldz = urldz;
	}

	public List<File> getFile1() {
		return file1;
	}

	public void setFile1(List<File> file1) {
		this.file1 = file1;
	}

	public List<String> getFile1FileName() {
		return file1FileName;
	}

	public void setFile1FileName(List<String> file1FileName) {
		this.file1FileName = file1FileName;
	}

	public List<File> getFile2() {
		return file2;
	}

	public void setFile2(List<File> file2) {
		this.file2 = file2;
	}

	public List<File> getFile3() {
		return file3;
	}

	public void setFile3(List<File> file3) {
		this.file3 = file3;
	}

	public List<File> getFile4() {
		return file4;
	}

	public void setFile4(List<File> file4) {
		this.file4 = file4;
	}

	public List<String> getFile2FileName() {
		return file2FileName;
	}

	public void setFile2FileName(List<String> file2FileName) {
		this.file2FileName = file2FileName;
	}

	public List<String> getFile3FileName() {
		return file3FileName;
	}

	public void setFile3FileName(List<String> file3FileName) {
		this.file3FileName = file3FileName;
	}

	public List<String> getFile4FileName() {
		return file4FileName;
	}

	public void setFile4FileName(List<String> file4FileName) {
		this.file4FileName = file4FileName;
	}

	public String getAllFileName() {
		return allFileName;
	}

	public void setAllFileName(String allFileName) {
		this.allFileName = allFileName;
	}

	public String getOriginFileName() {
		return originFileName;
	}

	public void setOriginFileName(String originFileName) {
		this.originFileName = originFileName;
	}

	public String getJfdmwybh() {
		return jfdmwybh;
	}

	public void setJfdmwybh(String jfdmwybh) {
		this.jfdmwybh = jfdmwybh;
	}

	public String getReviewTag() {
		return reviewTag;
	}

	public void setReviewTag(String reviewTag) {
		this.reviewTag = reviewTag;
	}

	public String getRfxmid() {
		return rfxmid;
	}

	public void setRfxmid(String rfxmid) {
		this.rfxmid = rfxmid;
	}

	public Yzssfgl getYzssfgl() {
		return yzssfgl;
	}

	public void setYzssfgl(Yzssfgl yzssfgl) {
		this.yzssfgl = yzssfgl;
	}

	public Xmhf getXmhf() {
		return xmhf;
	}

	public void setXmhf(Xmhf xmhf) {
		this.xmhf = xmhf;
	}

	public Xmxxb getXmxxb() {
		return xmxxb;
	}

	public void setXmxxb(Xmxxb xmxxb) {
		this.xmxxb = xmxxb;
	}

	public String getYzssfqy() {
		return yzssfqy;
	}

	public void setYzssfqy(String yzssfqy) {
		this.yzssfqy = yzssfqy;
	}

	public String getYzsqy() {
		return yzsqy;
	}

	public void setYzsqy(String yzsqy) {
		this.yzsqy = yzsqy;
	}

	public List<String> getYzssxqyList() {
		return yzssxqyList;
	}

	public void setYzssxqyList(List<String> yzssxqyList) {
		this.yzssxqyList = yzssxqyList;
	}

	public List<String> getYzssxdsdwList() {
		return yzssxdsdwList;
	}

	public void setYzssxdsdwList(List<String> yzssxdsdwList) {
		this.yzssxdsdwList = yzssxdsdwList;
	}

	public List<String> getYzssxsfxmmcList() {
		return yzssxsfxmmcList;
	}

	public void setYzssxsfxmmcList(List<String> yzssxsfxmmcList) {
		this.yzssxsfxmmcList = yzssxsfxmmcList;
	}

	public List<String> getYzssxshbmList() {
		return yzssxshbmList;
	}

	public void setYzssxshbmList(List<String> yzssxshbmList) {
		this.yzssxshbmList = yzssxshbmList;
	}

	public String getDownFileName() {
		return downFileName;
	}

	public void setDownFileName(String downFileName) {
		this.downFileName = downFileName;
	}

	public InputStream getDownFileStream() {
		return downFileStream;
	}

	public void setDownFileStream(InputStream downFileStream) {
		this.downFileStream = downFileStream;
	}

	public String getPrinterName() {
		return printerName;
	}

	public void setPrinterName(String printerName) {
		this.printerName = printerName;
	}

	public List<RfxmSfxx> getRfxmSfxx4Print() {
		return rfxmSfxx4Print;
	}

	public void setRfxmSfxx4Print(List<RfxmSfxx> rfxmSfxx4Print) {
		this.rfxmSfxx4Print = rfxmSfxx4Print;
	}

    public String getAttachId() {
        return attachId;
    }

    public void setAttachId(String attachId) {
        this.attachId = attachId;
    }

	public String getGdh() {
		return gdh;
	}

	public void setGdh(String gdh) {
		this.gdh = gdh;
	}

	public static String getHost() {
		return host;
	}

	public static String getPort() {
		return port;
	}

	public static String getUsername() {
		return username;
	}

	public static String getPassword() {
		return password;
	}

	public PaymentItemHis getPaymentItemHis() {
		return paymentItemHis;
	}

	public void setPaymentItemHis(PaymentItemHis paymentItemHis) {
		this.paymentItemHis = paymentItemHis;
	}

	public int getDownloadIndex() {
		return downloadIndex;
	}

	public void setDownloadIndex(int downloadIndex) {
		this.downloadIndex = downloadIndex;
	}
}
