package com.jshx.message.service;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.jshx.common.utils.Constant;
import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.exception.BasalException;
import com.jshx.message.dao.JshxMessageDao;
import com.jshx.message.entity.JshxMessage;
import com.jshx.module.admin.entity.Department;
import com.jshx.module.admin.entity.User;
import com.jshx.module.admin.service.DeptService;
import com.jshx.module.admin.service.UserService;
import com.jshx.module.form.entity.Attachfiles;

@Service("jshxMessageService")
public class JshxMessageService extends BaseServiceImpl {
	@Resource
	private JshxMessageDao dao;

	@Resource
	private DeptService deptService;
	
	@Resource
	private UserService userService;

	public JshxMessageService()
    {
        super();
        this.setDao(new JshxMessageDao());
    }
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap) {
		return dao.findByPage(page, paraMap);
	}
	public Pagination findByPageMobile(Pagination page, Map<String, Object> paraMap) {
		return dao.findByPageMobile(page, paraMap);
	}

	public JshxMessage getById(String id) {
		return dao.getById(id);
	}

	@Transactional
	public void save(JshxMessage model) {
		dao.save(model);
	}

	@Transactional
	public void update(JshxMessage model) {
		dao.update(model);
	}
	@Transactional
	public void updateMessageResult(String smsId, String messageResult) throws BasalException{
		JshxMessage sms =  dao.getById(smsId);
        sms.setMessageResult(messageResult);
        if(Constant.TB_SMS_SENT_RESULT_3.equals(messageResult)){
        	sms.setMessagestatus("1");
		}else{
			sms.setMessagestatus("2");
		}
        dao.update(sms);
	}

	@Transactional
	public void delete(String[] ids) {
		if (null != ids) {
			for (String id : ids) {
				dao.delete(id);
			}
		}
	}

	@Transactional
	public void deleteWithFlag(String[] ids) {
		if (null != ids) {
			for (String id : ids) {
				dao.deleteWithFlag(id);
			}
		}
	}

	/**
	 * <查询信息列表>
	 * @param paraMap
	 * @return
	 *
	 * 创建时间：2011-3-1
	 * 创建人：duanpf
	 * 方法描述：
	 * （参数含义说明如下）
	 */
	@Transactional
	public List findListByMap( Map<String, Object> paraMap) throws BasalException{
		List list = dao.findListByMap(paraMap);
		return list;
	}
	
	/**
	 * <更新信息列表>
	 * @param paraMap
	 * @return
	 *
	 * 创建时间：2011-3-1
	 * 创建人：duanpf
	 * 方法描述：
	 * （参数含义说明如下）
	 */
	@Transactional
	public void updateIsreadedMessageList(List list) throws BasalException{
		
		if(list == null || list.isEmpty()){
			return;
		}
		
		//取出的数据需要改变状态为已读
		Iterator it = list.iterator();
		while(it.hasNext()){
			Object[] obj = (Object[])it.next();
			JshxMessage jshxMessage =(JshxMessage)obj[0];
			jshxMessage.setIsreaded("1"); ////是否已读 0：未读 1：已读
			
			try{
				update(jshxMessage);
			}catch(Exception e){
				throw new BasalException(BasalException.ERROR, e.getMessage());
			}
		}

	}
	
	/**
	 * 获取所有附件信息
	 */
	public List<Attachfiles> findAllAttachfiles(){
		String hql = "from Attachfiles";
		return dao.findListByHql(hql);
	}
	public JshxMessageDao getDao() {
		return dao;
	}
	public void setDao(JshxMessageDao dao) {
		this.dao = dao;
	}
	
}
