package com.jshx.jkfsjlb.service.impl;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.*;

import javax.annotation.Resource;

import com.jshx.core.utils.StringUtil;
import com.jshx.module.admin.web.action.CommonAction;
import net.sf.json.JSONArray;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.jkfsjlb.dao.JkfsjlbDao;
import com.jshx.jkfsjlb.entity.Jkfsjlb;
import com.jshx.jkfsjlb.service.JkfsjlbService;

@Service("jkfsjlbService")
public class JkfsjlbServiceImpl extends BaseServiceImpl implements JkfsjlbService
{
	/**
	 * Dao类
	 */
	@Autowired() 
	@Qualifier("jkfsjlbDao")
	private JkfsjlbDao jkfsjlbDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return jkfsjlbDao.findByPage(page, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Jkfsjlb getById(String id)
	{
		return jkfsjlbDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param
	 */
	@Transactional
	public void save(Jkfsjlb jkfsjlb)
	{
		jkfsjlbDao.save(jkfsjlb);
	}

	/**
	 * 修改信息
	 * @param
	 */
	@Transactional
	public void update(Jkfsjlb jkfsjlb)
	{
		jkfsjlbDao.update(jkfsjlb);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects=jkfsjlbDao.findJkfsjlb(paraMap);
		
		jkfsjlbDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
				    jkfsjlbDao.deleteWithFlag(id);
			}
		}
	}

	@Transactional
	public Jkfsjlb  beforejkfs(String url ,Map<String ,String> map,String getOrPost)
	{
		//发送接口前，存表
		Jkfsjlb jkfsjlb = new Jkfsjlb();
		jkfsjlb.setDelFlag(0);
		//发送地址
		jkfsjlb.setJkdz(url);

		//发送参数
		String sendParam = JSONArray.fromObject(map).toString();
		jkfsjlb.setFscs(sendParam.substring(1,sendParam.length()-1));

		//上次发送时间
		DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
		jkfsjlb.setLastfssj(new Date());

		//重发次数
		jkfsjlb.setCfcs(0L);

		//发送状态(0：有返回，但是报错  1：没有返回  2：发送成功)
		jkfsjlb.setFszt(1L);

		//发送方式
		jkfsjlb.setFsfs(getOrPost);

		jkfsjlbDao.save(jkfsjlb);
		return jkfsjlb;
	}
	@Transactional
	public void  updateZhuantai(String result,Jkfsjlb jkfsjlb)
	{
		//返回结果
		if(StringUtil.isNotEmpty(result))
		{
			String result1 = CommonAction.getValueFromJsonstr(result,"message");
			if("查询失败".equals(result1))
			{
				jkfsjlb.setFszt(0L);
			}
			else if("查询成功".equals(result1))
			{
				jkfsjlb.setFszt(2L);
			}
			jkfsjlb.setCfcs(jkfsjlb.getCfcs()+1L);
			jkfsjlb.setLastfssj(new Date());
			jkfsjlb.setFhjg(result);
			jkfsjlbDao.update(jkfsjlb);
		}
	}
	@Transactional
	public List<Jkfsjlb> findJkfsjl(Map<String ,Object> map)
	{
		List<Jkfsjlb> jkfsjlbs = jkfsjlbDao.findJkfsjlb(map);
		return jkfsjlbs;
	}
}
