package com.jshx.hscmj.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.hscmj.entity.Hscmj;
import com.jshx.hscmj.dao.HscmjDao;

@Component("hscmjDao")
public class HscmjDaoImpl extends BaseDaoImpl implements HscmjDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findHscmjByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findHscmj(Map<String, Object> paraMap){
		return this.findListByHqlId("findHscmjByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Hscmj getById(String id)
	{
		return (Hscmj)this.getObjectById(Hscmj.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Hscmj hscmj)
	{
		hscmj.setId(null);
		this.saveOrUpdateObject(hscmj);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Hscmj hscmj)
	{
		this.saveOrUpdateObject(hscmj);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Hscmj.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Hscmj hscmj = (Hscmj)this.getObjectById(Hscmj.class, id);
		hscmj.setDelFlag(1);
		this.saveObject(hscmj);
	}
}
