package com.jshx.hisxrspjlb.web;

import java.io.FileInputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.json.CodeJsonValueProcessor;
import com.jshx.core.json.DateJsonValueProcessor;
import com.jshx.hisxrspjlb.entity.Hisxrspjlb;
import com.jshx.hisxrspjlb.service.HisxrspjlbService;

import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;

public class HisxrspjlbAction extends BaseAction
{

	/**
	 * 主键ID列表，用于接收页面提交的多条主键ID信息
	 */
	private String ids;

	/**
	 * 实体类
	 */
	private Hisxrspjlb hisxrspjlb = new Hisxrspjlb();

	/**
	 * 业务类
	 */
	@Autowired
	private HisxrspjlbService hisxrspjlbService;

	/**
	 * 修改新增标记，add为新增、mod为修改
	 */
	private String flag;

	/**
	 * 分页信息
	 */
	private Pagination pagination;

	private Date queryCheckTimeStart;

	private Date queryCheckTimeEnd;

	private Date queryCheckTime2Start;

	private Date queryCheckTime2End;

	@Autowired()
	@Qualifier("sessionFactory")
	private SessionFactory sessionFactory;
	private String acceptNo;

	public String getAcceptNo()
	{
		return acceptNo;
	}

	public void setAcceptNo(String acceptNo)
	{
		this.acceptNo = acceptNo;
	}

	/**
	 * 执行查询的方法，返回json数据
	 */
	public void list() throws Exception
	{
		Map<String, Object> paraMap = new HashMap<String, Object>();

		if (pagination == null)
			pagination = new Pagination(this.getRequest());

		if (null != hisxrspjlb)
		{
			// 设置查询条件，开发人员可以在此增加过滤条件
			if ((null != hisxrspjlb.getAcceptNo()) && (0 < hisxrspjlb.getAcceptNo().trim().length()))
			{
				paraMap.put("acceptNo", "%" + hisxrspjlb.getAcceptNo().trim() + "%");
			}

			if ((null != hisxrspjlb.getDwdm()) && (0 < hisxrspjlb.getDwdm().trim().length()))
			{
				paraMap.put("dwdm", "%" + hisxrspjlb.getDwdm().trim() + "%");
			}

		}
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(java.util.Date.class, new DateJsonValueProcessor());
		Map<String, String> codeMap = new HashMap<String, String>();
		// 此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId

		config.registerJsonValueProcessor(String.class, new CodeJsonValueProcessor(codeMap));
		final String filter = "id|acceptNo|checkType|sign1name|sign1|checkOpinion|checkTime|infoFlag|checkTime2|";
		if (filter != null && filter.length() > 1)
		{
			config.setJsonPropertyFilter(new PropertyFilter()
			{
				public boolean apply(Object source, String name, Object value)
				{
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		pagination = hisxrspjlbService.findByPage(pagination, paraMap);

		convObjectToJson(pagination, config);
	}

	public String list1() throws Exception
	{

		hisxrspjlb.setAcceptNo(acceptNo);

		return "success";
	}

	/**
	 * 查看详细信息
	 */
	public String view() throws Exception
	{
		if ((null != hisxrspjlb) && (null != hisxrspjlb.getId()))
			hisxrspjlb = hisxrspjlbService.getById(hisxrspjlb.getId());

		return VIEW;
	}

	/**
	 * 初始化修改信息
	 */
	public String initEdit() throws Exception
	{
		view();
		return EDIT;
	}

	/**
	 * 保存信息（包括新增和修改）
	 */
	public String save() throws Exception
	{
		FileInputStream in = null;
		try
		{
			// 设置Blob字段
			setBlobField(in);
		} finally
		{
			if (null != in)
			{
				try
				{
					in.close();
				} catch (Exception ex)
				{
				}
			}
		}

		if ("add".equalsIgnoreCase(this.flag))
		{
			hisxrspjlb.setDeptId(this.getLoginUserDepartmentId());
			hisxrspjlb.setDelFlag(0);
			hisxrspjlbService.save(hisxrspjlb);
		}
		else
		{
			hisxrspjlbService.update(hisxrspjlb);
		}

		return RELOAD;
	}

	/**
	 * 将File对象转换为Blob对象，并设置到实体类中
	 * 如果没有File对象，可删除此方法，并一并删除save方法中调用此方法的代码
	 */
	private void setBlobField(FileInputStream in)
	{
		if (null != hisxrspjlb)
		{
			try
			{
				// 此处将File对象转换成blob对象，并设置到hisxrspjlb中去

			} catch (Exception ex)
			{
				ex.printStackTrace();
			}
		}
	}

	/**
	 * 删除信息
	 */
	public String delete() throws Exception
	{
		try
		{
			hisxrspjlbService.deleteWithFlag(ids);
			this.getResponse().getWriter().println("{\"result\":true}");
		} catch (Exception e)
		{
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}

	public String getIds()
	{
		return ids;
	}

	public void setIds(String ids)
	{
		this.ids = ids;
	}

	public Pagination getPagination()
	{
		return pagination;
	}

	public void setPagination(Pagination pagination)
	{
		this.pagination = pagination;
	}

	public Hisxrspjlb getHisxrspjlb()
	{
		return this.hisxrspjlb;
	}

	public void setHisxrspjlb(Hisxrspjlb hisxrspjlb)
	{
		this.hisxrspjlb = hisxrspjlb;
	}

	public String getFlag()
	{
		return flag;
	}

	public void setFlag(String flag)
	{
		this.flag = flag;
	}

	public Date getQueryCheckTimeStart()
	{
		return this.queryCheckTimeStart;
	}

	public void setQueryCheckTimeStart(Date queryCheckTimeStart)
	{
		this.queryCheckTimeStart = queryCheckTimeStart;
	}

	public Date getQueryCheckTimeEnd()
	{
		return this.queryCheckTimeEnd;
	}

	public void setQueryCheckTimeEnd(Date queryCheckTimeEnd)
	{
		this.queryCheckTimeEnd = queryCheckTimeEnd;
	}

	public Date getQueryCheckTime2Start()
	{
		return this.queryCheckTime2Start;
	}

	public void setQueryCheckTime2Start(Date queryCheckTime2Start)
	{
		this.queryCheckTime2Start = queryCheckTime2Start;
	}

	public Date getQueryCheckTime2End()
	{
		return this.queryCheckTime2End;
	}

	public void setQueryCheckTime2End(Date queryCheckTime2End)
	{
		this.queryCheckTime2End = queryCheckTime2End;
	}

}
