package com.jshx.hisxrspjlb.service.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.hisxrspjlb.dao.HisxrspjlbDao;
import com.jshx.hisxrspjlb.entity.Hisxrspjlb;
import com.jshx.hisxrspjlb.service.HisxrspjlbService;

@Service("hisxrspjlbService")
public class HisxrspjlbServiceImpl extends BaseServiceImpl implements HisxrspjlbService
{
	/**
	 * Dao类
	 */
	@Autowired() 
	@Qualifier("hisxrspjlbDao")
	private HisxrspjlbDao hisxrspjlbDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return hisxrspjlbDao.findByPage(page, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Hisxrspjlb getById(String id)
	{
		return hisxrspjlbDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	@Transactional
	public void save(Hisxrspjlb hisxrspjlb)
	{
		hisxrspjlbDao.save(hisxrspjlb);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	@Transactional
	public void update(Hisxrspjlb hisxrspjlb)
	{
		hisxrspjlbDao.update(hisxrspjlb);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects=hisxrspjlbDao.findHisxrspjlb(paraMap);
		
		hisxrspjlbDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
				    hisxrspjlbDao.deleteWithFlag(id);
			}
		}
	}
}
