package com.jshx.hisxlspjlb.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.hisxlspjlb.entity.Hisxlspjlb;
import com.jshx.hisxlspjlb.dao.HisxlspjlbDao;

@Component("hisxlspjlbDao")
public class HisxlspjlbDaoImpl extends BaseDaoImpl implements HisxlspjlbDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findHisxlspjlbByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findHisxlspjlb(Map<String, Object> paraMap){
		return this.findListByHqlId("findHisxlspjlbByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Hisxlspjlb getById(String id)
	{
		return (Hisxlspjlb)this.getObjectById(Hisxlspjlb.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Hisxlspjlb hisxlspjlb)
	{
		hisxlspjlb.setId(null);
		this.saveOrUpdateObject(hisxlspjlb);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Hisxlspjlb hisxlspjlb)
	{
		this.saveOrUpdateObject(hisxlspjlb);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Hisxlspjlb.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Hisxlspjlb hisxlspjlb = (Hisxlspjlb)this.getObjectById(Hisxlspjlb.class, id);
		hisxlspjlb.setDelFlag(1);
		this.saveObject(hisxlspjlb);
	}
}
