package com.jshx.guidang.web;

import java.awt.print.Printable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.servlet.http.HttpServletResponse;

import com.jshx.zzhxm.entity.YzsMaterialCol;
import com.jshx.zzhxm.entity.Zzhxm;
import com.jshx.zzhxm.entity.ZzhxmJktzs;
import com.jshx.zzhxm.util.FTPUtils;
import com.jshx.zzhxm.util.JDBCUtils;
import org.activiti.engine.HistoryService;
import org.activiti.engine.IdentityService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.hibernate.LobHelper;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;

import com.jcraft.jsch.ChannelSftp;
import com.jshx.activiti.service.ActivitiService;
import com.jshx.common.utils.FileUtils;
import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.exception.BasalException;
import com.jshx.core.utils.BaseExcel;
import com.jshx.core.utils.DateUtil;
import com.jshx.core.utils.SFTPChannel;
import com.jshx.core.utils.StringUtil;
import com.jshx.core.utils.Struts2Util;
import com.jshx.core.utils.SysPropertiesUtil;
import com.jshx.fawen.entity.FawenAttach;
import com.jshx.fawen.service.FawenAttachService;
import com.jshx.module.admin.entity.Department;
import com.jshx.module.admin.entity.User;
import com.jshx.module.form.service.AttachfileService;
import com.jshx.printhis.entity.PrintHis;
import com.jshx.printhis.service.PrintHisService;
import com.jshx.spjlb.entity.Spjlb;
import com.jshx.spjlb.service.SpjlbService;
import com.jshx.xmxxb.entity.Xmxxb;
import com.jshx.xmxxb.service.XmxxbService;
import com.jshx.zsdw.entity.Zsdw;
import com.jshx.zsdw.service.ZsdwService;
import com.opensymphony.xwork2.ActionContext;
import com.jshx.core.json.CodeJsonValueProcessor;
import com.jshx.core.json.DateJsonValueProcessor;
import com.jshx.guidang.entity.Guidang;
import com.jshx.guidang.service.GuidangService;

public class GuidangAction extends BaseAction
{

	/**
	 * 主键ID列表，用于接收页面提交的多条主键ID信息
	 */
	private String ids;
	private String type;
	private String gdType;
	/**
	 * 实体类
	 */
	private Guidang guidang = new Guidang();
	private String allFileName;
	private String originFileName;
	private String dwdm;
	 private List<File> file1 ;  
	 private List<String> file1FileName ;
	public List<File> getFile1() {
		return file1;
	}

	public void setFile1(List<File> file1) {
		this.file1 = file1;
	}

	public List<String> getFile1FileName() {
		return file1FileName;
	}

	public void setFile1FileName(List<String> file1FileName) {
		this.file1FileName = file1FileName;
	}

	/**
	 * 业务类
	 */
	@Autowired
	private GuidangService guidangService;
	@Autowired
	private PrintHisService printHisService;
	@Autowired
	private XmxxbService xmxxbService;
    @Autowired
    private FawenAttachService fawenAttachService;
    @Autowired
    protected RuntimeService runtimeService;
    @Autowired
    protected TaskService taskService;
    @Autowired
    private IdentityService identityService;
    @Autowired
    private ActivitiService activitiService;
	@Autowired
	private ZsdwService zsdwService;
    @Autowired
    private HistoryService historyService;
	@Autowired
	private SpjlbService spjlbService;
	/**
	 * 修改新增标记，add为新增、mod为修改
	 */
	private String flag;
	private String taskId;
    private String outcome;
    private String comment;
	private Date queryLcjssjStart;

	private Date queryLcjssjEnd;
	private Date querySlsjStart;

	private Date querySlsjEnd;
	/**
	 * 分页信息
	 */
	private Pagination pagination;
	
	private List<FawenAttach> attach;
	
	@Autowired()
	@Qualifier("sessionFactory")
	private SessionFactory sessionFactory;
	
	
	public void list1() throws Exception{
		Map<String, Object> paraMap = new HashMap<String, Object>();
		List<Guidang> gdList = new ArrayList<Guidang>();
		if(pagination==null)
		    pagination = new Pagination(this.getRequest());
		if(!this.getLoginUser().getIsSuperAdmin()){
			Zsdw zsdw=zsdwService.getzsdw(this.getLoginUserDepartmentId());
			   paraMap.put("zsdw", zsdw.getZsdm());
	        }
	
		if (null != guidang)
		{
			// 设置查询条件，开发人员可以在此增加过滤条件
			if (StringUtils.isNotEmpty(guidang.getSlbh()))
			{
				paraMap.put("slbh", "%" + guidang.getSlbh() + "%");
			}
			//
			if (StringUtils.isNotEmpty(guidang.getJsdw()))
			{
				paraMap.put("jsdw", "%" + guidang.getJsdw() + "%");
			}
			if (StringUtils.isNotEmpty(guidang.getXmmc()))
			{
				paraMap.put("xmmc", "%" + guidang.getXmmc() + "%");
			}
//			if (StringUtils.isNotEmpty(guidang.getKzzd1()))
//			{
//				Xmxxb x=xmxxbService.getByXxylb(guidang.getKzzd1());
//				paraMap.put("kzzd1", "%" + x.getId() + "%");
//			}
			if (StringUtils.isNotEmpty(guidang.getDano()))
			{
				paraMap.put("dano", guidang.getDano());
			}
			if (StringUtils.isNotEmpty(guidang.getBllb()))
			{
				paraMap.put("bllb", guidang.getBllb());
			}
			
		}
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(java.util.Date.class,new DateJsonValueProcessor());  
		Map<String, String> codeMap = new HashMap<String, String>();
		//此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId
		
		config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap)); 
		final String filter = "id|slbh|xmdz|jsdw|bllb|dano|xmmc|isPrint|gdType|fmPrint|listPrint|kzzd1|xxylb|";
		if (filter != null && filter.length() > 1) {
			config.setJsonPropertyFilter(new PropertyFilter() {
				public boolean apply(Object source, String name, Object value) {
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		
		pagination = guidangService.findByPage(pagination, paraMap);
		List<Guidang> lgs=pagination.list;
		if(lgs.size()>0){
			List<Guidang> lvs=new ArrayList<>();
			for (int i = 0; i < lgs.size(); i++) {
				Xmxxb beanx=new Xmxxb();
				Guidang gu=new Guidang();
				beanx=xmxxbService.getById(lgs.get(i).getKzzd1());
				if(null!=beanx){
					gu=lgs.get(i);
					gu.setXxylb(beanx.getXxylb());
				}
				lvs.add(gu);
			}
			pagination.setList(lvs);
		}
		convObjectToJson(pagination, config);
	}
	/**
	 * 执行查询的方法，返回json数据
	 */
	public void list() throws Exception{
		Map<String, Object> paraMap = new HashMap<String, Object>();
		List<Guidang> gdList = new ArrayList<Guidang>();
		if(pagination==null)
		    pagination = new Pagination(this.getRequest());
		
		if(!this.getLoginUser().getIsSuperAdmin()){
			Zsdw zsdw=zsdwService.getzsdw(this.getLoginUserDepartmentId());
			   paraMap.put("zsdw", zsdw.getZsdm());
	        }
		
		Map<String, Object> spmap = new HashMap<String, Object>();
		boolean isspcx=false;
		if (null != querySlsjStart)
		{
			spmap.put("startSlsj", querySlsjStart);
			isspcx=true;
		}
		
		if (null != querySlsjEnd)
		{
			spmap.put("endSlsj", querySlsjEnd);
			isspcx=true;
		}
		if (null != queryLcjssjStart)
		{
			spmap.put("startlcjssj", queryLcjssjStart);
			isspcx=true;
		}
		
		if (null != queryLcjssjEnd)
		{
			spmap.put("endlcjssj", queryLcjssjEnd);
			isspcx=true;
		}
		   List sps=new ArrayList<>();
		if(isspcx){
			List<Spjlb> lssp=spjlbService.findSpjlball(spmap);
			if(null!=lssp&&lssp.size()>0){
				for (Spjlb spjlbean : lssp) {
					sps.add(spjlbean.getSlbh());
				}
			}else{
				sps.add("aaaa");
			}
			paraMap.put("slbhgd", sps);
		}
		
		if (null != guidang)
		{
			// 设置查询条件，开发人员可以在此增加过滤条件
			if (StringUtils.isNotEmpty(guidang.getSlbh()))
			{
				paraMap.put("slbh", "%" + guidang.getSlbh() + "%");
			}
			//
			if (StringUtils.isNotEmpty(guidang.getJsdw()))
			{
				paraMap.put("jsdw", "%" + guidang.getJsdw() + "%");
			}
			if (StringUtils.isNotEmpty(guidang.getXxylb()))
			{
				paraMap.put("xxylb", "%" + guidang.getXxylb() + "%");
			}
			if (StringUtils.isNotEmpty(guidang.getBllb()))
			{
				paraMap.put("bllb", guidang.getBllb());
			}
		}
		
		
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(java.util.Date.class,new DateJsonValueProcessor());  
		Map<String, String> codeMap = new HashMap<String, String>();
		//此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId
		
		config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap)); 
		final String filter = "id|slbh|xmdz|jsdw|bllb|dano|xmmc|gdType|kzzd1|zjsmj|createTime|gdjbr|";
		if (filter != null && filter.length() > 1) {
			config.setJsonPropertyFilter(new PropertyFilter() {
				public boolean apply(Object source, String name, Object value) {
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		//未归档查询
		if (StringUtils.isNotEmpty(guidang.getGdType())&&"0".equals(guidang.getGdType()))
		{
			pagination = xmxxbService.findgdXmxxb(pagination, paraMap);
			int totalcount = pagination.getTotalCount();
			List<Xmxxb> list = pagination.list;
			for(int i=0;i<list.size();i++)
			{
				Guidang gd = new Guidang();
				Xmxxb xmxxb = (Xmxxb) list.get(i);
				//Map<String, String> paramMap1 = new HashMap<String, String>();
				//paramMap1.put("bizrowid", guidang.getKzzd1());
				//paramMap1.put("xmType", "项目归档,项目撤销,信息修改,缴费受理");
			  // attach = fawenAttachService.queryAttachListByTempleId(paramMap1);
				gd.setSlbh(xmxxb.getSlbh());
				gd.setJsdw(xmxxb.getJsdw());
				gd.setXmmc(xmxxb.getXmmc());
				gd.setXmdz(xmxxb.getJsdd());
				gd.setBllb(xmxxb.getBllb());
				gd.setId(xmxxb.getId());
				gd.setKzzd2(xmxxb.getDwdm());
				gd.setKzzd1(xmxxb.getId());
				Map<String, Object> paraMap22 = new HashMap<String, Object>();
				paraMap22.put("slbh", xmxxb.getSlbh());
				List<Spjlb> lsp=spjlbService.findSpjlball(paraMap22);
				if(null!=lsp&&lsp.size()>0){
					if(null!=lsp.get(0).getLcjssj()){
						gd.setLcjssj(lsp.get(0).getLcjssj());
					}
					gd.setSlsj(lsp.get(0).getSlsj());
				}
				
				if(StringUtils.isEmpty(xmxxb.getIsgd()))
				{
					gd.setGdType("0");
				}else
				{
					gd.setGdType(xmxxb.getIsgd());
				}
				gdList.add(gd);
			}
			pagination = guidangService.findByPage(pagination, paraMap);
			pagination.list=gdList;
			pagination.setTotalCount(totalcount);
		}
		else if(StringUtils.isNotEmpty(guidang.getGdType())&&"1".equals(guidang.getGdType()))
		{
			//已归档查询
			if("sf".equals(paraMap.get("zsdm"))){
			pagination = guidangService.findByPage(pagination, paraMap);
			}else{
				paraMap.put("ygd", "1");
				pagination = xmxxbService.findByPage(pagination, paraMap);
				int totalcount = pagination.getTotalCount();
				List<Xmxxb> list = pagination.list;
				for(int i=0;i<list.size();i++)
				{
					Guidang gd = new Guidang();
					Xmxxb xmxxb = (Xmxxb) list.get(i);
					gd.setSlbh(xmxxb.getSlbh());
					gd.setJsdw(xmxxb.getJsdw());
					gd.setXmmc(xmxxb.getXmmc());
					gd.setXmdz(xmxxb.getJsdd());
					gd.setBllb(xmxxb.getBllb());
					gd.setId(xmxxb.getId());
					gd.setKzzd2(xmxxb.getDwdm());
					gd.setKzzd1(xmxxb.getId());
					gd.setDano(StringUtil.getDANO(xmxxb.getSlbh(), xmxxb.getDwdm()));
					gd.setZjsmj(xmxxb.getZjsmj());
					Map<String, Object> paraMap22 = new HashMap<String, Object>();
					paraMap22.put("slbh", xmxxb.getSlbh());
					List<Spjlb> lsp=spjlbService.findSpjlball(paraMap22);
					if(null!=lsp&&lsp.size()>0){
						if(null!=lsp.get(0).getLcjssj()){
							gd.setLcjssj(lsp.get(0).getLcjssj());
						}
						gd.setSlsj(lsp.get(0).getSlsj());
					}
					
					gd.setGdType("1");
					gdList.add(gd);
				}
				pagination = guidangService.findByPage(pagination, paraMap);
				pagination.list=gdList;
				pagination.setTotalCount(totalcount);
				
			}
			
		}
		
		convObjectToJson(pagination, config);
	}

	/**
	 * 查看详细信息
	 */
	public String view() throws Exception{
		Map<String, String> paramMap = new HashMap<String, String>();
		Xmxxb xmxxb =xmxxbService.getBySlbh(ids);
		
		if(xmxxb!=null)
		{
			Guidang gd = guidangService.getByxmbzj(xmxxb.getId());
			if(gd!=null)
			{
				guidang.setDano(gd.getDano());
			}
			guidang.setSlbh(xmxxb.getSlbh());
			guidang.setJsdw(xmxxb.getJsdw());
			guidang.setXmmc(xmxxb.getXmmc());
			guidang.setXmdz(xmxxb.getJsdd());
			if("0".equals(xmxxb.getBllb()))
			{
				guidang.setBllb("直接缴费");
			}
			if("1".equals(xmxxb.getBllb()))
			{
				guidang.setBllb("减免");
			}
			guidang.setKzzd2(xmxxb.getDwdm());
			guidang.setKzzd1(xmxxb.getId());
			paramMap.put("bizrowid", xmxxb.getId());
			if("2".equals(xmxxb.getIsgd())&&(!"ygd".equals(flag)))
			{
				paramMap.put("xmType","资料增补");
			}else
			{
				paramMap.put("xmType1","1");
			}
			attach= fawenAttachService.queryAttachListByTempleId(paramMap);
		}
		
		
		
		
		return VIEW;
	}
	

	public void update()
	{
		try
		{
			PrintHis printHis = printHisService.getPrintHisByxmbzj(ids);
		if(printHis==null)
		{
			printHis = new PrintHis();
			Xmxxb xmxxb =xmxxbService.getById(ids);
			printHis.setXmbzj(xmxxb.getId());
			printHis.setDelFlag(0);
			if("1".endsWith(type))
			{
			printHis.setFmPrint(type);
			}else
			{
				printHis.setListPrint(type);
			}
			printHis.setSlbh(xmxxb.getSlbh());
			printHisService.save(printHis);
		}else
		{
			if("1".endsWith(type))
			{
			printHis.setFmPrint(type);
			}else
			{
				printHis.setListPrint(type);
			}
			printHisService.update(printHis);
		}

		}catch(Exception e)
		{
			e.printStackTrace();
		}
	}

	/**
	 * 初始化修改信息
	 */
	public String initEdit() throws Exception{
		Xmxxb xmxxb = xmxxbService.getById(ids);
		if(xmxxb!=null)
		{
			guidang.setSlbh(xmxxb.getSlbh());
			guidang.setJsdw(xmxxb.getJsdw());
			guidang.setXmmc(xmxxb.getXmmc());
			guidang.setXmdz(xmxxb.getJsdd());
			if("0".equals(xmxxb.getBllb()))
			{
				guidang.setBllb("直接缴费");
			}
			if("1".equals(xmxxb.getBllb()))
			{
				guidang.setBllb("减免");
			}
			guidang.setKzzd2(xmxxb.getDwdm());
			guidang.setKzzd1(xmxxb.getId());
		}
		Map<String, String> paramMap = new HashMap<String, String>();
		paramMap.put("bizrowid", ids);
		paramMap.put("xmType1", "项目归档");
		attach= fawenAttachService.queryAttachListByTempleId(paramMap);
		for(int i=0;i<attach.size();i++)
		{
			FawenAttach fawenAttach =attach.get(i);
			String clno = fawenAttachService.getByFscl(fawenAttach.getAttachType());
			if(StringUtils.isEmpty(clno)&&!"信息修改".equals(fawenAttach.getXmType()))
			{
				attach.remove(i);
				i--;
			}
		}
	    return EDIT;
	}
	
	public String initEdit1() throws Exception{
		guidang = guidangService.getById(ids);
		if("0".equals(guidang.getBllb()))
		{
			guidang.setBllb("直接缴费");
		}
		if("1".equals(guidang.getBllb()))
		{
			guidang.setBllb("减免");
		}
		Map<String, String> paramMap = new HashMap<String, String>();
		paramMap.put("bizrowid", guidang.getKzzd1());
		paramMap.put("xmType1", "资料增补");
		attach= fawenAttachService.queryAttachListByTempleId(paramMap);
	    return EDIT;
	}

	/**
	 * 保存信息（包括新增和修改）
	 */
	public String save() throws Exception{

		try
		{
			Xmxxb xmxxb = xmxxbService.getById(guidang.getKzzd1());
			Map<String, String> paramMap = new HashMap<String, String>();
			paramMap.put("bizrowid", guidang.getKzzd1());
			paramMap.put("xmType", "资料增补");
		attach = fawenAttachService.queryAttachListByTempleId(paramMap);
		FawenAttach fawenAttach=null;
			if(attach.size()>0)
			{
				fawenAttach=attach.get(0);
			}
			String uuid = UUID.randomUUID().toString().replaceAll("-", "");
			Guidang gd = guidangService.getById(guidang.getId());
			gd.setSequencId(uuid);
			gd.setZbgdbz(guidang.getZbgdbz());
			gd.setZbgdsj(new Date());
			gd.setZbgdsqr(this.getLoginUser().getDisplayName());
			guidangService.update(gd);
			 String path = SysPropertiesUtil.jdlj(this.getRequest())
						+ File.separator+ "uploads"+ File.separator+"zlzb" +File.separator+xmxxb.getSlbh()+File.separator;
		     // 写到指定的路径中  
		        JSONObject jsonObject = JSONObject.fromObject(allFileName); 
		        JSONObject jsonObject1= JSONObject.fromObject(originFileName);
		    	String fileName = "";
						if(file1!=null)
						{
						  for(int i = 0 ; i < file1.size() ; i++ )  
					        {  
							  String attachType = jsonObject.getString(file1FileName.get(i));
							  //String clno = fawenAttachService.getByFscl(attachType,"资料增补");
							  fileName = FileUtils.uploadFile(file1.get(i),file1FileName.get(i), path);
							  paramMap.put("attachType", attachType);
							 List list = fawenAttachService.queryAttachListByTempleId(paramMap);
							 if(list.size()>0)
							 {
								 FawenAttach ft = (FawenAttach) list.get(0);
								 ft.setAttachname(file1FileName.get(i));
								 ft.setAttachpath("zlzb" +File.separator+xmxxb.getSlbh()+File.separator+fileName);
								 ft.setBizrowid(guidang.getKzzd1());
								 ft.setCreateTime(new Date());
								 ft.setWdno(jsonObject1.getString(file1FileName.get(i)));
								 fawenAttachService.update(ft);
							 }
							 else
							 {
							   FawenAttach att = new FawenAttach();
								att.setDelFlag(0);
								att.setAttachname(file1FileName.get(i));
								att.setAttachpath("zlzb" +File.separator+xmxxb.getSlbh()+File.separator+fileName);
								att.setBizrowid(guidang.getKzzd1());
								att.setCreateTime(new Date());
								att.setAttachType(attachType);
								att.setSequencId(uuid);
								if(fawenAttach!=null)
								{
									att.setXmType(fawenAttach.getXmType());
								}else
								{
									att.setXmType("资料增补");
								}
								att.setWdno(jsonObject1.getString(file1FileName.get(i)));
								fawenAttachService.save(att);
								}
					             
					              
					        } 	
						}
						 Map<String, Object> variables = new HashMap<String, Object>();
						 try {
					            identityService.setAuthenticatedUserId(this.getLoginUser().getLoginId());
					           runtimeService.startProcessInstanceByKey("zlzb", guidang.getKzzd1(), variables);
					           List<ProcessInstance> pi=  runtimeService.createProcessInstanceQuery().processInstanceBusinessKey(guidang.getKzzd1()).list();

					        } finally {
					            identityService.setAuthenticatedUserId(null);
					        }
				
		}catch(Exception e)
		{
			throw new BasalException(BasalException.ERROR,"系统异常,请联系管理员!");
			
		}
		return RELOAD;
	}
	
	public String handleTask() {
	       Task task  = taskService.createTaskQuery().taskId(taskId).singleResult();
	        ProcessInstance processInstance = runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
	        String businessKey =  processInstance.getBusinessKey();
	        guidang= guidangService.getByxmbzj(businessKey);
	       
	        List<String> outcomeList = activitiService.findOutComeListByTaskId(taskId);
	        Map<String, String> paramMap = new HashMap<String, String>();
			paramMap.put("sequencId", guidang.getSequencId());
			paramMap.put("xmType", "资料增补");
			attach= fawenAttachService.queryAttachListByTempleId(paramMap);
	        ActionContext.getContext().put("outcomeList", outcomeList);
	        return SUCCESS;
	    }
	
    public void submitTask() throws Exception{
        try {
            Task task = taskService.createTaskQuery().taskId(taskId).singleResult();
            activitiService.addComment(task, this.getLoginUser().getLoginId(), comment);
            Map<String, Object> variables = new HashMap<String, Object>();
            variables.put("outcome", outcome);
//            if("驳回".equals(outcome))
//            {
//            	Map<String, String> paramMap = new HashMap<String, String>();
//            	paramMap.put("sequencId", guidang.getSequencId());
//            	paramMap.put("xmType", "资料增补");
//     			attach= fawenAttachService.queryAttachListByTempleId(paramMap);
//     			for(FawenAttach fa:attach)
//     			{
//     				fa.setDelFlag(1);
//     				fawenAttachService.update(fa);
//     			}
//            }
            taskService.complete(taskId, variables);
            this.getResponse().getWriter().println("{\"result\":true}");
        }catch (Exception e) {
            this.getResponse().getWriter().println("{\"result\":false}");
        }
    }
    
	public String tohandleTask() {
	       Task task  = taskService.createTaskQuery().taskId(taskId).singleResult();
	        ProcessInstance processInstance = runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
	        String businessKey =  processInstance.getBusinessKey();
	        guidang= guidangService.getByxmbzj(businessKey);
	       
	        List<String> outcomeList = activitiService.findOutComeListByTaskId(taskId);
	        Map<String, String> paramMap = new HashMap<String, String>();
			paramMap.put("bizrowid", guidang.getKzzd1());
			paramMap.put("xmType", "资料增补");
			attach= fawenAttachService.queryAttachListByTempleId(paramMap);
	        ActionContext.getContext().put("outcomeList", outcomeList);
	        return SUCCESS;
	    }
	
 public void tosubmitTask() throws Exception{
     try {
    	 SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
         Task task = taskService.createTaskQuery().taskId(taskId).singleResult();
         ProcessInstance processInstance = runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
	      String businessKey =  processInstance.getBusinessKey();
	       guidang= guidangService.getByxmbzj(businessKey);
         activitiService.addComment(task, this.getLoginUser().getLoginId(), comment);
       
         Map<String, Object> variables = new HashMap<String, Object>();
         variables.put("outcome", outcome);
         taskService.complete(taskId, variables);
         if("通过".equals(outcome))
         {
	         Xmxxb xmxxb = xmxxbService.getById(businessKey);
	         xmxxb.setIsgd("2");
	         xmxxbService.update(xmxxb);
	         guidang.setGdType("2");
	         guidangService.update(guidang);
         }
//         if("通过".equals(outcome))
//         {
//	         Map<String, String> paramMap = new HashMap<String, String>();
//			paramMap.put("bizrowid", businessKey);
//			attach = fawenAttachService.queryAttachListByTempleId(paramMap); 
//			String ftpPath = SysPropertiesUtil.getProperty("ftppath")+"/"+sdf.format(new Date())+"/资料增补"+"/"+guidang.getSlbh();
//	
//			for(FawenAttach fawenAttach:attach)
//			{
//				String srcPath =ServletActionContext.getServletContext().getRealPath("/" + SysPropertiesUtil.getProperty("filePath"))+"\\"+fawenAttach.getAttachpath();
//				try
//				{
//				SFTPChannel.uploadFile(srcPath, ftpPath,ChannelSftp.OVERWRITE);
//				}catch(Exception e)
//				{
//					e.printStackTrace();
//				}
//			}
//         }
         this.getResponse().getWriter().println("{\"result\":true}");
     }catch (Exception e) {
         this.getResponse().getWriter().println("{\"result\":false}");
     }
 }
	
	public String uploadFile()
	{
		try
		{
			Xmxxb xmxxb =xmxxbService.getById(guidang.getKzzd1());
			Map<String, String> paramMap = new HashMap<String, String>();
			paramMap.put("bizrowid", xmxxb.getId());
			paramMap.put("xmType1", "项目归档");
		attach = fawenAttachService.queryAttachListByTempleId(paramMap);
		FawenAttach fawenAttach=null;
			if(attach.size()>0)
			{
				fawenAttach=attach.get(0);
			}
			 String path = SysPropertiesUtil.jdlj(this.getRequest())
						+ File.separator+ "uploads" +File.separator+xmxxb.getSlbh()+File.separator;
		     // 写到指定的路径中  
		        JSONObject jsonObject = JSONObject.fromObject(allFileName); 
		        JSONObject jsonObject1= JSONObject.fromObject(originFileName);
		    	String fileName = "";
						if(file1!=null)
						{
						  for(int i = 0 ; i < file1.size() ; i++ )  
					        {  
							  String attachType = jsonObject.getString(file1FileName.get(i));
							  String clno = fawenAttachService.getByFscl(attachType,"项目归档");
							  fileName = FileUtils.uploadFile(file1.get(i),file1FileName.get(i), path);
							  paramMap.put("attachType", attachType);
							 List list = fawenAttachService.queryAttachListByTempleId(paramMap);
							 if(list.size()>0)
							 {
								 FawenAttach ft = (FawenAttach) list.get(0);
								 ft.setAttachname(file1FileName.get(i));
								 ft.setAttachpath(xmxxb.getSlbh()+File.separator+fileName);
								 ft.setBizrowid(guidang.getKzzd1());
								 ft.setCreateTime(new Date());
								 ft.setWdno(jsonObject1.getString(file1FileName.get(i)));
								 fawenAttachService.update(ft);
							 }
							 else
							 {
							   FawenAttach att = new FawenAttach();
								att.setDelFlag(0);
								att.setAttachname(file1FileName.get(i));
								att.setAttachpath(xmxxb.getSlbh()+File.separator+fileName);
								att.setBizrowid(guidang.getKzzd1());
								att.setCreateTime(new Date());
								att.setAttachType(attachType);
								if(fawenAttach!=null)
								{
									att.setXmType(fawenAttach.getXmType());
								}else
								{
									att.setXmType("项目归档");
								}
								att.setWdno(jsonObject1.getString(file1FileName.get(i)));
								fawenAttachService.save(att);
								}
					             
					              
					        } 	
						}
		}catch(Exception e)
		{
			logger.error(e.toString());
			throw new BasalException(BasalException.ERROR,e.toString());
		}
		return RELOAD;
	}

	/**
	 * 将File对象转换为Blob对象，并设置到实体类中
	 * 如果没有File对象，可删除此方法，并一并删除save方法中调用此方法的代码
	 */
	private void setBlobField(FileInputStream in)
	{
		if (null != guidang)
		{
			try
			{
				//此处将File对象转换成blob对象，并设置到guidang中去
				
            }
            catch (Exception ex)
            {
                ex.printStackTrace();
            }
        }
    }
	public void isPrint() throws IOException
	{
		try
		{
		boolean result = false;
		PrintHis printHis = printHisService.getPrintHisByxmbzj(ids);
		if(printHis==null)
		{
			result=true;
		}else
		{
			if(StringUtils.isEmpty(printHis.getFmPrint())||StringUtils.isEmpty(printHis.getListPrint()))
			{
				result=true;
			}
		}
		this.getResponse().getWriter().println("{\"result\":" + result + "}");
		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":false}");
		}
	}


	private static final String host = SysPropertiesUtil.getProperty("gd.host");
	private static final String port = SysPropertiesUtil.getProperty("gd.port");
	private static final String username = SysPropertiesUtil.getProperty("gd.username");
	private static final String password = SysPropertiesUtil.getProperty("gd.password");
	private static final String dirPath = SysPropertiesUtil.getProperty("gd.ftpPath");
	/**
	 * 删除信息
	 */
	public String delete() throws Exception{
	    try{
			//guidangService.deleteWithFlag(ids);
	    	SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
	    	boolean result = true;
			String message = "成功！";
			String depeName= this.getLoginUserDepartment().getDeptName();
			Xmxxb xmxxb =xmxxbService.getBySlbh(ids);
			if(!"收费处".equals(depeName))
			{
				xmxxb.setIsgd("1");
				xmxxbService.update(xmxxb);
				this.getResponse().getWriter().println("{\"result\":" + result + ",\"message\":\"" + message + "\"}");
				return null;
			}
			String ftpPath = SysPropertiesUtil.getProperty("ftppath")+"/"+sdf.format(new Date())+"/"+xmxxb.getDwdm()+"/"+xmxxb.getSlbh()+"/";
	    	Map<String, String> paramMap = new HashMap<String, String>();
			paramMap.put("bizrowid", xmxxb.getId());
			if("2".equals(type))
			{
				
				paramMap.put("xmType", "资料增补");
				ftpPath =SysPropertiesUtil.getProperty("ftppath")+"/"+sdf.format(new Date())+"/zlzb"+"/"+xmxxb.getSlbh()+"/";

			}else
			{
				paramMap.put("xmType1", "归档");
			}
	
		attach = fawenAttachService.queryAttachListByTempleId(paramMap);
		if(attach.size()<=0)
		{
			result=false;
			message="该项目没有附件可以归档！";
		}else
		{
			
			for(FawenAttach fawenAttach:attach)
			{
				String attachType = fawenAttach.getAttachType();
				  String clno = fawenAttachService.getByFscl(attachType);
				  String srcPath = SysPropertiesUtil.jdlj(this.getRequest())
					+ File.separator+ "uploads" +File.separator+fawenAttach.getAttachpath();
					System.out.println("src路径:"+srcPath);	
				  if(StringUtils.isNotEmpty(clno)&&(!"2".equals(type))||"信息修改".equals(fawenAttach.getXmType())&&(!"2".equals(type))||StringUtils.isEmpty(clno)&&"2".equals(type))
				  {
						try
						{
						SFTPChannel.uploadFile(srcPath, ftpPath,ChannelSftp.OVERWRITE);
						}catch(Exception e)
						{
							e.printStackTrace();
							result=false;
							message=e.toString();
							break;
						}
				  }
				
			}
		if(result)
		{
			
			xmxxb.setIsgd("1");
			xmxxbService.update(xmxxb);
			guidang.setBllb(xmxxb.getBllb());
			guidang.setDelFlag(0);
			guidang.setSlbh(xmxxb.getSlbh());
			guidang.setXmmc(xmxxb.getXmmc());
			guidang.setXmdz(xmxxb.getJsdd());
			guidang.setJsdw(xmxxb.getJsdw());
			guidang.setDano(StringUtil.getDANO(xmxxb.getSlbh(), xmxxb.getDwdm()));
			guidang.setKzzd1(xmxxb.getId());
			guidang.setKzzd2(xmxxb.getDwdm());
			guidang.setXxylb(xmxxb.getXxylb());
			guidang.setZjsmj(xmxxb.getZjsmj());
			guidang.setGdjbr(this.getLoginUser().getDisplayName());
			Map<String, Object> paraMap22 = new HashMap<String, Object>();
			paraMap22.put("slbh", xmxxb.getSlbh());
			List<Spjlb> lsp=spjlbService.findSpjlball(paraMap22);
			if(null!=lsp&&lsp.size()>0){
				if(null!=lsp.get(0).getLcjssj()){
					guidang.setLcjssj(lsp.get(0).getLcjssj());
				}
				guidang.setSlsj(lsp.get(0).getSlsj());
			}
			

			if("2".equals(type))
			{
				Guidang	gd = guidangService.getByxmbzj(xmxxb.getId());
				gd.setGdType("2");
				gd.setZbdate(DateUtil.getCurrTimeString(DateUtil.DATE_FORMAT_YYYYMMDD));
				guidangService.update(gd);
			}else
			{
				guidangService.save(guidang);
			}
		}
		}
//		2020-10-15 添加对接档案系统功能 start-------------------------------------------------

//			String dirPath = dirPath;
			Map<String, Object> paramMap1 =new HashMap<>();

			String s = JDBCUtils.buildArchiveSql(xmxxb, guidang, "3");
			List<String> add = new ArrayList<String>();
			add.add(s);
			int b = JDBCUtils.insertData(add);
			if (b==0) {
				return null;
			}
			for (FawenAttach fawenAttach : attach) {
				String attachPath = fawenAttach.getAttachpath();
//					attachpath.replaceAll("\\", "/");
				if (null != fawenAttach && StringUtils.isNotBlank(attachPath)) {
					String srcPath = SysPropertiesUtil.jdlj(this.getRequest())
							+ File.separator+ "uploads" +File.separator + File.separator + attachPath;
					try {
						FileInputStream in = new FileInputStream(new File(srcPath));
						File file = new File(srcPath);
						String fileName = attachPath.substring(attachPath.lastIndexOf(attachPath.contains("/")?"/":"\\") + 1);
						String filePath = attachPath.substring(0, attachPath.lastIndexOf(attachPath.contains("/")?"/":"\\") + 1);
						boolean success = FTPUtils.uploadFile(host, username, password, Integer.parseInt(port), "uploads" +File.separator+"PTF" +File.separator+filePath, fileName, in);
						System.out.println(success);
						if (success) {
							List<String> sql = JDBCUtils.buildInVolumeSql(xmxxb, guidang, fawenAttach, "4");
							int i = JDBCUtils.insertData(sql);
							if (i==1) {
								System.out.println("档案系统插入中间库成功!");
							}else {
								System.out.println("档案系统插入中间库失败!");
							}
						}
					}catch(Exception e) {
						e.printStackTrace();
						break;
					}
				}
			}
//		2020-10-15 添加对接档案系统功能 end---------------------------------------------------
			this.getResponse().getWriter().println("{\"result\":" + result + ",\"message\":\"" + message + "\"}");
		}catch(Exception e){
	    	e.printStackTrace();
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}
	
	
	public String guidangdy()
	{
		Xmxxb xmxxb =xmxxbService.getBySlbh(ids);
		guidang.setSlbh(xmxxb.getSlbh());
		if(xmxxb.getBllb().equals("0"))
		{
			guidang.setBllb("直接缴费");
		}else if(xmxxb.getBllb().equals("1"))
		{
			guidang.setBllb("减免");
		}else
		{
			guidang.setBllb("");
		}
		guidang.setJsdw(xmxxb.getJsdw());
		guidang.setXmmc(xmxxb.getXmmc());
		guidang.setKzzd2(xmxxb.getZjsmj());
		guidang.setKzzd1(xmxxb.getId());
		return SUCCESS;
	}
	
	public String guidangdyList()
	{
		Xmxxb xmxxb =xmxxbService.getBySlbh(ids);
		type = StringUtil.getDANO(xmxxb.getSlbh(), xmxxb.getDwdm());
//		type=type.substring(0, 7);
		Map<String, String> paramMap = new HashMap<String, String>();
		paramMap.put("bizrowid", xmxxb.getId());
		//paramMap.put("xmType1", "项目归档");
		//paramMap.put("xmType", "'项目归档','信息修改','缴费受理','项目撤销','项目建档'");
	    attach = fawenAttachService.queryAttachListByTempleId(paramMap);
	    for(int i=0;i<attach.size();i++)
	    {
	    	FawenAttach fawenAttach=attach.get(i);
	    	 String clno = fawenAttachService.getByFscl(fawenAttach.getAttachType());
	    	 if(StringUtils.isEmpty(clno)&&!"信息修改".equals(fawenAttach.getXmType()))
	    	 {
	    		 attach.remove(i);
	             i--;
	    	 }
	    	 
	    }
	     if(!"2".equals(gdType)){
	    	 
	    Map<String, Object> paramMap2 = new HashMap<String, Object>();
	    paramMap2.put("slbh", xmxxb.getSlbh());
	    List<Spjlb> lsp=spjlbService.findSpjlball(paramMap2);
	    String isdzt="0";
	    if(null!=lsp&&lsp.size()>0){
	    	if(null!=lsp.get(0).getIsdzt()&&!"".equals(lsp.get(0).getIsdzt())){
	    		isdzt=lsp.get(0).getIsdzt();
//	    		isdzt="1";
	    		this.setRequestAttribute("dzt", isdzt);
	    		this.setRequestAttribute("dztbh", attach.size()+1);
	    	}
	    }
	     }
	    
		guidang.setKzzd1(xmxxb.getId());
		return SUCCESS;
	}
	public String guidangdyListdc() throws IOException
	{
		Xmxxb xmxxb =xmxxbService.getBySlbh(ids);
		type = StringUtil.getDANO(xmxxb.getSlbh(), xmxxb.getDwdm());
//		type=type.substring(0, 7);
		Map<String, String> paramMap = new HashMap<String, String>();
		paramMap.put("bizrowid", xmxxb.getId());
		//paramMap.put("xmType1", "项目归档");
		//paramMap.put("xmType", "'项目归档','信息修改','缴费受理','项目撤销','项目建档'");
		attach = fawenAttachService.queryAttachListByTempleId(paramMap);
		for(int i=0;i<attach.size();i++)
		{
			FawenAttach fawenAttach=attach.get(i);
			String clno = fawenAttachService.getByFscl(fawenAttach.getAttachType());
			if(StringUtils.isEmpty(clno)&&!"信息修改".equals(fawenAttach.getXmType()))
			{
				attach.remove(i);
				i--;
			}
			
		}
		List<Map<String, String>> datas=new ArrayList<>();
		for(int i=0;i<attach.size();i++){
			Map<String, String> m=new HashMap<>();
			 DecimalFormat df=new DecimalFormat("00");
		     String str2=df.format(i+1);
			m.put("BIANHAO", str2);
			m.put("DAN", type);
			m.put("TIMING", attach.get(i).getAttachType());
			m.put("YEHAO"," ");
			m.put("YEMA"," ");
			m.put("NIANDU", type.substring(0, 4));
			m.put("BEIZHU", " ");
			datas.add(m);
		}
	    Map<String, Object> paramMap2 = new HashMap<String, Object>();
	    paramMap2.put("slbh", xmxxb.getSlbh());
	    List<Spjlb> lsp=spjlbService.findSpjlball(paramMap2);
	    String isdzt="0";
	    if(null!=lsp&&lsp.size()>0){
	    	if(null!=lsp.get(0).getIsdzt()&&!"".equals(lsp.get(0).getIsdzt())){
	    		Map<String, String> m=new HashMap<>();
	    		 DecimalFormat df=new DecimalFormat("00");
			     String str2=df.format(datas.size()+1);
			     m.put("BIANHAO", str2);
				 m.put("DAN", type);
				m.put("TIMING", "核准图");
					m.put("YEHAO"," ");
					m.put("YEMA"," ");
					m.put("NIANDU", type.substring(0, 4));
					m.put("BEIZHU", " ");
	    		datas.add(m);
	    	}
	    }
	    Map dataMap = new HashMap();
		dataMap.put("exportList", datas);
		BaseExcel baseExcel=new BaseExcel();
		return baseExcel.exportExcel("dananmb", dataMap, "dananmb.xls");
//		return SUCCESS;
	}
	public String guidangdyListdc1() throws IOException
	{
		  String [] sls=ids.split("\\|");
		  List<Map<String, String>> datas=new ArrayList<>();
		  for (String isslbh : sls) {
			  Xmxxb xmxxb =xmxxbService.getBySlbh(isslbh);
			  Map<String, String> m=new HashMap<>();
			  m.put("SLBH", xmxxb.getSlbh());
			  if("0".equals(xmxxb.getBllb())){
				  m.put("BLLB", "直接缴费");
			  }else{
				  m.put("BLLB", "减免");
			  }
			  m.put("JSDWMC", xmxxb.getJsdw());
			  m.put("XMMC", xmxxb.getXmmc());
			  m.put("DWDZ", xmxxb.getJzdwdz());
			  m.put("JSDD", xmxxb.getJsdd());
			  m.put("ZJSMJ", xmxxb.getZjsmj());
			  type = StringUtil.getDANO(xmxxb.getSlbh(), xmxxb.getDwdm());
//			  type=type.substring(0, 7);
			  m.put("DAN", type);
			  m.put("BAOGUAN", "");
			  m.put("NIANDU", type.substring(0,4));
			  m.put("CUNFANG", "");
			  m.put("HEHAO", "");
			  datas.add(m); 
		}
		  
		  
//		type = StringUtil.getDANO(xmxxb.getSlbh(), xmxxb.getDwdm());
//		type=type.substring(0, 7);
//		Map<String, String> paramMap = new HashMap<String, String>();
//		paramMap.put("bizrowid", xmxxb.getId());
//		//paramMap.put("xmType1", "项目归档");
//		//paramMap.put("xmType", "'项目归档','信息修改','缴费受理','项目撤销','项目建档'");
//		attach = fawenAttachService.queryAttachListByTempleId(paramMap);
//		for(int i=0;i<attach.size();i++)
//		{
//			FawenAttach fawenAttach=attach.get(i);
//			String clno = fawenAttachService.getByFscl(fawenAttach.getAttachType());
//			if(StringUtils.isEmpty(clno)&&!"信息修改".equals(fawenAttach.getXmType()))
//			{
//				attach.remove(i);
//				i--;
//			}
//			
//		}
//		List<Map<String, String>> datas=new ArrayList<>();
//		for(int i=0;i<attach.size();i++){
//			Map<String, String> m=new HashMap<>();
//			DecimalFormat df=new DecimalFormat("00");
//			String str2=df.format(i+1);
//			m.put("BIANHAO", str2);
//			m.put("DAN", type);
//			m.put("TIMING", attach.get(i).getAttachType());
//			m.put("YEHAO"," ");
//			m.put("YEMA"," ");
//			m.put("NIANDU", type.substring(0, 4));
//			m.put("BEIZHU", " ");
//			datas.add(m);
//		}
//		Map<String, Object> paramMap2 = new HashMap<String, Object>();
//		paramMap2.put("slbh", xmxxb.getSlbh());
//		List<Spjlb> lsp=spjlbService.findSpjlball(paramMap2);
//		String isdzt="0";
//		if(null!=lsp&&lsp.size()>0){
//			if(null!=lsp.get(0).getIsdzt()&&!"".equals(lsp.get(0).getIsdzt())){
//				Map<String, String> m=new HashMap<>();
//				DecimalFormat df=new DecimalFormat("00");
//				String str2=df.format(datas.size()+1);
//				m.put("BIANHAO", str2);
//				m.put("DAN", type);
//				m.put("TIMING", "核准图");
//				m.put("YEHAO"," ");
//				m.put("YEMA"," ");
//				m.put("NIANDU", type.substring(0, 4));
//				m.put("BEIZHU", " ");
//				datas.add(m);
//			}
//		}
		Map dataMap = new HashMap();
		dataMap.put("exportList", datas);
		BaseExcel baseExcel=new BaseExcel();
		return baseExcel.exportExcel("dananinfo", dataMap, "dananinfo.xls");
//		return SUCCESS;
	}
	
	public String getIds(){
		return ids;
	}

	public void setIds(String ids){
		this.ids = ids;
	}

	public Pagination getPagination(){
		return pagination;
	}

	public void setPagination(Pagination pagination){
		this.pagination = pagination;
	}

	public Guidang getGuidang(){
		return this.guidang;
	}

	public void setGuidang(Guidang guidang){
		this.guidang = guidang;
	}

	public String getFlag(){
		return flag;
	}

    public void setFlag(String flag){
        this.flag = flag;
    }

	public List<FawenAttach> getAttach() {
		return attach;
	}

	public void setAttach(List<FawenAttach> attach) {
		this.attach = attach;
	}

	public String getAllFileName() {
		return allFileName;
	}

	public void setAllFileName(String allFileName) {
		this.allFileName = allFileName;
	}

	public String getOriginFileName() {
		return originFileName;
	}

	public void setOriginFileName(String originFileName) {
		this.originFileName = originFileName;
	}

	public String getDwdm() {
		return dwdm;
	}

	public void setDwdm(String dwdm) {
		this.dwdm = dwdm;
	}

	public String getTaskId() {
		return taskId;
	}

	public void setTaskId(String taskId) {
		this.taskId = taskId;
	}

	public String getOutcome() {
		return outcome;
	}

	public void setOutcome(String outcome) {
		this.outcome = outcome;
	}

	public String getComment() {
		return comment;
	}

	public void setComment(String comment) {
		this.comment = comment;
	}
       
	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public Date getQueryLcjssjStart() {
		return queryLcjssjStart;
	}

	public void setQueryLcjssjStart(Date queryLcjssjStart) {
		this.queryLcjssjStart = queryLcjssjStart;
	}

	public Date getQueryLcjssjEnd() {
		return queryLcjssjEnd;
	}

	public void setQueryLcjssjEnd(Date queryLcjssjEnd) {
		this.queryLcjssjEnd = queryLcjssjEnd;
	}

	public Date getQuerySlsjStart() {
		return querySlsjStart;
	}

	public void setQuerySlsjStart(Date querySlsjStart) {
		this.querySlsjStart = querySlsjStart;
	}

	public Date getQuerySlsjEnd() {
		return querySlsjEnd;
	}

	public void setQuerySlsjEnd(Date querySlsjEnd) {
		this.querySlsjEnd = querySlsjEnd;
	}

	public String getGdType() {
		return gdType;
	}

	public void setGdType(String gdType) {
		this.gdType = gdType;
	}
	


}
