package com.jshx.guidang.service.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.guidang.dao.GuidangDao;
import com.jshx.guidang.entity.Guidang;
import com.jshx.guidang.service.GuidangService;

@Service("guidangService")
public class GuidangServiceImpl extends BaseServiceImpl implements GuidangService
{
	/**
	 * Dao类
	 */
	@Autowired() 
	@Qualifier("guidangDao")
	private GuidangDao guidangDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return guidangDao.findByPage(page, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Guidang getById(String id)
	{
		return guidangDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	@Transactional
	public void save(Guidang guidang)
	{
		guidangDao.save(guidang);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	@Transactional
	public void update(Guidang guidang)
	{
		guidangDao.update(guidang);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects=guidangDao.findGuidang(paraMap);
		
		guidangDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
				    guidangDao.deleteWithFlag(id);
			}
		}
	}

	@Override
	public Guidang getByxmbzj(String id) {
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("kzzd1", id);
		Guidang guidang =(Guidang) guidangDao.findObjectByFieldsMap(Guidang.class, paraMap); 
		return guidang;
	}



	
}
