package com.jshx.fstzs.web;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.jshx.common.utils.NumberToCN;
import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.json.CodeJsonValueProcessor;
import com.jshx.core.json.DateJsonValueProcessor;
import com.jshx.core.utils.SysPropertiesUtil;
import com.jshx.fstzs.entity.Fstzs;
import com.jshx.fstzs.entity.FstzsXm;
import com.jshx.fstzs.fsutil.bean.FsResult;
import com.jshx.fstzs.fsutil.bean.JkztResp;
import com.jshx.fstzs.fsutil.bean.KjjksResp;
import com.jshx.fstzs.fsutil.bean.KpResp;
import com.jshx.fstzs.service.FstzsService;
import com.jshx.fstzs.service.FstzsXmService;
import com.jshx.fstzs.fsutil.FsRequest;
import com.jshx.kpsjgl.service.KpsjglService;
import com.jshx.xmxxb.entity.Xmxxb;
import com.jshx.xmxxb.service.XmxxbService;
import com.neusoft.egov.utils.TextUtils;
import net.sf.json.JsonConfig;
import org.springframework.beans.factory.annotation.Autowired;

import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

public class FstzsAction extends BaseAction {

    @Autowired
    FstzsService fstzsService;
    @Autowired
    FstzsXmService fstzsXmService;

    @Autowired
    XmxxbService xmxxbService;
    /**
     * 获取收款人信息
     */
    @Autowired
    KpsjglService kpsjglService;

    /**
     * 分页信息
     */
    private Pagination pagination;

    Fstzs fstzs = new Fstzs();
    FstzsXm fstzsXm = new FstzsXm();

    /**
     * 非税通知书项目列表状态入参
     */
    Integer status;
    String id;
    /**
     * 区别新增与编辑
     * add/edit
     */
    String flag;
    String jkrList;
    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    /**
     * 筛选项；开始时间
     */
    String kssj;
    /**
     * 筛选项；结束时间
     */
    String jssj;
    /**
     * 非税通知书项目生成通知书的时候，上传的列表
     */
    List<Fstzs> fstzsList = new ArrayList<>();


    /**
     * fstzs列表
     * 执行查询的方法，返回json数据
     */
    public void list() throws Exception{
        Map<String, Object> paraMap = new HashMap<String, Object>();
        if(pagination==null)
            pagination = new Pagination(this.getRequest());
        //url带了status参数
        List<Integer> statusList = new ArrayList<>();
        if(status != null) {
            statusList.add(status);
        } else {
            statusList.add(1);//已激活
            statusList.add(2);//已作废

        }
        paraMap.put("status",statusList);
        if(null != fstzs){
            //筛选条件带了status，覆盖之前的
            if(fstzs.getStatus() != null) {
                paraMap.put("status",new ArrayList<Integer>(){{
                    add(fstzs.getStatus());
                }});
            }

            if (!TextUtils.isEmpty(fstzs.getSlbh())){
                paraMap.put("slbh", "%" + fstzs.getSlbh().trim() + "%");
            }
            if (!TextUtils.isEmpty(fstzs.getJsdwmc())){
                paraMap.put("jsdwmc", "%" + fstzs.getJsdwmc().trim() + "%");
            }
            if (!TextUtils.isEmpty(fstzs.getGcxmmc())){
                paraMap.put("gcxmmc", "%" + fstzs.getGcxmmc().trim() + "%");
            }

            if (!TextUtils.isEmpty(fstzs.getJkm())){
                paraMap.put("jkm", "%" + fstzs.getJkm().trim() + "%");
            }

            if (!TextUtils.isEmpty(fstzs.getYjje())){
                String yjje = fstzs.getYjje().trim();
                if(yjje.endsWith(".00")) {
                    yjje = yjje.substring(0,yjje.length() - 3);
                }
                paraMap.put("yjje", "%" + yjje + "%");
            }

            if (fstzs.getKpState() != null){
                paraMap.put("kpState", fstzs.getKpState());
            }

            if(!TextUtils.isEmpty(kssj)) {
                long ksTime = dateFormat.parse(kssj).getTime();
                paraMap.put("kssj", ksTime + "");
            }

            if(!TextUtils.isEmpty(jssj)) {
                long jsTime = dateFormat.parse(jssj).getTime();
                paraMap.put("jssj", jsTime + "");
            }

        }
        JsonConfig config = new JsonConfig();
        config.registerJsonValueProcessor(Date.class,new DateJsonValueProcessor());
        Map<String, String> codeMap = new HashMap<String, String>();
        //此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId

        config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap));

        pagination = fstzsService.findByPage(pagination, paraMap);
        for (Object o : pagination.list) {
            Fstzs fff = (Fstzs) o;
            //查询项目是否审批通过，没通过不给开票
            Xmxxb bySlbh = xmxxbService.getBySlbh(fff.getSlbh());
            if(bySlbh != null) {//没查到对应项目
                fff.setIsSptg("0".equals(bySlbh.getIssptg()) ? 1 : 0);
            } else {
                fff.setIsSptg(1);
            }
        }
        convObjectToJson(pagination, config);
    }


    /**
     * fstzs项目列表
     * 执行查询的方法，返回json数据
     */
    public void listXm() throws Exception{
        Map<String, Object> paraMap = new HashMap<String, Object>();
        if(pagination==null)
            pagination = new Pagination(this.getRequest());
        List<Integer> statusList = new ArrayList<>();
        if(status != null) {
            statusList.add(status);
        } else {
            statusList.add(1);
            statusList.add(2);
            statusList.add(3);
            statusList.add(4);
            statusList.add(6);//部分激活，可再次激活
        }
        paraMap.put("status",statusList);
        if(null != fstzsXm){
            //状态
            if (!TextUtils.isEmpty(fstzsXm.getSlbh())){
                paraMap.put("slbh", "%" + fstzsXm.getSlbh().trim() + "%");
            }
            if (!TextUtils.isEmpty(fstzsXm.getJsdwmc())){
                paraMap.put("jsdwmc", "%" + fstzsXm.getJsdwmc().trim() + "%");
            }
            if (!TextUtils.isEmpty(fstzsXm.getGcxmmc())){
                paraMap.put("gcxmmc", "%" + fstzsXm.getGcxmmc().trim() + "%");
            }
            if (!TextUtils.isEmpty(fstzsXm.getYjje())){
                String yjje = fstzsXm.getYjje().trim();
                if(yjje.endsWith(".00")) {
                    yjje = yjje.substring(0,yjje.length() - 3);
                }
                paraMap.put("yjje", "%" + yjje + "%");
            }

        }
        JsonConfig config = new JsonConfig();
        config.registerJsonValueProcessor(Date.class,new DateJsonValueProcessor());
        Map<String, String> codeMap = new HashMap<String, String>();
        //此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId

        config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap));

        pagination = fstzsXmService.findByPage(pagination, paraMap);

        convObjectToJson(pagination, config);
    }

    /**
     * 生成非税通知书窗口
     * @return
     */
    public String winAddFstzs() {
        fstzsXm = fstzsXmService.getById(id);
        try {
            //金额转中文
            fstzsXm.setYjjedx(NumberToCN.number2CNMontrayUnit(new BigDecimal(fstzsXm.getYjje())));
            HashMap<String, Object> params = new HashMap<>();
            params.put("slbh",fstzsXm.getSlbh());
            fstzsList = fstzsService.findList(params);
            if(fstzsList.size() == 0) {
                Fstzs f = new Fstzs();
                f.setJkr(fstzsXm.getJsdwmc());
                f.setYjje(fstzsXm.getYjje());
                f.setYjmj(fstzsXm.getPaymentItemPending().getCsmj());
                fstzsList.add(f);
            }

            if(TextUtils.isEmpty(fstzsXm.getMobile())) {
                Xmxxb bySlbh = xmxxbService.getBySlbh(fstzsXm.getSlbh());
                if(bySlbh != null) {
                    fstzsXm.setMobile(bySlbh.getPhone());
                }
            }
        } catch (Exception e) {}
        return VIEW;
    }

    public String winFstzs() {
        fstzs = fstzsService.getById(id);
        fstzsXm = fstzsXmService.getBySlbh(fstzs.getSlbh());
        fstzs.setYjjeDx(NumberToCN.number2CNMontrayUnit(new BigDecimal(fstzs.getYjje())));
        fstzs.setYjjeQfw(SysPropertiesUtil.qwfgf(fstzs.getYjje()));
        return VIEW;
    }

    /**
     * 生成非税通知书操作
     * @return
     */
    public String addFstzs() {
        FstzsXm dbXm = fstzsXmService.getById(fstzsXm.getId());
        //更新数据库项目状态
        dbXm.setJsdwmc(fstzsXm.getJsdwmc());
        dbXm.setStatus(1);//状态改为已生成、待复核
        dbXm.setJbr(this.getLoginUser().getDisplayName());
        dbXm.setBeizhu(fstzsXm.getBeizhu());
        dbXm.setKhh(fstzsXm.getKhh());
        dbXm.setMobile(fstzsXm.getMobile());
        dbXm.setZhanghao(fstzsXm.getZhanghao());
        dbXm.setJkrlx(fstzsXm.getJkrlx());

        HashMap<String, Object> params = new HashMap<>();
        params.put("slbh",dbXm.getSlbh());
        fstzsList = fstzsService.findList(params);
        String beizhuAppend = dbXm.getSlbh() + "，共" + fstzsList.size() + "张电子发票";
        if(TextUtils.isEmpty(dbXm.getBeizhu())) {
            dbXm.setBeizhu(beizhuAppend);
        } else if(!dbXm.getBeizhu().contains(beizhuAppend)) {
            dbXm.setBeizhu(dbXm.getBeizhu() + "，" + beizhuAppend);
        }
        fstzsXmService.update(dbXm);
        return RELOAD;
    }

    /**
     * 校验添加的多个缴款人
     * 添加前，会把改受理编号下的历史缴款人删除
     */
    public void checkAddFstzs() throws IOException {
        boolean result = true;
        String message = "OK";
        if(TextUtils.isEmpty(jkrList)) {
            message = "请添加缴款人";
            result = false;
        } else {
            fstzsList = new Gson().fromJson(jkrList,new TypeToken<List<Fstzs>>(){}.getType());
            //校验输入
            //1,校验是否为空
            double amount = 0d;
            for(Fstzs f : fstzsList) {
                if(TextUtils.isEmpty(f.getJkr())) {
                    message = "缴款人名字不能为空！";
                    result = false;
                    break;
                } else if(TextUtils.isEmpty(f.getYjje())) {
                    message = "应缴金额不能为空！";
                    result = false;
                    break;
                }
                try {
                    amount += Double.parseDouble(f.getYjje());
                } catch (Exception e) {
                    message = "应缴金额格式不正确！";
                    result = false;
                    break;
                }
            }

            if(result) {
                //2判断总应缴金额是否一样
                FstzsXm fstzsXm = fstzsXmService.getById(id);
                if(Double.parseDouble(fstzsXm.getYjje()) != amount) {
                    message = "合计金额与项目应缴金额不一致";
                    result = false;
                } else {
                    message = "校验正确，添加进表，并提交表单";
                    result = true;
                    //先查询是否有老的数据，有就删除先
                    //编辑时，先删除之前添加的内容
                    HashMap<String, Object> params = new HashMap<>();
                    params.put("slbh",fstzsXm.getSlbh());
                    List<Fstzs> list = fstzsService.findList(params);
                    if(list != null && list.size() > 0) {
                        List<String> ids = list.stream().map(f -> f.getId()).collect(Collectors.toList());
                        fstzsService.delete(ids);
                    }

                    // 添加多条记录到fstzs表
                    fstzsList.stream().map(i -> {
                        i.setDelFlag(0);
                        i.setStatus(0);
                        i.setFstzsXm(fstzsXm);
                        i.setGcxmmc(fstzsXm.getGcxmmc());
                        i.setJsdwmc(fstzsXm.getJsdwmc());
                        i.setSlbh(fstzsXm.getSlbh());
                        i.setLength(fstzsList.size());
                        i.setIsJk(0);
                        i.setKpState(0);
                        return i;
                    }).forEach(i-> fstzsService.save(i));
                }
            }

        }

        this.getResponse().getWriter().println("{\"result\":"+result+",\"message\":\"" + message + "!"+"\"}");
    }

    /**
     * 复核前验证正确性
     */
    public void checkReviewFstzs() throws IOException {
        boolean result = true;
        String message = "OK";
        FstzsXm fstzsXm = fstzsXmService.getById(this.fstzsXm.getId());
        if(this.getLoginUser().getDisplayName().equals(fstzsXm.getJbr())) {
            result = false;
            message = "不可以复核自己";
        }

        this.getResponse().getWriter().println("{\"result\":"+result+",\"message\":\"" + message + "!"+"\"}");
    }

    /**
     * 复核非税通知书
     * flag=0 通过 flag=1 退回
     * @return
     */
    public String reviewFstzs() {
        FstzsXm fstzsXm = fstzsXmService.getById(this.fstzsXm.getId());
        if("0".equals(flag)) {
            fstzsXm.setStatus(2);
        } else {
            fstzsXm.setFhyj(this.fstzsXm.getFhyj());
            fstzsXm.setStatus(3);
        }
        fstzsXmService.update(fstzsXm);
        return RELOAD;
    }

    /**
     * 项目激活
     * @return
     */
    public void jihuo() throws IOException {
        boolean result = true;
        String message = "OK";
        FstzsXm xm = fstzsXmService.getById(id);
        HashMap<String, Object> params = new HashMap<>();
        params.put("slbh",xm.getSlbh());
        // 需要调用财政系统操作，财政返回成功之后，才可以修改入库
        List<Fstzs> list = fstzsService.findList(params);
        list.stream().forEach(f-> {
            if(f.getStatus() != 1) {//已激活的不再重复激活
                f.setLsh(System.currentTimeMillis() + "");//生成流水号
                f.setFstzsXm(xm);
                f.setJksJbr(this.getLoginUser().getDisplayName());
                FsResult<KjjksResp> resp = FsRequest.jihuo(f);
                if(resp.success) {//成功
                    f.setStatus(1);
                    f.setJkm(resp.data.payCode);
                    f.setJkUrl(resp.data.url);
                    f.setJhTime(dateFormat.format(new Date()));
                    f.setBzrq(resp.data.createTime);
                } else {//失败
                    f.setStatus(4);//生成缴费码失败
                }
                fstzsService.update(f);
            }
        });
        List<Fstzs> unSuccess = list.stream().filter(i -> i.getStatus() != 1).collect(Collectors.toList());//不成功的数量
        if(unSuccess == null || unSuccess.size() == 0) {//全部成功
            message = "共" + list.size() + "个缴款人的通知书已成功推给非税系统";
            xm.setJhjd(list.size() + "/" + list.size());
            xm.setStatus(5);
        } else {
            int success = list.size() - unSuccess.size();
            message = "共" + list.size() + "个缴款人的通知书,成功推给非税系统" + success + "个，失败" + unSuccess.size() + "个，请返回列表重新激活";
            xm.setJhjd(success + "/" + list.size());
            xm.setStatus(6);
        }
        fstzsXmService.update(xm);
        this.getResponse().getWriter().println("{\"result\":"+result+",\"message\":\"" + message + "!"+"\"}");
    }

    /**
     * 作废操作
     */
    public void zuofei() throws IOException {
        boolean result = true;
        String message = "OK";

        HashMap<String, Object> params = new HashMap<>();
        params.put("slbh",fstzs.getSlbh());
        List<Fstzs> list = fstzsService.findList(params);
        FstzsXm xm = fstzsXmService.getBySlbh(fstzs.getSlbh());
        List<Fstzs> jkList = list.stream().filter(i -> i.getIsJk() == 1).collect(Collectors.toList());
        if(jkList != null && jkList.size() > 0) {
            result = false;
            message = jkList.get(0).getJkr() + "已缴款,无法作废其他！";
        }
        if(result) {
            for (Fstzs f : list) {
                // 需要调用财政系统，作废接口
                if(f.getStatus() != 2) {//已作废的不再重复作废
                    FsResult<Boolean> zuofei = FsRequest.zuofei(f);
                    if(zuofei.success) {
                        f.setStatus(2);//已作废
                        fstzsService.update(f);
                    } else {
                        result = false;
                        message = zuofei.msg;
                        break;
                    }
                }
            }

            if(result) {
                xm.setStatus(4);//已作废
                fstzsXmService.update(xm);
            }
        }
        this.getResponse().getWriter().println("{\"result\":"+result+",\"message\":\"" + message + "!"+"\"}");
    }

    /**
     * 开票
     */
    public void kaipiao() throws IOException {
        boolean result = true;
        String message = "操作成功";

        Fstzs fstzs = fstzsService.getById(id);
        FstzsXm xm = fstzsXmService.getBySlbh(fstzs.getSlbh());
        String jbr = this.getLoginUser().getDisplayName();
        fstzs.setFstzsXm(xm);
        FsResult<String> kaipiao = FsRequest.kaipiao(fstzs, jbr);
        if(kaipiao.success) {
            fstzs.setKpState(2);//非同步返回，需要异步查询
            fstzs.setKpLsh(kaipiao.data);
            fstzs.setKpJbr(jbr);
            fstzsService.update(fstzs);
            message = "开票中，请稍后查询!";
        } else {
            result = false;
            message = kaipiao.msg;
        }

        this.getResponse().getWriter().println("{\"result\":"+result+",\"message\":\"" + message + "!"+"\"}");

    }

    public void kaipiaoCx() throws IOException {
        boolean result = true;
        String message = "操作成功";

        Fstzs fstzs = fstzsService.getById(id);
        FsResult<KpResp> kaipiao = FsRequest.kaipiaoCx(fstzs.getKpLsh());
        if(kaipiao.success) {
            fstzs.setKpState(1);//修改为开票完成状态
            fstzs.setKpTime(kaipiao.data.date);
            fstzs.setDzph(kaipiao.data.billNo);
            fstzs.setPjdm(kaipiao.data.billBatchCode);
            fstzs.setPjUrl(kaipiao.data.url);
            fstzsService.update(fstzs);
        } else {
            result = false;
            message = kaipiao.msg;
        }
        this.getResponse().getWriter().println("{\"result\":"+result+",\"message\":\"" + message + "!"+"\"}");
    }

    /**
     * 删除操作
     * xm表复原，status=0
     * 删除对应缴费人的信息
     */
    public String shanchu() {
        FstzsXm xm = fstzsXmService.getById(fstzsXm.getId());
        xm.setStatus(0);
        xm.setFhyj("");
        xm.setZhanghao("");
        xm.setKhh("");
        xm.setMobile("");
        xm.setBeizhu("");
        HashMap<String, Object> params = new HashMap<>();
        params.put("slbh",xm.getSlbh());
        List<Fstzs> list = fstzsService.findList(params);
        List<String> ids = list.stream().map(i -> i.getId()).collect(Collectors.toList());
        fstzsService.delete(ids);
        fstzsXmService.update(xm);
        return RELOAD;
    }

    /**
     * 缴费状态查询
     * FstzsDsrw，定时任务也在查询状态，所以这边修改了，那边也需要同步修改
     */
    public void queryJfzt() throws IOException {
        Map<String, Object> paraMap = new HashMap<String, Object>();
        paraMap.put("status",new ArrayList<Integer>(){{
            add(1);//已激活
        }});

        /**
         * 先返回，在请求接口
         */
        this.getResponse().getWriter().println("{\"result\":"+true+",\"message\":\"更新中，请稍后刷新列表!"+"\"}");

        //1，查询全部未激活的信息
        List<Fstzs> list = fstzsService.findList(paraMap);
        list.stream().map(i-> {
            //2，循环接口请求缴费状态
            FsResult<JkztResp> jiaokuanzt = FsRequest.jiaokuanzt(i);
            if(jiaokuanzt.success) {
                i.setStatus(3);//已缴款
                i.setIsJk(1);
                i.setJkTime(jiaokuanzt.data.confirmDate);
                i.setJkqd(jiaokuanzt.data.paymentChannel);
                fstzsService.update(i);
            }
            return i;
        }).forEach(i-> System.out.println("查询缴费状态！"));
    }

    public Pagination getPagination() {
        return pagination;
    }

    public void setPagination(Pagination pagination) {
        this.pagination = pagination;
    }

    public Fstzs getFstzs() {
        return fstzs;
    }

    public void setFstzs(Fstzs fstzs) {
        this.fstzs = fstzs;
    }

    public FstzsXm getFstzsXm() {
        return fstzsXm;
    }

    public void setFstzsXm(FstzsXm fstzsXm) {
        this.fstzsXm = fstzsXm;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getFlag() {
        return flag;
    }

    public void setFlag(String flag) {
        this.flag = flag;
    }

    public List<Fstzs> getFstzsList() {
        return fstzsList;
    }

    public void setFstzsList(List<Fstzs> fstzsList) {
        this.fstzsList = fstzsList;
    }

    public String getJkrList() {
        return jkrList;
    }

    public void setJkrList(String jkrList) {
        this.jkrList = jkrList;
    }

    public String getKssj() {
        return kssj;
    }

    public void setKssj(String kssj) {
        this.kssj = kssj;
    }

    public String getJssj() {
        return jssj;
    }

    public void setJssj(String jssj) {
        this.jssj = jssj;
    }
}
