package com.jshx.fstzs.fsutil;

import com.jshx.core.utils.CodeUtil;

import java.util.Map;
import java.util.TreeMap;

/**
 *  财政局
 */
public class SecurityUtils {
    public static final String APPKEY = "f756761c49d19870cb444582312d";
    public static final String KEY = "security";

    /**
     * 第一步，将请求参数按照名称字母顺序排序，把所有参数值串在一起。
     * (security除外)
     * 请求参数：
     * method,format,app_id,datetime,version,
     * encryption,message_id,message,region_code,agency_code
     * 参数按ASCII顺序排序为： agency_code, app_id,
     * datetime,encryption,format,message, message_id, method,region_code,version
     * 例如参数值：agency_code=1,app_id=2,datetime=3,encryption=4,format=5
     * , message=6, message_id=7 ,method=8 ,region_code=9, version=10
     * 得到拼接串：12345678910
     *
     * 第二步，使用md5算法进行加密。
     * 将appKey 拼接到参数字符串头、尾进行md5加密后，再转化成大写。
     * 格式是：byte2hex(MD5(appKey12345678910appKey))
     * Java防伪方法见附录2
     * 注：byte2hex为自定义方法，JAVA中MD5是对字节数组加密，加密结果是16字节，
     * 我们需要的是32位的大写字符串。
     * @param param
     * @return
     */
    public static void security(Map<String,String> param) {
        if(param == null || param.size() == 0) return;
        //1,使用treemap自动进行ASCII顺序排序
        TreeMap<String,String> treeMap = new TreeMap<>(param);
        StringBuffer values = new StringBuffer(APPKEY);
        treeMap.keySet().stream().map(i-> treeMap.get(i)).forEach(v-> values.append(v));
        values.append(APPKEY);
        //MD5加密
        String target = CodeUtil.encode(values.toString(), CodeUtil.MD5).toUpperCase();
        //放回原参数
        param.put(KEY,target);
    }
}
