package com.jshx.fstzs.fsutil;

import cn.com.infosec.netsign.agent.NetSignAgent;
import cn.com.infosec.netsign.agent.NetSignResult;
import cn.com.infosec.netsign.agent.exception.NetSignAgentException;
import cn.com.infosec.netsign.agent.exception.ServerProcessException;

import java.net.URL;
import java.security.cert.X509Certificate;

/**
 * 财政签名
 */
public class FsSignUtil {
    
    public static String sign(String old) {
        try {
            URL url = FsSignUtil.class.getResource("");
            NetSignAgent.initialize(url.getPath() + "netsignagent.properties");
        } catch (NetSignAgentException e) {
            e.printStackTrace();
        }
        try {
            //签名原文
            byte[] laintext = old.getBytes() ;
            //签名证书DN，null表示用服务器默认证书进行签名
            String subject = null ;
            //摘要算法，null表示用服务器默认的摘要算法
            String digestAlg = null ;
            //是否做TSA签名
            boolean useTSA = false ;
            //签名
            NetSignResult result = NetSignAgent.detachedSignature(laintext , subject , digestAlg , useTSA ) ;
            //获取byte形式的签名结果
            byte[] signedText = result.getByteArrayResult( NetSignResult.SIGN_TEXT ) ;
            //获取base64编码后的签名结果
            return result.getStringResult( NetSignResult.SIGN_TEXT ) ;
        } catch (NetSignAgentException e ) {
            e.printStackTrace();
            System.out.println( "errorCode:" + e.getErrorCode() );
            System.out.println( "errorMsg:" + e.getMessage() );
        } catch (ServerProcessException e ) {
            e.printStackTrace();
            System.out.println( "errorCode:" + e.getErrorCode() );
            System.out.println( "errorMsg:" + e.getMessage() );
        }
        return null;
    }

    /**
     * @param old
     * @param signedText  base64编码的签名
     * @param tsaText  base64编码的TSA
     */
    public static void design(String old,String signedText,String tsaText) {
        try {
            // 签名原文
            byte[] laintext = old.getBytes();

            // 是否需要返回签名证书
            boolean needCert = false;
            // 验签名
            NetSignResult result = NetSignAgent.detachedVerify( laintext ,signedText , tsaText , needCert );
            // 签名证书主题
            result.getStringResult( NetSignResult.SIGN_SUBJECT );
            // 签名证书颁发者主题为
            result.getStringResult( NetSignResult.SIGN_ISSUER_SUBJECT );
            // 签名证书序列号为
            result.getStringResult( NetSignResult.SIGN_SER_NUMBER );
            // 签名证书起始时间为
            result.getStringResult( NetSignResult.SIGN_START_TIME );
            // 签名证书终止时间为
            result.getStringResult( NetSignResult.SIGN_END_TIME );
            // 签名证书
            X509Certificate cert = ( X509Certificate ) result
                    .getResult( NetSignResult.SIGN_CERT );
        } catch ( NetSignAgentException e ) {
            e.printStackTrace();
            System.out.println( "errorCode:" + e.getErrorCode() );
            System.out.println( "errorMsg:" + e.getMessage() );
        } catch ( ServerProcessException e ) {
            e.printStackTrace();
            System.out.println( "errorCode:" + e.getErrorCode() );
            System.out.println( "errorMsg:" + e.getMessage() );
        }
    }
}


















