package com.jshx.fstzs.dao.impl;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.fstzs.dao.FstzsDao;
import com.jshx.fstzs.dao.FstzsXmDao;
import com.jshx.fstzs.entity.Fstzs;
import com.jshx.fstzs.entity.FstzsXm;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

@Component("fstzsXmDao")
public class FstzsXmDaoImpl extends BaseDaoImpl implements FstzsXmDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findFstzsXmByMap", paraMap, page);
	}

	public List findByPage(Map<String, Object> paraMap)
	{
		return this.findListByHqlId("findFstzsXmByMap",paraMap);
	}


	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public FstzsXm getById(String id)
	{
		return (FstzsXm)this.getObjectById(FstzsXm.class, id);
	}

	/**
	 * 保存信息
	 * @param fstzsXm 信息
	 */
	public void save(FstzsXm fstzsXm)
	{
		fstzsXm.setId(null);
		this.saveOrUpdateObject(fstzsXm);
	}

	/**
	 * 修改信息
	 * @param fstzsXm 信息
	 */
	public void update(FstzsXm fstzsXm)
	{
		this.saveOrUpdateObject(fstzsXm);
	}
	/**
	 * 修改信息
	 * @param fstzsXm 信息
	 */
	@Override
	public void updateNotSave(FstzsXm fstzsXm)
	{
		this.update(fstzsXm);
	}

	/**
	 * 物理删除信息
	 * @param id 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(FstzsXm.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param id 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		FstzsXm fstzsXm = (FstzsXm)this.getObjectById(FstzsXm.class, id);
		fstzsXm.setDelFlag(1);
		this.saveObject(fstzsXm);
	}
}
