package com.jshx.core.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;

import javax.servlet.http.HttpServletResponse;

import net.sf.jxls.exception.ParsePropertyException;
import net.sf.jxls.transformer.XLSTransformer;

import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class ExportExcel {
	 public void export(String filename , Map dataMap , String model , HttpServletResponse response) throws IOException
	    {
	        XLSTransformer transformer = new XLSTransformer();
	        HSSFWorkbook workbook = null;
	        InputStream in;
	        try
	        {
	            in = getClass().getResource(model).openStream();
	            workbook = (HSSFWorkbook)transformer.transformXLS(in, dataMap);
	            outExcel(workbook, response, filename);
	        }
	        catch (Exception e)
	        {
	            e.printStackTrace();
	        }
	    }

	    protected void outExcel(HSSFWorkbook workbook , HttpServletResponse response , String filename)
	    {
	        response.setContentType("application ns.ms-excel");
	        response.setHeader("Expires", "0");
	        response.setHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
	        response.setHeader("Pragma", "public");
	        try
	        {
	            response.setHeader("Content-disposition", "attachment;filename="
	                    + java.net.URLEncoder.encode(filename, "UTF-8") + ".xls");
	        }
	        catch (UnsupportedEncodingException e1)
	        {
	            e1.printStackTrace();
	        }
	        try
	        {
	            workbook.write(response.getOutputStream());
	        }
	        catch (ParsePropertyException e)
	        {
	            e.printStackTrace();
	        }
	        catch (IOException e)
	        {
	            e.printStackTrace();
	        }
	    }
}
