package com.jshx.core.security;

import java.io.Serializable;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.Security;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;

import javax.crypto.Cipher;

import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
/**
 * RSA加解密
 * 
 * @author Caron
 *
 */

public class RSAKeyGenerater implements Serializable {
	
	private static final Logger logger = LoggerFactory.getLogger(RSAKeyGenerater.class);
	
	private KeyPair keyPair = null;
     
    /**
     * 生成public key
     * @return
     */
    public String generateBase64PublicKey(long seed) {
    	try{
    		Security.addProvider(new org.bouncycastle.jce.provider.BouncyCastleProvider());
            SecureRandom random = new SecureRandom();
            random.setSeed(seed);
            KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA", "BC");
            generator.initialize(1024, random);
            keyPair = generator.generateKeyPair();
            RSAPublicKey key = (RSAPublicKey)keyPair.getPublic();
            return new String(Base64.encodeBase64(key.getEncoded()));
    	}catch(Exception e){
    		logger.error(e.getMessage(), e);
    		return null;
    	}
    }
     
    /**
     * 解密
     * @param string
     * @return
     */
    public String decryptBase64(String string) {
        return new String(decrypt(Base64.decodeBase64(string)));
    }
     
    private byte[] decrypt(byte[] string) {
        try {
            Security.addProvider(new org.bouncycastle.jce.provider.BouncyCastleProvider());
            Cipher cipher = Cipher.getInstance("RSA/None/PKCS1Padding", "BC");
            RSAPrivateKey pbk = (RSAPrivateKey)keyPair.getPrivate();
            cipher.init(Cipher.DECRYPT_MODE, pbk);
            byte[] plainText = cipher.doFinal(string);
            return plainText;
        }catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}
