package com.jshx.account.paymentVoucher.web;

import java.io.File;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import com.jshx.billManager.entity.BillManager;
import com.jshx.billlq.entity.Billlq;
import com.jshx.billlq.service.BilllqService;
import com.jshx.common.utils.FileUtils;
import com.jshx.core.utils.StringUtil;
import com.jshx.core.utils.Struts2Util;
import com.jshx.rfxm.entity.Rfxm;
import com.jshx.rfxm.service.RfxmService;
import com.jshx.spjlb.entity.Spjlb;
import com.jshx.spjlb.service.SpjlbService;
import com.jshx.wwjdclinfo.entity.Wwjdclinfo;
import com.jshx.wwjdclinfo.service.WwjdclinfoService;
import com.jshx.wwsqys.entity.Wwsqys;
import com.jshx.wwsqys.service.WwsqysService;
import com.jshx.yzsjfhc.service.PaymentVerificationService;
import com.jshx.yzsjfhc.service.PaymentVerifyChargeService;
import org.activiti.editor.language.json.converter.util.CollectionUtils;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.dom4j.Element;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;

import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.xmxxb.entity.Xmxxb;
import com.jshx.xmxxb.service.XmxxbService;
import com.jshx.zsdw.entity.Zsdw;
import com.jshx.zsdw.service.ZsdwService;
import com.neusoft.egov.utils.ZLibMimeUtil;
import com.neusoft.egov.utils.billendnumber;

import http.UnitServiceServiceStub;
import http.entity.DATA;
import http.entity.LIST;
import http.entity.Main;
import http.entity.Record;
import http.entity.Srxm;
import http.utils.JaxbUtil;
import http.utils.JaxbUtil.CollectionWrapper;

import com.jshx.core.json.CodeJsonValueProcessor;
import com.jshx.core.json.DateJsonValueProcessor;
import com.jshx.core.utils.SysPropertiesUtil;
import com.jshx.jktzs.entity.Jktzs;
import com.jshx.jktzs.service.JktzsService;
import com.jshx.kpsjgl.entity.Kpsjgl;
import com.jshx.kpsjgl.service.KpsjglService;
import com.jshx.lxrinfo.entity.Lxrinfo;
import com.jshx.lxrinfo.service.LxrinfoService;
import com.jshx.mjyj.entity.Mjyj;
import com.jshx.mjyj.service.MjyjService;
import com.jshx.module.admin.web.action.CommonAction;
import com.jshx.paymentItemDelay.entity.PaymentItemDelay;
import com.jshx.paymentItemDelay.service.PaymentItemDelayService;
import com.jshx.paymentItemDelayHis.entity.PaymentItemDelayHis;
import com.jshx.paymentItemDelayHis.service.PaymentItemDelayHisService;
import com.jshx.paymentItemHis.entity.PaymentItemHis;
import com.jshx.paymentItemHis.service.PaymentItemHisService;
import com.jshx.xmdrb.service.GenericManager;
import com.jshx.account.accountBank.entity.AccountBank;
import com.jshx.account.accountBank.service.AccountBankService;
import com.jshx.account.paymentVoucher.service.PaymentVoucherService;
import com.jshx.account.paymentVoucherHis.entity.PaymentVoucherHis;
import com.jshx.account.paymentVoucherHis.service.PaymentVoucherHisService;
import com.jshx.billManager.entity.Indeticur;
import com.jshx.billManager.service.BillManagerService;
import com.jshx.cktzs.entity.Cktzs;
import com.jshx.cktzs.service.CktzsService;
import com.jshx.common.utils.Constant;
import com.jshx.common.utils.NumberToCN;

import javax.servlet.http.HttpServletRequest;

public class PaymentVoucherAction extends BaseAction
{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * 主键ID，用于接收页面提交的主键ID信息
	 */
	private String id;


	private File file; //文件上传
	
	/**
	 * 主键ID列表，用于接收页面提交的多条主键ID信息
	 */
	private String ids;
	
	/**
	 * 实体类
	 */
	private Xmxxb xmxxb = new Xmxxb();

	private AccountBank accountBank = new AccountBank();
	
	private PaymentVoucherHis paymentVoucherHis = new PaymentVoucherHis();
	
	private PaymentItemHis paymentItemHis = new PaymentItemHis();

	private Rfxm rfxm;

	private PaymentItemDelayHis paymentItemDelayHis = new PaymentItemDelayHis();
	
	private Mjyj mjyj = new Mjyj();
	
	private Zsdw zsdwxx = new Zsdw();
	
	private Jktzs jktzs = new Jktzs();

	private Main main = new Main();
	private Lxrinfo lxrinfo=new Lxrinfo();
	/**
	 * 业务类
	 */
	@Autowired
	private AccountBankService accountBankService;
	@Autowired
        private KpsjglService kpsjglService;
	
	@Autowired
	private XmxxbService xmxxbService;
	
	@Autowired
	private PaymentVoucherService paymentVoucherService;
	
	@Autowired
	private PaymentVoucherHisService paymentVoucherHisService;
	
	@Autowired
	private PaymentItemHisService paymentItemHisService;

	@Autowired
	private RfxmService rfxmService;
	
	@Autowired
	private PaymentItemDelayService paymentItemDelayService;
	
	@Autowired
	private PaymentItemDelayHisService paymentItemDelayHisService;
	
	@Autowired
	private MjyjService mjyjService;
	
	@Autowired
	private ZsdwService zsdwService;
	
	@Autowired
	private JktzsService jktzsService;
	
	@Autowired
	private CktzsService cktzsService;

	@Autowired
	private WwjdclinfoService wwjdclinfoService;
	
	@Autowired
	private GenericManager genericManager;
	
	@Autowired
    protected RuntimeService runtimeService;
	
    @Autowired
    protected TaskService taskService;
    
    @Autowired
    private BillManagerService billManagerService;
    @Autowired
    private LxrinfoService lxrinfoService;

    @Autowired
	private WwsqysService wwsqysService;

/*    @Autowired
	private BilllqService billlqService;*/

	/**
	 * 修改新增标记，add为新增、mod为修改
	 */
	private String flag;
	
	/**
	 * 上传非税标记,add为首次上传、update为重新上传、disable为作废
	 */
	private String mode;

	/**
	 * 分页信息
	 */
	private Pagination pagination;
	
	
	private Date queryArrivalTimeStart;

	private Date queryArrivalTimeEnd;
	
	private String taskId;
	
	private String result;

	private String outcome;
	
	private String ECN;//电子监管号
	
	@Autowired()
	@Qualifier("sessionFactory")
	private SessionFactory sessionFactory;

	private String comment;
	
	/**
	 * 征收联系单编号
	 */
	private String zslxdbh;

	/**
	 * 受理编号
	 */
	private String orderId;
	
	/**
	 * 金额大写
	 */
	private String amount_CN;

	
	/**
	 * 当前日期
	 */
	private String currentDate;
	
	/**
	 * 征收单位
	 */
	private String zsdw;
	
	/**
	 * 征收单位编码
	 */
	private String zsdwbm;
	
	/**
	 * 区划码
	 */
	private String qhm;
	
	/**
	 * 收款人全称
	 */
	private String skrqc;

	private List<Wwjdclinfo> wwjdclinfos = new ArrayList<>();
	
	/**
	 * 收款人账户
	 */
	private String skrzh;
	
	/**
	 * 收款人开户行
	 */
	private String skrkhh;
	
	/**
	 * 项目编码
	 */
	private String xmbm;
	
	/**
	 * 收入项目名称
	 */
	private String srxmmc;
	
	/**
	 * 项目数量
	 */
	private String xmsl;
	
	/**
	 * 项目金额
	 */
	private String xmje;
	
	/**
	 * 作废标识
	 */
	private String zfbz;
	
	/**
	 * 单位名称
	 */
	private String dwmc;
	
	/**
	 * 一般缴款书票据号码
	 */
	private String voucherCode;
	
	/**
	 * 对接非税类型 0：未作废 1： 已作废
	 */
	private String type;

	/**
	 * 是否缓缴项目
	 */
	private String isDelay;

	/**
	 * 票据号码
	 */
	private String pjhm;

	/**
	 * 缴款全称
	 */
	private String jkqc;
	
	/**
	 * 缴费类型   0：直接解缴 1：集中汇缴
	 */
	private String payType;

	@Autowired
	private SpjlbService spjlbService;
	@Autowired
	private PaymentVerificationService paymentVerificationService;
	@Autowired
	private PaymentVerifyChargeService paymentVerifyChargeService;

	/**
	 * 缴费方式   0:现金 1：转账
	 */
	private String payMethod;

	private String csptf;
	
	/**
	 * 执行查询的方法，返回json数据
	 */
	public void queryInfo() throws Exception{
		Map<String, Object> paraMap = new HashMap<String, Object>();

		if(pagination==null)
		    pagination = new Pagination(this.getRequest());
		    
		if(null != xmxxb){
		    //设置查询条件，开发人员可以在此增加过滤条件
			if ((null != xmxxb.getXmlsh()) && (0 < xmxxb.getXmlsh().trim().length())){
				paraMap.put("xmlsh", "%" + xmxxb.getXmlsh().trim() + "%");
			}

			if ((null != xmxxb.getXxylb()) && (0 < xmxxb.getXxylb().trim().length())){
				paraMap.put("xxylb", "%" + xmxxb.getXxylb().trim() + "%");
			}

			if ((null != xmxxb.getXmbh()) && (0 < xmxxb.getXmbh().trim().length())){
				paraMap.put("xmbh", "%" + xmxxb.getXmbh().trim() + "%");
			}

			if ((null != xmxxb.getSlbh()) && (0 < xmxxb.getSlbh().trim().length())){
				paraMap.put("slbh", "%" + xmxxb.getSlbh().trim() + "%");
			}

			if ((null != xmxxb.getJsdw()) && (0 < xmxxb.getJsdw().trim().length())){
				paraMap.put("jsdw", "%" + xmxxb.getJsdw().trim() + "%");
			}

			if ((null != xmxxb.getDwbh()) && (0 < xmxxb.getDwbh().trim().length())){
				paraMap.put("dwbh", "%" + xmxxb.getDwbh().trim() + "%");
			}

			if ((null != xmxxb.getXmmc()) && (0 < xmxxb.getXmmc().trim().length())){
				paraMap.put("xmmc", "%" + xmxxb.getXmmc().trim() + "%");
			}

			if ((null != xmxxb.getLianxiren()) && (0 < xmxxb.getLianxiren().trim().length())){
				paraMap.put("lianxiren", "%" + xmxxb.getLianxiren().trim() + "%");
			}

		}
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(java.util.Date.class,new DateJsonValueProcessor());  
		Map<String, String> codeMap = new HashMap<String, String>();
		//此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId
		
		config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap)); 
		final String filter = "id|gzlbh|slbh|xmlsh|xxylb|xmbh|jsdw|dwbh|jbcs|czgs|bllb|ckbh|lsck|zjdyjks|zsdw|zsfw|issdxm|lianxiren|xkzh|jzmjdx|jzmjdc|jzmj27|jzmj8ys|zjzmjds|csje|beizhu|xmmc|mjyj|";
		if (filter != null && filter.length() > 1) {
			config.setJsonPropertyFilter(new PropertyFilter() {
				public boolean apply(Object source, String name, Object value) {
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		pagination = paymentVoucherService.findByPage(pagination, paraMap);
		
		convObjectToJson(pagination, config);
	}
	
	/**
	 * 开票数据录入
	 * @return
	 */
	public String dataRecordAdd(){
		try{
			//暂时将数据存在配置文件内
//			zsdw = SysPropertiesUtil.getProperty("Zsdw");
//			zsdwbm = SysPropertiesUtil.getProperty("Zsdwbm");
//			qhm = SysPropertiesUtil.getProperty("Qhm");
//			skrqc = SysPropertiesUtil.getProperty("Skrqc");
//			skrzh = SysPropertiesUtil.getProperty("Skrzh");
//			skrkhh = SysPropertiesUtil.getProperty("Skrkhh");
//			xmbm = SysPropertiesUtil.getProperty("Xmbm");
//			srxmmc = SysPropertiesUtil.getProperty("Srxmmc");
		        
			Kpsjgl kp=kpsjglService.findbygllb("001");
			zsdw = kp.getZsdw();
			zsdwbm = kp.getZsdwbm();
			qhm = kp.getQhm();
			skrqc = kp.getKrqc();
			skrzh = kp.getSkrzh();
			skrkhh = kp.getSkrkhh();
			xmbm = kp.getXmbm();
			srxmmc = kp.getSrxmmc();
			paymentItemHis = paymentItemHisService.getById(id);
			if(null!=paymentItemHis){
				//获取项目信息
				amount_CN = NumberToCN.number2CNMontrayUnit(new BigDecimal(paymentItemHis.getPtyjje()));
			}
		}catch(Exception e){
			logger.error(e.getMessage());
		}
		return SUCCESS;
	}
	
	/**
	 * 开票数据查看
	 * @return
	 */
	public String dataRecordDetail(){
		SimpleDateFormat outSdf = new SimpleDateFormat("yyyyMMdd");
		currentDate = outSdf.format(new Date());
		try{
			paymentVoucherHis = paymentVoucherHisService.getById(id);
			if(null!=paymentVoucherHis){
				//获取项目信息
				amount_CN = NumberToCN.number2CNMontrayUnit(new BigDecimal(paymentVoucherHis.getAmount()));
			}
		}catch(Exception e){
			logger.error(e.getMessage());
		}
		return SUCCESS;
	}
	

	/**
	 * 缓缴款项目开票数据录入
	 * @return
	 */
	public String dataRecordDelayAdd(){
		try{
			//暂时将数据存在配置文件内
//			zsdw = SysPropertiesUtil.getProperty("Zsdw");
//			zsdwbm = SysPropertiesUtil.getProperty("Zsdwbm");
//			qhm = SysPropertiesUtil.getProperty("Qhm");
//			skrqc = SysPropertiesUtil.getProperty("Skrqc");
//			skrzh = SysPropertiesUtil.getProperty("Skrzh");
//			skrkhh = SysPropertiesUtil.getProperty("Skrkhh");
//			xmbm = SysPropertiesUtil.getProperty("Xmbm");
//			srxmmc = SysPropertiesUtil.getProperty("Srxmmc");
			Kpsjgl kp=kpsjglService.findbygllb("001");
                        zsdw = kp.getZsdw();
                        zsdwbm = kp.getZsdwbm();
                        qhm = kp.getQhm();
                        skrqc = kp.getKrqc();
                        skrzh = kp.getSkrzh();
                        skrkhh = kp.getSkrkhh();
                        xmbm = kp.getXmbm();
                        srxmmc = kp.getSrxmmc();
			paymentItemDelayHis = paymentItemDelayHisService.getById(id);
			amount_CN = NumberToCN.number2CNMontrayUnit(new BigDecimal(paymentItemDelayHis.getSjje()));
		}catch(Exception e){
			logger.error(e.getMessage());
		}
		return SUCCESS;
	}
	
	/**
	 * 一般缴款书
	 * @return
	 */
	public String JiaoKuanShu(){
		try{
			paymentItemHis = paymentItemHisService.getById(id);
			if(null!=paymentItemHis)
			//获取项目信息
			xmxxb = xmxxbService.getById(paymentItemHis.getXmbzj());
			if(null!=xmxxb){
				//获取电子监管号
				ECN = generateECN(xmxxb.getBllb());
			}else{
				throw new Exception("项目信息不存在，请核实数据！");
			}
		}catch(Exception e){
			logger.error(e.getMessage());
		}
		return "JiaoKuanShu";
	}
	
	/**
	 * 房改办
	 * @return
	 */
	public String FangGaiBan(){
		SimpleDateFormat outSdf = new SimpleDateFormat("yyyyMMdd");
		currentDate = outSdf.format(new Date());
		try{
			paymentItemHis = paymentItemHisService.getById(id);
			if(null!=paymentItemHis){
				//获取项目信息
				xmxxb = xmxxbService.getById(paymentItemHis.getXmbzj());
				zsdwxx = zsdwService.getzsdw(this.getLoginUserDepartmentId());
				lxrinfo=lxrinfoService.getBybhdwdm("003", zsdwxx.getZsdm());
			}
		}catch(Exception e){
			logger.error(e.getMessage());
		}
		return "FangGaiBan";
	}
	
	/**
	 * 规划局缴费凭证
	 * @return
	 */
	public String GuiHua(){
		SimpleDateFormat outSdf = new SimpleDateFormat("yyyyMMdd");
		currentDate = outSdf.format(new Date());
		try{
 			paymentItemHis = paymentItemHisService.getById(id);
			 Map<String,Object> param = new HashMap<>();
			 param.put("paymentHisId",paymentItemHis.getId());
			List<Rfxm> rfxmList = rfxmService.findRfxm(param);
			if(rfxmList != null && rfxmList.size() > 0) {
				rfxm = rfxmList.get(0);
			}

			if(null!=paymentItemHis){
				//获取项目信息
				xmxxb = xmxxbService.getById(paymentItemHis.getXmbzj());
				zsdwxx = zsdwService.getzsdw(this.getLoginUserDepartmentId());
				lxrinfo=lxrinfoService.getBybhdwdm("003", zsdwxx.getZsdm());
			}
			setCsptf(SysPropertiesUtil.add(paymentItemHis.getPtyjje(), paymentItemHis.getPtymje()));
		}catch(Exception e){
			logger.error(e.getMessage());
		}
		return "GuiHua";
	}
	
	/**
	 * 产权处缴费凭证
	 * @return
	 */
	public String ChanQuan(){
		SimpleDateFormat outSdf = new SimpleDateFormat("yyyyMMdd");
		currentDate = outSdf.format(new Date());
		try{
			paymentItemHis = paymentItemHisService.getById(id);
			if(null!=paymentItemHis){
				//获取项目信息
				xmxxb = xmxxbService.getById(paymentItemHis.getXmbzj());
				if(xmxxb!=null && xmxxb.getXmmc() != null && xmxxb.getXmmc().length()>16)
				{
					String xmmc = xmxxb.getXmmc();
					String xmmc1 = xmmc.substring(0,16);
					String xmmc2 = xmmc.substring(16);
					this.getRequest().setAttribute("xmmc1",xmmc1);
					this.getRequest().setAttribute("xmmc2",xmmc2);
				}
				if(xmxxb!=null && xmxxb.getYjje()!=null && xmxxb.getYjje().length()>0)
                {
                    BigDecimal bigDecimal = new BigDecimal(xmxxb.getYjje());
                    bigDecimal = bigDecimal.divide(new BigDecimal("10000"));
                    this.getRequest().setAttribute("yjje",bigDecimal.toString());
                }
				zsdwxx = zsdwService.getzsdw(this.getLoginUserDepartmentId());
				lxrinfo=lxrinfoService.getBybhdwdm("003", zsdwxx.getZsdm());
			}
		}catch(Exception e){
			logger.error(e.getMessage());
		}
		return "ChanQuan";
	}
	
	/**
	 * 资金科创缴费凭证
	 * @return
	 */
	public String ZiJin(){
		SimpleDateFormat outSdf = new SimpleDateFormat("yyyyMMdd");
		currentDate = outSdf.format(new Date());
		try{
			paymentItemHis = paymentItemHisService.getById(id);
			if(null!=paymentItemHis){
				//获取项目信息
				xmxxb = xmxxbService.getById(paymentItemHis.getXmbzj());
				zsdwxx = zsdwService.getzsdw(this.getLoginUserDepartmentId());
				lxrinfo=lxrinfoService.getBybhdwdm("003", zsdwxx.getZsdm());
			}
		}catch(Exception e){
			logger.error(e.getMessage());
		}
		return "ZiJin";
	}
	
	/**
	 * 保存联系单编号
	 */
	public void updateZslxdbh(){
		paymentItemHis = paymentItemHisService.getById(id);
		paymentItemHis.setZslxdbh(zslxdbh);
		paymentItemHis.setIsPrintJfpz("1");//已打印
		paymentItemHisService.update(paymentItemHis);
	}
	
	/**
	 * 校验票据号码是否可用
	 * 0:可以使用	1: 票据号输入有误，请核实	2：票据号码已被使用
	 * @throws Exception 
	 */
	public void checkVoucherCode() throws Exception{
		int result = 0;
		try {
			//校验票据编码合法性
			if(validVoucherCode(pjhm)){
				//校验票据是否被使用
				if(IsExistVoucherCode(pjhm)){
					//校验此票据是否已入库被领用
					if(IsStoredCode(pjhm)){
						result = 0;
					}else{
						result = 3;
					}
				}else{
					result = 2;
				}
			}else{
				result = 1;
			}
			Kpsjgl kp=kpsjglService.findbygllb("001");
	                if(kp.getBdjg()==1){
	                    result = 5;
	                }
			
			this.getResponse().getWriter().println("{\"result\":"+ result +"}");
		} catch (Exception e) {
			result = 4;
			logger.error(e.getMessage());
			this.getResponse().getWriter().println("{\"result\":"+ result +"}");
		}
	}
	//特殊录入批量校验
	public void checkVoucherCodetb() throws Exception{
		int result = 0;
		String message="";
		try {
			String []resu=pjhm.split("\\,");
			if(resu.length>0){
			for (int i = 0; i < resu.length; i++) {
				String pj=resu[i];
				if (pj.length()>15) {
					break;
				}
				if(validVoucherCode(pj)){
					//校验票据是否被使用
					if(IsExistVoucherCode(pj)){
						//校验此票据是否已入库被领用
						if(IsStoredCode(pj)){
							result = 0;
						}else{
							result = 3;
							message=pj;
							break;
						}
					}else{
						result = 2;
						message=pj;
						break;
					}
				}else{
					result = 1;
					message=pj;
					break;
				}
			}
			}
			else{
				result = 5;
			}
			this.getResponse().getWriter().println("{\"result\":"+result+",\"message\":\"" + message + "\"}");

		} catch (Exception e) {
			result = 4;
			e.printStackTrace();
			logger.error(e.getMessage());
			this.getResponse().getWriter().println("{\"result\":"+ result +"}");
		}
	}
	
	/**
	 * 上传票据信息到非税系统
	 * @throws Exception 
	 */
	public String uploadVoucherInfo() throws Exception{
		String result = "";
		if("Y".equals(SysPropertiesUtil.getProperty("InterfaceOpen"))){
			result = reportNonTax(paymentVoucherHis,zfbz);
		}else{
			result = "1|成功";
		}
		String[] splits = result.split("\\|");
		String response = splits[0];
		String message = splits[1];//接口返回信息
		paymentVoucherHis.setDelFlag(0);
		paymentVoucherHis.setDeptId(this.getLoginUserDepartmentId());
		paymentVoucherHis.setOperator(this.getLoginUser().getDisplayName());
		paymentVoucherHis.setPrintDate(new Date());
		paymentVoucherHis.setValidCode(getValidCode(paymentVoucherHis));//全票面信息校验码
		if("-1".equals(response)){
			paymentVoucherHis.setApplyStatus(Constant.VOUCHER_USE_STATUS_2);
		}else if("1".equals(response)){
			paymentVoucherHis.setApplyStatus(Constant.VOUCHER_USE_STATUS_0);
		}
		paymentVoucherHis.setDestroyStatus(Constant.VOUCHER_DESTROY_STATUS_0);//默认未缴销
		paymentVoucherHis.setMessage("上报："+message);
		paymentVoucherService.add(paymentVoucherHis, response, isDelay, id);
		return RELOAD;
	}
	/**
	 * 不上传非税系统
	 * @throws Exception 
	 */
	public String uploadVoucherInfotb() throws Exception{
//		String result ="1|成功";
		String[] splits = paymentVoucherHis.getVoucherCode().split("\\,");
		paymentVoucherHis.setDelFlag(0);
		paymentVoucherHis.setDeptId(this.getLoginUserDepartmentId());
		paymentVoucherHis.setOperator(this.getLoginUser().getDisplayName());
		paymentVoucherHis.setPrintDate(new Date());
		
		SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
		String pjbz="";
		pjbz="关联编号:"+paymentVoucherHis.getVoucherCode()+".";
		paymentVoucherHis.setDestroyStatus(Constant.VOUCHER_DESTROY_STATUS_0);//默认未缴销
		//四位全局校验码
		for (int i = 0; i < splits.length; i++) {
			StringBuffer source = new StringBuffer();
			BigDecimal areaBd = new BigDecimal(paymentVoucherHis.getArea());
			String area = areaBd.setScale(2, BigDecimal.ROUND_HALF_UP).toString();
			BigDecimal amountBd = new BigDecimal(paymentVoucherHis.getAmount());
			String amount = amountBd.setScale(2, BigDecimal.ROUND_HALF_UP).toString();
			if(i==0){
				source.append(splits[0]).append(format.format(new Date())).append(paymentVoucherHis.getZsdwbm()).append(paymentVoucherHis.getPayerName()).append(paymentVoucherHis.getSkrzh()).append(paymentVoucherHis.getPayType()).append(paymentVoucherHis.getXmbm()).append(area).append(amount);
				paymentVoucherHis.setApplyStatus(Constant.VOUCHER_USE_STATUS_0);
				paymentVoucherHis.setMessage("上报：成功");
			}else{
				source.append(splits[i]).append(format.format(new Date())).append(paymentVoucherHis.getZsdwbm()).append(paymentVoucherHis.getPayerName()).append(paymentVoucherHis.getSkrzh()).append(paymentVoucherHis.getPayType()).append(paymentVoucherHis.getXmbm()).append(area).append(amount);
				paymentVoucherHis.setApplyStatus(Constant.VOUCHER_USE_STATUS_1);
				paymentVoucherHis.setMessage("作废：成功");
			}
			if(splits[i].length()<15) {
				String validCode = billendnumber.calculateBillMac(source.toString());
				paymentVoucherHis.setValidCode(validCode);//全票面信息校验码
			}
			//模拟票据领取发放功能
			/*List<Indeticur>  list = new ArrayList<Indeticur>();
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
			String startNo =splits[i];
			String endNo = splits[i];
			String uuid = UUID.randomUUID().toString().replaceAll("-", "");
			String no = splits[i];
			Indeticur indeticur = new Indeticur();
			indeticur.setDelFlag(0);
			indeticur.setIsrece(0);
			indeticur.setNo(no);
			indeticur.setIsprint("0");
			indeticur.setSort(0);
			indeticur.setRkTime(sdf.format(new Date()));
			indeticur.setSequenceID(uuid);

			indeticur.setIsrece(1);
			indeticur.setPerson(this.getLoginUser().getDisplayName());
			indeticur.setState("0");
			indeticur.setZsdw("市收费处");
			list.add(indeticur);
			// 批量插入indeticur然后更新billManager
			billManagerService.batchupdate(list);
			BillManager billManager = new BillManager();
//		billManager.setCount("1");
			billManager.setDeptId(this.getLoginUser().getDept().getId());
			billManager.setDelFlag(0);
			billManager.setEndno(endNo);
			billManager.setRktime(sdf.format(new Date()));
			billManager.setStartno(startNo);
			billManager.setSequentID(uuid);
			billManagerService.save(billManager);

			Billlq billlq = new Billlq();
			billlq.setCount("1");
			billlq.setPerson(this.getLoginUser().getDisplayName());
			billlq.setDeptId(this.getLoginUser().getDept().getId());
			billlq.setZsdw(this.getLoginUser().getDept().getDeptName());
			billlq.setDelFlag(0);
			billlq.setStartno(startNo);
			billlq.setEndno(endNo);
			billlq.setLqtime(sdf.format(new Date()));
			billlqService.save(billlq);
			paymentVoucherHis.setVoucherCode(splits[i]);
			paymentVoucherService.addtb(paymentVoucherHis, "1", isDelay, id,pjbz);*/
		}
		
		return RELOAD;
	}
	
	/**
	 * 作废票据信息  
	 * @throws Exception
	 */
	public void disableVoucherInfo() throws Exception{
		try{
		    Kpsjgl kp=kpsjglService.findbygllb("001");
		    if(kp.getBdjg()==0){
		     
			PaymentVoucherHis paymentVoucherHis = paymentVoucherHisService.getById(id);
			String result = "";
			if("Y".equals(SysPropertiesUtil.getProperty("InterfaceOpen"))){
				result = reportNonTax(paymentVoucherHis,zfbz);
			}else{
				result = "1|成功";
			}
			String[] splits = result.split("\\|");
			String response = splits[0];
			String message = splits[1];//接口返回信息
			if("1".equals(response)){
				paymentVoucherHis.setApplyStatus(Constant.VOUCHER_USE_STATUS_1);
			}
			paymentVoucherHis.setMessage("作废："+message);
			paymentVoucherService.disable(paymentVoucherHis, response);
			this.getResponse().getWriter().println("{\"result\":true}");
			   
                    }else{
                        this.getResponse().getWriter().println("{\"result\":false}");
                    }
		}catch(Exception e){
			logger.error(e.getMessage());
			this.getResponse().getWriter().println("{\"result\":false}");
		}
	}
	
	/**
	 * 重新上传开票信息
	 * @throws Exception
	 */
	public void reUploadVoucherInfo() throws Exception{
		try{
		    Kpsjgl kp=kpsjglService.findbygllb("001");
                    if(kp.getBdjg()==0){
			PaymentVoucherHis paymentVoucherHis = paymentVoucherHisService.getById(id);
			String result = "";
			if("Y".equals(SysPropertiesUtil.getProperty("InterfaceOpen"))){
				result = reportNonTax(paymentVoucherHis,zfbz);
			}else{
				result = "1|成功";
			}
			String[] splits = result.split("\\|");
			String response = splits[0];
			String message = splits[1];//接口返回信息
			if("1".equals(response)){
				paymentVoucherHis.setApplyStatus(Constant.VOUCHER_USE_STATUS_0);
			}
			paymentVoucherHis.setMessage("重新上报："+message);
			paymentVoucherHis.setPrintDate(new Date());
			paymentVoucherService.reUpload(paymentVoucherHis,response);
			this.getResponse().getWriter().println("{\"result\":true}");
                    }else{
                        this.getResponse().getWriter().println("{\"result\":false}");
                    }
		}catch(Exception e){
			logger.error(e.getMessage());
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		
	}
	
	/**
	 * 上报非税系统
	 * -1:上传失败 1:上传成功  2:票据号码输入有误 3:票据编号已被使用 4:非税接口无法连接 5：系统异常
	 * @throws Exception
	 */
	public void invokeInterface() throws Exception{
		String response = "-1" ;
		try{
			//校验票据编码合法性
			if(validVoucherCode(pjhm)){
				//校验票据是否被使用
				if(IsExistVoucherCode(pjhm)){
					//调用非税接口
					response = reportNonTax(paymentVoucherHis,zfbz);
				}else{
					response = "3";
				}
			}else{
				response = "2";
			}
		}catch(Exception e){
			response = "5";
			logger.error(e.getMessage());
		}finally{
			//非缓缴项目
			if("4".equals(response) || "-1".equals(response) || "1".equals(response)){
				if("update".equalsIgnoreCase(mode)){//重新上传
					PaymentVoucherHis paymentVoucherHis = paymentVoucherHisService.getById(id);
					if("1".equals(response)){
						paymentVoucherHis.setApplyStatus(Constant.VOUCHER_USE_STATUS_0);
					}
					paymentVoucherHisService.update(paymentVoucherHis);
				}else if("add".equalsIgnoreCase(mode)){//首次开票上传
					PaymentVoucherHis paymentVoucherHis = new PaymentVoucherHis();
					paymentVoucherHis.setDelFlag(0);
					paymentVoucherHis.setDeptId(this.getLoginUserDepartmentId());
					paymentVoucherHis.setZsdw(zsdw);//执收单位
					paymentVoucherHis.setZsdwbm(zsdwbm);//执收单位编码
					paymentVoucherHis.setQhm(qhm);//区划码
					paymentVoucherHis.setSkrqc(skrqc);//收款人全称
					paymentVoucherHis.setSkrzh(skrzh);//收款人账号
					paymentVoucherHis.setSkrkhh(skrkhh);//收款人开户行
					paymentVoucherHis.setPayType(payType);//缴费类型
					paymentVoucherHis.setPayMethod(payMethod);//缴费方法
					paymentVoucherHis.setPayerName(jkqc);//缴款全称
					paymentVoucherHis.setVoucherCode(pjhm);//票据号码
					paymentVoucherHis.setXmbm(xmbm);//项目编码
					paymentVoucherHis.setSrxmmc(srxmmc);//收入项目名称
					paymentVoucherHis.setArea(xmsl);//项目数量
					paymentVoucherHis.setAmount(xmje);//项目金额
					paymentVoucherHis.setOperator(this.getLoginUser().getDisplayName());
					paymentVoucherHis.setPrintDate(new Date());
					paymentVoucherHis.setValidCode(getValidCode(paymentVoucherHis));//全票面信息校验码
					if("4".equals(response) || "-1".equals(response)){
						paymentVoucherHis.setApplyStatus(Constant.VOUCHER_USE_STATUS_2);
					}else if("1".equals(response)){
						paymentVoucherHis.setApplyStatus(Constant.VOUCHER_USE_STATUS_0);
					}
					if("0".equals(isDelay)){//是否缓缴项目
						paymentItemDelayHis = paymentItemDelayHisService.getById(id);
						paymentVoucherHis.setDwdm(paymentItemDelayHis.getDwdm());
						paymentVoucherHis.setOrderId(paymentItemDelayHis.getSlbh());
						paymentVoucherHis.setRelateId(paymentItemDelayHis.getId());
						paymentVoucherHis.setType("1");
					}else{
						paymentItemHis = paymentItemHisService.getById(id);
						paymentVoucherHis.setDwdm(paymentItemHis.getDwdm());
						paymentVoucherHis.setOrderId(paymentItemHis.getSlbh());
						paymentVoucherHis.setRelateId(paymentItemHis.getId());
						paymentVoucherHis.setType("0");
					}
					paymentVoucherHisService.save(paymentVoucherHis);
				}else if("disable".equalsIgnoreCase(mode)){//开票作废
					PaymentVoucherHis paymentVoucherHis = paymentVoucherHisService.getById(id);
					if("1".equals(response)){
						paymentVoucherHis.setApplyStatus(Constant.VOUCHER_USE_STATUS_1);
						paymentVoucherHisService.update(paymentVoucherHis);
					}
				}
			}
		}
		this.getResponse().getWriter().println("{\"result\":"+ response +"}");
	}
	
	/**
	 * 生成电子监管号（当前系统时间+四位随机码）
	 * @return
	 */
	@Deprecated
	private String generateECN(String type){
		Long time = System.currentTimeMillis();// 获得系统时间，作为生成随机数的种子
		Random random = new Random();
		int randomNum = random.nextInt(9999);//四位随机数
		StringBuffer sb = new StringBuffer();
		sb.append(time).append(randomNum).append("-").append(type);
		return sb.toString();
	}
	
	/**
	 * 校验项目情况（审批是否通过、单位是否有逾期费用未缴清）
	 * @throws Exception
	 */
	public void checkPoject() throws Exception{
		boolean result = true;
		String message = "成功！";
		paymentItemHis = paymentItemHisService.getById(id);
		//根据项目表主键查询此项目是否审批通过 （此项目存在审核未通过先缴费的情况）
		xmxxb = xmxxbService.getById(paymentItemHis.getXmbzj());
		if(null != xmxxb){
			if(!"0".equals(xmxxb.getIssptg())){
				result = false;
				message = "该项目审批未通过，暂时无法生成凭证！";
			}else{
				//判断此项目是否解锁，若解锁则无需判断此单位的催缴记录（业务要求：有催缴记录的单位未缴清费用之前所有项目不允许打印）
				if(!Constant.STATUS_LOCK_2.equals(paymentItemHis.getLockFlag())){
					if(hasDelayProject(paymentItemHis.getDwmc())){
						result = false;
						message = "该单位有逾期未缴清的项目，暂时无法操作！";
					}
				}
			}
		}else{
			result = false;
			message = "该项目不存在，请联系管理员！";
		}
		Kpsjgl kp=kpsjglService.findbygllb("001");
		if(kp.getBdjg()==1){
		    result = false;
                    message = "非税基础数据同步有误,请联系管理员!";
		}

		this.getResponse().getWriter().println("{\"result\":" + result + ",\"message\":\"" + message + "\"}");
	}


	public void checkPoject1() throws Exception{
		boolean result = true;
		String message = "成功！";
		paymentItemHis = paymentItemHisService.getById(id);
		//根据项目表主键查询此项目是否审批通过 （此项目存在审核未通过先缴费的情况）
		xmxxb = xmxxbService.getById(paymentItemHis.getXmbzj());
		if(null != xmxxb){
			if(!"0".equals(xmxxb.getIssptg())){
				result = false;
				message = "该项目审批未通过，暂时无法生成凭证！";
			}else{
				//判断此项目是否解锁，若解锁则无需判断此单位的催缴记录（业务要求：有催缴记录的单位未缴清费用之前所有项目不允许打印）
				if(!Constant.STATUS_LOCK_2.equals(paymentItemHis.getLockFlag())){
					if(hasDelayProject(paymentItemHis.getDwmc())){
						result = false;
						message = "该单位有逾期未缴清的项目，暂时无法生成凭证！";
					}
				}
			}
		}else{
			result = false;
			message = "该项目不存在，请联系管理员！";
		}

		this.getResponse().getWriter().println("{\"result\":" + result + ",\"message\":\"" + message + "\"}");
	}


	public void checkCwyz() throws Exception{
		boolean result = true;
		String message = "成功！";

		if(!this.getLoginUser().getLoginId().equals("102012") && !this.getLoginUser().getLoginId().equals("102008")) {
			result = false;
			message = "您没有用章权限！";
		}

		this.getResponse().getWriter().println("{\"result\":" + result + ",\"message\":\"" + message + "\"}");
	}

	//发送短信
	public void faduanxin() throws Exception{
	    boolean result = true;
	    String message = "成功！";
	    paymentItemHis = paymentItemHisService.getById(id);
	    paymentItemHis.setIsfdx("1");
	    paymentItemHisService.update(paymentItemHis);
	    //根据项目表主键查询此项目是否审批通过 （此项目存在审核未通过先缴费的情况）
	    xmxxb = xmxxbService.getById(paymentItemHis.getXmbzj());
	    if(null != xmxxb){
	        //短信
//                String neirong=xmb.getSlbh()+"-"+xmb.getXmmc()+"已超过缴费时间";
                    String phones=xmxxb.getPhone();
                    Pattern p=Pattern.compile("^1\\d{10}$");
                    Matcher m=p.matcher(phones);
                    if(!"".equals(phones)&&m.matches()&&phones.length()==11&&"sf".equals(xmxxb.getDwdm())){
                          String neirong=xmxxb.getJsdw()+"单位,"+xmxxb.getXmmc()+"项目现已办清,请及时到市政务中心A246窗口,领取缴费凭证,咨询电话025-68505246";
                          
                        CommonAction.send(neirong, phones+",", this.getLoginUserDepartmentId(),this.getLoginUser().getDisplayName()); 
                    }
	    }
	    this.getResponse().getWriter().println("{\"result\":" + result + ",\"message\":\"" + message + "\"}");
	}
	
	/**
	 * 查询是否有催缴项目记录
	 * @param dwmc 单位名称
	 * @throws Exception
	 */
	private boolean hasDelayProject(String dwmc) throws Exception{
		Map<String, Object> paraMap = new HashMap<String, Object>();
		Map<String, Object> paraMap2 = new HashMap<String, Object>();
		//单位名称
		paraMap.put("dwmc",dwmc);
		paraMap.put("isjk","0");
		//查询催款记录表
		List<Cktzs> cklist=cktzsService.findByall(paraMap);
		paraMap2.put("dwmc2",dwmc);
		List<PaymentItemDelay> delayHis = paymentItemDelayService.findall(paraMap2);
	    if(null!=cklist && cklist.size()>0)
	    	return true;
	    else if(null!=delayHis && delayHis.size()>0)
	    	return true;
	    else
	    	return false;
	}

	/**
	 * 初始化修改信息
	 */
	public String fujian() throws Exception{
		 xmxxb = xmxxbService.getByXxylb(xmxxb.getXxylb());
		 Map map = new HashMap();
		 map.put("xxylb",xmxxb.getXxylb());
		Pagination  pagination1 = wwjdclinfoService.findByPage(new Pagination(1,0),map);
		wwjdclinfos = pagination1.getListOfObject();
		HttpServletRequest request = Struts2Util.getRequest();
		request.setAttribute("jfpz","no");
		if("001".equals(xmxxb.getMjyj())||"005".equals(xmxxb.getMjyj()))
		{
			request.setAttribute("istbsgxt","yes".equals(xmxxb.getIstbsgxt())?"yes":"no");
		}else
		{
			request.setAttribute("istbsgxt","yes");
		}
		request.setAttribute("istbsgxt","yes".equals(xmxxb.getIstbsgxt())?"yes":"no");

		for(Wwjdclinfo wwjdclinfo : wwjdclinfos)
		{
			 if("缴费凭证".equals(wwjdclinfo.getFjqm()))
			{
				request.setAttribute("jfpz","yes".equals(wwjdclinfo.getIsSync())?"yes":"no");
			}
		}
		String dwdma = zsdwService.getDwdm(this.getLoginUserDepartmentId());
		if(!(StringUtil.isNotEmpty(dwdma)&& dwdma.equals("sf")))
		{
			request.setAttribute("issfc","no");
		}


		return EDIT;
	}
	/**
	 * 凭证上传
	 * 先缓存至服务器
	 */
	public String fujiantongbu() throws Exception
	{
		String fileName1="";
		String rubiaopath ="";
		//id : uploadName;ids:uploadShowName
		if(file!=null && StringUtil.isNotEmpty(id))
		{
			//TODO 上传文件
			String path = SysPropertiesUtil.jdlj(this.getRequest())
					+ File.separator+ "wwupload"+ File.separator+"bjcl" +File.separator+xmxxb.getXxylb()+File.separator;
			rubiaopath = "wwupload"+ File.separator+"bjcl" +File.separator+xmxxb.getXxylb()+File.separator+id;
			rubiaopath = rubiaopath.replaceAll("\\\\", "/").trim();
			path = path.replaceAll("\\\\", "/").trim();
			fileName1 = FileUtils.uploadFile(file,id, path);
		}
		Wwjdclinfo wwjdclinfo = new Wwjdclinfo();
		wwjdclinfo.setDeptId(this.getLoginUserDepartmentId());
		wwjdclinfo.setDelFlag(0);

		xmxxb = xmxxbService.getByXxylb(xmxxb.getXxylb());
//			List<Wwsqys> ls = wwsqysService.findxxylb(xmxxb.getXxylb());
		if(xmxxb != null && "9".equals(xmxxb.getHfsz()))
		{
			List<Wwsqys> wwsqyss = wwsqysService.findxxylb(xmxxb.getXxylb());
			wwjdclinfo.setWwsqbh(wwsqyss.get(0).getWwsqbh());
		}
		else
		{
			wwjdclinfo.setWwsqbh("xxsbxm");
		}

		wwjdclinfo.setScdz(rubiaopath);
		wwjdclinfo.setScwjm(id);
		wwjdclinfo.setFjqm(ids);
//		wwjdclinfo.setWwsqbh(wwsqys.getWwsqbh());
		wwjdclinfo.setXxylb(xmxxb.getXxylb());
		//查询表中是否存在，若存在则覆盖
		Map<String, Object> paraMap = new HashMap<String, Object>();
		Pagination pagination =new Pagination(1,100);
		paraMap.put("xxylb",xmxxb.getXxylb());
		paraMap.put("fjqm",ids);
		pagination = wwjdclinfoService.findByPage(pagination,paraMap);
		List<Wwjdclinfo> wwjdclinfos = pagination.getListOfObject();
		if(CollectionUtils.isEmpty(wwjdclinfos))
		{
			wwjdclinfoService.save(wwjdclinfo);
		}
		else
		{
			Wwjdclinfo wwjdclinfo1 = wwjdclinfos.get(0);
			wwjdclinfo1.setFjqm(ids);
			wwjdclinfo1.setScwjm(id);
			wwjdclinfo1.setScdz(rubiaopath);
			wwjdclinfoService.update(wwjdclinfo1);
		}
		return RELOAD;
	}

	/**
	 * @return
	 * @throws Exception
	 */
	private String reportNonTax(PaymentVoucherHis paymentVoucherHis, String zfbz) throws Exception{
		SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
		UnitServiceServiceStub stub = new UnitServiceServiceStub();
		UnitServiceServiceStub.SendCommonBillData info = new  UnitServiceServiceStub.SendCommonBillData();
		try{
			//接口对接用户名密码
			info.setIn0(SysPropertiesUtil.getProperty("interfaceName"));
			info.setIn1(SysPropertiesUtil.getProperty("interfacePwd"));
			//构造接口xml报文
			main.setPjlx("3201000101");//票据类型 老的01001 新的从2018年7月1日起用3201000101
			main.setPjhm(paymentVoucherHis.getVoucherCode());//票据号码
			main.setQpmjym(getValidCode(paymentVoucherHis));//全票面校验信息
			main.setDwbm(paymentVoucherHis.getZsdwbm());//开票单位编码
			main.setWtdwbm(paymentVoucherHis.getZsdwbm());
 			main.setJkfs("0".equals(paymentVoucherHis.getPayMethod())?"01":"02");//缴款方式
			main.setKprq(format.format(new Date()));//开票日期
			if(null!=paymentVoucherHis.getPayerName())
			{
				main.setJkqc(paymentVoucherHis.getPayerName());//缴款人全称
			}
			if(null!=paymentVoucherHis.getSkrqc())
			{
				main.setSkqc(paymentVoucherHis.getSkrqc());//收款人全称
			}
			if(null!=paymentVoucherHis.getSkrzh())
			{
				main.setSkzh(paymentVoucherHis.getSkrzh());//收款人账户
			}
			if(null!=paymentVoucherHis.getSkrkhh())
			{
				main.setSkyh(paymentVoucherHis.getSkrkhh());//收款人开户行
			}
			if(null!=paymentVoucherHis.getAmount())
			{
				main.setZje(paymentVoucherHis.getAmount());//总金额
			}
			main.setZfbz(zfbz);//作废标志，0未作废，1已作废*/
			Srxm srxm = new Srxm();
			if(null!=paymentVoucherHis.getXmbm())
			{
				srxm.setXmbm(paymentVoucherHis.getXmbm());//项目编码
			}
			if(null!=paymentVoucherHis.getAmount())
			{
				srxm.setXmje(paymentVoucherHis.getAmount());//项目金额
			}
			if(null!=paymentVoucherHis.getArea())
			{
				srxm.setXmsl(paymentVoucherHis.getArea());//项目数量
			}
			List<Srxm> srxmList= new ArrayList<Srxm>();
			srxmList.add(srxm);
			
			LIST list = new LIST();
			list.setSrxm(srxmList);
			
			Record record = new Record();
			record.setMain(main);
			record.setList(list);
			
			List<Record> recordList = new ArrayList<Record>();
			recordList.add(record);
			 
			DATA data = new DATA();
			data.setDataType("COMMONBILLINFO"); 
			data.setRecord(recordList);
			JaxbUtil requestBinder = new JaxbUtil(DATA.class,  
	                CollectionWrapper.class);  
	        String retXml = requestBinder.toXml(data, "GB2312").replace(" standalone=\"yes\"", "");
			System.out.println(retXml);
	        info.setIn2(ZLibMimeUtil.zLibEncode(retXml));//报文需要压缩加密
	        String result = stub.sendCommonBillData(info).getSendCommonBillDataReturn();
	        return ZLibMimeUtil.zLibDecode(result);
		}catch(org.apache.axis2.AxisFault f){
			logger.error(f.getCause().getMessage());
			return "-1|"+f.getCause().getMessage();
		}catch(Exception e){
			return "-1|"+e.getMessage();
		}
	}
	
	/**
	 * 获取全票面信息校验码
	 * @return
	 */
	private String getValidCode(PaymentVoucherHis paymentVoucherHis){
		SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
		StringBuffer source = new StringBuffer();
		BigDecimal areaBd = new BigDecimal(paymentVoucherHis.getArea());
		String area = areaBd.setScale(2, BigDecimal.ROUND_HALF_UP).toString();
		BigDecimal amountBd = new BigDecimal(paymentVoucherHis.getAmount());
		String amount = amountBd.setScale(2, BigDecimal.ROUND_HALF_UP).toString();
		//四位全局校验码
		source.append(paymentVoucherHis.getVoucherCode()).append(format.format(new Date())).append(paymentVoucherHis.getZsdwbm()).append(paymentVoucherHis.getPayerName()).append(paymentVoucherHis.getSkrzh()).append(paymentVoucherHis.getPayType()).append(paymentVoucherHis.getXmbm()).append(area).append(amount);
		String validCode = billendnumber.calculateBillMac(source.toString());
		return validCode;
	}
	
	/**
	 * 校验票据号码正确性
	 * @param voucherCode
	 * @return
	 */
	private boolean validVoucherCode(String voucherCode){
		String validNo = billendnumber.getCode(voucherCode.substring(0, voucherCode.length()-1));
		//校验位
		String lastNo = voucherCode.substring(voucherCode.length()-1, voucherCode.length());
		if(validNo.equals(lastNo)){
			return true;
		}
		return false;
	}
	
	/**
	 * 判断此票号是否已使用
	 * @param voucherCode
	 * @return
	 */
	private boolean IsExistVoucherCode(String voucherCode){
		Map<String,Object> paraMap = new HashMap<String,Object>();
		paraMap.put("code", voucherCode);
		List list = paymentVoucherHisService.findPaymentVoucherHis(paraMap);
		if(null!=list && list.size()>0){
			return false;
		}
		return true;
	}
	
	/**
	 * 判断此票据是否已入库被领用
	 * @param voucherCode
	 * @return
	 */
	private boolean IsStoredCode(String voucherCode){
		Map<String,Object> paraMap = new HashMap<String,Object>();
		Zsdw dwdm=zsdwService.getzsdw(this.getLoginUserDepartmentId());
		paraMap.put("isrece", 1);
		paraMap.put("zsdw", "%"+dwdm.getZsdw()+"%");
		paraMap.put("no", voucherCode);
		Indeticur ind = billManagerService.findIndeticurByNo(paraMap);
		if(null != ind){
			return true;
		}
		return false;
	}
	
	
	
	
	//执收单位信息
	private void getUnitInfo() throws Exception{
		SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
		UnitServiceServiceStub stub = new UnitServiceServiceStub();
		UnitServiceServiceStub.GetUnitInfo info = new  UnitServiceServiceStub.GetUnitInfo();
		//接口对接用户名密码
		info.setIn0(SysPropertiesUtil.getProperty("interfaceName"));
		info.setIn1(SysPropertiesUtil.getProperty("interfacePwd"));
		String result = stub.getUnitInfo(info).getGetUnitInfoReturn();
		//String result = stub.sendCommonBillData(info).getSendCommonBillDataReturn();
		
		Element root =ZLibMimeUtil.jiedian(ZLibMimeUtil.zLibDecode(result));
		String Zsdwbm=ZLibMimeUtil.getxmlnr(root,"/DATA/RECORD/dwbm");
		String Zsdw=ZLibMimeUtil.getxmlnr(root,"/DATA/RECORD/dwmc");
//        System.out.println(ZLibMimeUtil.zLibDecode(result));
	}
	//获得委托单位信息
//	private void getEntrustUnitInfo() throws Exception{
//		SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
//		UnitServiceServiceStub stub = new UnitServiceServiceStub();
//		UnitServiceServiceStub.GetEntrustUnitInfo info = new  UnitServiceServiceStub.GetEntrustUnitInfo();
//		//接口对接用户名密码
//		info.setIn0(SysPropertiesUtil.getProperty("interfaceName"));
//		info.setIn1(SysPropertiesUtil.getProperty("interfacePwd"));
//		String result = stub.getEntrustUnitInfo(info).getGetEntrustUnitInfoReturn();
//		System.out.println(ZLibMimeUtil.zLibDecode(result));
//	}
	//获得执收单位的收入项目信息
	private void getItemData() throws Exception{
		SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
		UnitServiceServiceStub stub = new UnitServiceServiceStub();
		UnitServiceServiceStub.GetItemData info = new  UnitServiceServiceStub.GetItemData();
		//接口对接用户名密码
		info.setIn0(SysPropertiesUtil.getProperty("interfaceName"));
		info.setIn1(SysPropertiesUtil.getProperty("interfacePwd"));
		String result = stub.getItemData(info).getGetItemDataReturn();
		System.out.println(ZLibMimeUtil.zLibDecode(result));
		Element root =ZLibMimeUtil.jiedian(ZLibMimeUtil.zLibDecode(result));
		List elements = root.elements();
		if(elements.size()>0){
			   for (Iterator it = elements.iterator(); it.hasNext();) {
				    Element elem = (Element) it.next();
				    Element xmmc=(Element)elem.selectSingleNode("xmmc");
				    if("城市基础设施配套费-市区".equals(xmmc.getText())){
				    	Element xmbm=(Element)elem.selectSingleNode("xmbm");
				    	Element biaozbun=(Element)elem.selectSingleNode("sfbzsx");
				    	String Xmbm=xmbm.getText();
				    	String Srxmmc =xmmc.getText();
				    	String sfbzsx =biaozbun.getText();//150
				    	System.out.println(xmbm.getText());
				    	System.out.println(xmmc.getText());
				    }
				   }
		}
	}
	//代理银行信息
	private void getBankData() throws Exception{
		SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
		UnitServiceServiceStub stub = new UnitServiceServiceStub();
		UnitServiceServiceStub.GetBankData info = new  UnitServiceServiceStub.GetBankData();
		//接口对接用户名密码
		info.setIn0(SysPropertiesUtil.getProperty("interfaceName"));
		info.setIn1(SysPropertiesUtil.getProperty("interfacePwd"));
		String result = stub.getBankData(info).getGetBankDataReturn();
		System.out.println(ZLibMimeUtil.zLibDecode(result));
		Element root =ZLibMimeUtil.jiedian(ZLibMimeUtil.zLibDecode(result));
		List elements = root.elements();
		if(elements.size()>0){
			   for (Iterator it = elements.iterator(); it.hasNext();) {
				    Element elem = (Element) it.next();
				    Element khhmc=(Element)elem.selectSingleNode("khhmc");
				    if("农行鼓楼支行".equals(khhmc.getText())){
				    	Element zhzh=(Element)elem.selectSingleNode("zhzh");
				    	Element zhmc=(Element)elem.selectSingleNode("zhmc");
				    	String Skrzh=zhzh.getText();
				    	String Skrkhh =khhmc.getText();
				    	String Skrqc =zhmc.getText();
				    	System.out.println(zhzh.getText());
				    	System.out.println(zhmc.getText());
				    	System.out.println(khhmc.getText());
				    }
				   }
		}
	}
	
	//获得票据名称信息
	private void getBillInfo() throws Exception{
		SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
		UnitServiceServiceStub stub = new UnitServiceServiceStub();
		UnitServiceServiceStub.GetBillInfo info = new  UnitServiceServiceStub.GetBillInfo();
		//接口对接用户名密码
		info.setIn0(SysPropertiesUtil.getProperty("interfaceName"));
		info.setIn1(SysPropertiesUtil.getProperty("interfacePwd"));
		String result = stub.getBillInfo(info).getGetBillInfoReturn();
		System.out.println(ZLibMimeUtil.zLibDecode(result));
	}
	//获得票据名称信息
	private void getUnitBillInfo() throws Exception{
		SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
		UnitServiceServiceStub stub = new UnitServiceServiceStub();
		UnitServiceServiceStub.GetUnitBillInfo info = new  UnitServiceServiceStub.GetUnitBillInfo();
		//接口对接用户名密码
		info.setIn0(SysPropertiesUtil.getProperty("interfaceName"));
		info.setIn1(SysPropertiesUtil.getProperty("interfacePwd"));
		String result = stub.getUnitBillInfo(info).getGetUnitBillInfoReturn();
		System.out.println(ZLibMimeUtil.zLibDecode(result));
	}

	public void pinzhenSyncPz()throws Exception
	{
		if(ids != null)
		{
			xmxxb = xmxxbService.getByXxylb(ids);
			xxsyncPz(xmxxb);
		}
		else
		{
			this.getResponse().getWriter().println("{\"result\":\"false\"}");
			return ;
		}
	}
	/**
	 * 线下项目同步凭证方法
	 */
	private void xxsyncPz(Xmxxb xmxxb) throws Exception
	{
		//根据信息一览表id查询办件材料表的信息
		Map<String,Object> paraMap = new HashMap<>();
		paraMap.put("xxylb",xmxxb.getXxylb());
		Pagination pagination = wwjdclinfoService.findByPage(new Pagination(1,0),paraMap);
		List<Wwjdclinfo> listOfObject = pagination.getListOfObject();
		if(CollectionUtils.isEmpty(listOfObject))
		{
			this.getResponse().getWriter().println("{\"result1\":\"false\",\"info\":\"结果件未上传！\"}");
			return ;
		}
		Wwjdclinfo wwjdclinfo2 = null;
		String flag2 = null ;
		for(Wwjdclinfo wwjdclinfo : listOfObject)
		{
			if("缴费凭证".equals(wwjdclinfo.getFjqm()))
			{
				flag2 =	wwjdclinfo.getIsSync();
				wwjdclinfo2 = wwjdclinfo;
			}
		}
		if(wwjdclinfo2 == null)
		{
			this.getResponse().getWriter().println("{\"result1\":\"false\",\"info\":\"缴费凭证未上传！\"}");
			return ;
		}
		if( "yes".equals(flag2) && "yes".equals(xmxxb.getIstbsgxt()))
		{
			this.getResponse().getWriter().println("{\"result1\":\"false\",\"info\":\"不可重复同步！\"}");
			return ;
		}

		PaymentItemHis paymentItemHis = paymentItemHisService.getByXmbId(xmxxb.getId());

		Map<String,String> map = new HashMap();

		//凭证同步
		map.put("wwsqbh",wwjdclinfo2.getWwsqbh());
//		map.put("xxylb",wwjdclinfo2.getXxylb());
		map.put("fjqm",wwjdclinfo2.getFjqm());
		map.put("Scwjm",wwjdclinfo2.getScwjm());
		map.put("scdz",wwjdclinfo2.getScdz());

		//电子监管号
		map.put("dzjgh",paymentItemHis.getECN());
		map.put("jfpzbh",paymentItemHis.getZslxdbh());
		map.put("xmslbh",paymentItemHis.getSlbh());
//		map.put("jfje",paymentItemHis.getZyjje());//缴费金额
//		map.put("mjje",paymentItemHis.getZymje());//免缴金额

		map.put("xxylb",xmxxb.getXxylb());
		map.put("fgwxmbh",xmxxb.getLxpw());
		map.put("jsdw",xmxxb.getJsdw());
		map.put("xmmc",xmxxb.getXmmc());
		map.put("gcxmdz",xmxxb.getJsdd());
		map.put("szmj",xmxxb.getZjsmj());
		map.put("bz",xmxxb.getBeizhu());

		map.put("jfpzlxdh",xmxxb.getPhone());
		map.put("jfpzlxr",xmxxb.getLianxiren());
		map.put("jddh","000000");
		map.put("jfpzdyrq",paymentItemHis.getUpdateTime().toString());
		map.put("ghxmbh",xmxxb.getXmbh()); //规划项目编号


		//审核过程记录
		Map<String, Object> jkjlb = new HashMap<String, Object>();
		jkjlb.put("xxbbh", xmxxb.getXxylb());
		List<Spjlb> ls=spjlbService.findSpjlball(jkjlb);
		String csr="";//初审人
		String csyj="";//初审意见
		String fhr="";//复核人
		String fhyj="";//复核意见
		String yjfy="";//应缴金额
		if(null!=ls&&ls.size()>0){
			csr=ls.get(0).getCsr();
			csyj=ls.get(0).getCsbz();
			fhr=ls.get(0).getFhr();
			fhyj=ls.get(0).getFhbz();
			Map<String, Object> jktzmap1 = new HashMap<String, Object>();
			jktzmap1.put("slbh", ls.get(0).getSlbh());
			List<Jktzs> jklist=jktzsService.findByAll(jktzmap1);
			if(null!=jklist&&jklist.size()>0){
				Jktzs jk = jklist.get(0);
				yjfy=jk.getJfje();
				map.put("ghxkzbh",jk.getGhxkz()); //规划许可证编号
				map.put("jfmj",jk.getJfmj()); //缴费面积
				map.put("jfje",jk.getJfje()); //缴费金额
				map.put("mjmj",jk.getMjmj()); //免缴面积
				map.put("mjje",jk.getMjje()); //免缴金额
				map.put("qtfy",jk.getRfyj()); //其他费用
				map.put("jktzsbh",jk.getDzbh());//缴款通知书编号
			}


		}
		map.put("csr", csr);
		map.put("csyj", csyj);
		map.put("fhr", fhr);
		map.put("fhyj", fhyj);
		map.put("yjfy", yjfy);
		if("001".equals(xmxxb.getMjyj())||"005".equals(xmxxb.getMjyj()))
		{
			map.put("isneed","yes");
		}else
		{
			map.put("isneed","no");
		}

		map.put("key",String.valueOf((new Date().getTime()*6+1)/7));
		map.put("method","xxsyncpz");
		String dwdm = "";
		if (!this.getLoginUser().getIsSuperAdmin())
		{
			dwdm =StringUtil.isEmpty(xmxxb.getDwdm())? zsdwService.getDwdm(this.getLoginUserDepartmentId()):xmxxb.getDwdm();
		}
//		String result3 =  CommonAction.send2wwSGXK(xmxxb,null,dwdm,map);//arvin1122
		String result3 = "true";
//		String result3 = com.jshx.module.admin.web.action.CommonAction.send2ww(map,null);
		if(StringUtil.isEmpty(result3)||"false".equals(result3)) {

			this.getResponse().getWriter().println("{\"result1\":\"false\",\"info\":\"同步失败！\"}");
			return;
		}
		else if("true".equals(result3))
		{
			//更新表字段isSync为yes
			wwjdclinfo2.setIsSync("yes");
			wwjdclinfoService.update(wwjdclinfo2);
			/*if(paymentItemHis.getYzsFlag() == 2){
				savePaymentVerification(xmxxb, paymentItemHis);
			}*/
			HashMap<String, Object> rfxmParam = new HashMap<>();
			rfxmParam.put("paymentHisId",paymentItemHis.getId());
			List<Rfxm> rfxmList = rfxmService.findRfxm(rfxmParam);
			if(rfxmList != null && rfxmList.size() > 0) {//同步成功记录下，不允许再次同步了
				Rfxm rfxm = rfxmList.get(0);
				rfxm.setIsTb(1);
				rfxmService.update(rfxm);
			}
			this.getResponse().getWriter().println("{\"result1\":\"true\",\"info\":\"查询成功\"}");
			return ;
		}
	}

	/*private void savePaymentVerification(Xmxxb xmxxb,PaymentItemHis paymentItemHis) {
		PaymentVerification model = new PaymentVerification();
		model.setDelFlag(0);
		model.setDeptId(xmxxb.getDeptId());
		model.setXxbbh(xmxxb.getId());
		model.setXxylb(xmxxb.getXxylb());
		model.setGhxkzbh(xmxxb.getXkzh());
		model.setGhxmbh(xmxxb.getXmbh());
		model.setJfpzbh(paymentItemHis.getZslxdbh());
		model.setJsdwmc(xmxxb.getJsdw());
		model.setGcxmmc(xmxxb.getXmmc());
		model.setStatusCnjfhj(xmxxb.getPaymentLink());
//		model.setJktzsbh(paymentItemHis.getECN());
		model.setSecondUnit(xmxxb.getZsfw());
		model.setVerifyStatus("0");
		model.setSfxxIds("");

		model.setXmdm(xmxxb.getLxpw());
//		model.setGcxmdd();
		paymentVerificationService.save(model);
		Kpsjgl kp=kpsjglService.findbygllb("001");
		zsdw = kp.getZsdw();
		zsdwbm = kp.getZsdwbm();
		qhm = kp.getQhm();
		skrqc = kp.getKrqc();
		skrzh = kp.getSkrzh();
		skrkhh = kp.getSkrkhh();
		xmbm = kp.getXmbm();
		srxmmc = kp.getSrxmmc();
		PaymentVerifyCharge charge = new PaymentVerifyCharge();
		charge.setSfxmmc(kp.getSrxmmc());
		charge.setSfxmlxdbh(paymentItemHis.getECN());
		charge.setKhyh(kp.getSkrkhh());
		charge.setSkrzh(kp.getSkrzh());
		charge.setYjjemx(paymentItemHis.getPtyjje());
		charge.setShbm(kp.getZsdw());
		charge.setCnjfhj(xmxxb.getPaymentLink()+"");
		charge.setZzhxmid(model.getId());
		paymentVerifyChargeService.save(charge);
	}*/


	public String getIds(){
		return ids;
	}

	public void setIds(String ids){
		this.ids = ids;
	}

	public Pagination getPagination(){
		return pagination;
	}

	public void setPagination(Pagination pagination){
		this.pagination = pagination;
	}
	
	public Xmxxb getXmxxb() {
		return xmxxb;
	}

	public void setXmxxb(Xmxxb xmxxb) {
		this.xmxxb = xmxxb;
	}

	public AccountBank getAccountBank(){
		return this.accountBank;
	}

	public void setAccountBank(AccountBank accountBank){
		this.accountBank = accountBank;
	}
	
	public PaymentItemHis getPaymentItemHis() {
		return paymentItemHis;
	}

	public void setPaymentItemHis(PaymentItemHis paymentItemHis) {
		this.paymentItemHis = paymentItemHis;
	}
	
	public PaymentVoucherHis getPaymentVoucherHis() {
		return paymentVoucherHis;
	}

	public void setPaymentVoucherHis(PaymentVoucherHis paymentVoucherHis) {
		this.paymentVoucherHis = paymentVoucherHis;
	}

	public String getFlag(){
		return flag;
	}

    public void setFlag(String flag){
        this.flag = flag;
    }
       
    
	public Date getQueryArrivalTimeStart(){
		return this.queryArrivalTimeStart;
	}

	public void setQueryArrivalTimeStart(Date queryArrivalTimeStart){
		this.queryArrivalTimeStart = queryArrivalTimeStart;
	}

	public Date getQueryArrivalTimeEnd(){
		return this.queryArrivalTimeEnd;
	}

	public void setQueryArrivalTimeEnd(Date queryArrivalTimeEnd){
		this.queryArrivalTimeEnd = queryArrivalTimeEnd;
	}

	public String getTaskId() {
		return taskId;
	}

	public void setTaskId(String taskId) {
		this.taskId = taskId;
	}

	public String getOutcome() {
		return outcome;
	}

	public void setOutcome(String outcome) {
		this.outcome = outcome;
	}

	public String getResult() {
		return result;
	}

	public void setResult(String result) {
		this.result = result;
	}

	public String getComment() {
		return comment;
	}

	public void setComment(String comment) {
		this.comment = comment;
	}
	
	public String getZslxdbh() {
		return zslxdbh;
	}

	public void setZslxdbh(String zslxdbh) {
		this.zslxdbh = zslxdbh;
	}

	public String getOrderId() {
		return orderId;
	}

	public void setOrderId(String orderId) {
		this.orderId = orderId;
	}


	public String getId() {
		return id;
	}


	public void setId(String id) {
		this.id = id;
	}


	public String getECN() {
		return ECN;
	}


	public void setECN(String eCN) {
		ECN = eCN;
	}

	public String getAmount_CN() {
		return amount_CN;
	}

	public void setAmount_CN(String amount_CN) {
		this.amount_CN = amount_CN;
	}

	public Main getMain() {
		return main;
	}

	public void setMain(Main main) {
		this.main = main;
	}

	public String getCurrentDate() {
		return currentDate;
	}

	public void setCurrentDate(String currentDate) {
		this.currentDate = currentDate;
	}
	
	public String getZsdw() {
		return zsdw;
	}

	public void setZsdw(String zsdw) {
		this.zsdw = zsdw;
	}

	public String getZsdwbm() {
		return zsdwbm;
	}

	public void setZsdwbm(String zsdwbm) {
		this.zsdwbm = zsdwbm;
	}

	public String getQhm() {
		return qhm;
	}

	public void setQhm(String qhm) {
		this.qhm = qhm;
	}

	public String getSkrqc() {
		return skrqc;
	}

	public void setSkrqc(String skrqc) {
		this.skrqc = skrqc;
	}

	public String getSkrzh() {
		return skrzh;
	}

	public void setSkrzh(String skrzh) {
		this.skrzh = skrzh;
	}

	public String getSkrkhh() {
		return skrkhh;
	}

	public void setSkrkhh(String skrkhh) {
		this.skrkhh = skrkhh;
	}
	
	public String getXmbm() {
		return xmbm;
	}

	public void setXmbm(String xmbm) {
		this.xmbm = xmbm;
	}

	public String getSrxmmc() {
		return srxmmc;
	}

	public void setSrxmmc(String srxmmc) {
		this.srxmmc = srxmmc;
	}

	public Mjyj getMjyj() {
		return mjyj;
	}

	public void setMjyj(Mjyj mjyj) {
		this.mjyj = mjyj;
	}

	public Zsdw getZsdwxx() {
		return zsdwxx;
	}

	public void setZsdwxx(Zsdw zsdwxx) {
		this.zsdwxx = zsdwxx;
	}

	public Jktzs getJktzs() {
		return jktzs;
	}

	public void setJktzs(Jktzs jktzs) {
		this.jktzs = jktzs;
	}

	public String getDwmc() {
		return dwmc;
	}

	public void setDwmc(String dwmc) {
		this.dwmc = dwmc;
	}

	public String getVoucherCode() {
		return voucherCode;
	}

	public void setVoucherCode(String voucherCode) {
		this.voucherCode = voucherCode;
	}

	public String getMode() {
		return mode;
	}

	public void setMode(String mode) {
		this.mode = mode;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public PaymentItemDelayHis getPaymentItemDelayHis() {
		return paymentItemDelayHis;
	}

	public void setPaymentItemDelayHis(PaymentItemDelayHis paymentItemDelayHis) {
		this.paymentItemDelayHis = paymentItemDelayHis;
	}

	public String getIsDelay() {
		return isDelay;
	}

	public void setIsDelay(String isDelay) {
		this.isDelay = isDelay;
	}

	public String getXmsl() {
		return xmsl;
	}

	public void setXmsl(String xmsl) {
		this.xmsl = xmsl;
	}

	public String getXmje() {
		return xmje;
	}

	public void setXmje(String xmje) {
		this.xmje = xmje;
	}

	public String getZfbz() {
		return zfbz;
	}

	public void setZfbz(String zfbz) {
		this.zfbz = zfbz;
	}

	public String getPayType() {
		return payType;
	}

	public void setPayType(String payType) {
		this.payType = payType;
	}

	public String getPayMethod() {
		return payMethod;
	}

	public void setPayMethod(String payMethod) {
		this.payMethod = payMethod;
	}

	public String getJkqc() {
		return jkqc;
	}

	public void setJkqc(String jkqc) {
		this.jkqc = jkqc;
	}

	public String getPjhm() {
		return pjhm;
	}

	public void setPjhm(String pjhm) {
		this.pjhm = pjhm;
	}

	public String getCsptf() {
		return csptf;
	}

	public void setCsptf(String csptf) {
		this.csptf = csptf;
	}

    public Lxrinfo getLxrinfo() {
        return lxrinfo;
    }

    public void setLxrinfo(Lxrinfo lxrinfo) {
        this.lxrinfo = lxrinfo;
    }

	public File getFile() {
		return file;
	}

	public void setFile(File file) {
		this.file = file;
	}

	public List<Wwjdclinfo> getWwjdclinfos() {
		return wwjdclinfos;
	}

	public void setWwjdclinfos(List<Wwjdclinfo> wwjdclinfos) {
		this.wwjdclinfos = wwjdclinfos;
	}

	public Rfxm getRfxm() {
		return rfxm;
	}

	public void setRfxm(Rfxm rfxm) {
		this.rfxm = rfxm;
	}
}
