package com.jshx.account.accountBank.web;

import com.jshx.core.base.dao.BaseDao;
import com.jshx.module.admin.service.UserRoleService;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.servlet.http.HttpServletResponse;

import org.activiti.engine.IdentityService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.multipart.MultiPartRequestWrapper;
import org.hibernate.LobHelper;
import org.hibernate.SessionFactory;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.transaction.annotation.Transactional;

import net.sf.json.JSONArray;
import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;

import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.exception.BasalException;
import com.jshx.core.utils.StringUtil;
import com.jshx.core.utils.SysPropertiesUtil;
import com.jshx.dxpz.service.DxpzService;
import com.jshx.module.admin.entity.User;
import com.jshx.module.admin.web.action.CommonAction;
import com.jshx.paymentItemHis.entity.PaymentItemHis;
import com.jshx.paymentItemHis.service.PaymentItemHisService;
import com.jshx.paymentItemPending.entity.PaymentItemPending;
import com.jshx.paymentItemPending.service.PaymentItemPendingService;
import com.jshx.xmxxb.entity.Xmxxb;
import com.jshx.xmxxb.service.XmxxbService;
import com.opensymphony.xwork2.ActionContext;
import com.sun.xml.internal.bind.v2.runtime.reflect.opt.Const;
import com.jshx.core.json.CodeJsonValueProcessor;
import com.jshx.core.json.DateJsonValueProcessor;
import com.jshx.account.accountBank.entity.AccountBank;
import com.jshx.account.accountBank.entity.AccountBankAttach;
import com.jshx.account.accountBank.service.AccountBankAttachService;
import com.jshx.account.accountBank.service.AccountBankService;
import com.jshx.account.paymentVoucher.entity.PaymentVoucher;
import com.jshx.account.paymentVoucher.service.PaymentVoucherService;
import com.jshx.activiti.service.ActivitiService;
import com.jshx.common.utils.Constant;
import com.jshx.common.utils.FileUtils;

public class AccountBankAction extends BaseAction
{

	/**主键ID，用于接收页面提交的主键ID
	 * 
	 */
	private String id;
	
	/**
	 * 主键ID列表，用于接收页面提交的多条主键ID信息
	 */
	private String ids;

	/**
	 * 实体类
	 */
	private AccountBank accountBank = new AccountBank();
	
	private PaymentItemPending paymentItemPending = new PaymentItemPending();
	
	private PaymentItemHis paymentItemHis = new PaymentItemHis();
	
	private List<AccountBank> list = new ArrayList<AccountBank>(); 

	private Xmxxb xmxxb = new Xmxxb();
	/**
	 * 业务类
	 */
	@Autowired
	private AccountBankService accountBankService;
	
	@Autowired
	private AccountBankAttachService accountBankAttachService;
	
	@Autowired
	private PaymentVoucherService paymentVoucherService;
	
	@Autowired
	private PaymentItemPendingService paymentItemPendingService;
	
	@Autowired
	private PaymentItemHisService paymentItemHisService;
	
	@Autowired
    private IdentityService identityService;
	
	@Autowired
    protected RuntimeService runtimeService;
	
    @Autowired
    protected TaskService taskService;
    
    @Autowired
    private ActivitiService activitiService;
    
    @Autowired
    private XmxxbService xmxxbService;

    @Autowired
		private DxpzService dxpzService;

    @Autowired
		private UserRoleService userRoleService;

	/**
	 * 修改新增标记，add为新增、mod为修改
	 */
	private String flag;

	/**
	 * 分页信息
	 */
	private Pagination pagination;
	
	
	private Date queryArrivalTimeStart;

	private Date queryArrivalTimeEnd;
	
	private String taskId;
	
	private String result;

	private String outcome;
	
	@Autowired()
	@Qualifier("sessionFactory")
	private SessionFactory sessionFactory;

	private String comment;

	private String orderId;
	
	private String uploadifyFileName;

	private File uploadify;

	private String allFileName;

	private String originFileName;

	private List<AccountBankAttach> attach;

	private String attachId;

	private String downFileName;
	
	private InputStream downFileStream;
	
	private Double amount;

	private String orderIds;
	
	private String arrivalTime;

	private File file;
	
	/**
	 * 执行查询的方法，返回json数据
	 */
	public void list() throws Exception{
		//根据角色获取子系统类型
		String type = userRoleService.childSysType(getLoginUser());

		Map<String, Object> paraMap = new HashMap<String, Object>();

		paraMap.put("sysType",type);

		if(pagination==null)
		    pagination = new Pagination(this.getRequest());
		    
		if(null != accountBank){
		    //设置查询条件，开发人员可以在此增加过滤条件
			if ((null != accountBank.getDevelopUnit()) && (0 < accountBank.getDevelopUnit().trim().length())){
				paraMap.put("developUnit", "%" + accountBank.getDevelopUnit().trim() + "%");
			}
			if (null != queryArrivalTimeStart){
				paraMap.put("queryArrivalTimeStart", queryArrivalTimeStart);
			}

			if (null != queryArrivalTimeEnd){
				paraMap.put("queryArrivalTimeEnd", queryArrivalTimeEnd);
			}
			
			if ((null != accountBank.getHasInvoice()) && (0 < accountBank.getHasInvoice().trim().length())){
				paraMap.put("hasInvoice", accountBank.getHasInvoice());
			}
			
			if ((null != accountBank.getStatus()) && (0 < accountBank.getStatus().trim().length())){
				paraMap.put("status", accountBank.getStatus());
			}
			
			//查询未审核的银行到账信息
			//paraMap.put("status", Constant.AUDIT_STATUS_NO);
		}
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(java.util.Date.class,new DateJsonValueProcessor());  
		Map<String, String> codeMap = new HashMap<String, String>();
		//此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId
		
		config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap)); 
		final String filter = "id|developUnit|amount|arrivalTime|hasInvoice|status|";
		if (filter != null && filter.length() > 1) {
			config.setJsonPropertyFilter(new PropertyFilter() {
				public boolean apply(Object source, String name, Object value) {
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		pagination = accountBankService.findByPage(pagination, paraMap);
		
		convObjectToJson(pagination, config);
	}

	/**
	 * 查看详细信息
	 */
	public String view() throws Exception{
		Map<String, String> paramMap = new HashMap<String, String>();
		if((null != accountBank)&&(null != accountBank.getId())){
			accountBank = accountBankService.getById(accountBank.getId());
			paramMap.put("bizrowid", accountBank.getId());
			setAttach(accountBankAttachService.queryAttachListByTempleId(paramMap));
		}
		return VIEW;
	}

	/**
	 * 初始化修改信息
	 */
	public String initEdit() throws Exception{
		if("add".equalsIgnoreCase(this.flag)){
			accountBank.setArrivalTime(new Date());
			SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
			arrivalTime = format.format(new Date());
		}
		view();
	    return EDIT;
	}

	/**
	 * 保存信息（包括新增和修改）
	 */
	public String save() throws Exception{
		String path = "";
		String fileName = "";
		if(null!=file && null!=originFileName){
			/*path = this.getRequest().getSession().getServletContext()
					.getRealPath(File.separator)
					+ File.separator+ "uploads" + File.separator + Constant.ACCOUNT_BANK + File.separator;*/
			path = SysPropertiesUtil.jdlj(this.getRequest()) + File.separator + "uploads" + File.separator + Constant.ACCOUNT_BANK + File.separator;
			fileName = FileUtils.uploadFile(file,originFileName, path,UUID.randomUUID().toString());
		}

		//保存和更新时添加子系统类型
		String type = userRoleService.childSysType(getLoginUser());
		accountBank.setSysType(type);

		if ("add".equalsIgnoreCase(this.flag)){
			accountBank.setDeptId(this.getLoginUserDepartmentId());
			accountBank.setDelFlag(0);
			//银行到账审核状态 初始化未审核
			accountBank.setStatus(Constant.AUDIT_STATUS_NO);
			accountBankService.save(accountBank,fileName,originFileName);
		}else{
			accountBankService.update(accountBank,fileName,originFileName);
		}
		
		return RELOAD;
	}

	/**
	 * 将File对象转换为Blob对象，并设置到实体类中
	 * 如果没有File对象，可删除此方法，并一并删除save方法中调用此方法的代码
	 */
	private void setBlobField(FileInputStream in)
	{
		if (null != accountBank)
		{
			try
			{
				//此处将File对象转换成blob对象，并设置到accountBank中去
				
            }
            catch (Exception ex)
            {
                ex.printStackTrace();
            }
        }
    }

	/**
	 * 删除信息
	 */
	public String delete() throws Exception{
	    try{
			accountBankService.deleteWithFlag(ids);
			this.getResponse().getWriter().println("{\"result\":true}");
		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}
	
	/**
     * 指定跳转财务办理页面（目标URL）
     * @return
     */
    public String toConfirm() {
        return SUCCESS;
    }
    
    /**
     * 财务办理页
     * @return
     */
    public String deal(){
    	String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
			    {
			    	AccountBank accountBank = accountBankService.getById(id);
			    	Map<String, String> paramMap = new HashMap<String, String>();
			    	accountBank = accountBankService.getById(accountBank.getId());
					paramMap.put("bizrowid", accountBank.getId());
					List<AccountBankAttach> attach = accountBankAttachService.queryAttachListByTempleId(paramMap);
					accountBank.setAttach(attach);
					list.add(accountBank);
			    }
			}
		}
    	return SUCCESS;
    }
    
    /**
     * 财务确认最终确认页
     * @return
     */
    public String operate(){
    	return SUCCESS;
    }
    
    /**
     * 财务修改到账金额
     * @throws Exception 
     */
    public void updateAmount() throws Exception{
    	try{
            accountBank= accountBankService.getById(id);
            accountBank.setAmount(amount);
            accountBankService.update(accountBank);
            this.getResponse().getWriter().println("{\"result\":true}");
    	}catch(Exception e){
    		this.getResponse().getWriter().println("{\"result\":false}");
    	}
    	 
    }
    

    /**
     * 待缴款财务确认提交
     * @throws Exception
     */
    public void submitConfirmPending() throws Exception{
        try {
        	//拆分多条待缴费项目信息
    		String[] orderIdArray = orderIds.split("\\|");
    		if(null != orderIdArray)
    		{
    			for(String orderId : orderIdArray)
    			{
    			    if(orderId!=null && !orderId.trim().equals(""))
    			    {
    			    	accountBankService.accountConfirmPending(orderId, ids, outcome, this.getLoginUser().getId(), identityService, runtimeService);
    			    }
    			}
    		}
        	this.getResponse().getWriter().println("{\"result\":true}");
        }catch (Exception e) {
        	logger.error(e.getMessage());
        	this.getResponse().getWriter().println("{\"result\":false}");
        }
    }
    
    /**
     * 缓缴款财务确认提交
     * @throws Exception
     */
    public void submitConfirmDelay() throws Exception{
        try {
		    if(null != orderId && !orderId.trim().equals(""))
		    {
		    	accountBankService.accountConfirmDelay(orderId, ids, this.getLoginUser().getLoginId(), identityService, runtimeService);
		    }
        	this.getResponse().getWriter().println("{\"result\":true}");
        }catch (Exception e) {
        	logger.error(e.getMessage());
        	this.getResponse().getWriter().println("{\"result\":false}");
        }
    }
    
    /**
     * 指定跳转预确认经办页面（目标URL）
     * @return
     */
    public String toHandle(){
    	 Task task  = taskService.createTaskQuery().taskId(taskId).singleResult();
         ProcessInstance processInstance = runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
         String businessKey =  processInstance.getBusinessKey();
         paymentItemHis = paymentItemHisService.getByXmbId(businessKey);
         xmxxb = xmxxbService.getById(paymentItemHis.getXmbzj());
         
         if(null!=xmxxb&&null!=paymentItemHis){
        	 
         String neirong=xmxxb.getSlbh()+"_"+SysPropertiesUtil.qwfgf(String.valueOf(paymentItemHis.getZyjje()))+"已到账,无凭证,请予办理";
     	String phones=dxpzService.findbyywbm("005",xmxxb.getDwdm());
	     if(!"".equals(phones)){
//		      CommonAction.send(neirong, phones, this.getLoginUserDepartmentId(),this.getLoginUser().getDisplayName());
		      CommonAction.sendNewMessage(neirong, phones, this.getLoginUserDepartmentId(),this.getLoginUser().getDisplayName());
	     }
         }
         List<String> outcomeList = activitiService.findOutComeListByTaskId(taskId);
         ActionContext.getContext().put("outcomeList", outcomeList);
         return SUCCESS;
    }
    
    public String viewAccountBank(){
    	if(null != ids && !"".equals(ids.trim())){
	    	String[] idArray = ids.split("\\|");
			if(null != idArray)
			{
				for(String id : idArray)
				{
				    if(id!=null && !id.trim().equals(""))
				    {
				    	//将银行到账信息状态置为已审核
				    	AccountBank accountBank = accountBankService.getById(id);
				    	if(null!=accountBank){
				    		list.add(accountBank);
				    	}
				    }
				}
			}
    	}
		return SUCCESS;
    }
    
    /**
     * 预确认经办提交办理
     * @throws Exception
     */
    public void submitHandle() throws Exception{
        try {
            Task task = taskService.createTaskQuery().taskId(taskId).singleResult();
            activitiService.addComment(task, this.getLoginUser().getLoginId(), comment);
            Map<String, Object> variables = new HashMap<String, Object>();
            variables.put("outcome", outcome);
            taskService.complete(taskId, variables);
            this.getResponse().getWriter().println("{\"result\":true}");
        }catch (Exception e) {
            this.getResponse().getWriter().println("{\"result\":false}");
        }
    }
    
    /**
     * 指定跳转预确认复核页面（目标URL）
     * @return
     */
    public String toCheck(){
    	 Task task  = taskService.createTaskQuery().taskId(taskId).singleResult();
         ProcessInstance processInstance = runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
         String businessKey =  processInstance.getBusinessKey();
         paymentItemHis = paymentItemHisService.getByXmbId(businessKey);
         xmxxb = xmxxbService.getById(paymentItemHis.getXmbzj());
         List<String> outcomeList = activitiService.findOutComeListByTaskId(taskId);
         ActionContext.getContext().put("outcomeList", outcomeList);
         return SUCCESS;
    }
    
    /**
     * 预确认复核提交办理
     * @throws Exception
     */
    public void submitCheck() throws Exception{
        try {
            Task task = taskService.createTaskQuery().taskId(taskId).singleResult();
            activitiService.addComment(task, this.getLoginUser().getLoginId(), comment);
            Map<String, Object> variables = new HashMap<String, Object>();
            variables.put("outcome", outcome);
            taskService.complete(taskId, variables);
            this.getResponse().getWriter().println("{\"result\":true}");
        }catch (Exception e) {
            this.getResponse().getWriter().println("{\"result\":false}");
        }
    }
    
    /**
     * 指定跳转预确认审核页面（目标URL）
     * @return
     */
    public String toAudit(){
    	 Task task  = taskService.createTaskQuery().taskId(taskId).singleResult();
         ProcessInstance processInstance = runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
         String businessKey =  processInstance.getBusinessKey();
         paymentItemHis = paymentItemHisService.getByXmbId(businessKey);
         xmxxb = xmxxbService.getById(paymentItemHis.getXmbzj());
         List<String> outcomeList = activitiService.findOutComeListByTaskId(taskId);
         ActionContext.getContext().put("outcomeList", outcomeList);
         return SUCCESS;
    }
    
    /**
     * 预确认审核提交办理
     * @throws Exception
     */
    public void submitAudit() throws Exception{
        try {
            Task task = taskService.createTaskQuery().taskId(taskId).singleResult();
            ProcessInstance processInstance = runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
            String businessKey =  processInstance.getBusinessKey();
            activitiService.addComment(task, this.getLoginUser().getLoginId(), comment);
            //审批通过则允许打印一般缴款通知书
            if(Constant.OUTCOME_PASS.equals(outcome)){
            	paymentItemHis = paymentItemHisService.getByXmbId(businessKey);
            	paymentItemHis.setPrintFlag(Constant.PRINT_PRIV);
            	paymentItemHisService.update(paymentItemHis);
            }
            Map<String, Object> variables = new HashMap<String, Object>();
            variables.put("outcome", outcome);
            taskService.complete(taskId, variables);
            this.getResponse().getWriter().println("{\"result\":true}");
        }catch (Exception e) {
            this.getResponse().getWriter().println("{\"result\":false}");
        }
    }
    
    /**
	 * 上传文件
	 * @return
	 */
	public void uploadify() throws IOException {
		int pos = uploadifyFileName.lastIndexOf(".");
		String extension = uploadifyFileName.substring(pos);
		String filepath = SysPropertiesUtil.getProperty("filePath") + File.separator + Constant.ACCOUNT_BANK;
		String newName = UUID.randomUUID().toString().replaceAll("-", "")
				.toLowerCase()
				+ extension;
		File newfile = new File(ServletActionContext.getServletContext()
				.getRealPath("/" + filepath));
		
		if(!newfile.exists())
		{
			newfile.mkdirs();
		}
		File destFile = new File(newfile+"/"+newName);
		copy(uploadify, destFile);
		getResponse().getWriter().println(newName);
	}
	
	/**
	 * 复制文件
	 * @param src
	 * @param dst
	 */
	private void copy(File src, File dst) {
		try {
			InputStream in = null;
			OutputStream out = null;
			try {
				in = new BufferedInputStream(new FileInputStream(src));
				out = new BufferedOutputStream(new FileOutputStream(dst));
				byte[] buffer = new byte[1024];
				int byteRead = -1;
				while ((byteRead = in.read(buffer)) != -1) 
				{
					out.write(buffer, 0, byteRead);
				}
				// 刷新此缓冲的输出流
				out.flush();
			} finally {
				if (in != null) {
					in.close();
				}
				if (out != null) {
					out.close();
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
    
	/**
	 * 下载附件文件
	 * @param filePath
	 * @return
	 */
	public String downloadFile() {

		if (StringUtil.isNotEmpty(attachId) ) {
			try {
				AccountBankAttach accountBankAttach = accountBankAttachService.getById(attachId);
				if (null != accountBankAttach) {
					//服务器路径,创建文件夹
					 // 得到当前路径  
					String filename = accountBankAttach.getAttachpath();
	                String cc = this.getRequest().getSession().getServletContext()
							.getRealPath(File.separator);
			        File ff = new File(cc);
			        String ab=ff.getParent();
			        String url=new File(ab).getParent()+File.separator+ "uploads" + File.separator + Constant.ACCOUNT_BANK + File.separator+ filename;
	                url = url.replaceAll("\\\\","/").trim();
	                File file = new File(url);
					downFileName = java.net.URLEncoder.encode(accountBankAttach.getAttachname(), "UTF-8");
					InputStream inputStream = null;
					byte[] contents = null;
					try {
						inputStream = new FileInputStream(file);
						contents = new byte[inputStream.available()];
						inputStream.read(contents);
					} catch (FileNotFoundException e) {
						logger.error(e.getMessage());
						return ERROR;
					} catch (IOException e) {
						logger.error(e.getMessage());
					}
					downFileStream = getDownLoadFileStream(contents);
				}
			} catch (Exception ex) {
				logger.error(ex.toString());
			}
		}
		return SUCCESS;
	}
	
	/**
	 * 将文件转换成输入流，提供struts下载参数
	 * @param fileName 需要下载的文件路径
	 * @return
	 */
	public InputStream getDownLoadFileStream(byte[] bytes) {
		try {
			//将得到的字节输出流转换成字节数组——>字节输入流
			downFileStream = new ByteArrayInputStream(bytes);
		} catch (Exception e) {
			return null;
		}
		return downFileStream;
	}
	
	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getIds(){
		return ids;
	}

	public void setIds(String ids){
		this.ids = ids;
	}

	public Pagination getPagination(){
		return pagination;
	}

	public void setPagination(Pagination pagination){
		this.pagination = pagination;
	}

	public AccountBank getAccountBank(){
		return this.accountBank;
	}

	public void setAccountBank(AccountBank accountBank){
		this.accountBank = accountBank;
	}

	public String getFlag(){
		return flag;
	}

    public void setFlag(String flag){
        this.flag = flag;
    }
       
    
	public Date getQueryArrivalTimeStart(){
		return this.queryArrivalTimeStart;
	}

	public void setQueryArrivalTimeStart(Date queryArrivalTimeStart){
		this.queryArrivalTimeStart = queryArrivalTimeStart;
	}

	public Date getQueryArrivalTimeEnd(){
		return this.queryArrivalTimeEnd;
	}

	public void setQueryArrivalTimeEnd(Date queryArrivalTimeEnd){
		this.queryArrivalTimeEnd = queryArrivalTimeEnd;
	}

	public String getTaskId() {
		return taskId;
	}

	public void setTaskId(String taskId) {
		this.taskId = taskId;
	}

	public String getOutcome() {
		return outcome;
	}

	public void setOutcome(String outcome) {
		this.outcome = outcome;
	}

	public String getResult() {
		return result;
	}

	public void setResult(String result) {
		this.result = result;
	}

	public String getComment() {
		return comment;
	}

	public void setComment(String comment) {
		this.comment = comment;
	}
	
	public String getOrderId() {
		return orderId;
	}

	public void setOrderId(String orderId) {
		this.orderId = orderId;
	}

	public String getUploadifyFileName() {
		return uploadifyFileName;
	}

	public void setUploadifyFileName(String uploadifyFileName) {
		this.uploadifyFileName = uploadifyFileName;
	}

	public File getUploadify() {
		return uploadify;
	}

	public void setUploadify(File uploadify) {
		this.uploadify = uploadify;
	}
	
	public String getAllFileName() {
		return allFileName;
	}

	public void setAllFileName(String allFileName) {
		this.allFileName = allFileName;
	}

	public String getOriginFileName() {
		return originFileName;
	}

	public void setOriginFileName(String originFileName) {
		this.originFileName = originFileName;
	}

	public List<AccountBankAttach> getAttach() {
		return attach;
	}

	public void setAttach(List<AccountBankAttach> attach) {
		this.attach = attach;
	}

	public String getAttachId() {
		return attachId;
	}

	public void setAttachId(String attachId) {
		this.attachId = attachId;
	}

	public String getDownFileName() {
		return downFileName;
	}

	public void setDownFileName(String downFileName) {
		this.downFileName = downFileName;
	}

	public InputStream getDownFileStream() {
		return downFileStream;
	}

	public void setDownFileStream(InputStream downFileStream) {
		this.downFileStream = downFileStream;
	}

	public Double getAmount() {
		return amount;
	}

	public void setAmount(Double amount) {
		this.amount = amount;
	}

	public List<AccountBank> getList() {
		return list;
	}

	public void setList(List<AccountBank> list) {
		this.list = list;
	}
	
	public String getOrderIds() {
		return orderIds;
	}

	public void setOrderIds(String orderIds) {
		this.orderIds = orderIds;
	}
	
	public PaymentItemPending getPaymentItemPending() {
		return paymentItemPending;
	}

	public void setPaymentItemPending(PaymentItemPending paymentItemPending) {
		this.paymentItemPending = paymentItemPending;
	}
	
	public PaymentItemHis getPaymentItemHis() {
		return paymentItemHis;
	}

	public void setPaymentItemHis(PaymentItemHis paymentItemHis) {
		this.paymentItemHis = paymentItemHis;
	}

	public String getArrivalTime() {
		return arrivalTime;
	}

	public void setArrivalTime(String arrivalTime) {
		this.arrivalTime = arrivalTime;
	}

	public File getFile() {
		return file;
	}

	public void setFile(File file) {
		this.file = file;
	}

	public Xmxxb getXmxxb() {
		return xmxxb;
	}

	public void setXmxxb(Xmxxb xmxxb) {
		this.xmxxb = xmxxb;
	}
	
}
