/**
 * Copyright 2013 hongxin 
 * Change Revision
 * ---------------------------------------------------------------
 * Date               Author            Remarks
 * 2013-5-13          YuWeitao          create
 * ---------------------------------------------------------------
 */
package com.jshx.activiti.service.identity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.jshx.activiti.util.ActivitiUtils;
import com.jshx.core.base.vo.Pagination;
import com.jshx.module.admin.entity.Department;
import com.jshx.module.admin.service.DeptService;
import org.activiti.engine.identity.Group;
import org.activiti.engine.impl.GroupQueryImpl;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.persistence.entity.GroupEntity;
import org.activiti.engine.impl.persistence.entity.GroupEntityManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.jshx.module.admin.entity.User;
import com.jshx.module.admin.entity.UserRole;
import com.jshx.module.admin.service.UserRoleService;
import com.jshx.module.admin.service.UserService;

/**  
 * 自定义Activiti用户组管理类
 * 
 * @author   YuWeitao
 * @version  创建时间：2013-5-13  15:32:01
 * 
 */
@Service  
public class CustomGroupEntityManager extends GroupEntityManager {   
    @Autowired
    private UserService userService; 
    
    @Autowired
    private UserRoleService userRoleService;

    @Autowired
    private DeptService deptService;

    @Override
    public List<Group> findGroupByQueryCriteria(GroupQueryImpl query, Page page) {
        int pageNumb, pageSize;
        pageNumb = page.getFirstResult()/page.getMaxResults()+1;
        pageSize = page.getMaxResults();
        Map<String, Object> map = new HashMap<>();
        if(query.getName()!=null){
            map.put("roleName", query.getName());
        }
        Pagination pagination = new Pagination(pageNumb, pageSize);
        pagination = userRoleService.listUserRoleByPage(pagination, map);
        List<UserRole> roleList = pagination.getListOfObject();
        List<Group> groupList = new ArrayList<>();
        if(roleList!=null){
            for(UserRole role: roleList){
                GroupEntity groupEntity = ActivitiUtils.toActivitiGroup(role);
                groupList.add(groupEntity);
            }
        }
        return groupList;
    }

    @Override
    public long findGroupCountByQueryCriteria(GroupQueryImpl query) {
        Map<String, Object> map = new HashMap<>();
        if(query.getName()!=null){
            map.put("roleName", query.getName());
        }
        return userRoleService.countRole(map);
    }


    @Override
    public List<Group> findGroupsByNativeQuery(Map<String, Object> parameterMap, int firstResult, int maxResults) {
        return null;
    }

    @Override
    public long findGroupCountByNativeQuery(Map<String, Object> parameterMap) {
        return -1;
    }
  
    @Override  
    public List<Group> findGroupsByUser(final String userName) {
        if (userName == null)
            return null;
        User user = userService.findUserByLoginId(userName);
    	Map<String, Object> paraMap = new HashMap<String, Object>();
    	paraMap.put("userId", user.getId());
    	List<UserRole> userRoleList = userRoleService.findUserRole(paraMap);
        List<Group> gs = new ArrayList<Group>();   
        GroupEntity groupEntity;   
        for (UserRole userRole : userRoleList) {   
        	groupEntity = new GroupEntity();   
        	groupEntity.setRevision(1);   
        	groupEntity.setType("assignment");   
  
        	groupEntity.setId(userRole.getRoleName());   //taskCandidateUser等方法是通过groupEntity.id来查询的，对应流程定义文件中的activiti:candidateGroups等值
        	groupEntity.setName(userRole.getRoleName());   
            gs.add(groupEntity);   
        }   
        return gs;   
    }
}  
