package com.jshx.activiti.cmd;

import org.activiti.bpmn.converter.BpmnXMLConverter;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.ResourceEntity;
import org.activiti.engine.impl.util.io.BytesStreamSource;
import org.activiti.engine.repository.Deployment;

import java.io.InputStream;
import java.io.Serializable;

/**
 * 获取BPMN模型命令(非缓存)
 *
 * Created by chenjian on 16/5/27.
 */
public class GetBpmnModelCmd implements Command<BpmnModel>, Serializable {

    private static final long serialVersionUID = 8167762371289445046L;

    protected ProcessDefinitionEntity processDefinition;

    public GetBpmnModelCmd(ProcessDefinitionEntity processDefinition) {
        this.processDefinition = processDefinition;
    }

    @Override
    public BpmnModel execute(CommandContext commandContext) {
        if (processDefinition == null) {
            throw new ActivitiIllegalArgumentException("processDefinitionId is null");
        }

        // Fetch the resource
        String resourceName = processDefinition.getResourceName();
        ResourceEntity resource = Context.getCommandContext().getResourceEntityManager()
                .findResourceByDeploymentIdAndResourceName(processDefinition.getDeploymentId(), resourceName);
        if (resource == null) {
            if (Context.getCommandContext().getDeploymentEntityManager().findDeploymentById(processDefinition.getDeploymentId()) == null) {
                throw new ActivitiObjectNotFoundException("deployment for process definition does not exist: "
                        + processDefinition.getDeploymentId(), Deployment.class);
            } else {
                throw new ActivitiObjectNotFoundException("no resource found with name '" + resourceName
                        + "' in deployment '" + processDefinition.getDeploymentId() + "'", InputStream.class);
            }
        }

        // Convert the bpmn 2.0 xml to a bpmn model
        BpmnXMLConverter bpmnXMLConverter = new BpmnXMLConverter();
        return bpmnXMLConverter.convertToBpmnModel(new BytesStreamSource(resource.getBytes()), false, false);
    }
}
