<%@page language="java" pageEncoding="UTF-8" isELIgnored="false"%>
<%@include file="/common/header.jsp"%>
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<title>缓缴款核销</title>
	<%@include file="/common/jsLib.jsp"%>
	<script type="text/javascript">
		function submit(){
	    	var other_reg = /^(\d{1,10})(\.\d{1,2})?$/;
	    	if(other_reg.test($("#amount").val()) != true){
	    		$.messager.alert('错误','请输入正确格式的金额！');
	    		return;
	    	}
	    	
	    	//金额不能大于缓缴余额
	    	if(parseFloat($("#amount").val()) > parseFloat("${paymentItemDelay.hjye}")){
	    		$.messager.alert('错误','填写金额不能大于缓缴余额！');
	    		return;
	    	}
	    	
	    	//登记文号不能为空
	    	if(""==$("#registNo").val().trim()){
	    		$.messager.alert('错误','登记文号不能为空！');
	    		return;
	    	}
	    	
	    	$.messager.confirm("核销申请","确定核销吗?",function(result){
				$.ajax({
	            	url : "paymentItemDelayFree.action",
	            	type: 'post',
	                dataType: 'json',
	                async : false,
	                data:{ 
	                	id : "${paymentItemDelay.id}",
	                	amount : $("#amount").val(),
	                	registNo : $("#registNo").val(),
	                	remark : $("#remark").val(),
	                	type : $("#reimburseType").val(),
	                	operatorComment : $("#operatorComment").val()
	                },
	                error: function(){
	                	$.messager.alert('错误','提交核销申请时出错！');
	                },
	                success: function(data){
	                    if(data.result){
	                    	$.messager.alert('提示','提交核销申请成功！',"info",function(){
	                    		parent.close_win('win_paymentItemDelay');
	                    	});
	                    }else{
	                    	$.messager.alert('错误','提交其它处理申请时出错！');
	                    }
	                }
	            });
			}); 
		}
	</script>
</head>

<body validform="true">
   <div class="box_01 boxBmargin12 submitdata">
		<div class="inner6px">
			<div class="cell" style="width: 100%">
			<table width="100%" border="0">
				<tr>
					<td colspan="4" height="100px" style="text-align:center">项目信息</td>
				</tr>
				<tr>
					<th width="20%">受理编号/档案号</th>
					<td colspan="3">${paymentItemDelay.slbh}</td>
				</tr>
				<tr>
					<th width="20%">建筑单位名称</th>
					<td colspan="3">${paymentItemDelay.dwmc}</td>
				</tr>
				<tr>
					<th width="20%">工程项目名称</th>
					<td colspan="3">${paymentItemDelay.xmmc}</td>
				</tr>
				<tr>
					<th width="20%">办理依据</th>
					<td width="30%">${paymentItemDelay.blyj}</td>
					<th width="20%">总建筑面积(平方米)</th>
					<td width="30%">${paymentItemDelay.csmj}</td>
				</tr>
				<tr>
					<th width="20%">缓缴金额(元)</th>
					<td width="30%"><fmt:formatNumber value="${paymentItemDelay.hjje}" pattern="#,##0.00#"/></td>
					<th width="20%">已核销金额原始记录(元)</th>
					<td width="30%"><fmt:formatNumber value="${paymentItemDelay.ysyjje}" pattern="#,##0.00#"/></td>
				</tr>
				<tr>
					<th width="20%">核销金额(元)</th>
					<td width="30%"><fmt:formatNumber value="${paymentItemDelay.yjje}" pattern="#,##0.00#"/></td>
					<th width="20%">缓缴余额(元)</th>
					<td width="30%"><fmt:formatNumber value="${paymentItemDelay.hjye}" pattern="#,##0.00#"/></td>
				</tr>
				<tr>
					<td colspan="4" height="100px" style="text-align:center">项目核销</td>
				</tr>
				<tr>
					<th>核销类型</th>
					<td>
						<select id="reimburseType" style="width:40%">
							<option value="1" selected="selected">免缴</option>
							<option value="2">其它</option>
						</select>
					</td>
					<th>本次核销金额(元)</th>
					<td><input type="text" id="amount"></td>
				</tr>
				<tr>
               		<th width="20%">登记文号</th>
               		<td colspan="3">
               			<input type="text" id="registNo" style="width:80%">
               		</td>
               	</tr>
				<tr>
               		<th width="20%">核销依据</th>
               		<td colspan="3">
               			<textarea id="remark" style="resize:none;width:80%"></textarea>
               		</td>
               	</tr>
               	<tr>
               		<th width="20%">经办意见</th>
               		<td colspan="3">
               			<textarea id="operatorComment" style="resize:none;width:80%;height: 65px;"></textarea>
               		</td>
               	</tr>
				<tr>
					<td colspan="4" height="100px" style="text-align:center">
						<a href="javascript:submit();" class="btn_01">确定<b></b></a>&nbsp;
						<a href="#" class="btn_01"  onclick="parent.close_win('win_paymentItemDelay');">关闭<b></b></a>
					</td>
				</tr>
			</table>
			</div>
		</div>
	</div>
</body>
</html>
