<%@page language="java" pageEncoding="UTF-8" %>
<%@include file="/common/header.jsp" %>
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title></title>
    <%@include file="/common/jsLib.jsp" %>
    <script type="text/javascript">

        $(function () {
            $('#pagination').datagrid($.extend(dg_cm_pp, {
                title: '任务流转记录',
                url: 'viewHistory.action',
                queryParams: {
                    processInstanceId: ${processInstanceId}
                },
                fitColumns: false,
                columns: [[
                    {field: 'name', title: '任务名称', width: fixWidth(0.2)},
                    {
                        field: 'startTime', title: '开始时间', width: fixWidth(0.2), formatter: function (value, rec) {
                        if (rec.startTime == null) return;
                        var date = new Date(rec.startTime.time);
                        var retStr = date.format("yyyy-MM-dd hh:mm:ss");
                        return retStr;
                    }
                    },
                    {
                        field: 'endTime', title: '结束时间', width: fixWidth(0.2), formatter: function (value, rec) {
                        if (rec.endTime == null) return;
                        var date = new Date(rec.endTime.time);
                        var retStr = date.format("yyyy-MM-dd hh:mm:ss");
                        return retStr;
                    }
                    },
                    {field: 'assignee', title: '处理人', width: fixWidth(0.15)},
                    {
                        field: 'duration',
                        title: '持续时间(分)',
                        width: fixWidth(0.15)
                    }
                ]]
            }));
        });
    </script>
</head>

<body>
<div class="page_content">
    <div class="box_01 submitdata">
        <div class="inner12px">
            <form name="myform" method="post">
                <div id="pagination"></div>
            </form>
        </div>
    </div>
</div>
</body>
</html>