/*************备份还原的一些方法*************/
//获取当前时间
getCurrentDate = function() { 
    var now = new Date();
    var year = now.getFullYear();       //年
    var month = now.getMonth() + 1;     //月
    var day = now.getDate();            //日
    var hh = now.getHours();            //时
    var mm = now.getMinutes();          //分
    var ss = now.getSeconds();          //秒
    var clock = year + ".";
    if(month < 10){
        clock += "0";
    }
    clock += month + ".";
    if(day < 10){
        clock += "0";
    }
    clock += day + " ";
    if(hh < 10){
        clock += "0";
    }
    clock += hh + ".";
    if (mm < 10){
        clock += '0'
    }
    clock += mm + ".";
    if (ss < 10){
        clock += '0'
    }
    clock += ss;
    return(clock);
} 
//创建手动备份设置对话框
createManualBackupSettingDialog = function(manualBackupGrid) {
    var self = this;
    var addMunualBackupSettingDialog = new FR.Dialog({
        title: FR.i18nText("FS-System-Config_Manual_Backup"),
        text4OK: FR.i18nText("FS-Generic-Simple_OK"),
        text4Cancel: FR.i18nText("FS-Generic-Simple_Cancel"),
        onOK: function () {
            //添加backup dialog确定按钮事件
            var defaultEntryName = getCurrentDate();
            //获取备份目录名
            var entryName = addMunualBackupSettingDialog.getWidgetByName("backupentryname").getValue();
            if (!entryName || !(entryName.length > 0)){
                entryName = defaultEntryName;
            }
            var config = {
                url: FR.servletURL + "?op=fr_server&cmd=manual_backup",
                data: {
                    optype: 'back_up',
                    entryName: entryName
                }
            };
            var completeFn = function(res, status){
                if (status === 'success') {
                    var manualBackupTable = manualBackupGrid;
                    manualBackupTable.refresh();
                    FR.Msg.toast(FR.i18nText("FS-System-Config_Backup_Complete"));
                }
            }
            FS.Async.ajax(config,completeFn);

        },
        onCancel: function () {
        },
        destroyOnClose: true,
        animate: false,
        width: 355,
        height: 150,
        confirm: true,
        border: true,
        closable: true,
        contentWidget: {
            type: 'absolute',
            items: [
                {
                    type: 'llabel',
                    value: FR.i18nText("FS-Generic-WF_Name"),
                    height: 21,
                    width: 30,
                    textalign: 'right',
                    x: 50,
                    y: 30
                },
                {
                    type: 'text',
                    value: getCurrentDate(),
                    height: 21,
                    width: 220,
                    widgetName: 'backupentryname',
                    x: 100,
                    y: 30
                }
            ]
        }
    });
    return addMunualBackupSettingDialog;
};

//创建手动备份列表配置
var createManualBackupGridCfg = function () {
    var self = this;
    var manualBackupGridCfg = [{
        key: 'manualbackupname',
        value: 'manualbackupname',
        width: 626
    }];
    manualBackupGridCfg.push({
        width: 24,
        onCellCreate: function (rowIdx, colIdx, item, colCfg) {
            var editBtn = new FR.IconButton({
                width: 24,
                height: 24,
                imgsrc: 'fs-servercfg-edit-blue',
                handler: function () {
                    var okCallback = function () {
                        //编辑用户dialog确定按钮事件
                        var newBackupName = editDialog.getWidgetByName("backupeditname").getValue();
                        var oldBackupName = item.manualbackupname;
                        var config = {
                            url: FR.servletURL + "?op=fr_server&cmd=manual_backup",
                            data: {
                                optype: 'edit_backup',
                                oldname: oldBackupName,
                                newname: newBackupName
                            }
                        };
                        var completeFn = function(res, status){
                            if (status === 'success') {
                                manualBackupGrid.resultWidgets.manualbackupgrid.refresh();
                            }
                        }
                        if (oldBackupName != newBackupName){
                            FS.Async.ajax(config,completeFn);
                        }
                    };
                    var editDialog = new FR.Dialog({
                        title: FR.i18nText("FS-System-Config_Manual_Backup"),
                        text4OK: FR.i18nText("FS-Generic-Simple_OK"),
                        text4Cancel: FR.i18nText("FS-Generic-Simple_Cancel"),
                        onOK: function () {
                            return okCallback.apply(this);
                        },
                        onCancel: function () {
                        },
                        destroyOnClose: true,
                        width: 355,
                        height: 150,
                        confirm: true,
                        border: true,
                        contentWidget: {
                            type: 'absolute',
                            items: [
                                {
                                    type: 'llabel',
                                    value: FR.i18nText("FS-Generic-WF_Name"),
                                    height: 21,
                                    width: 30,
                                    textalign: 'right',
                                    x: 50,
                                    y: 30
                                },
                                {
                                    type: 'text',
                                    height: 21,
                                    width: 220,
                                    widgetName: 'backupeditname',
                                    x: 100,
                                    y: 30
                                }
                            ]
                        }
                    });
                    editDialog.setVisible(true);
                    editDialog.getWidgetByName("backupeditname").setValue(item.manualbackupname);
                }
            });
            return editBtn.element;
        }
    });
    manualBackupGridCfg.push({
        width: 24,
        onCellCreate: function (rowIdx, colIdx, item, colCfg) {
            var restoreBtn = new FR.IconButton({
                width: 24,
                height: 24,
                imgsrc: 'fs-servercfg-restore',
                handler: function () {
                    FR.Msg.confirm(FR.i18nText("FS-System-Config_Restore"), FR.i18nText("FS-System-Config_Sure_To_Restore"), function (result) {
                        if (result) {
                            var config = {
                                url: FR.servletURL + "?op=fr_server&cmd=restore",
                                data: {
                                    backupname: item.manualbackupname,
                                    backuptype: 'manual'
                                },
                                type: 'POST'
                            };
                            var completeFn = function(res, status){
                                if (status === "success") {
                                    FR.Msg.toast(FR.i18nText("FS-System-Config_Restore_Complete"));
                                }
                            };
                            FS.Async.ajax(config,completeFn);
                        }
                    })
                }
            });

            return restoreBtn.element;
        }
    });

    var manualBackupGrid = {
        type: 'quickgrid',
        page: true,
        autoPage: true,
        pageCount: 10,
        multiSelect: true,
        intervalColor: true,
        isHeadShow: false,
        marginLeft: 10,
        marginRight: 10,
        widgetName: 'manualbackupgrid',
        async: {
            url: FR.servletURL + "?op=fr_server&cmd=manual_backup",
            data: {
                optype: 'list_backup'
            }
        },
        onAsyncSuccess: function (res, status) {
            var result = FR.jsonDecode(res);
            this.options.items = result;
            var backupNumPane = this.getWidgetByName("manualbackupnum");
            backupNumPane.setValue(result.length + "/30");
        },
        columnsConfig: manualBackupGridCfg
    };

    return manualBackupGrid;
};
//创建自动备份列表配置
var createAutoBackupGridCfg = function () {
    var self = this;
    var autoBackupGridCfg = [{
        key: 'autobackupname',
        value: 'autobackupname',
        width: 650
    }];
    autoBackupGridCfg.push({
        width: 24,
        onCellCreate: function (rowIdx, colIdx, item, colCfg) {
            var restoreBtn = new FR.IconButton({
                width: 24,
                height: 24,
                imgsrc: 'fs-servercfg-restore',
                handler: function () {
                    FR.Msg.confirm(FR.i18nText("FS-System-Config_Restore"), FR.i18nText("FS-System-Config_Sure_To_Restore"), function (result) {
                        if (result) {
                            var config = {
                                url: FR.servletURL + "?op=fr_server&cmd=restore",
                                data: {
                                    backupname: item.autobackupname,
                                    backuptype: 'auto'
                                },
                                type: 'POST'
                            };
                            var completeFn = function(res, status){
                                if (status === "success"){
                                    FR.Msg.toast(FR.i18nText("FS-System-Config_Restore_Complete"));
                                }
                            };
                            FS.Async.ajax(config,completeFn);
                        }
                    })
                }
            });
            return restoreBtn.element;
        }
    });
    var autoBackupGrid = {
        type: 'quickgrid',
        page: true,
        autoPage: true,
        pageCount: 10,
        multiSelect: true,
        intervalColor: true,
        isHeadShow: false,
        marginLeft: 10,
        marginRight: 10,
        widgetName: 'autobackupgrid',
        async: {
            url: FR.servletURL + "?op=fr_server&cmd=auto_backup",
            data: {
                optype: 'list_backup'
            }
        },
        onAsyncSuccess: function (res, status) {
            var result = FR.jsonDecode(res);
            this.options.items = result;
            var backupNumPane = this.getWidgetByName("autobackupnum");
            backupNumPane.setValue(result.length + "/30");
        },
        columnsConfig: autoBackupGridCfg
    };

    return autoBackupGrid;
};
//创建备份列表表头
var createHeaderControl = function (backupNum, backupDelete) {
    var self = this;
    var header = [
        {},{
            type: 'llabel',
            widgetName: backupNum,
            width: 40,
            height: 20,
            value: '0/30'
        }
    ];
    header.unshift({
        type: 'iconbutton',
        text: FR.i18nText("FS-System-Config_Delete_Backup"),
        baseClass: 'fs-servercfg-delete-blue',
        widgetName: backupDelete,
        handler: function () {
            var self = this;
            FR.Msg.confirm(FR.i18nText("FS-System-Config_Delete_Backup"), FR.i18nText("FS-Generic-Sure_To_Delete") + "?", function (result) {
                if (result) {
                    var backupGrid;
                    var backupType;
                    if(self.options.widgetName === "manualbackupdelete") {
                        backupGrid = self.getWidgetByName("manualbackupgrid");
                        backupType = "manual";
                    }
                    if(self.options.widgetName === "autobackupdelete") {
                        backupGrid = self.getWidgetByName("autobackupgrid");
                        backupType = "auto";
                    }
                    if(!backupGrid || !backupType){
                        return;
                    }
                    var selectedData = backupGrid.getSelectedData();
                    var backupNames = [];
                    for (var i = 0,len = selectedData.length; i < len; i++) {
                        backupNames.push(backupType === "manual" ? selectedData[i].manualbackupname : selectedData[i].autobackupname);
                    }
                    var config = {
                        url: FR.servletURL + "?op=fr_server&cmd=delete",
                        data: {
                            backupname: backupNames,
                            backuptype: backupType
                        },
                        type: 'POST'
                    };
                    var completeFn = function(res, status){
                        if (status === "success") {
                            backupGrid.refresh();
                        }
                    };
                    if (backupNames.length > 0){
                        FS.Async.ajax(config,completeFn);
                    }
                }
            });
        }
    })

    return header;
};

//获取自动备份定时器信息
var getAutoBackupTimer = function (){
    return FS.Sync.ajax({
        url: FR.servletURL + "?op=fr_server&cmd=auto_backup",
        data: {
            optype: "getinfo_backup"            
        },
        type: 'POST'
    });
};

//更新自动备份定时器
var updateAutoBakupTimer = function (isStartTimer, timerFreq){
    FS.Sync.ajax({
        url: FR.servletURL + "?op=fr_server&cmd=auto_backup",
        data: {
            optype: "update_backup",
            isStart: isStartTimer,
            backup_frequency: timerFreq
        },
        type: 'POST'
    });
};

var popData = function (index) {
    _popBackupdata();
};

var _popBackupdata = function () {
};

/*************备份还原*************/
//备份还原模块
var backupRestoreModule = function () {
    var result = getAutoBackupTimer();
    var isTimerStart = true;
    var backupFreq = 7;
    //假如不存在自动备份的任务就创建一个
    if(!result.timerName) {
        updateAutoBakupTimer(isTimerStart, backupFreq);
    }
    else {
        isTimerStart = result.isStart;
        backupFreq = result.backup_frequency;
    }

    //backup config
    var backupConfig = {
        type: 'llabel',
        levelStyle: 1,
        value: FR.i18nText("FS-System-Config_Backup")
    };
    var backupConfigPanel = {
        type: 'tablepane',
        colSize: [750],
        rowSize: [28,20],
        vgap: 15,
        items: 
        [
            [{
                type: 'quickbutton', 
                text: FR.i18nText("FS-System-Config_Manual_Backup"), 
                style: 'blue', 
                height: 28, 
                width: FR.i18nTextWidth("FS-System-Config_Manual_Backup") + 30,
                handler: function() {
                    var self = this;
                    if (self.getWidgetByName("manualbackupnum").getValue().split("/")[0] >= 30){
                        FR.Msg.toast(FR.i18nText("FS-System-Config_Cleanup_Backup"));
                        return;
                    }
                    var dialog = createManualBackupSettingDialog(self.getWidgetByName("manualbackupgrid"));
                    dialog.setVisible(true);
                }
            }], 
            [{
                type: 'tablepane',
                colSize: ['auto', 10, 60, 10, 'auto'],
                rowSize: [20],
                vgap: 0,
                items:
                [
                    [{
                        type: 'checkbox',
                        marginleft: 0,
                        widgetName: 'isautobackup',
                        text: FR.i18nText("FS-System-Config_Backup_Every"),
                        listeners: [{
                            eventName: 'afteredit',
                            action: function() {
                                var isautobackup = this.getValue();
                                this.getWidgetByName("backupfrequency").setEnable(isautobackup);
                                updateAutoBakupTimer(isautobackup, this.getWidgetByName("backupfrequency").getValue());
                            }
                        }],
                        selected: isTimerStart
                    },{},{
                        type: 'combo',
                        widgetName: 'backupfrequency',
                        directEdit: false,
                        value: backupFreq,
                        items: [
                        {value: 1, text: FR.i18nText("FS-System-Config_Backup_Frequency_Oneday")},
                        {value: 7, text: FR.i18nText("FS-System-Config_Backup_Frequency_Oneweek")},
                        {value: 30, text: FR.i18nText("FS-System-Config_Backup_Frequency_Onemonth")},
                        {value: 90, text: FR.i18nText("FS-System-Config_Backup_Frequency_Threemonths")},
                        {value: 180, text: FR.i18nText("FS-System-Config_backup_Frequency_Sixmonths")}
                        ],
                        disabled: !isTimerStart,
                        listeners: [{
                            eventName: "afteredit",
                            action: function(){
                                var backupFrequency = this.getValue();
                                //假如选了个空的值，默认设置为一周
                                if(!backupFrequency){
                                    this.setValue(7);
                                    backupFrequency = 7;
                                }
                                updateAutoBakupTimer(true, backupFrequency);
                            }
                        }]
                    },{},{
                        type: 'llabel',
                        value: FR.i18nText("FS-System-Config_Auto_Backup_Once")
                    }]
                ]
            }]
        ]
    };
    //manual backup
    var manualBackupItems = {
        menu: FR.i18nText("FS-System-Config_Restore") + ':' + FR.i18nText("FS-System-Config_Manual_Backup"),
        content: {
            type: 'tablepane',
            colSize: ['auto', 620, 30],
            vgap: 15,
            rowSize: [28, 'auto'],
            items: 
            [
            createHeaderControl('manualbackupnum', 'manualbackupdelete'),
            [createManualBackupGridCfg(),null,null]
            ]
        }
    };
    var restoreManualBackup = {
        type: 'accordion',
        items: [manualBackupItems]
    };
    //auto backup
    var autoBackupItems = {
        menu: FR.i18nText("FS-System-Config_Restore") + ':' + FR.i18nText("FS-System-Config_Auto_Backup"),
        content: {
            type: 'tablepane',
            colSize: ['auto', 620, 30],
            vgap: 15,
            rowSize: [28, 'auto'],
            items: 
            [
            createHeaderControl('autobackupnum', 'autobackupdelete'),
            [createAutoBackupGridCfg(), null, null]
            ]
        }
    };
    var restoreAutoBackup = {
        type: 'accordion',
        items: [autoBackupItems]
    };
    //main panel
    var backupRestorePanel = {
        title: FR.i18nText("FS-System_Backup_Restore"),
        content: {
            widgetName: 'backupRestorePanel',
            type: 'tablepane',
            width: 730,
            colSize: [730],
            rowSize: ['auto', 'auto', 'auto', 'auto'],
            vgap: 25,
            items: [[backupConfig],[backupConfigPanel],[restoreManualBackup],[restoreAutoBackup]]
        }
    };
    
    return backupRestorePanel;
};

//加载到sysmgr中
FS.Plugin.SystemItems.push({
    ui : this.backupRestoreModule,
    pop : this.popData
});