/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Macro;
import ij.Menus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.macro.Interpreter;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class Concatenator
implements PlugIn,
ItemListener {
    public String pluginName = "Concatenator";
    static boolean all_option = false;
    boolean keep = false;
    static boolean keep_option = false;
    boolean batch = false;
    boolean macro = false;
    boolean im4D = true;
    static boolean im4D_option = false;
    public int maxEntries = 18;
    String[] imageTitles;
    ImagePlus[] images;
    Vector choices;
    Checkbox allWindows;
    final String none = "-- None --";
    String newtitle = "Concatenated Stacks";
    ImagePlus newImp;
    int stackSize;
    double min = 0.0;
    double max = 3.4028234663852886E38;

    public void run(String arg) {
        boolean bl = this.macro = !arg.equals("");
        if (!this.showDialog()) {
            return;
        }
        ImagePlus imp0 = this.images != null && this.images.length > 0 ? this.images[0] : null;
        this.newImp = imp0.isComposite() || imp0.isHyperStack() ? this.concatenateHyperstacks(this.images, this.newtitle, this.keep) : this.createHypervol();
        if (this.newImp != null) {
            this.newImp.show();
        }
    }

    public ImagePlus run() {
        if (!this.showDialog()) {
            return null;
        }
        this.newImp = this.createHypervol();
        return this.newImp;
    }

    public ImagePlus concatenate(ImagePlus imp1, ImagePlus imp2, boolean keep) {
        this.images = new ImagePlus[2];
        this.images[0] = imp1;
        this.images[1] = imp2;
        return this.concatenate(this.images, keep);
    }

    public ImagePlus concatenate(ImagePlus[] ims, boolean keepIms) {
        this.images = ims;
        this.imageTitles = new String[ims.length];
        int i = 0;
        while (i < ims.length) {
            if (ims[i] == null) {
                IJ.error(this.pluginName, "Null ImagePlus passed to concatenate(...) method");
                return null;
            }
            this.imageTitles[i] = ims[i].getTitle();
            ++i;
        }
        this.keep = keepIms;
        this.batch = true;
        this.newImp = this.createHypervol();
        return this.newImp;
    }

    ImagePlus createHypervol() {
        boolean firstImage = true;
        Properties[] propertyArr = new Properties[this.images.length];
        ImagePlus currentImp = null;
        ImageStack concat_Stack = null;
        this.stackSize = 0;
        int dataType = 0;
        int width = 0;
        int height = 0;
        Calibration cal = null;
        int count = 0;
        int i = 0;
        while (i < this.images.length) {
            if (this.images[i] != null) {
                currentImp = this.images[i];
                if (firstImage) {
                    cal = currentImp.getCalibration();
                    width = currentImp.getWidth();
                    height = currentImp.getHeight();
                    this.stackSize = currentImp.getNSlices();
                    dataType = currentImp.getType();
                    concat_Stack = currentImp.createEmptyStack();
                    this.min = currentImp.getProcessor().getMin();
                    this.max = currentImp.getProcessor().getMax();
                    firstImage = false;
                }
                if (currentImp.getNSlices() != this.stackSize && this.im4D) {
                    IJ.error(this.pluginName, "Cannot create 4D image because stack sizes are not equal.");
                    return null;
                }
                if (currentImp.getType() != dataType) {
                    IJ.log("Omitting " + this.imageTitles[i] + " - image type not matched");
                } else if (currentImp.getWidth() != width || currentImp.getHeight() != height) {
                    IJ.log("Omitting " + this.imageTitles[i] + " - dimensions not matched");
                } else {
                    boolean duplicated = this.isDuplicated(currentImp, i);
                    this.concat(concat_Stack, currentImp.getStack(), this.keep || duplicated);
                    propertyArr[count] = currentImp.getProperties();
                    this.imageTitles[count] = currentImp.getTitle();
                    if (!this.keep && !duplicated) {
                        currentImp.changes = false;
                        currentImp.hide();
                    }
                    ++count;
                }
            }
            ++i;
        }
        ImagePlus imp = new ImagePlus(this.newtitle, concat_Stack);
        imp.setCalibration(cal);
        imp.setProperty("Number of Stacks", new Integer(count));
        imp.setProperty("Stacks Properties", propertyArr);
        imp.setProperty("Image Titles", this.imageTitles);
        imp.getProcessor().setMinAndMax(this.min, this.max);
        if (this.im4D) {
            imp.setDimensions(1, this.stackSize, imp.getStackSize() / this.stackSize);
            imp.setOpenAsHyperStack(true);
        }
        return imp;
    }

    void concat(ImageStack stack3, ImageStack stack1, boolean dup) {
        int slice = 1;
        int size = stack1.getSize();
        int i = 1;
        while (i <= size) {
            ImageProcessor ip = stack1.getProcessor(slice);
            String label = stack1.getSliceLabel(slice);
            if (dup) {
                ip = ip.duplicate();
                ++slice;
            } else {
                stack1.deleteSlice(slice);
            }
            stack3.addSlice(label, ip);
            ++i;
        }
    }

    public ImagePlus concatenateHyperstacks(ImagePlus[] images, String newTitle, boolean keep) {
        int n = images.length;
        int width = images[0].getWidth();
        int height = images[0].getHeight();
        int bitDepth = images[0].getBitDepth();
        int channels = images[0].getNChannels();
        int slices = images[0].getNSlices();
        int frames = images[0].getNFrames();
        boolean concatSlices = slices > 1 && frames == 1;
        int i = 1;
        while (i < n) {
            if (images[i].getNFrames() > 1) {
                concatSlices = false;
            }
            if (images[i].getWidth() != width || images[i].getHeight() != height || images[i].getBitDepth() != bitDepth || images[i].getNChannels() != channels || !concatSlices && images[i].getNSlices() != slices) {
                IJ.error(this.pluginName, "Images do not all have the same dimensions or type");
                return null;
            }
            ++i;
        }
        ImageStack stack2 = new ImageStack(width, height);
        int slices2 = 0;
        int frames2 = 0;
        int i2 = 0;
        while (i2 < n) {
            ImageStack stack = images[i2].getStack();
            slices = images[i2].getNSlices();
            if (concatSlices) {
                slices = images[i2].getNSlices();
                slices2 += slices;
                frames2 = frames;
            } else {
                frames = images[i2].getNFrames();
                frames2 += frames;
                slices2 = slices;
            }
            int f = 1;
            while (f <= frames) {
                int s = 1;
                while (s <= slices) {
                    int c = 1;
                    while (c <= channels) {
                        int index = (f - 1) * channels * s + (s - 1) * channels + c;
                        ImageProcessor ip = stack.getProcessor(index);
                        if (keep) {
                            ip = ip.duplicate();
                        }
                        String label = stack.getSliceLabel(index);
                        stack2.addSlice(label, ip);
                        ++c;
                    }
                    ++s;
                }
                ++f;
            }
            ++i2;
        }
        ImagePlus imp2 = new ImagePlus(newTitle, stack2);
        imp2.setDimensions(channels, slices2, frames2);
        if (channels > 1) {
            int mode = 0;
            if (images[0].isComposite()) {
                mode = ((CompositeImage)images[0]).getMode();
            }
            imp2 = new CompositeImage(imp2, mode);
            ((CompositeImage)imp2).copyLuts(images[0]);
        }
        if (channels > 1 && frames2 > 1) {
            imp2.setOpenAsHyperStack(true);
        }
        if (!keep) {
            int i3 = 0;
            while (i3 < n) {
                images[i3].changes = false;
                images[i3].close();
                ++i3;
            }
        }
        return imp2;
    }

    boolean showDialog() {
        int[] wList;
        boolean all_windows = false;
        this.batch = Interpreter.isBatchMode();
        this.macro = this.macro || IJ.isMacro() && Macro.getOptions() != null;
        boolean bl = this.im4D = Menus.commandInUse("Stack to Image5D") && !this.batch;
        if (this.macro) {
            String options = Macro.getOptions();
            if (options.indexOf("stack1") != -1 && options.indexOf("stack2") != -1) {
                Macro.setOptions(options.replaceAll("stack", "image"));
            }
            int macroImageCount = 0;
            options = Macro.getOptions();
            while (options.indexOf("image" + (macroImageCount + 1)) != -1) {
                ++macroImageCount;
            }
            this.maxEntries = macroImageCount;
        }
        if ((wList = WindowManager.getIDList()) == null) {
            IJ.error("No windows are open.");
            return false;
        }
        if (wList.length < 2) {
            IJ.error("Two or more windows must be open");
            return false;
        }
        int nImages = wList.length;
        String[] titles = new String[nImages];
        String[] titles_none = new String[nImages + 1];
        int i = 0;
        while (i < nImages) {
            ImagePlus imp = WindowManager.getImage(wList[i]);
            if (imp != null) {
                titles[i] = imp.getTitle();
                titles_none[i] = imp.getTitle();
            } else {
                titles[i] = "";
                titles_none[i] = "";
            }
            ++i;
        }
        titles_none[nImages] = "-- None --";
        GenericDialog gd = new GenericDialog(this.pluginName);
        gd.addCheckbox("All_open windows", all_option);
        gd.addChoice("Image1:", titles, titles[0]);
        gd.addChoice("Image2:", titles, titles[1]);
        int i2 = 2;
        while (i2 < (nImages + 1 < this.maxEntries ? nImages + 1 : this.maxEntries)) {
            gd.addChoice("Image" + (i2 + 1) + ":", titles_none, titles_none[i2]);
            ++i2;
        }
        gd.addStringField("Title:", this.newtitle, 16);
        gd.addCheckbox("Keep original images", keep_option);
        gd.addCheckbox("Open as 4D_image", im4D_option);
        if (!this.macro) {
            this.choices = gd.getChoices();
            Enumeration e = this.choices.elements();
            while (e.hasMoreElements()) {
                ((Choice)e.nextElement()).addItemListener(this);
            }
            Vector v = gd.getCheckboxes();
            this.allWindows = (Checkbox)v.firstElement();
            this.allWindows.addItemListener(this);
            if (all_option) {
                this.itemStateChanged(new ItemEvent(this.allWindows, 701, null, 1));
            }
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        all_option = all_windows = gd.getNextBoolean();
        this.newtitle = gd.getNextString();
        keep_option = this.keep = gd.getNextBoolean();
        im4D_option = this.im4D = gd.getNextBoolean();
        ImagePlus[] tmpImpArr = new ImagePlus[nImages + 1];
        String[] tmpStrArr = new String[nImages + 1];
        int count = 0;
        int i3 = 0;
        while (i3 < nImages + 1) {
            int index;
            if (all_windows) {
                index = i3;
            } else {
                if (i3 == (nImages + 1 < this.maxEntries ? nImages + 1 : this.maxEntries)) break;
                index = gd.getNextChoiceIndex();
            }
            if (index >= nImages) break;
            if (!titles[index].equals("")) {
                tmpStrArr[count] = titles[index];
                tmpImpArr[count] = WindowManager.getImage(wList[index]);
                ++count;
            }
            ++i3;
        }
        if (count < 2) {
            IJ.error(this.pluginName, "Please select at least 2 images");
            return false;
        }
        this.imageTitles = new String[count];
        this.images = new ImagePlus[count];
        System.arraycopy(tmpStrArr, 0, this.imageTitles, 0, count);
        System.arraycopy(tmpImpArr, 0, this.images, 0, count);
        return true;
    }

    boolean isDuplicated(ImagePlus imp, int index) {
        int length = this.images.length;
        if (index >= length - 1) {
            return false;
        }
        int i = index + 1;
        while (i < length) {
            if (imp == this.images[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void itemStateChanged(ItemEvent ie) {
        if (ie.getSource() == this.allWindows) {
            int count = 0;
            if (this.allWindows.getState()) {
                Enumeration e = this.choices.elements();
                while (e.hasMoreElements()) {
                    Choice c = (Choice)e.nextElement();
                    c.select(count++);
                    c.setEnabled(false);
                }
            } else {
                Enumeration e = this.choices.elements();
                while (e.hasMoreElements()) {
                    Choice c = (Choice)e.nextElement();
                    c.setEnabled(true);
                }
            }
        } else {
            boolean foundNone = false;
            Enumeration e = this.choices.elements();
            while (e.hasMoreElements()) {
                Choice c = (Choice)e.nextElement();
                if (!foundNone) {
                    c.setEnabled(true);
                    if (!c.getSelectedItem().equals("-- None --")) continue;
                    foundNone = true;
                    continue;
                }
                c.select("-- None --");
                c.setEnabled(false);
            }
        }
    }

    public void setIm5D(boolean bool) {
        im4D_option = bool;
    }
}

