/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.Menus;
import ij.Prefs;
import ij.Undo;
import ij.gui.HistogramWindow;
import ij.gui.ImageWindow;
import ij.gui.PlotWindow;
import ij.macro.Interpreter;
import ij.plugin.frame.Editor;
import ij.plugin.frame.PlugInFrame;
import ij.plugin.frame.Recorder;
import ij.text.TextWindow;
import ij.util.Tools;
import java.awt.CheckboxMenuItem;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.MenuItem;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;

public class WindowManager {
    public static boolean checkForDuplicateName;
    private static Vector imageList;
    private static Vector nonImageList;
    private static ImageWindow currentWindow;
    private static Window frontWindow;
    private static Frame frontFrame;
    private static Hashtable tempImageTable;

    static {
        imageList = new Vector();
        nonImageList = new Vector();
        tempImageTable = new Hashtable();
    }

    private WindowManager() {
    }

    public static void setCurrentWindow(ImageWindow win) {
        ImagePlus imp;
        if (win == null || win.isClosed() || win.getImagePlus() == null) {
            return;
        }
        WindowManager.setWindow(win);
        tempImageTable.remove(Thread.currentThread());
        if (win == currentWindow || imageList.size() == 0) {
            return;
        }
        if (currentWindow != null && (imp = currentWindow.getImagePlus()) != null) {
            if (!Prefs.keepUndoBuffers) {
                imp.trimProcessor();
            }
            imp.saveRoi();
        }
        Undo.reset();
        currentWindow = win;
        Menus.updateMenus();
        if (Recorder.record && !IJ.isMacro()) {
            Recorder.record("selectWindow", win.getImagePlus().getTitle());
        }
    }

    public static ImageWindow getCurrentWindow() {
        return currentWindow;
    }

    static int getCurrentIndex() {
        return imageList.indexOf(currentWindow);
    }

    public static ImagePlus getCurrentImage() {
        ImagePlus img = (ImagePlus)tempImageTable.get(Thread.currentThread());
        if (img == null) {
            img = WindowManager.getActiveImage();
        }
        return img;
    }

    public static void setTempCurrentImage(ImagePlus img) {
        if (img == null) {
            tempImageTable.remove(Thread.currentThread());
        } else {
            tempImageTable.put(Thread.currentThread(), img);
        }
    }

    public static void setTempCurrentImage(Thread thread, ImagePlus img) {
        if (thread == null) {
            throw new RuntimeException("thread==null");
        }
        if (img == null) {
            tempImageTable.remove(thread);
        } else {
            tempImageTable.put(thread, img);
        }
    }

    private static ImagePlus getActiveImage() {
        if (currentWindow != null) {
            return currentWindow.getImagePlus();
        }
        if (frontWindow != null && frontWindow instanceof ImageWindow) {
            return ((ImageWindow)frontWindow).getImagePlus();
        }
        if (imageList.size() > 0) {
            ImageWindow win = (ImageWindow)imageList.elementAt(imageList.size() - 1);
            return win.getImagePlus();
        }
        return Interpreter.getLastBatchModeImage();
    }

    public static int getWindowCount() {
        int count = imageList.size();
        return count;
    }

    public static int getImageCount() {
        int count = imageList.size();
        if ((count += Interpreter.getBatchModeImageCount()) == 0 && WindowManager.getCurrentImage() != null) {
            count = 1;
        }
        return count;
    }

    public static Window getActiveWindow() {
        return frontWindow;
    }

    public static Frame getFrontWindow() {
        return frontFrame;
    }

    public static synchronized int[] getIDList() {
        int[] batchModeImages;
        int nBatchImages;
        int nWindows = imageList.size();
        if (nWindows + (nBatchImages = (batchModeImages = Interpreter.getBatchModeImageIDs()).length) == 0) {
            return null;
        }
        int[] list = new int[nWindows + nBatchImages];
        int i = 0;
        while (i < nBatchImages) {
            list[i] = batchModeImages[i];
            ++i;
        }
        int index = 0;
        int i2 = nBatchImages;
        while (i2 < nBatchImages + nWindows) {
            ImageWindow win = (ImageWindow)imageList.elementAt(index++);
            list[i2] = win.getImagePlus().getID();
            ++i2;
        }
        return list;
    }

    public static synchronized Frame[] getNonImageWindows() {
        ArrayList list = new ArrayList();
        int i = 0;
        while (i < nonImageList.size()) {
            Object win = nonImageList.elementAt(i);
            if (win instanceof Frame) {
                list.add(win);
            }
            ++i;
        }
        Frame[] frames = new Frame[list.size()];
        list.toArray(frames);
        return frames;
    }

    public static synchronized ImagePlus getImage(int imageID) {
        if (imageID > 0) {
            imageID = WindowManager.getNthImageID(imageID);
        }
        if (imageID == 0 || WindowManager.getImageCount() == 0) {
            return null;
        }
        ImagePlus imp2 = Interpreter.getBatchModeImage(imageID);
        if (imp2 != null) {
            return imp2;
        }
        ImagePlus imp = null;
        int i = 0;
        while (i < imageList.size()) {
            ImageWindow win = (ImageWindow)imageList.elementAt(i);
            imp2 = win.getImagePlus();
            if (imageID == imp2.getID()) {
                imp = imp2;
                break;
            }
            ++i;
        }
        imp2 = WindowManager.getCurrentImage();
        if (imp == null && imp2 != null && imp2.getID() == imageID) {
            return imp2;
        }
        return imp;
    }

    public static synchronized int getNthImageID(int n) {
        if (n <= 0) {
            return 0;
        }
        if (Interpreter.isBatchMode()) {
            int[] list = WindowManager.getIDList();
            if (n > list.length) {
                return 0;
            }
            return list[n - 1];
        }
        if (n > imageList.size()) {
            return 0;
        }
        ImageWindow win = (ImageWindow)imageList.elementAt(n - 1);
        if (win != null) {
            return win.getImagePlus().getID();
        }
        return 0;
    }

    public static synchronized ImagePlus getImage(String title) {
        int[] wList = WindowManager.getIDList();
        if (wList == null) {
            return null;
        }
        int i = 0;
        while (i < wList.length) {
            ImagePlus imp = WindowManager.getImage(wList[i]);
            if (imp != null && imp.getTitle().equals(title)) {
                return imp;
            }
            ++i;
        }
        return null;
    }

    public static synchronized void addWindow(Window win) {
        if (win == null) {
            return;
        }
        if (win instanceof ImageWindow) {
            WindowManager.addImageWindow((ImageWindow)win);
        } else {
            Menus.insertWindowMenuItem(win);
            nonImageList.addElement(win);
        }
    }

    public static void addWindow(Frame win) {
        WindowManager.addWindow((Window)win);
    }

    private static void addImageWindow(ImageWindow win) {
        ImagePlus imp = win.getImagePlus();
        if (imp == null) {
            return;
        }
        WindowManager.checkForDuplicateName(imp);
        imageList.addElement(win);
        Menus.addWindowMenuItem(imp);
        WindowManager.setCurrentWindow(win);
    }

    static void checkForDuplicateName(ImagePlus imp) {
        String name;
        if (checkForDuplicateName && WindowManager.isDuplicateName(name = imp.getTitle())) {
            imp.setTitle(WindowManager.getUniqueName(name));
        }
        checkForDuplicateName = false;
    }

    static boolean isDuplicateName(String name) {
        int n = imageList.size();
        int i = 0;
        while (i < n) {
            ImageWindow win = (ImageWindow)imageList.elementAt(i);
            String name2 = win.getImagePlus().getTitle();
            if (name.equals(name2)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String getUniqueName(String name) {
        String name2 = name;
        String extension = "";
        int len = name2.length();
        int lastDot = name2.lastIndexOf(".");
        if (lastDot != -1 && len - lastDot < 6 && lastDot != len - 1) {
            extension = name2.substring(lastDot, len);
            name2 = name2.substring(0, lastDot);
        }
        int lastDash = name2.lastIndexOf("-");
        len = name2.length();
        if (lastDash != -1 && len - lastDash < 4 && lastDash < len - 1 && Character.isDigit(name2.charAt(lastDash + 1)) && name2.charAt(lastDash + 1) != '0') {
            name2 = name2.substring(0, lastDash);
        }
        int i = 1;
        while (i <= 99) {
            String name3 = String.valueOf(name2) + "-" + i + extension;
            if (!WindowManager.isDuplicateName(name3)) {
                return name3;
            }
            ++i;
        }
        return name;
    }

    public static String makeUniqueName(String name) {
        return WindowManager.isDuplicateName(name) ? WindowManager.getUniqueName(name) : name;
    }

    public static synchronized void removeWindow(Window win) {
        if (win instanceof ImageWindow) {
            WindowManager.removeImageWindow((ImageWindow)win);
        } else {
            int index = nonImageList.indexOf(win);
            ImageJ ij = IJ.getInstance();
            if (index >= 0) {
                Menus.removeWindowMenuItem(index);
                nonImageList.removeElement(win);
            }
        }
        WindowManager.setWindow(null);
    }

    public static void removeWindow(Frame win) {
        WindowManager.removeWindow((Window)win);
    }

    private static void removeImageWindow(ImageWindow win) {
        int index = imageList.indexOf(win);
        if (index == -1) {
            return;
        }
        if (imageList.size() > 1 && IJ.isMacro()) {
            int newIndex = index - 1;
            if (newIndex < 0) {
                newIndex = imageList.size() - 1;
            }
            WindowManager.setCurrentWindow((ImageWindow)imageList.elementAt(newIndex));
        } else {
            currentWindow = null;
        }
        imageList.removeElementAt(index);
        WindowManager.setTempCurrentImage(null);
        int nonImageCount = nonImageList.size();
        if (nonImageCount > 0) {
            ++nonImageCount;
        }
        Menus.removeWindowMenuItem(nonImageCount + index);
        Menus.updateMenus();
        Undo.reset();
    }

    public static void setWindow(Window win) {
        frontWindow = win;
        if (win instanceof Frame) {
            frontFrame = (Frame)win;
        }
    }

    public static void setWindow(Frame win) {
        frontWindow = win;
        frontFrame = win;
    }

    public static synchronized boolean closeAllWindows() {
        while (imageList.size() > 0) {
            if (!((ImageWindow)imageList.elementAt(0)).close()) {
                return false;
            }
            IJ.wait(100);
        }
        Frame[] nonImages = WindowManager.getNonImageWindows();
        int i = 0;
        while (i < nonImages.length) {
            Frame frame = nonImages[i];
            if (frame != null && frame instanceof Editor) {
                ((Editor)frame).close();
                if (((Editor)frame).fileChanged()) {
                    return false;
                }
                IJ.wait(100);
            }
            ++i;
        }
        ImageJ ij = IJ.getInstance();
        if (ij != null && ij.quitting() && IJ.getApplet() == null) {
            return true;
        }
        int i2 = 0;
        while (i2 < nonImages.length) {
            Frame frame = nonImages[i2];
            if (frame instanceof PlugInFrame && !(frame instanceof Editor)) {
                ((PlugInFrame)frame).close();
            } else if (frame instanceof TextWindow) {
                ((TextWindow)frame).close();
            } else {
                frame.dispose();
            }
            ++i2;
        }
        return true;
    }

    public static void putBehind() {
        if (IJ.debugMode) {
            IJ.log("putBehind");
        }
        if (imageList.size() < 1 || currentWindow == null) {
            return;
        }
        int index = imageList.indexOf(currentWindow);
        ImageWindow win = null;
        int count = 0;
        do {
            if (--index < 0) {
                index = imageList.size() - 1;
            }
            win = (ImageWindow)imageList.elementAt(index);
            if (++count != imageList.size()) continue;
            return;
        } while (win instanceof HistogramWindow || win instanceof PlotWindow);
        if (win == null) {
            return;
        }
        ImagePlus imp = win.getImagePlus();
        if (imp != null) {
            IJ.selectWindow(imp.getID());
        }
    }

    public static ImagePlus getTempCurrentImage() {
        return (ImagePlus)tempImageTable.get(Thread.currentThread());
    }

    public static Window getWindow(String title) {
        int i = 0;
        while (i < nonImageList.size()) {
            String winTitle;
            Object win = nonImageList.elementAt(i);
            String string = winTitle = win instanceof Frame ? ((Frame)win).getTitle() : ((Dialog)win).getTitle();
            if (title.equals(winTitle)) {
                return (Window)win;
            }
            ++i;
        }
        return WindowManager.getImageWindow(title);
    }

    public static Frame getFrame(String title) {
        int i = 0;
        while (i < nonImageList.size()) {
            String winTitle;
            Object win = nonImageList.elementAt(i);
            String string = winTitle = win instanceof Frame ? ((Frame)win).getTitle() : null;
            if (title.equals(winTitle)) {
                return (Frame)win;
            }
            ++i;
        }
        return WindowManager.getImageWindow(title);
    }

    private static Frame getImageWindow(String title) {
        int[] wList = WindowManager.getIDList();
        int len = wList != null ? wList.length : 0;
        int i = 0;
        while (i < len) {
            ImagePlus imp = WindowManager.getImage(wList[i]);
            if (imp != null && imp.getTitle().equals(title)) {
                return imp.getWindow();
            }
            ++i;
        }
        return null;
    }

    static synchronized void activateWindow(String menuItemLabel, MenuItem item) {
        int start;
        String idString;
        int id;
        ImagePlus imp;
        int i = 0;
        while (i < nonImageList.size()) {
            String title;
            Object win = nonImageList.elementAt(i);
            String string = title = win instanceof Frame ? ((Frame)win).getTitle() : ((Dialog)win).getTitle();
            if (menuItemLabel.equals(title)) {
                if (win instanceof Frame) {
                    WindowManager.toFront((Frame)win);
                } else {
                    ((Dialog)win).toFront();
                }
                ((CheckboxMenuItem)item).setState(false);
                if (Recorder.record && !IJ.isMacro()) {
                    Recorder.record("selectWindow", title);
                }
                return;
            }
            ++i;
        }
        int lastSpace = menuItemLabel.lastIndexOf(32);
        if (lastSpace > 0) {
            menuItemLabel = menuItemLabel.substring(0, lastSpace);
        }
        if ((imp = WindowManager.getImage(id = (int)Tools.parseDouble(idString = item.getActionCommand(), 0.0))) == null) {
            return;
        }
        ImageWindow win1 = imp.getWindow();
        if (win1 == null) {
            return;
        }
        WindowManager.setCurrentWindow(win1);
        WindowManager.toFront(win1);
        int index = imageList.indexOf(win1);
        int n = Menus.window.getItemCount();
        int j = start = 5 + Menus.windowMenuItems2;
        while (j < n) {
            MenuItem mi = Menus.window.getItem(j);
            ((CheckboxMenuItem)mi).setState(j - start == index);
            ++j;
        }
    }

    public static synchronized void repaintImageWindows() {
        int[] list = WindowManager.getIDList();
        if (list == null) {
            return;
        }
        int i = 0;
        while (i < list.length) {
            ImagePlus imp2 = WindowManager.getImage(list[i]);
            if (imp2 != null) {
                imp2.setTitle(imp2.getTitle());
                ImageWindow win = imp2.getWindow();
                if (win != null) {
                    win.repaint();
                }
            }
            ++i;
        }
    }

    static void showList() {
        if (IJ.debugMode) {
            int i = 0;
            while (i < imageList.size()) {
                ImageWindow win = (ImageWindow)imageList.elementAt(i);
                ImagePlus imp = win.getImagePlus();
                IJ.log(String.valueOf(i) + " " + imp.getTitle() + (win == currentWindow ? "*" : ""));
                ++i;
            }
            IJ.log(" ");
        }
    }

    public static void toFront(Frame frame) {
        if (frame == null) {
            return;
        }
        if (frame.getState() == 1) {
            frame.setState(0);
        }
        frame.toFront();
    }
}

