/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.IJ;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Rectangle;
import java.awt.image.ColorModel;

public class ImageStack {
    private static final int BYTE = 0;
    private static final int SHORT = 1;
    private static final int FLOAT = 2;
    private static final int RGB = 3;
    private static final int UNKNOWN = -1;
    static final int INITIAL_SIZE = 25;
    static final String outOfRange = "Argument out of range: ";
    private int type = -1;
    private int nSlices = 0;
    private Object[] stack;
    private String[] label;
    private int width;
    private int height;
    private Rectangle roi;
    private ColorModel cm;
    private double min = Double.MAX_VALUE;
    private double max;
    private float[] cTable;

    public ImageStack() {
    }

    public ImageStack(int width, int height) {
        this(width, height, null);
    }

    public ImageStack(int width, int height, int size) {
        this.width = width;
        this.height = height;
        this.stack = new Object[size];
        this.label = new String[size];
        this.nSlices = size;
    }

    public ImageStack(int width, int height, ColorModel cm) {
        this.width = width;
        this.height = height;
        this.cm = cm;
        this.stack = new Object[25];
        this.label = new String[25];
        this.nSlices = 0;
    }

    public void addSlice(String sliceLabel, Object pixels) {
        if (pixels == null) {
            throw new IllegalArgumentException("'pixels' is null!");
        }
        if (!pixels.getClass().isArray()) {
            throw new IllegalArgumentException("'pixels' is not an array");
        }
        int size = this.stack.length;
        ++this.nSlices;
        if (this.nSlices >= size) {
            Object[] tmp1 = new Object[size * 2];
            System.arraycopy(this.stack, 0, tmp1, 0, size);
            this.stack = tmp1;
            String[] tmp2 = new String[size * 2];
            System.arraycopy(this.label, 0, tmp2, 0, size);
            this.label = tmp2;
        }
        this.stack[this.nSlices - 1] = pixels;
        this.label[this.nSlices - 1] = sliceLabel;
        if (this.type == -1) {
            if (pixels instanceof byte[]) {
                this.type = 0;
            } else if (pixels instanceof short[]) {
                this.type = 1;
            } else if (pixels instanceof float[]) {
                this.type = 2;
            } else if (pixels instanceof int[]) {
                this.type = 3;
            }
        }
    }

    public void addUnsignedShortSlice(String sliceLabel, Object pixels) {
        this.addSlice(sliceLabel, pixels);
    }

    public void addSlice(ImageProcessor ip) {
        this.addSlice(null, ip);
    }

    public void addSlice(String sliceLabel, ImageProcessor ip) {
        if (ip.getWidth() != this.width || ip.getHeight() != this.height) {
            throw new IllegalArgumentException("Dimensions do not match");
        }
        if (this.nSlices == 0) {
            this.cm = ip.getColorModel();
            this.min = ip.getMin();
            this.max = ip.getMax();
        }
        this.addSlice(sliceLabel, ip.getPixels());
    }

    public void addSlice(String sliceLabel, ImageProcessor ip, int n) {
        if (n < 0 || n > this.nSlices) {
            throw new IllegalArgumentException(outOfRange + n);
        }
        this.addSlice(sliceLabel, ip);
        Object tempSlice = this.stack[this.nSlices - 1];
        String tempLabel = this.label[this.nSlices - 1];
        int first = n > 0 ? n : 1;
        int i = this.nSlices - 1;
        while (i >= first) {
            this.stack[i] = this.stack[i - 1];
            this.label[i] = this.label[i - 1];
            --i;
        }
        this.stack[n] = tempSlice;
        this.label[n] = tempLabel;
    }

    public void deleteSlice(int n) {
        if (n < 1 || n > this.nSlices) {
            throw new IllegalArgumentException(outOfRange + n);
        }
        if (this.nSlices < 1) {
            return;
        }
        int i = n;
        while (i < this.nSlices) {
            this.stack[i - 1] = this.stack[i];
            this.label[i - 1] = this.label[i];
            ++i;
        }
        this.stack[this.nSlices - 1] = null;
        this.label[this.nSlices - 1] = null;
        --this.nSlices;
    }

    public void deleteLastSlice() {
        if (this.nSlices > 0) {
            this.deleteSlice(this.nSlices);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setRoi(Rectangle roi) {
        this.roi = roi;
    }

    public Rectangle getRoi() {
        if (this.roi == null) {
            return new Rectangle(0, 0, this.width, this.height);
        }
        return this.roi;
    }

    public void update(ImageProcessor ip) {
        if (ip != null) {
            this.min = ip.getMin();
            this.max = ip.getMax();
            this.cTable = ip.getCalibrationTable();
            this.cm = ip.getColorModel();
        }
    }

    public Object getPixels(int n) {
        if (n < 1 || n > this.nSlices) {
            throw new IllegalArgumentException(outOfRange + n);
        }
        return this.stack[n - 1];
    }

    public void setPixels(Object pixels, int n) {
        if (n < 1 || n > this.nSlices) {
            throw new IllegalArgumentException(outOfRange + n);
        }
        this.stack[n - 1] = pixels;
    }

    public Object[] getImageArray() {
        return this.stack;
    }

    public int getSize() {
        return this.nSlices;
    }

    public String[] getSliceLabels() {
        if (this.nSlices == 0) {
            return null;
        }
        return this.label;
    }

    public String getSliceLabel(int n) {
        if (n < 1 || n > this.nSlices) {
            throw new IllegalArgumentException(outOfRange + n);
        }
        return this.label[n - 1];
    }

    public String getShortSliceLabel(int n) {
        int len;
        String shortLabel = this.getSliceLabel(n);
        if (shortLabel == null) {
            return null;
        }
        int newline = shortLabel.indexOf(10);
        if (newline == 0) {
            return null;
        }
        if (newline > 0) {
            shortLabel = shortLabel.substring(0, newline);
        }
        if ((len = shortLabel.length()) > 4 && shortLabel.charAt(len - 4) == '.' && !Character.isDigit(shortLabel.charAt(len - 1))) {
            shortLabel = shortLabel.substring(0, len - 4);
        }
        if (shortLabel.length() > 60) {
            shortLabel = shortLabel.substring(0, 60);
        }
        return shortLabel;
    }

    public void setSliceLabel(String label, int n) {
        if (n < 1 || n > this.nSlices) {
            throw new IllegalArgumentException(outOfRange + n);
        }
        this.label[n - 1] = label;
    }

    public ImageProcessor getProcessor(int n) {
        ImageProcessor ip;
        if (n < 1 || n > this.nSlices) {
            throw new IllegalArgumentException(outOfRange + n);
        }
        if (this.nSlices == 0) {
            return null;
        }
        if (this.stack[0] == null) {
            throw new IllegalArgumentException("Pixel array is null");
        }
        if (this.stack[0] instanceof byte[]) {
            ip = new ByteProcessor(this.width, this.height, null, this.cm);
        } else if (this.stack[0] instanceof short[]) {
            ip = new ShortProcessor(this.width, this.height, null, this.cm);
        } else if (this.stack[0] instanceof int[]) {
            ip = new ColorProcessor(this.width, this.height, null);
        } else if (this.stack[0] instanceof float[]) {
            ip = new FloatProcessor(this.width, this.height, null, this.cm);
        } else {
            throw new IllegalArgumentException("Unknown stack type");
        }
        ip.setPixels(this.stack[n - 1]);
        if (this.min != Double.MAX_VALUE && ip != null && !(ip instanceof ColorProcessor)) {
            ip.setMinAndMax(this.min, this.max);
        }
        if (this.cTable != null) {
            ip.setCalibrationTable(this.cTable);
        }
        return ip;
    }

    public void setProcessor(ImageProcessor ip, int n) {
        if (n < 1 || n > this.nSlices) {
            throw new IllegalArgumentException(outOfRange + n);
        }
        if (this.type != -1 && this.type != this.getType(ip)) {
            throw new IllegalArgumentException("Wrong type for this stack");
        }
        if (ip.getWidth() != this.width || ip.getHeight() != this.height) {
            throw new IllegalArgumentException("Wrong dimensions for this stack");
        }
        this.stack[n - 1] = ip.getPixels();
    }

    public void setColorModel(ColorModel cm) {
        this.cm = cm;
    }

    public ColorModel getColorModel() {
        return this.cm;
    }

    public boolean isRGB() {
        return this.nSlices == 3 && this.stack[0] instanceof byte[] && this.getSliceLabel(1) != null && this.getSliceLabel(1).equals("Red");
    }

    public boolean isHSB() {
        return this.nSlices == 3 && this.getSliceLabel(1) != null && this.getSliceLabel(1).equals("Hue");
    }

    public boolean isVirtual() {
        return false;
    }

    public void trim() {
        int n = (int)Math.round(Math.log(this.nSlices) + 1.0);
        int i = 0;
        while (i < n) {
            this.deleteLastSlice();
            System.gc();
            ++i;
        }
    }

    public String toString() {
        String v = this.isVirtual() ? "(V)" : "";
        return "stack[" + this.getWidth() + "x" + this.getHeight() + "x" + this.getSize() + v + "]";
    }

    public final double getVoxel(int x, int y, int z) {
        if (x >= 0 && x < this.width && y >= 0 && y < this.height && z >= 0 && z < this.nSlices) {
            switch (this.type) {
                case 0: {
                    byte[] bytes = (byte[])this.stack[z];
                    return bytes[y * this.width + x] & 0xFF;
                }
                case 1: {
                    short[] shorts = (short[])this.stack[z];
                    return shorts[y * this.width + x] & 0xFFFF;
                }
                case 2: {
                    float[] floats = (float[])this.stack[z];
                    return floats[y * this.width + x];
                }
                case 3: {
                    int[] ints = (int[])this.stack[z];
                    return ints[y * this.width + x] & 0xFFFFFFFF;
                }
            }
            return 0.0;
        }
        return 0.0;
    }

    public final void setVoxel(int x, int y, int z, double value) {
        if (x >= 0 && x < this.width && y >= 0 && y < this.height && z >= 0 && z < this.nSlices) {
            switch (this.type) {
                case 0: {
                    byte[] bytes = (byte[])this.stack[z];
                    if (value > 255.0) {
                        value = 255.0;
                    } else if (value < 0.0) {
                        value = 0.0;
                    }
                    bytes[y * this.width + x] = (byte)(value + 0.5);
                    break;
                }
                case 1: {
                    short[] shorts = (short[])this.stack[z];
                    if (value > 65535.0) {
                        value = 65535.0;
                    } else if (value < 0.0) {
                        value = 0.0;
                    }
                    shorts[y * this.width + x] = (short)(value + 0.5);
                    break;
                }
                case 2: {
                    float[] floats = (float[])this.stack[z];
                    floats[y * this.width + x] = (float)value;
                    break;
                }
                case 3: {
                    int[] ints = (int[])this.stack[z];
                    ints[y * this.width + x] = (int)value;
                }
            }
        }
    }

    public float[] getVoxels(int x0, int y0, int z0, int w, int h, int d, float[] voxels) {
        boolean inBounds;
        boolean bl = inBounds = x0 >= 0 && x0 + w <= this.width && y0 >= 0 && y0 + h <= this.height && z0 >= 0 && z0 + d <= this.nSlices;
        if (voxels == null || voxels.length != w * h * d) {
            voxels = new float[w * h * d];
        }
        int i = 0;
        int z = z0;
        while (z < z0 + d) {
            int y = y0;
            while (y < y0 + h) {
                block16: {
                    block15: {
                        if (!inBounds) break block15;
                        switch (this.type) {
                            case 0: {
                                byte[] bytes = (byte[])this.stack[z];
                                int x = x0;
                                while (x < x0 + w) {
                                    voxels[i++] = bytes[y * this.width + x] & 0xFF;
                                    ++x;
                                }
                                break block16;
                            }
                            case 1: {
                                short[] shorts = (short[])this.stack[z];
                                int x = x0;
                                while (x < x0 + w) {
                                    voxels[i++] = shorts[y * this.width + x] & 0xFFFF;
                                    ++x;
                                }
                                break block16;
                            }
                            case 2: {
                                float[] floats = (float[])this.stack[z];
                                int x = x0;
                                while (x < x0 + w) {
                                    voxels[i++] = floats[y * this.width + x];
                                    ++x;
                                }
                                break block16;
                            }
                            case 3: {
                                int[] ints = (int[])this.stack[z];
                                int x = x0;
                                while (x < x0 + w) {
                                    voxels[i++] = ints[y * this.width + x] & 0xFFFFFFFF;
                                    ++x;
                                }
                                break block16;
                            }
                            default: {
                                int x = x0;
                                while (x < x0 + w) {
                                    voxels[i++] = 0.0f;
                                    ++x;
                                }
                                break block16;
                            }
                        }
                    }
                    int x = x0;
                    while (x < x0 + w) {
                        voxels[i++] = (float)this.getVoxel(x, y, z);
                        ++x;
                    }
                }
                ++y;
            }
            ++z;
        }
        return voxels;
    }

    public float[] getVoxels(int x0, int y0, int z0, int w, int h, int d, float[] voxels, int channel) {
        boolean inBounds;
        if (this.getBitDepth() != 24) {
            return this.getVoxels(x0, y0, z0, w, h, d, voxels);
        }
        boolean bl = inBounds = x0 >= 0 && x0 + w <= this.width && y0 >= 0 && y0 + h <= this.height && z0 >= 0 && z0 + d <= this.nSlices;
        if (voxels == null || voxels.length != w * h * d) {
            voxels = new float[w * h * d];
        }
        int i = 0;
        int z = z0;
        while (z < z0 + d) {
            int[] ints = (int[])this.stack[z];
            int y = y0;
            while (y < y0 + h) {
                int x = x0;
                while (x < x0 + w) {
                    int value = inBounds ? ints[y * this.width + x] & 0xFFFFFFFF : (int)this.getVoxel(x, y, z);
                    switch (channel) {
                        case 0: {
                            value = (value & 0xFF0000) >> 16;
                            break;
                        }
                        case 1: {
                            value = (value & 0xFF00) >> 8;
                            break;
                        }
                        case 2: {
                            value &= 0xFF;
                        }
                    }
                    voxels[i++] = value;
                    ++x;
                }
                ++y;
            }
            ++z;
        }
        return voxels;
    }

    public void setVoxels(int x0, int y0, int z0, int w, int h, int d, float[] voxels) {
        boolean inBounds;
        boolean bl = inBounds = x0 >= 0 && x0 + w <= this.width && y0 >= 0 && y0 + h <= this.height && z0 >= 0 && z0 + d <= this.nSlices;
        if (voxels == null || voxels.length != w * h * d) {
            // empty if block
        }
        int i = 0;
        int z = z0;
        while (z < z0 + d) {
            int y = y0;
            while (y < y0 + h) {
                block21: {
                    block20: {
                        if (!inBounds) break block20;
                        switch (this.type) {
                            case 0: {
                                float value;
                                byte[] bytes = (byte[])this.stack[z];
                                int x = x0;
                                while (x < x0 + w) {
                                    int n = i++;
                                    value = voxels[n];
                                    if (value > 255.0f) {
                                        value = 255.0f;
                                    } else if (value < 0.0f) {
                                        value = 0.0f;
                                    }
                                    bytes[y * this.width + x] = (byte)(value + 0.5f);
                                    ++x;
                                }
                                break block21;
                            }
                            case 1: {
                                float value;
                                short[] shorts = (short[])this.stack[z];
                                int x = x0;
                                while (x < x0 + w) {
                                    int n = i++;
                                    value = voxels[n];
                                    if (value > 65535.0f) {
                                        value = 65535.0f;
                                    } else if (value < 0.0f) {
                                        value = 0.0f;
                                    }
                                    shorts[y * this.width + x] = (short)(value + 0.5f);
                                    ++x;
                                }
                                break block21;
                            }
                            case 2: {
                                float value;
                                float[] floats = (float[])this.stack[z];
                                int x = x0;
                                while (x < x0 + w) {
                                    floats[y * this.width + x] = value = voxels[i++];
                                    ++x;
                                }
                                break block21;
                            }
                            case 3: {
                                float value;
                                int[] ints = (int[])this.stack[z];
                                int x = x0;
                                while (x < x0 + w) {
                                    value = voxels[i++];
                                    ints[y * this.width + x] = (int)value;
                                    ++x;
                                }
                                break block0;
                            }
                        }
                        break block21;
                    }
                    int x = x0;
                    while (x < x0 + w) {
                        this.setVoxel(x, y, z, voxels[i++]);
                        ++x;
                    }
                }
                ++y;
            }
            ++z;
        }
    }

    public void setVoxels(int x0, int y0, int z0, int w, int h, int d, float[] voxels, int channel) {
        boolean inBounds;
        if (this.getBitDepth() != 24) {
            this.setVoxels(x0, y0, z0, w, h, d, voxels);
            return;
        }
        boolean bl = inBounds = x0 >= 0 && x0 + w <= this.width && y0 >= 0 && y0 + h <= this.height && z0 >= 0 && z0 + d <= this.nSlices;
        if (voxels == null || voxels.length != w * h * d) {
            // empty if block
        }
        int i = 0;
        int z = z0;
        while (z < z0 + d) {
            int[] ints = (int[])this.stack[z];
            int y = y0;
            while (y < y0 + h) {
                int x = x0;
                while (x < x0 + w) {
                    int value = inBounds ? ints[y * this.width + x] & 0xFFFFFFFF : (int)this.getVoxel(x, y, z);
                    int color = (int)voxels[i++];
                    switch (channel) {
                        case 0: {
                            value = value & 0xFF00FFFF | (color & 0xFF) << 16;
                            break;
                        }
                        case 1: {
                            value = value & 0xFFFF00FF | (color & 0xFF) << 8;
                            break;
                        }
                        case 2: {
                            value = value & 0xFFFFFF00 | color & 0xFF;
                        }
                    }
                    if (inBounds) {
                        ints[y * this.width + x] = value;
                    } else {
                        this.setVoxel(x, y, z, value);
                    }
                    ++x;
                }
                ++y;
            }
            ++z;
        }
    }

    public void drawSphere(double radius, int xc, int yc, int zc) {
        int diameter = (int)Math.round(radius * 2.0);
        double r = radius;
        int xmin = (int)((double)xc - r + 0.5);
        int ymin = (int)((double)yc - r + 0.5);
        int zmin = (int)((double)zc - r + 0.5);
        int xmax = xmin + diameter;
        int ymax = ymin + diameter;
        int zmax = zmin + diameter;
        double r2 = r * r;
        double xoffset = (double)xmin + (r -= 0.5);
        double yoffset = (double)ymin + r;
        double zoffset = (double)zmin + r;
        int x = xmin;
        while (x <= xmax) {
            int y = ymin;
            while (y <= ymax) {
                int z = zmin;
                while (z <= zmax) {
                    double xx = (double)x - xoffset;
                    double yy = (double)y - yoffset;
                    double zz = (double)z - zoffset;
                    if (xx * xx + yy * yy + zz * zz <= r2) {
                        this.setVoxel(x, y, z, 255.0);
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    public int getBitDepth() {
        switch (this.type) {
            case 0: {
                return 8;
            }
            case 1: {
                return 16;
            }
            case 2: {
                return 32;
            }
            case 3: {
                return 24;
            }
        }
        return 0;
    }

    private int getType(ImageProcessor ip) {
        int bitDepth = ip.getBitDepth();
        switch (bitDepth) {
            case 8: {
                return 0;
            }
            case 16: {
                return 1;
            }
            case 32: {
                return 2;
            }
            case 24: {
                return 3;
            }
        }
        return -1;
    }

    public static ImageStack create(int width, int height, int depth, int bitdepth) {
        ImageStack stack = IJ.createImage("", width, height, depth, bitdepth).getStack();
        if (bitdepth == 16 || bitdepth == 32) {
            stack.min = Double.MAX_VALUE;
            stack.max = 0.0;
        }
        return stack;
    }
}

