/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.v2.org.apache.poi.ss.formula.constant;

import com.fr.third.v2.org.apache.poi.ss.usermodel.ErrorConstants;
import com.fr.third.v2.org.apache.poi.util.POILogFactory;
import com.fr.third.v2.org.apache.poi.util.POILogger;

public class ErrorConstant {
    private static POILogger logger = POILogFactory.getLogger(ErrorConstant.class);
    private static final ErrorConstants EC = null;
    private static final ErrorConstant NULL = new ErrorConstant(0);
    private static final ErrorConstant DIV_0 = new ErrorConstant(7);
    private static final ErrorConstant VALUE = new ErrorConstant(15);
    private static final ErrorConstant REF = new ErrorConstant(23);
    private static final ErrorConstant NAME = new ErrorConstant(29);
    private static final ErrorConstant NUM = new ErrorConstant(36);
    private static final ErrorConstant NA = new ErrorConstant(42);
    private final int _errorCode;

    private ErrorConstant(int errorCode) {
        this._errorCode = errorCode;
    }

    public int getErrorCode() {
        return this._errorCode;
    }

    public String getText() {
        if (ErrorConstants.isValidCode(this._errorCode)) {
            return ErrorConstants.getText(this._errorCode);
        }
        return "unknown error code (" + this._errorCode + ")";
    }

    public static ErrorConstant valueOf(int errorCode) {
        switch (errorCode) {
            case 0: {
                return NULL;
            }
            case 7: {
                return DIV_0;
            }
            case 15: {
                return VALUE;
            }
            case 23: {
                return REF;
            }
            case 29: {
                return NAME;
            }
            case 36: {
                return NUM;
            }
            case 42: {
                return NA;
            }
        }
        logger.log(5, new Object[]{"Warning - unexpected error code (" + errorCode + ")"});
        return new ErrorConstant(errorCode);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(64);
        sb.append(this.getClass().getName()).append(" [");
        sb.append(this.getText());
        sb.append("]");
        return sb.toString();
    }
}

