/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.v2.org.apache.poi.openxml4j.opc.internal.marshallers;

import com.fr.third.v2.org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import com.fr.third.v2.org.apache.poi.openxml4j.opc.PackagePart;
import com.fr.third.v2.org.apache.poi.openxml4j.opc.StreamHelper;
import com.fr.third.v2.org.apache.poi.openxml4j.opc.internal.ZipHelper;
import com.fr.third.v2.org.apache.poi.openxml4j.opc.internal.marshallers.PackagePropertiesMarshaller;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public final class ZipPackagePropertiesMarshaller
extends PackagePropertiesMarshaller {
    public boolean marshall(PackagePart part, OutputStream out) throws OpenXML4JException {
        if (!(out instanceof ZipOutputStream)) {
            throw new IllegalArgumentException("ZipOutputStream expected!");
        }
        ZipOutputStream zos = (ZipOutputStream)out;
        ZipEntry ctEntry = new ZipEntry(ZipHelper.getZipItemNameFromOPCName(part.getPartName().getURI().toString()));
        try {
            zos.putNextEntry(ctEntry);
            super.marshall(part, out);
            if (!StreamHelper.saveXmlInStream(this.xmlDoc, out)) {
                return false;
            }
            zos.closeEntry();
        }
        catch (IOException e) {
            throw new OpenXML4JException(e.getLocalizedMessage());
        }
        return true;
    }
}

