/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.hsqldb.util;

import com.fr.third.org.hsqldb.lib.java.JavaSystem;
import com.fr.third.org.hsqldb.util.DatabaseManager;
import com.fr.third.org.hsqldb.util.DatabaseManagerCommon;
import com.fr.third.org.hsqldb.util.Grid;
import com.fr.third.org.hsqldb.util.Tree;
import com.fr.third.org.hsqldb.util.ZaurusConnectionDialog;
import com.fr.third.org.hsqldb.util.ZaurusEditor;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowListener;
import java.awt.image.MemoryImageSource;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class ZaurusDatabaseManager
extends DatabaseManager
implements ActionListener,
WindowListener,
KeyListener {
    Button butTree;
    Button butCommand;
    Button butResult;
    Button butEditor;
    Panel pCard;
    CardLayout layoutCard;
    ZaurusEditor eEditor;
    static String defDriver;
    static String defURL;
    static String defUser;
    static String defPassword;
    static String defQuery;
    static String defDirectory;
    static String defDatabase;
    static int defWidth;
    static int defHeight;
    static int defLocX;
    static int defLocY;

    public void connect(Connection c) {
        if (c == null) {
            return;
        }
        if (this.cConn != null) {
            try {
                this.cConn.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
        this.cConn = c;
        try {
            this.dMeta = this.cConn.getMetaData();
            this.sStatement = this.cConn.createStatement();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.refreshTree();
    }

    public static void main(String[] arg) {
        bMustExit = true;
        for (int i = 0; i < arg.length; ++i) {
            if (arg[i].equalsIgnoreCase("-driver") && i + 1 < arg.length) {
                defDriver = arg[++i];
                continue;
            }
            if (arg[i].equalsIgnoreCase("-url") && i + 1 < arg.length) {
                defURL = arg[++i];
                continue;
            }
            if (arg[i].equalsIgnoreCase("-width") && i + 1 < arg.length) {
                ++i;
                try {
                    defWidth = Integer.parseInt(arg[i]);
                }
                catch (Exception e) {}
                continue;
            }
            if (arg[i].equalsIgnoreCase("-height") && i + 1 < arg.length) {
                ++i;
                try {
                    defHeight = Integer.parseInt(arg[i]);
                }
                catch (Exception e) {}
                continue;
            }
            if (arg[i].equalsIgnoreCase("-locx") && i + 1 < arg.length) {
                ++i;
                try {
                    defLocX = Integer.parseInt(arg[i]);
                }
                catch (Exception e) {}
                continue;
            }
            if (arg[i].equalsIgnoreCase("-locy") && i + 1 < arg.length) {
                ++i;
                try {
                    defLocY = Integer.parseInt(arg[i]);
                }
                catch (Exception e) {}
                continue;
            }
            if (arg[i].equalsIgnoreCase("-user") && i + 1 < arg.length) {
                defUser = arg[++i];
                continue;
            }
            if (arg[i].equalsIgnoreCase("-password") && i + 1 < arg.length) {
                defPassword = arg[++i];
                continue;
            }
            if (arg[i].equalsIgnoreCase("-query") && i + 1 < arg.length) {
                defQuery = arg[++i];
                continue;
            }
            if (arg[i].equalsIgnoreCase("-defDirectory") && i + 1 < arg.length) {
                defDirectory = arg[++i];
                continue;
            }
            if (arg[i].equalsIgnoreCase("-database") && i + 1 < arg.length) {
                defDatabase = arg[++i];
                continue;
            }
            ZaurusDatabaseManager.showUsage();
            return;
        }
        ZaurusDatabaseManager m = new ZaurusDatabaseManager();
        m.main();
        Connection c = null;
        if (defDriver != null && defURL != null || defDatabase != null) {
            if (defDatabase != null) {
                defDriver = "com.fr.third.org.hsqldb.jdbcDriver";
                defURL = "jdbc:hsqldb:" + defDatabase;
                defUser = "SA";
                defPassword = "";
            }
            try {
                Class.forName(defDriver).newInstance();
                c = DriverManager.getConnection(defURL, defUser, defPassword);
            }
            catch (Exception e) {
                System.out.println("No connection for " + defDriver + " at " + defURL);
                e.printStackTrace();
            }
        } else {
            c = ZaurusConnectionDialog.createConnection(m.fMain, "Connect", new Insets(defWidth, defHeight, defLocX, defLocY));
        }
        if (c == null) {
            return;
        }
        m.connect(c);
    }

    private static void showUsage() {
        System.out.println("Usage: java com.fr.third.org.hsqldb.util.ZaurusDatabaseManager [options]");
        System.out.println("where options could be:");
        System.out.println("If the next two options are set, the specified connection will be used:");
        System.out.println("   -driver dr");
        System.out.println("   -url address");
        System.out.println("-user name");
        System.out.println("-password passw");
        System.out.println("Alternative the database argument is used,");
        System.out.println("and the hsqldb Driver Standalone is chosen for user 'SA'.");
        System.out.println("-database db");
        System.out.println("-query qu                   the query qu will be read during initialization");
        System.out.println("-defaultDirectory defdir    default dir for the file open dialog");
        System.out.println("If the next two options are set, the frame will be set to the specified values:");
        System.out.println("   -width width");
        System.out.println("   -height height");
        System.out.println("-locX positon left ");
        System.out.println("-locY positon top ");
        System.out.println("");
        System.out.println("1. Example: java com.fr.third.org.hsqldb.util.ZaurusDatabaseManager +");
        System.out.println("  -driver 'com.fr.third.org.hsqldb.jdbcDriver' +");
        System.out.println("  -url 'jdbc:hsqldb:test'");
        System.out.println("2. Example: java com.fr.third.org.hsqldb.util.ZaurusDatabaseManager +");
        System.out.println("  -database 'test'");
    }

    public void main() {
        this.fMain = new Frame("HSQLDB Database Manager for Zaurus");
        this.imgEmpty = this.createImage(new MemoryImageSource(2, 2, new int[16], 2, 2));
        this.fMain.setIconImage(this.imgEmpty);
        this.fMain.addWindowListener(this);
        MenuBar bar = new MenuBar();
        String[] fitems = new String[]{"-Connect...", "--", "-Open Script...", "-Save Script...", "-Save Result...", "--", "-Exit"};
        this.addMenu(bar, "File", fitems);
        String[] vitems = new String[]{"-Refresh Tree", "--", "-View Tree", "-View Command", "-View Result", "-View Editor", "--", "-Results in Grid", "-Results in Text"};
        this.addMenu(bar, "View", vitems);
        String[] sitems = new String[]{"-SELECT", "-INSERT", "-UPDATE", "-DELETE", "--", "-CREATE TABLE", "-DROP TABLE", "-CREATE INDEX", "-DROP INDEX", "--", "-SCRIPT", "-SHUTDOWN", "--", "-Test Script"};
        this.addMenu(bar, "SQL", sitems);
        Menu recent = new Menu("Recent");
        this.mRecent = new Menu("Recent");
        bar.add(this.mRecent);
        String[] soptions = new String[]{"-AutoCommit on", "-AutoCommit off", "-Commit", "-Rollback", "--", "-Disable MaxRows", "-Set MaxRows to 100", "--", "-Logging on", "-Logging off", "--", "-Insert test data"};
        this.addMenu(bar, "Options", soptions);
        String[] shelp = new String[]{"-Show HTML-Help in browser"};
        this.addMenu(bar, "?", shelp);
        this.fMain.setMenuBar(bar);
        this.fMain.setSize(defWidth, defHeight);
        this.fMain.add("Center", this);
        this.initGUI();
        this.sRecent = new String[24];
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension size = this.fMain.getSize();
        if (d.width > 640) {
            this.fMain.setLocation((d.width - size.width) / 2, (d.height - size.height) / 2);
        } else if (defWidth > 0 && defHeight > 0) {
            this.fMain.setLocation(defLocX, defLocY);
            this.fMain.setSize(defWidth, defHeight);
        } else {
            this.fMain.setLocation(0, 0);
            this.fMain.setSize(d);
        }
        this.fMain.show();
        if (defQuery != null) {
            this.txtCommand.setText(DatabaseManagerCommon.readFile(defQuery));
        }
        this.txtCommand.requestFocus();
    }

    public void keyTyped(KeyEvent k) {
        if (k.getKeyChar() == '\n' && (k.isControlDown() || k.isShiftDown())) {
            k.consume();
            this.execute();
            this.layoutCard.show(this.pCard, "result");
        }
    }

    public void keyPressed(KeyEvent k) {
    }

    public void actionPerformed(ActionEvent ev) {
        String s = ev.getActionCommand();
        if (s == null && ev.getSource() instanceof MenuItem) {
            s = ((MenuItem)ev.getSource()).getLabel();
        }
        if (s.equals("Execute")) {
            this.execute();
            this.layoutCard.show(this.pCard, "result");
        } else if (s.equals("Tree")) {
            this.layoutCard.show(this.pCard, "tree");
        } else if (s.equals("Command")) {
            this.layoutCard.show(this.pCard, "command");
        } else if (s.equals("Result")) {
            this.layoutCard.show(this.pCard, "result");
        } else if (s.equals("Editor")) {
            this.layoutCard.show(this.pCard, "editor");
        } else if (s.equals("Exit")) {
            this.windowClosing(null);
        } else if (s.equals("Logging on")) {
            JavaSystem.setLogToSystem(true);
        } else if (s.equals("Logging off")) {
            JavaSystem.setLogToSystem(false);
        } else if (s.equals("Refresh Tree")) {
            this.refreshTree();
            this.layoutCard.show(this.pCard, "tree");
        } else if (s.startsWith("#")) {
            int i = Integer.parseInt(s.substring(1));
            this.txtCommand.setText(this.sRecent[i]);
        } else if (s.equals("Connect...")) {
            this.connect(ZaurusConnectionDialog.createConnection(this.fMain, "Connect", new Insets(defWidth, defHeight, defLocX, defLocY)));
            this.refreshTree();
            this.layoutCard.show(this.pCard, "tree");
        } else if (s.equals("View Tree")) {
            this.layoutCard.show(this.pCard, "tree");
        } else if (s.equals("View Command")) {
            this.layoutCard.show(this.pCard, "command");
        } else if (s.equals("View Result")) {
            this.layoutCard.show(this.pCard, "result");
        } else if (s.equals("View Editor")) {
            this.layoutCard.show(this.pCard, "editor");
        } else if (s.equals("Results in Grid")) {
            this.iResult = 0;
            this.pResult.removeAll();
            this.pResult.add("Center", this.gResult);
            this.pResult.doLayout();
            this.layoutCard.show(this.pCard, "result");
        } else if (s.equals("Open Script...")) {
            FileDialog f = new FileDialog(this.fMain, "Open Script", 0);
            if (defDirectory != null) {
                f.setDirectory(defDirectory);
            }
            f.show();
            String file = f.getFile();
            if (file != null) {
                this.txtCommand.setText(DatabaseManagerCommon.readFile(f.getDirectory() + file));
            }
            this.layoutCard.show(this.pCard, "command");
        } else if (s.equals("Save Script...")) {
            FileDialog f = new FileDialog(this.fMain, "Save Script", 1);
            if (defDirectory != null) {
                f.setDirectory(defDirectory);
            }
            f.show();
            String file = f.getFile();
            if (file != null) {
                DatabaseManagerCommon.writeFile(f.getDirectory() + file, this.txtCommand.getText());
            }
        } else if (s.equals("Save Result...")) {
            FileDialog f = new FileDialog(this.fMain, "Save Result", 1);
            if (defDirectory != null) {
                f.setDirectory(defDirectory);
            }
            f.show();
            String file = f.getFile();
            if (file != null) {
                this.showResultInText();
                DatabaseManagerCommon.writeFile(f.getDirectory() + file, this.txtResult.getText());
            }
        } else if (s.equals("Results in Text")) {
            this.iResult = 1;
            this.pResult.removeAll();
            this.pResult.add("Center", this.txtResult);
            this.pResult.doLayout();
            this.showResultInText();
            this.layoutCard.show(this.pCard, "result");
        } else if (s.equals("AutoCommit on")) {
            try {
                this.cConn.setAutoCommit(true);
            }
            catch (SQLException e) {}
        } else if (s.equals("AutoCommit off")) {
            try {
                this.cConn.setAutoCommit(false);
            }
            catch (SQLException e) {}
        } else if (s.equals("Commit")) {
            try {
                this.cConn.commit();
            }
            catch (SQLException e) {}
        } else if (s.equals("Insert test data")) {
            this.insertTestData();
            this.layoutCard.show(this.pCard, "result");
        } else if (s.equals("Rollback")) {
            try {
                this.cConn.rollback();
            }
            catch (SQLException e) {}
        } else if (s.equals("Disable MaxRows")) {
            try {
                this.sStatement.setMaxRows(0);
            }
            catch (SQLException e) {}
        } else if (s.equals("Set MaxRows to 100")) {
            try {
                this.sStatement.setMaxRows(100);
            }
            catch (SQLException e) {}
        } else if (s.equals("SELECT")) {
            this.showHelp(DatabaseManagerCommon.selectHelp);
        } else if (s.equals("INSERT")) {
            this.showHelp(DatabaseManagerCommon.insertHelp);
        } else if (s.equals("UPDATE")) {
            this.showHelp(DatabaseManagerCommon.updateHelp);
        } else if (s.equals("DELETE")) {
            this.showHelp(DatabaseManagerCommon.deleteHelp);
        } else if (s.equals("CREATE TABLE")) {
            this.showHelp(DatabaseManagerCommon.createTableHelp);
        } else if (s.equals("DROP TABLE")) {
            this.showHelp(DatabaseManagerCommon.dropTableHelp);
        } else if (s.equals("CREATE INDEX")) {
            this.showHelp(DatabaseManagerCommon.createIndexHelp);
        } else if (s.equals("DROP INDEX")) {
            this.showHelp(DatabaseManagerCommon.dropIndexHelp);
        } else if (s.equals("CHECKPOINT")) {
            this.showHelp(DatabaseManagerCommon.checkpointHelp);
        } else if (s.equals("SCRIPT")) {
            this.showHelp(DatabaseManagerCommon.scriptHelp);
        } else if (s.equals("SHUTDOWN")) {
            this.showHelp(DatabaseManagerCommon.shutdownHelp);
        } else if (s.equals("SET")) {
            this.showHelp(DatabaseManagerCommon.setHelp);
        } else if (s.equals("Test Script")) {
            this.showHelp(DatabaseManagerCommon.testHelp);
        } else if (s.equals("Show HTML-Help in browser")) {
            try {
                System.out.println("Starting Opera on index.html");
                Runtime.getRuntime().exec(new String[]{"opera", "/home/QtPalmtop/help/html/hsqldb/index.html"});
            }
            catch (IOException e) {
                System.out.println("A problem with Opera occured.");
            }
        }
    }

    private void initGUI() {
        Panel pQuery = new Panel();
        Panel pCommand = new Panel();
        this.pCard = new Panel();
        this.layoutCard = new CardLayout(2, 2);
        this.pCard.setLayout(this.layoutCard);
        this.butTree = new Button("Tree");
        this.butCommand = new Button("Command");
        this.butResult = new Button("Result");
        this.butEditor = new Button("Editor");
        this.butTree.addActionListener(this);
        this.butCommand.addActionListener(this);
        this.butResult.addActionListener(this);
        this.butEditor.addActionListener(this);
        Panel pButtons = new Panel();
        pButtons.setLayout(new GridLayout(1, 4, 8, 8));
        pButtons.add(this.butTree);
        pButtons.add(this.butCommand);
        pButtons.add(this.butResult);
        pButtons.add(this.butEditor);
        this.pResult = new Panel();
        pQuery.setLayout(new BorderLayout());
        pCommand.setLayout(new BorderLayout());
        this.pResult.setLayout(new BorderLayout());
        Font fFont = new Font("Dialog", 0, 12);
        this.txtCommand = new TextArea(5, 40);
        this.txtCommand.addKeyListener(this);
        this.txtResult = new TextArea(20, 40);
        this.txtCommand.setFont(fFont);
        this.txtResult.setFont(new Font("Courier", 0, 12));
        this.butExecute = new Button("Execute");
        this.butExecute.addActionListener(this);
        pCommand.add("South", this.butExecute);
        pCommand.add("Center", this.txtCommand);
        this.gResult = new Grid();
        this.setLayout(new BorderLayout());
        this.pResult.add("Center", this.gResult);
        this.tTree = new Tree();
        this.tTree.setMinimumSize(new Dimension(200, 100));
        this.gResult.setMinimumSize(new Dimension(200, 300));
        this.eEditor = new ZaurusEditor();
        this.pCard.add("tree", this.tTree);
        this.pCard.add("command", pCommand);
        this.pCard.add("result", this.pResult);
        this.pCard.add("editor", this.eEditor);
        this.fMain.add("Center", this.pCard);
        this.fMain.add("North", pButtons);
        this.doLayout();
        this.fMain.pack();
    }

    protected void refreshTree() {
        super.refreshTree();
        this.eEditor.refresh(this.cConn);
    }

    static {
        defWidth = 237;
        defHeight = 259;
        defLocX = 0;
        defLocY = 0;
    }
}

