/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.hsqldb.persist;

import com.fr.third.org.hsqldb.Database;
import com.fr.third.org.hsqldb.HsqlException;
import com.fr.third.org.hsqldb.Row;
import com.fr.third.org.hsqldb.Session;
import com.fr.third.org.hsqldb.Table;
import com.fr.third.org.hsqldb.Trace;
import com.fr.third.org.hsqldb.index.RowIterator;
import com.fr.third.org.hsqldb.lib.DoubleIntIndex;
import com.fr.third.org.hsqldb.lib.HsqlArrayList;
import com.fr.third.org.hsqldb.lib.StopWatch;
import com.fr.third.org.hsqldb.lib.Storage;
import com.fr.third.org.hsqldb.lib.StringUtil;
import com.fr.third.org.hsqldb.persist.DataFileCache;
import com.fr.third.org.hsqldb.persist.ScaledRAFile;
import com.fr.third.org.hsqldb.rowio.RowInputInterface;
import com.fr.third.org.hsqldb.rowio.RowOutputBinary;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;

final class DataFileDefrag {
    BufferedOutputStream fileStreamOut;
    long fileOffset;
    StopWatch stopw = new StopWatch();
    String filename;
    int[][] rootsList;
    Database database;
    DataFileCache cache;
    int scale;
    DoubleIntIndex transactionRowLookup;

    DataFileDefrag(Database db, DataFileCache cache, String filename) {
        this.database = db;
        this.cache = cache;
        this.scale = cache.cacheFileScale;
        this.filename = filename;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void process() throws HsqlException, IOException {
        Storage dest;
        boolean complete;
        block14: {
            complete = false;
            Trace.printSystemOut("Defrag Transfer begins");
            this.transactionRowLookup = this.database.txManager.getTransactionIDList();
            HsqlArrayList allTables = this.database.schemaManager.getAllTables();
            this.rootsList = new int[allTables.size()][];
            dest = null;
            try {
                try {
                    int i;
                    OutputStream fos = this.database.getFileAccess().openOutputStreamElement(this.filename + ".new");
                    this.fileStreamOut = new BufferedOutputStream(fos, 4096);
                    for (i = 0; i < 32; ++i) {
                        this.fileStreamOut.write(0);
                    }
                    this.fileOffset = 32L;
                    int tSize = allTables.size();
                    for (i = 0; i < tSize; ++i) {
                        Table t = (Table)allTables.get(i);
                        if (t.getTableType() == 4) {
                            int[] rootsArray = this.writeTableToDataFile(t);
                            this.rootsList[i] = rootsArray;
                        } else {
                            this.rootsList[i] = null;
                        }
                        Trace.printSystemOut(t.getName().name + " complete");
                    }
                    this.writeTransactionRows();
                    this.fileStreamOut.flush();
                    this.fileStreamOut.close();
                    this.fileStreamOut = null;
                    dest = ScaledRAFile.newScaledRAFile(this.database, this.filename + ".new", false, 0, this.database.getURLProperties().getProperty("storage_class_name"), this.database.getURLProperties().getProperty("storage_key"));
                    dest.seek(12L);
                    dest.writeLong(this.fileOffset);
                    dest.close();
                    dest = null;
                    int size = this.rootsList.length;
                    for (i = 0; i < size; ++i) {
                        int[] roots = this.rootsList[i];
                        if (roots == null) continue;
                        Trace.printSystemOut(StringUtil.getList(roots, ",", ""));
                    }
                    complete = true;
                }
                catch (IOException e) {
                    throw Trace.error(29, this.filename + ".new");
                }
                catch (OutOfMemoryError e) {
                    throw Trace.error(72);
                }
                Object var10_11 = null;
                if (this.fileStreamOut == null) break block14;
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                if (this.fileStreamOut != null) {
                    this.fileStreamOut.close();
                }
                if (dest != null) {
                    dest.close();
                }
                if (complete) throw throwable;
                this.database.getFileAccess().removeElement(this.filename + ".new");
                throw throwable;
            }
            this.fileStreamOut.close();
        }
        if (dest != null) {
            dest.close();
        }
        if (complete) return;
        this.database.getFileAccess().removeElement(this.filename + ".new");
    }

    void updateTableIndexRoots() throws HsqlException {
        HsqlArrayList allTables = this.database.schemaManager.getAllTables();
        int size = allTables.size();
        for (int i = 0; i < size; ++i) {
            Table t = (Table)allTables.get(i);
            if (t.getTableType() != 4) continue;
            int[] rootsArray = this.rootsList[i];
            t.setIndexRoots(rootsArray);
        }
    }

    void updateTransactionRowIDs() throws HsqlException {
        this.database.txManager.convertTransactionIDs(this.transactionRowLookup);
    }

    int[] writeTableToDataFile(Table table) throws IOException, HsqlException {
        Row row;
        Session session = this.database.getSessionManager().getSysSession();
        RowOutputBinary rowOut = new RowOutputBinary();
        DoubleIntIndex pointerLookup = new DoubleIntIndex(table.getPrimaryIndex().sizeEstimate(), false);
        int[] rootsArray = table.getIndexRootsArray();
        long pos = this.fileOffset;
        int count = 0;
        pointerLookup.setKeysSearchTarget();
        Trace.printSystemOut("lookup begins: " + this.stopw.elapsedTime());
        RowIterator it = table.rowIterator(session);
        while (it.hasNext()) {
            row = it.next();
            pointerLookup.addUnsorted(row.getPos(), (int)(pos / (long)this.scale));
            if (count % 50000 == 0) {
                Trace.printSystemOut("pointer pair for row " + count + " " + row.getPos() + " " + pos);
            }
            pos += (long)row.getStorageSize();
            ++count;
        }
        Trace.printSystemOut(table.getName().name + " list done ", this.stopw.elapsedTime());
        count = 0;
        it = table.rowIterator(session);
        while (it.hasNext()) {
            row = it.next();
            rowOut.reset();
            row.write(rowOut, pointerLookup);
            this.fileStreamOut.write(rowOut.getOutputStream().getBuffer(), 0, rowOut.size());
            this.fileOffset += (long)row.getStorageSize();
            if (count % 50000 == 0) {
                Trace.printSystemOut(count + " rows " + this.stopw.elapsedTime());
            }
            ++count;
        }
        for (int i = 0; i < rootsArray.length; ++i) {
            if (rootsArray[i] == -1) continue;
            int lookupIndex = pointerLookup.findFirstEqualKeyIndex(rootsArray[i]);
            if (lookupIndex == -1) {
                throw Trace.error(129);
            }
            rootsArray[i] = pointerLookup.getValue(lookupIndex);
        }
        this.setTransactionRowLookups(pointerLookup);
        Trace.printSystemOut(table.getName().name + " : table converted");
        return rootsArray;
    }

    void setTransactionRowLookups(DoubleIntIndex pointerLookup) {
        int size = this.transactionRowLookup.size();
        for (int i = 0; i < size; ++i) {
            int key = this.transactionRowLookup.getKey(i);
            int lookupIndex = pointerLookup.findFirstEqualKeyIndex(key);
            if (lookupIndex == -1) continue;
            this.transactionRowLookup.setValue(i, pointerLookup.getValue(lookupIndex));
        }
    }

    void writeTransactionRows() {
        int size = this.transactionRowLookup.size();
        for (int i = 0; i < size; ++i) {
            if (this.transactionRowLookup.getValue(i) != 0) continue;
            int key = this.transactionRowLookup.getKey(i);
            try {
                this.transactionRowLookup.setValue(i, (int)(this.fileOffset / (long)this.scale));
                RowInputInterface rowIn = this.cache.readObject(key);
                this.fileStreamOut.write(rowIn.getBuffer(), 0, rowIn.getSize());
                this.fileOffset += (long)rowIn.getSize();
                continue;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }
}

