/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.hsqldb.lib;

import com.fr.third.org.hsqldb.lib.StringConverter;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.io.UnsupportedEncodingException;

public class HsqlByteArrayOutputStream
extends OutputStream
implements DataOutput {
    protected byte[] buffer;
    protected int count;

    public HsqlByteArrayOutputStream() {
        this(128);
    }

    public HsqlByteArrayOutputStream(int size) {
        if (size < 128) {
            size = 128;
        }
        this.buffer = new byte[size];
    }

    public HsqlByteArrayOutputStream(byte[] buffer) {
        this.buffer = buffer;
    }

    public HsqlByteArrayOutputStream(InputStream input, int length) throws IOException {
        this.buffer = new byte[length];
        int left = length;
        while (left > 0) {
            int read = input.read(this.buffer, this.count, left);
            if (read == -1) {
                if (left <= 0) break;
                input.close();
                throw new EOFException();
            }
            left -= read;
            this.count += read;
        }
    }

    public void writeShort(int v) {
        this.ensureRoom(2);
        this.buffer[this.count++] = (byte)(v >>> 8);
        this.buffer[this.count++] = (byte)v;
    }

    public void writeInt(int v) {
        if (this.count + 4 > this.buffer.length) {
            this.ensureRoom(4);
        }
        this.buffer[this.count++] = (byte)(v >>> 24);
        this.buffer[this.count++] = (byte)(v >>> 16);
        this.buffer[this.count++] = (byte)(v >>> 8);
        this.buffer[this.count++] = (byte)v;
    }

    public void writeLong(long v) {
        this.writeInt((int)(v >>> 32));
        this.writeInt((int)v);
    }

    public final void writeBytes(String s) {
        int len = s.length();
        this.ensureRoom(len);
        for (int i = 0; i < len; ++i) {
            this.buffer[this.count++] = (byte)s.charAt(i);
        }
    }

    public final void writeFloat(float v) {
        this.writeInt(Float.floatToIntBits(v));
    }

    public final void writeDouble(double v) {
        this.writeLong(Double.doubleToLongBits(v));
    }

    public void writeBoolean(boolean v) {
        this.ensureRoom(1);
        this.buffer[this.count++] = (byte)(v ? 1 : 0);
    }

    public void writeByte(int v) {
        this.ensureRoom(1);
        this.buffer[this.count++] = (byte)v;
    }

    public void writeChar(int v) {
        this.ensureRoom(2);
        this.buffer[this.count++] = (byte)(v >>> 8);
        this.buffer[this.count++] = (byte)v;
    }

    public void writeChars(String s) {
        int len = s.length();
        this.ensureRoom(len * 2);
        for (int i = 0; i < len; ++i) {
            char v = s.charAt(i);
            this.buffer[this.count++] = (byte)(v >>> 8);
            this.buffer[this.count++] = (byte)v;
        }
    }

    public void writeUTF(String str) throws IOException {
        int len = str.length();
        if (len > 65535) {
            throw new UTFDataFormatException();
        }
        this.ensureRoom(len * 3 + 2);
        int initpos = this.count;
        this.count += 2;
        StringConverter.writeUTF(str, this);
        int bytecount = this.count - initpos - 2;
        if (bytecount > 65535) {
            this.count = initpos;
            throw new UTFDataFormatException();
        }
        this.buffer[initpos++] = (byte)(bytecount >>> 8);
        this.buffer[initpos] = (byte)bytecount;
    }

    public void flush() throws IOException {
    }

    public void write(int b) {
        this.ensureRoom(1);
        this.buffer[this.count++] = (byte)b;
    }

    public void writeNoCheck(int b) {
        this.buffer[this.count++] = (byte)b;
    }

    public void write(byte[] b) {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) {
        this.ensureRoom(len);
        System.arraycopy(b, off, this.buffer, this.count, len);
        this.count += len;
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this.buffer, 0, this.count);
    }

    public void reset() {
        this.count = 0;
    }

    public byte[] toByteArray() {
        byte[] newbuf = new byte[this.count];
        System.arraycopy(this.buffer, 0, newbuf, 0, this.count);
        return newbuf;
    }

    public int size() {
        return this.count;
    }

    public void setPosition(int newPos) {
        if (newPos > this.buffer.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.count = newPos;
    }

    public String toString() {
        return new String(this.buffer, 0, this.count);
    }

    public String toString(String enc) throws UnsupportedEncodingException {
        return new String(this.buffer, 0, this.count, enc);
    }

    public void close() throws IOException {
    }

    public void write(char[] c, int off, int len) {
        this.ensureRoom(len * 2);
        for (int i = off; i < len; ++i) {
            char v = c[i];
            this.buffer[this.count++] = (byte)(v >>> 8);
            this.buffer[this.count++] = (byte)v;
        }
    }

    public void fill(int b, int len) {
        this.ensureRoom(len);
        for (int i = 0; i < len; ++i) {
            this.buffer[this.count++] = (byte)b;
        }
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public void setBuffer(byte[] buffer) {
        this.count = 0;
        this.buffer = buffer;
    }

    public void ensureRoom(int extra) {
        int newcount = this.count + extra;
        int newsize = this.buffer.length;
        if (newcount > newsize) {
            while (newcount > newsize) {
                newsize *= 2;
            }
            byte[] newbuf = new byte[newsize];
            System.arraycopy(this.buffer, 0, newbuf, 0, this.count);
            this.buffer = newbuf;
        }
    }

    public void reset(int newSize) {
        this.count = 0;
        if (newSize > this.buffer.length) {
            this.buffer = new byte[newSize];
        }
    }

    public void reset(byte[] buffer) {
        this.count = 0;
        this.buffer = buffer;
    }
}

