/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.hsqldb.jdbc;

import com.fr.third.org.hsqldb.Column;
import com.fr.third.org.hsqldb.Library;
import com.fr.third.org.hsqldb.jdbc.Util;
import com.fr.third.org.hsqldb.jdbc.jdbcConnection;
import com.fr.third.org.hsqldb.jdbc.jdbcResultSet;
import com.fr.third.org.hsqldb.lib.StringUtil;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;

public class jdbcDatabaseMetaData
implements DatabaseMetaData {
    static final Integer INT_COLUMNS_NO_NULLS = new Integer(0);
    private jdbcConnection connection;
    private boolean useSchemaDefault;
    private static final String BRI_SESSION_SCOPE_IN_LIST = "(2)";
    private static final String BRI_TEMPORARY_SCOPE_IN_LIST = "(0,1,2)";
    private static final String BRI_TRANSACTION_SCOPE_IN_LIST = "(1,2)";
    private static final String selstar = "SELECT * FROM INFORMATION_SCHEMA.";
    private static final String whereTrue = " WHERE 1=1";

    public boolean allProceduresAreCallable() throws SQLException {
        return true;
    }

    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    public String getURL() throws SQLException {
        return this.connection.getURL();
    }

    public String getUserName() throws SQLException {
        ResultSet rs = this.execute("CALL USER()");
        rs.next();
        String result = rs.getString(1);
        rs.close();
        return result;
    }

    public boolean isReadOnly() throws SQLException {
        ResultSet rs = this.execute("CALL \"com.fr.third.org.hsqldb.Library.isReadOnlyDatabase\"()");
        rs.next();
        boolean result = rs.getBoolean(1);
        rs.close();
        return result;
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedLow() throws SQLException {
        return true;
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    public String getDatabaseProductName() throws SQLException {
        ResultSet rs = this.execute("call \"com.fr.third.org.hsqldb.Library.getDatabaseProductName\"()");
        rs.next();
        String result = rs.getString(1);
        rs.close();
        return result;
    }

    public String getDatabaseProductVersion() throws SQLException {
        ResultSet rs = this.execute("call \"com.fr.third.org.hsqldb.Library.getDatabaseProductVersion\"()");
        rs.next();
        String result = rs.getString(1);
        rs.close();
        return result;
    }

    public String getDriverName() throws SQLException {
        return "HSQL Database Engine Driver";
    }

    public String getDriverVersion() throws SQLException {
        return "1.8.1";
    }

    public int getDriverMajorVersion() {
        return 1;
    }

    public int getDriverMinorVersion() {
        return 8;
    }

    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return true;
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public String getIdentifierQuoteString() throws SQLException {
        return "\"";
    }

    public String getSQLKeywords() throws SQLException {
        return "BEFORE,BIGINT,BINARY,CACHED,DATETIME,LIMIT,LONGVARBINARY,LONGVARCHAR,OBJECT,OTHER,SAVEPOINT,TEMP,TEXT,TOP,TRIGGER,TINYINT,VARBINARY,VARCHAR_IGNORECASE";
    }

    public String getNumericFunctions() throws SQLException {
        return StringUtil.getList(Library.sNumeric, ",", "");
    }

    public String getStringFunctions() throws SQLException {
        return StringUtil.getList(Library.sString, ",", "");
    }

    public String getSystemFunctions() throws SQLException {
        return StringUtil.getList(Library.sSystem, ",", "");
    }

    public String getTimeDateFunctions() throws SQLException {
        return StringUtil.getList(Library.sTimeDate, ",", "");
    }

    public String getSearchStringEscape() throws SQLException {
        return "\\";
    }

    public String getExtraNameCharacters() throws SQLException {
        return "";
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return true;
    }

    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    public boolean supportsConvert() throws SQLException {
        return true;
    }

    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        return true;
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return true;
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        return true;
    }

    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        return true;
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return true;
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return false;
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return false;
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return true;
    }

    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        return false;
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    public String getSchemaTerm() throws SQLException {
        return "SCHEMA";
    }

    public String getProcedureTerm() throws SQLException {
        return "";
    }

    public String getCatalogTerm() throws SQLException {
        return "";
    }

    public boolean isCatalogAtStart() throws SQLException {
        return false;
    }

    public String getCatalogSeparator() throws SQLException {
        return "";
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return !this.useSchemaDefault;
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return !this.useSchemaDefault;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return !this.useSchemaDefault;
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        return false;
    }

    public boolean supportsStoredProcedures() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return true;
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }

    public boolean supportsUnion() throws SQLException {
        return true;
    }

    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return true;
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return true;
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    public int getMaxCharLiteralLength() throws SQLException {
        return 0;
    }

    public int getMaxColumnNameLength() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInIndex() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInSelect() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInTable() throws SQLException {
        return 0;
    }

    public int getMaxConnections() throws SQLException {
        return 0;
    }

    public int getMaxCursorNameLength() throws SQLException {
        return 0;
    }

    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    public int getMaxSchemaNameLength() throws SQLException {
        return 0;
    }

    public int getMaxProcedureNameLength() throws SQLException {
        return 0;
    }

    public int getMaxCatalogNameLength() throws SQLException {
        return 0;
    }

    public int getMaxRowSize() throws SQLException {
        return 0;
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return true;
    }

    public int getMaxStatementLength() throws SQLException {
        return 0;
    }

    public int getMaxStatements() throws SQLException {
        return 0;
    }

    public int getMaxTableNameLength() throws SQLException {
        return 0;
    }

    public int getMaxTablesInSelect() throws SQLException {
        return 0;
    }

    public int getMaxUserNameLength() throws SQLException {
        return 0;
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        return 1;
    }

    public boolean supportsTransactions() throws SQLException {
        return true;
    }

    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        return level == 1 || level == 2 || level == 4 || level == 8;
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return false;
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return true;
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return true;
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        if (jdbcDatabaseMetaData.wantsIsNull(procedureNamePattern)) {
            return this.executeSelect("SYSTEM_PROCEDURES", "0=1");
        }
        schemaPattern = this.translateSchema(schemaPattern);
        StringBuffer select = this.toQueryPrefix("SYSTEM_PROCEDURES").append(jdbcDatabaseMetaData.and("PROCEDURE_CAT", "=", catalog)).append(jdbcDatabaseMetaData.and("PROCEDURE_SCHEM", "LIKE", schemaPattern)).append(jdbcDatabaseMetaData.and("PROCEDURE_NAME", "LIKE", procedureNamePattern));
        return this.execute(select.toString());
    }

    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        if (jdbcDatabaseMetaData.wantsIsNull(procedureNamePattern) || jdbcDatabaseMetaData.wantsIsNull(columnNamePattern)) {
            return this.executeSelect("SYSTEM_PROCEDURECOLUMNS", "0=1");
        }
        schemaPattern = this.translateSchema(schemaPattern);
        StringBuffer select = this.toQueryPrefix("SYSTEM_PROCEDURECOLUMNS").append(jdbcDatabaseMetaData.and("PROCEDURE_CAT", "=", catalog)).append(jdbcDatabaseMetaData.and("PROCEDURE_SCHEM", "LIKE", schemaPattern)).append(jdbcDatabaseMetaData.and("PROCEDURE_NAME", "LIKE", procedureNamePattern)).append(jdbcDatabaseMetaData.and("COLUMN_NAME", "LIKE", columnNamePattern));
        return this.execute(select.toString());
    }

    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        if (jdbcDatabaseMetaData.wantsIsNull(tableNamePattern) || types != null && types.length == 0) {
            return this.executeSelect("SYSTEM_TABLES", "0=1");
        }
        schemaPattern = this.translateSchema(schemaPattern);
        StringBuffer select = this.toQueryPrefix("SYSTEM_TABLES").append(jdbcDatabaseMetaData.and("TABLE_CAT", "=", catalog)).append(jdbcDatabaseMetaData.and("TABLE_SCHEM", "LIKE", schemaPattern)).append(jdbcDatabaseMetaData.and("TABLE_NAME", "LIKE", tableNamePattern));
        if (types != null) {
            select.append(" AND TABLE_TYPE IN (").append(StringUtil.getList(types, ",", "'")).append(')');
        }
        return this.execute(select.toString());
    }

    public ResultSet getSchemas() throws SQLException {
        return this.executeSelect("SYSTEM_SCHEMAS", null);
    }

    public ResultSet getCatalogs() throws SQLException {
        return this.executeSelect("SYSTEM_CATALOGS", null);
    }

    public ResultSet getTableTypes() throws SQLException {
        return this.executeSelect("SYSTEM_TABLETYPES", null);
    }

    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        if (jdbcDatabaseMetaData.wantsIsNull(tableNamePattern) || jdbcDatabaseMetaData.wantsIsNull(columnNamePattern)) {
            return this.executeSelect("SYSTEM_COLUMNS", "0=1");
        }
        schemaPattern = this.translateSchema(schemaPattern);
        StringBuffer select = this.toQueryPrefix("SYSTEM_COLUMNS").append(jdbcDatabaseMetaData.and("TABLE_CAT", "=", catalog)).append(jdbcDatabaseMetaData.and("TABLE_SCHEM", "LIKE", schemaPattern)).append(jdbcDatabaseMetaData.and("TABLE_NAME", "LIKE", tableNamePattern)).append(jdbcDatabaseMetaData.and("COLUMN_NAME", "LIKE", columnNamePattern));
        return this.execute(select.toString());
    }

    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        if (table == null) {
            Util.sqlException(62);
        }
        if (jdbcDatabaseMetaData.wantsIsNull(columnNamePattern)) {
            return this.executeSelect("SYSTEM_COLUMNPRIVILEGES", "0=1");
        }
        schema = this.translateSchema(schema);
        StringBuffer select = this.toQueryPrefix("SYSTEM_COLUMNPRIVILEGES").append(jdbcDatabaseMetaData.and("TABLE_CAT", "=", catalog)).append(jdbcDatabaseMetaData.and("TABLE_SCHEM", "=", schema)).append(jdbcDatabaseMetaData.and("TABLE_NAME", "=", table)).append(jdbcDatabaseMetaData.and("COLUMN_NAME", "LIKE", columnNamePattern));
        return this.execute(select.toString());
    }

    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        if (jdbcDatabaseMetaData.wantsIsNull(tableNamePattern)) {
            return this.executeSelect("SYSTEM_TABLEPRIVILEGES", "0=1");
        }
        schemaPattern = this.translateSchema(schemaPattern);
        StringBuffer select = this.toQueryPrefix("SYSTEM_TABLEPRIVILEGES").append(jdbcDatabaseMetaData.and("TABLE_CAT", "=", catalog)).append(jdbcDatabaseMetaData.and("TABLE_SCHEM", "LIKE", schemaPattern)).append(jdbcDatabaseMetaData.and("TABLE_NAME", "LIKE", tableNamePattern));
        return this.execute(select.toString());
    }

    /*
     * WARNING - void declaration
     */
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        void var6_6;
        switch (scope) {
            case 0: {
                String scopeIn = BRI_TEMPORARY_SCOPE_IN_LIST;
                break;
            }
            case 1: {
                String scopeIn = BRI_TRANSACTION_SCOPE_IN_LIST;
                break;
            }
            case 2: {
                String scopeIn = BRI_SESSION_SCOPE_IN_LIST;
                break;
            }
            default: {
                throw Util.sqlException(38, 118, null);
            }
        }
        if (table == null) {
            Util.sqlException(62);
        }
        schema = this.translateSchema(schema);
        Integer Nullable2 = nullable ? null : INT_COLUMNS_NO_NULLS;
        StringBuffer select = this.toQueryPrefix("SYSTEM_BESTROWIDENTIFIER").append(jdbcDatabaseMetaData.and("TABLE_CAT", "=", catalog)).append(jdbcDatabaseMetaData.and("TABLE_SCHEM", "=", schema)).append(jdbcDatabaseMetaData.and("TABLE_NAME", "=", table)).append(jdbcDatabaseMetaData.and("NULLABLE", "=", Nullable2)).append(" AND SCOPE IN " + (String)var6_6);
        return this.execute(select.toString());
    }

    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        if (table == null) {
            Util.sqlException(62);
        }
        schema = this.translateSchema(schema);
        StringBuffer select = this.toQueryPrefix("SYSTEM_VERSIONCOLUMNS").append(jdbcDatabaseMetaData.and("TABLE_CAT", "=", catalog)).append(jdbcDatabaseMetaData.and("TABLE_SCHEM", "=", schema)).append(jdbcDatabaseMetaData.and("TABLE_NAME", "=", table));
        return this.execute(select.toString());
    }

    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        if (table == null) {
            Util.sqlException(62);
        }
        schema = this.translateSchema(schema);
        StringBuffer select = this.toQueryPrefix("SYSTEM_PRIMARYKEYS").append(jdbcDatabaseMetaData.and("TABLE_CAT", "=", catalog)).append(jdbcDatabaseMetaData.and("TABLE_SCHEM", "=", schema)).append(jdbcDatabaseMetaData.and("TABLE_NAME", "=", table));
        return this.execute(select.toString());
    }

    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        if (table == null) {
            Util.sqlException(62);
        }
        schema = this.translateSchema(schema);
        StringBuffer select = this.toQueryPrefix("SYSTEM_CROSSREFERENCE").append(jdbcDatabaseMetaData.and("FKTABLE_CAT", "=", catalog)).append(jdbcDatabaseMetaData.and("FKTABLE_SCHEM", "=", schema)).append(jdbcDatabaseMetaData.and("FKTABLE_NAME", "=", table)).append(" ORDER BY PKTABLE_CAT, PKTABLE_SCHEM, PKTABLE_NAME, KEY_SEQ");
        return this.execute(select.toString());
    }

    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        if (table == null) {
            Util.sqlException(62);
        }
        schema = this.translateSchema(schema);
        StringBuffer select = this.toQueryPrefix("SYSTEM_CROSSREFERENCE").append(jdbcDatabaseMetaData.and("PKTABLE_CAT", "=", catalog)).append(jdbcDatabaseMetaData.and("PKTABLE_SCHEM", "=", schema)).append(jdbcDatabaseMetaData.and("PKTABLE_NAME", "=", table));
        return this.execute(select.toString());
    }

    public ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        if (primaryTable == null || foreignTable == null) {
            Util.sqlException(62);
        }
        primarySchema = this.translateSchema(primarySchema);
        foreignSchema = this.translateSchema(foreignSchema);
        StringBuffer select = this.toQueryPrefix("SYSTEM_CROSSREFERENCE").append(jdbcDatabaseMetaData.and("PKTABLE_CAT", "=", primaryCatalog)).append(jdbcDatabaseMetaData.and("PKTABLE_SCHEM", "=", primarySchema)).append(jdbcDatabaseMetaData.and("PKTABLE_NAME", "=", primaryTable)).append(jdbcDatabaseMetaData.and("FKTABLE_CAT", "=", foreignCatalog)).append(jdbcDatabaseMetaData.and("FKTABLE_SCHEM", "=", foreignSchema)).append(jdbcDatabaseMetaData.and("FKTABLE_NAME", "=", foreignTable));
        return this.execute(select.toString());
    }

    public ResultSet getTypeInfo() throws SQLException {
        return this.executeSelect("SYSTEM_TYPEINFO", null);
    }

    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        if (table == null) {
            Util.sqlException(62);
        }
        schema = this.translateSchema(schema);
        Boolean nu = unique ? Boolean.FALSE : null;
        StringBuffer select = this.toQueryPrefix("SYSTEM_INDEXINFO").append(jdbcDatabaseMetaData.and("TABLE_CAT", "=", catalog)).append(jdbcDatabaseMetaData.and("TABLE_SCHEM", "=", schema)).append(jdbcDatabaseMetaData.and("TABLE_NAME", "=", table)).append(jdbcDatabaseMetaData.and("NON_UNIQUE", "=", nu));
        return this.execute(select.toString());
    }

    public boolean supportsResultSetType(int type) throws SQLException {
        return type == 1003 || type == 1004;
    }

    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        return this.supportsResultSetType(type) && concurrency == 1007;
    }

    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean updatesAreDetected(int type) throws SQLException {
        return false;
    }

    public boolean deletesAreDetected(int type) throws SQLException {
        return false;
    }

    public boolean insertsAreDetected(int type) throws SQLException {
        return false;
    }

    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        if (jdbcDatabaseMetaData.wantsIsNull(typeNamePattern) || types != null && types.length == 0) {
            this.executeSelect("SYSTEM_UDTS", "0=1");
        }
        schemaPattern = this.translateSchema(schemaPattern);
        StringBuffer select = this.toQueryPrefix("SYSTEM_UDTS").append(jdbcDatabaseMetaData.and("TYPE_CAT", "=", catalog)).append(jdbcDatabaseMetaData.and("TYPE_SCHEM", "LIKE", schemaPattern)).append(jdbcDatabaseMetaData.and("TYPE_NAME", "LIKE", typeNamePattern));
        if (types != null) {
            select.append(" AND DATA_TYPE IN (").append(StringUtil.getList(types, ",", "'")).append(')');
        }
        return this.execute(select.toString());
    }

    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    public boolean supportsSavepoints() throws SQLException {
        return true;
    }

    public boolean supportsNamedParameters() throws SQLException {
        return true;
    }

    public boolean supportsMultipleOpenResults() throws SQLException {
        return false;
    }

    public boolean supportsGetGeneratedKeys() throws SQLException {
        return false;
    }

    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        if (jdbcDatabaseMetaData.wantsIsNull(typeNamePattern)) {
            return this.executeSelect("SYSTEM_SUPERTYPES", "0=1");
        }
        schemaPattern = this.translateSchema(schemaPattern);
        StringBuffer select = this.toQueryPrefix("SYSTEM_SUPERTYPES").append(jdbcDatabaseMetaData.and("TYPE_CAT", "=", catalog)).append(jdbcDatabaseMetaData.and("TYPE_SCHEM", "LIKE", schemaPattern)).append(jdbcDatabaseMetaData.and("TYPE_NAME", "LIKE", typeNamePattern));
        return this.execute(select.toString());
    }

    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        if (jdbcDatabaseMetaData.wantsIsNull(tableNamePattern)) {
            return this.executeSelect("SYSTEM_SUPERTABLES", "0=1");
        }
        schemaPattern = this.translateSchema(schemaPattern);
        StringBuffer select = this.toQueryPrefix("SYSTEM_SUPERTABLES").append(jdbcDatabaseMetaData.and("TABLE_CAT", "=", catalog)).append(jdbcDatabaseMetaData.and("TABLE_SCHEM", "LIKE", schemaPattern)).append(jdbcDatabaseMetaData.and("TABLE_NAME", "LIKE", tableNamePattern));
        return this.execute(select.toString());
    }

    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        if (jdbcDatabaseMetaData.wantsIsNull(typeNamePattern) || jdbcDatabaseMetaData.wantsIsNull(attributeNamePattern)) {
            return this.executeSelect("SYSTEM_UDTATTRIBUTES", "0=1");
        }
        schemaPattern = this.translateSchema(schemaPattern);
        StringBuffer select = this.toQueryPrefix("SYSTEM_UDTATTRIBUTES").append(jdbcDatabaseMetaData.and("TYPE_CAT", "=", catalog)).append(jdbcDatabaseMetaData.and("TYPE_SCHEM", "LIKE", schemaPattern)).append(jdbcDatabaseMetaData.and("TYPE_NAME", "LIKE", typeNamePattern)).append(jdbcDatabaseMetaData.and("ATTR_NAME", "LIKE", attributeNamePattern));
        return this.execute(select.toString());
    }

    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return holdability == 1;
    }

    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    public int getDatabaseMajorVersion() throws SQLException {
        ResultSet rs = this.execute("call \"com.fr.third.org.hsqldb.Library.getDatabaseMajorVersion\"()");
        rs.next();
        int result = rs.getInt(1);
        rs.close();
        return result;
    }

    public int getDatabaseMinorVersion() throws SQLException {
        ResultSet rs = this.execute("call \"com.fr.third.org.hsqldb.Library.getDatabaseMinorVersion\"()");
        rs.next();
        int result = rs.getInt(1);
        rs.close();
        return result;
    }

    public int getJDBCMajorVersion() throws SQLException {
        return 3;
    }

    public int getJDBCMinorVersion() throws SQLException {
        return 0;
    }

    public int getSQLStateType() throws SQLException {
        return 2;
    }

    public boolean locatorsUpdateCopy() throws SQLException {
        return false;
    }

    public boolean supportsStatementPooling() throws SQLException {
        return false;
    }

    jdbcDatabaseMetaData(jdbcConnection c) throws SQLException {
        this.connection = c;
        if (c.connProperties != null) {
            this.useSchemaDefault = c.connProperties.isPropertyTrue("default_schema");
        }
    }

    private static String and(String id, String op, Object val) {
        if (val == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        boolean isStr = val instanceof String;
        if (isStr && ((String)val).length() == 0) {
            return sb.append(" AND ").append(id).append(" IS NULL").toString();
        }
        String v = isStr ? Column.createSQLString((String)val) : String.valueOf(val);
        sb.append(" AND ").append(id).append(' ');
        if (isStr && "LIKE".equalsIgnoreCase(op)) {
            if (v.indexOf(95) < 0 && v.indexOf(37) < 0) {
                sb.append("=").append(' ').append(v);
            } else {
                sb.append("LIKE").append(' ').append(v);
                if (v.indexOf("\\_") >= 0 || v.indexOf("\\%") >= 0) {
                    sb.append(" ESCAPE '\\'");
                }
            }
        } else {
            sb.append(op).append(' ').append(v);
        }
        return sb.toString();
    }

    private ResultSet execute(String sql) throws SQLException {
        int scroll = 1004;
        int concur = 1007;
        ResultSet r = this.connection.createStatement(1004, 1007).executeQuery(sql);
        ((jdbcResultSet)r).autoClose = true;
        return r;
    }

    private ResultSet executeSelect(String table, String where) throws SQLException {
        String select = selstar + table;
        if (where != null) {
            select = select + " WHERE " + where;
        }
        return this.execute(select);
    }

    private StringBuffer toQueryPrefix(String t) {
        StringBuffer sb = new StringBuffer(255);
        return sb.append(selstar).append(t).append(whereTrue);
    }

    private static boolean wantsIsNull(String s) {
        return s != null && s.length() == 0;
    }

    private String translateSchema(String schemaName) throws SQLException {
        if (this.useSchemaDefault && schemaName != null && schemaName.length() == 0) {
            ResultSet rs = this.executeSelect("SYSTEM_SCHEMAS", "IS_DEFAULT=TRUE");
            if (rs.next()) {
                return rs.getString(1);
            }
            return schemaName;
        }
        return schemaName;
    }
}

